;;;
;;;	Test CP-1600
;;;

	CPU	CP-1600

	ORG	X'0000'

LABEL0:	
	MVOI	R0,123
	MVII	-32768,R1
	ADDI	32767,R2
	SUBI	65535,R3
	CMPI	0,R4
	ANDI	X'AA55',R5
	XORI	'AS',R6

	SDBD

	GSWD	R0
	NOP
	NOP	1
	SIN
	SIN	2
	RSWD	R1
	HLT
	EIS
	DIS
	TCI
	CLRC
	SETC

	J	LABEL0
LABEL1:	JE	LABEL1
	JD	LABEL2
	JSR	R4,LABEL3
	JSRE	R5,LABEL0
	JSRD	R6,LABEL1
	JSRE	R6,X'AA55'

LABEL2:	MVO	R0,DATA0
	MVI	DATA1,R1
	ADD	DATA2,R2
	SUB	DATA0,R3
	CMP	DATA1,R4
	AND	DATA2,R5
	XOR	DATA3,R6

	MVO@	R0,R4
	PSHR	R1
	MVI@	R5,R2
	PULR	R3
	ADD@	R6,R3
	SUB@	R6,R0
	CMP@	R4,R1
	AND@	R5,R2
	XOR@	R6,R3

L0:	B	LABEL0
	NOPP
	BC	L0
L1:	BLGT	L1
	BNC	L2
L2:	BLLT	L3
	BOV	L4
	BNOV	L5
L3:	BPL	L0
	BMI	L1
	BZE	L2
	BEQ	L3
L4:	BNZE	L4
	BNEQ	L5
	BLT	L0
	BGE	L1
L5:	BLE	L2
	BGT	L3
	BUSC	L4
	BESC	L5
	BEXT	L0,7

	MOVR	R0,R1
	TSTR	R2
	JR	R3
	ADDR	R4,R5
	SUBR	R0,R1
	CMPR	R2,R3
	ANDR	R4,R5
	XORR	R6,R0
	CLRR	R1
	INCR	R2
	DECR	R3
	COMR	R4
	NEGR	R5
	ADCR	R6

	SWAP	R0
	SLL	R1,1
	RLC	R2,2
	SLLC	R3
	SLR	R0,1
	SAR	R1,2
	RRC	R2
	SARC	R3,1

DATA0:	RES	2
	ZERO	3
DATA1:	WORD	-1,32767
DATA2:	BYTE	-32768,65535
DATA3:	TEXT	"Test",13,X'0A',0
LABEL3:

	;; Sample from Manual
	CLRR	R3
GET:	MVI@	R4,R2
	MOVR	R3,R3
	BNZE	CHK
	CMPI	' ',R2
	BEQ	GET
	INCR	R3
CHK:	SUBI	48,R2

	SDBD
	MVII	100,R3

	SDBD
	NOP
	XORI	123,R0

	BITS	10
	MVII	1023,R0
	MVII	1024,R1
	MVII	65535,R2

	BITS	11
	ADDI	2047,R0
	ADDI	2048,R1
	ADDI	4096,R2

	; Map PACKING to PAK/UPAK

PAK	macro
	packing	on
	endm

UPAK	macro
	packing	off
	endm

CR:	EQU	X'0D'
LF:	EQU	X'0A'

	BYTE	127
	WORD	127

	; packing is on by default for CP1600

	TEXT	"Hello", CR, LF, 0

	; turn packing off -> one word per character

	UPAK
	TEXT	"Hello", CR, LF, 0

	; turn packing on again

	PAK
	TEXT	"Hello", CR, LF, 0

	END
