	; a somewhat more elaborated test of the 430(X) instruction set

	cpu	msp430
	relaxed	on
	page	0

	; the first part are MSP430 instructions, the list and reference
        ; values are borrowed from the Naken Assembler ;-)

	equ	number_five,5

testing	macro	a,b
	mov	a,b
	endm

start:
	mov.b	#5, &100		; 0x40f2 0x0005 0x0064
	mov.b	100, &100		; 0x40d2 0x005c 0x0064
	add.w	100, &0x100		; 0x5092 0x0056 0x0100
	sub.w	&0x8000, &0x100		; 0x8292 0x8000 0x0100
	mov.w	&0x8000, r1		; 0x4211 0x8000
	rrc.w	r9			; 0x1009
	rra.w	&0x100			; 0x1112 0x0100
	jmp	start			; 0x3fee
	push	r9			; 0x1209
	push.w	r9			; 0x1209
	push.b	r9			; 0x1249
	sxt	r9			; 0x1189
	swpb	r9			; 0x1089
	reti				; 0x1300
	call	&start			; 0x1292 0x0000
blah:
	jnz	start			; 0x23e5
	jne	start			; 0x23e4
	jz	start			; 0x27e3
	jeq	start			; 0x27e2
	jc	start			; 0x2fe1
	jhs	start			; 0x2fe0
	jn	start			; 0x33df
	jge	start			; 0x37de
	jl	start			; 0x3bdd
	testing	#2,4			; 0x43a0 0xffbc
	testing	#number_five,4		; 0x40b0 0x0005 0xffb6
	addc.w	100, &0x100		; 0x6092 0x0012 0x0100
	sub.w	100, &0x100		; 0x8092 0x000c 0x0100
	cmp.w	100, &0x100		; 0x9092 0x0006 0x0100
	dadd.b	100, &0x100		; 0xa0d2 0x0000 0x0100
	bit.b	#5, &0x100		; 0xb0f2 0x0005 0x0100
	bit.b	#0xff, &0x100		; 0xb3f2 0x0100
	bis.b	#0xff, &0x100		; 0xd3f2 0x0100
	xor.b	#0xff, &0x100		; 0xe3f2 0x0100
	and.b	#0xff, &0x100		; 0xf3f2 0x0100
	adc.b	r9			; 0x6349
	br	#start			; 0x4300
	clrc				; 0xc312
	clrn				; 0xc222
	clrz				; 0xc322
	dadc.w	&0x100			; 0xa382 0x0100
	dec.w	&0x100			; 0x8392 0x0100
	decd.w	&0x100			; 0x83a2 0x0100
	dint				; 0xc232
	eint				; 0xd232
	inc.w	&0x100			; 0x5392 0x0100
	inv.w	&0x100			; 0xe3b2 0x0100
	nop				; 0x4303
	ret				; 0x4130
	rla.w	&0x100			; 0x5292 0x0100 0x0100
	rlc.w	&0x100			; 0x6292 0x0100 0x0100
	sbc.w	&0x100			; 0x7382 0x0100
	setc				; 0xd312
	setn				; 0xd222
	setz				; 0xd322
	tst.w r6			; 0x9306

	; iterate over all MSP430 instructions

	org	100h

	mov	r4,r7			; 0x4407
	mov.b	r4,r7			; 0x4447
	mov.w	r4,r7			; 0x4407
	mov	#4,r7			; 0x4227
	mov.b	#4,r7			; 0x4267
	mov.w	#4,r7			; 0x4227
	mov	#8,r7			; 0x4237
	mov.b	#8,r7			; 0x4277
	mov.w	#8,r7			; 0x4237
	mov	#0,r7			; 0x4307
	mov.b	#0,r7			; 0x4347
	mov.w	#0,r7			; 0x4307
	mov	#1,r7			; 0x4317
	mov.b	#1,r7			; 0x4357
	mov.w	#1,r7			; 0x4317
	mov	#2,r7			; 0x4327
	mov.b	#2,r7			; 0x4367
	mov.w	#2,r7			; 0x4327
	mov	#0ffffh,r7		; 0x4337
	mov.b	#0ffh,r7		; 0x4377
	mov.w	#0ffffh,r7		; 0x4337
	mov	#-1,r7			; 0x4337
	mov.b	#-1,r7			; 0x4377
	mov.w	#-1,r7			; 0x4337
	mov	#100,r7			; 0x4037 0x0064
	mov.b	#100,r7			; 0x4077 0x0064
	mov.w	#100,r7			; 0x4037 0x0064
	mov	@r6,r7			; 0x4627
	mov.b	@r6,r7			; 0x4667
	mov.w	@r6,r7			; 0x4627
	mov	42(r6),r7		; 0x4617 0x002a
	mov.b	42(r6),r7		; 0x4657 0x002a
	mov.w	42(r6),r7		; 0x4617 0x002a
	mov	@r6,r7			; 0x4627
	mov.b	@r6,r7			; 0x4667
	mov.w	@r6,r7			; 0x4627
	mov	@r6+,r7			; 0x4637
	mov.b	@r6+,r7			; 0x4677
	mov.w	@r6+,r7			; 0x4637
	mov	&1234h,r7		; 0x4217 0x1234
	mov.b	&1234h,r7		; 0x4257 0x1234
	mov.w	&1234h,r7		; 0x4217 0x1234
	mov	1234h,r7		; 0x4017 0x10cc
	mov.b	1234h,r7		; 0x4057 0x10c8
	mov.w	1234h,r7		; 0x4017 0x10c4
	mov	r4,200(r8)		; 0x4488 0x00c8
	mov.b	r4,200(r8)		; 0x44c8 0x00c8
	mov.w	r4,200(r8)		; 0x4488 0x00c8
	mov	#4,200(r8)		; 0x42a8 0x00c8
	mov.b	#4,200(r8)		; 0x42e8 0x00c8
	mov.w	#4,200(r8)		; 0x42a8 0x00c8
	mov	#8,200(r8)		; 0x42b8 0x00c8
	mov.b	#8,200(r8)		; 0x42f8 0x00c8
	mov.w	#8,200(r8)		; 0x42b8 0x00c8
	mov	#0,200(r8)		; 0x4388 0x00c8
	mov.b	#0,200(r8)		; 0x43c8 0x00c8
	mov.w	#0,200(r8)		; 0x4388 0x00c8
	mov	#1,200(r8)		; 0x4398 0x00c8
	mov.b	#1,200(r8)		; 0x43d8 0x00c8
	mov.w	#1,200(r8)		; 0x4398 0x00c8
	mov	#2,200(r8)		; 0x43a8 0x00c8
	mov.b	#2,200(r8)		; 0x43e8 0x00c8
	mov.w	#2,200(r8)		; 0x43a8 0x00c8
	mov	#0ffffh,200(r8)		; 0x43b8 0x00c8
	mov.b	#0ffh,200(r8)		; 0x43f8 0x00c8
	mov.w	#0ffffh,200(r8)		; 0x43b8 0x00c8
	mov	#-1,200(r8)		; 0x43b8 0x00c8
	mov.b	#-1,200(r8)		; 0x43f8 0x00c8
	mov.w	#-1,200(r8)		; 0x43b8 0x00c8
	mov	#100,200(r8)		; 0x40b8 0x0064 0x00c8
	mov.b	#100,200(r8)		; 0x40f8 0x0064 0x00c8
	mov.w	#100,200(r8)		; 0x40b8 0x0064 0x00c8
	mov	@r6,200(r8)		; 0x46a8 0x00c8
	mov.b	@r6,200(r8)		; 0x46e8 0x00c8
	mov.w	@r6,200(r8)		; 0x46a8 0x00c8
	mov	42(r6),200(r8)		; 0x4698 0x002a 0x00c8
	mov.b	42(r6),200(r8)		; 0x46d8 0x002a 0x00c8
	mov.w	42(r6),200(r8)		; 0x4698 0x002a 0x00c8
	mov	@r6,200(r8)		; 0x46a8 0x00c8
	mov.b	@r6,200(r8)		; 0x46e8 0x00c8
	mov.w	@r6,200(r8)		; 0x46a8 0x00c8
	mov	@r6+,200(r8)		; 0x46b8 0x00c8
	mov.b	@r6+,200(r8)		; 0x46f8 0x00c8
	mov.w	@r6+,200(r8)		; 0x46b8 0x00c8
	mov	&1234h,200(r8)		; 0x4298 0x1234 0x00c8
	mov.b	&1234h,200(r8)		; 0x42d8 0x1234 0x00c8
	mov.w	&1234h,200(r8)		; 0x4298 0x1234 0x00c8
	mov	1234h,200(r8)		; 0x4098 0x1006 0x00c8
	mov.b	1234h,200(r8)		; 0x40d8 0x1000 0x00c8
	mov.w	1234h,200(r8)		; 0x4098 0x0ffa 0x00c8
	mov	r4,&1234h		; 0x4482 0x1234
	mov.b	r4,&1234h		; 0x44c2 0x1234
	mov.w	r4,&1234h		; 0x4482 0x1234
	mov	#4,&1234h		; 0x42a2 0x1234
	mov.b	#4,&1234h		; 0x42e2 0x1234
	mov.w	#4,&1234h		; 0x42a2 0x1234
	mov	#8,&1234h		; 0x42b2 0x1234
	mov.b	#8,&1234h		; 0x42f2 0x1234
	mov.w	#8,&1234h		; 0x42b2 0x1234
	mov	#0,&1234h		; 0x4382 0x1234
	mov.b	#0,&1234h		; 0x43c2 0x1234
	mov.w	#0,&1234h		; 0x4382 0x1234
	mov	#1,&1234h		; 0x4392 0x1234
	mov.b	#1,&1234h		; 0x43d2 0x1234
	mov.w	#1,&1234h		; 0x4392 0x1234
	mov	#2,&1234h		; 0x43a2 0x1234
	mov.b	#2,&1234h		; 0x43e2 0x1234
	mov.w	#2,&1234h		; 0x43a2 0x1234
	mov	#0ffffh,&1234h		; 0x43b2 0x1234
	mov.b	#0ffh,&1234h		; 0x43f2 0x1234
	mov.w	#0ffffh,&1234h		; 0x43b2 0x1234
	mov	#-1,&1234h		; 0x43b2 0x1234
	mov.b	#-1,&1234h		; 0x43f2 0x1234
	mov.w	#-1,&1234h		; 0x43b2 0x1234
	mov	#100,&1234h		; 0x40b2 0x0064 0x1234
	mov.b	#100,&1234h		; 0x40f2 0x0064 0x1234
	mov.w	#100,&1234h		; 0x40b2 0x0064 0x1234
	mov	@r6,&1234h		; 0x46a2 0x1234
	mov.b	@r6,&1234h		; 0x46e2 0x1234
	mov.w	@r6,&1234h		; 0x46a2 0x1234
	mov	42(r6),&1234h		; 0x4692 0x002a 0x1234
	mov.b	42(r6),&1234h		; 0x46d2 0x002a 0x1234
	mov.w	42(r6),&1234h		; 0x4692 0x002a 0x1234
	mov	@r6,&1234h		; 0x46a2 0x1234
	mov.b	@r6,&1234h		; 0x46e2 0x1234
	mov.w	@r6,&1234h		; 0x46a2 0x1234
	mov	@r6+,&1234h		; 0x46b2 0x1234
	mov.b	@r6+,&1234h		; 0x46f2 0x1234
	mov.w	@r6+,&1234h		; 0x46b2 0x1234
	mov	&1234h,&1234h		; 0x4292 0x1234 0x1234
	mov.b	&1234h,&1234h		; 0x42d2 0x1234 0x1234
	mov.w	&1234h,&1234h		; 0x4292 0x1234 0x1234
	mov	1234h,&1234h		; 0x4092 0x0f3a 0x1234
	mov.b	1234h,&1234h		; 0x40d2 0x0f34 0x1234
	mov.w	1234h,&1234h		; 0x4092 0x0f2e 0x1234
	mov	r4,1234h		; 0x4480 0x0f28
	mov.b	r4,1234h		; 0x44c0 0x0f24
	mov.w	r4,1234h		; 0x4480 0x0f20
	mov	#4,1234h		; 0x42a0 0x0f1c
	mov.b	#4,1234h		; 0x42e0 0x0f18
	mov.w	#4,1234h		; 0x42a0 0x0f14
	mov	#8,1234h		; 0x42b0 0x0f10
	mov.b	#8,1234h		; 0x42f0 0x0f0c
	mov.w	#8,1234h		; 0x42b0 0x0f08
	mov	#0,1234h		; 0x4380 0x0f04
	mov.b	#0,1234h		; 0x43c0 0x0f00
	mov.w	#0,1234h		; 0x4380 0x0efc
	mov	#1,1234h		; 0x4390 0x0ef8
	mov.b	#1,1234h		; 0x43d0 0x0ef4
	mov.w	#1,1234h		; 0x4390 0x0ef0
	mov	#2,1234h		; 0x43a0 0x0eec
	mov.b	#2,1234h		; 0x43e0 0x0ee8
	mov.w	#2,1234h		; 0x43a0 0x0ee4
	mov	#0ffffh,1234h		; 0x43b0 0x0ee0
	mov.b	#0ffh,1234h		; 0x43f0 0x0edc
	mov.w	#0ffffh,1234h		; 0x43b0 0x0ed8
	mov	#-1,1234h		; 0x43b0 0x0ed4
	mov.b	#-1,1234h		; 0x43f0 0x0ed0
	mov.w	#-1,1234h		; 0x43b0 0x0ecc
	mov	#100,1234h		; 0x40b0 0x0064 0x0ec6
	mov.b	#100,1234h		; 0x40f0 0x0064 0x0ec0
	mov.w	#100,1234h		; 0x40b0 0x0064 0x0eba
	mov	@r6,1234h		; 0x46a0 0x0eb6
	mov.b	@r6,1234h		; 0x46e0 0x0eb2
	mov.w	@r6,1234h		; 0x46a0 0x0eae
	mov	42(r6),1234h		; 0x4690 0x002a 0x0ea8
	mov.b	42(r6),1234h		; 0x46d0 0x002a 0x0ea2
	mov.w	42(r6),1234h		; 0x4690 0x002a 0x0e9c
	mov	@r6,1234h		; 0x46a0 0x0e98
	mov.b	@r6,1234h		; 0x46e0 0x0e94
	mov.w	@r6,1234h		; 0x46a0 0x0e90
	mov	@r6+,1234h		; 0x46b0 0x0e8c
	mov.b	@r6+,1234h		; 0x46f0 0x0e88
	mov.w	@r6+,1234h		; 0x46b0 0x0e84
	mov	&1234h,1234h		; 0x4290 0x1234 0x0e7e
	mov.b	&1234h,1234h		; 0x42d0 0x1234 0x0e78
	mov.w	&1234h,1234h		; 0x4290 0x1234 0x0e72
	mov	1234h,1234h		; 0x4090 0x0e6e 0x0e6c
	mov.b	1234h,1234h		; 0x40d0 0x0e68 0x0e66
	mov.w	1234h,1234h		; 0x4090 0x0e62 0x0e60
	add	r4,r7			; 0x5407
	add.b	r4,r7			; 0x5447
	add.w	r4,r7			; 0x5407
	add	#4,r7			; 0x5227
	add.b	#4,r7			; 0x5267
	add.w	#4,r7			; 0x5227
	add	#8,r7			; 0x5237
	add.b	#8,r7			; 0x5277
	add.w	#8,r7			; 0x5237
	add	#0,r7			; 0x5307
	add.b	#0,r7			; 0x5347
	add.w	#0,r7			; 0x5307
	add	#1,r7			; 0x5317
	add.b	#1,r7			; 0x5357
	add.w	#1,r7			; 0x5317
	add	#2,r7			; 0x5327
	add.b	#2,r7			; 0x5367
	add.w	#2,r7			; 0x5327
	add	#0ffffh,r7		; 0x5337
	add.b	#0ffh,r7		; 0x5377
	add.w	#0ffffh,r7		; 0x5337
	add	#-1,r7			; 0x5337
	add.b	#-1,r7			; 0x5377
	add.w	#-1,r7			; 0x5337
	add	#100,r7			; 0x5037 0x0064
	add.b	#100,r7			; 0x5077 0x0064
	add.w	#100,r7			; 0x5037 0x0064
	add	@r6,r7			; 0x5627
	add.b	@r6,r7			; 0x5667
	add.w	@r6,r7			; 0x5627
	add	42(r6),r7		; 0x5617 0x002a
	add.b	42(r6),r7		; 0x5657 0x002a
	add.w	42(r6),r7		; 0x5617 0x002a
	add	@r6,r7			; 0x5627
	add.b	@r6,r7			; 0x5667
	add.w	@r6,r7			; 0x5627
	add	@r6+,r7			; 0x5637
	add.b	@r6+,r7			; 0x5677
	add.w	@r6+,r7			; 0x5637
	add	&1234h,r7		; 0x5217 0x1234
	add.b	&1234h,r7		; 0x5257 0x1234
	add.w	&1234h,r7		; 0x5217 0x1234
	add	1234h,r7		; 0x5017 0x0df6
	add.b	1234h,r7		; 0x5057 0x0df2
	add.w	1234h,r7		; 0x5017 0x0dee
	add	r4,200(r8)		; 0x5488 0x00c8
	add.b	r4,200(r8)		; 0x54c8 0x00c8
	add.w	r4,200(r8)		; 0x5488 0x00c8
	add	#4,200(r8)		; 0x52a8 0x00c8
	add.b	#4,200(r8)		; 0x52e8 0x00c8
	add.w	#4,200(r8)		; 0x52a8 0x00c8
	add	#8,200(r8)		; 0x52b8 0x00c8
	add.b	#8,200(r8)		; 0x52f8 0x00c8
	add.w	#8,200(r8)		; 0x52b8 0x00c8
	add	#0,200(r8)		; 0x5388 0x00c8
	add.b	#0,200(r8)		; 0x53c8 0x00c8
	add.w	#0,200(r8)		; 0x5388 0x00c8
	add	#1,200(r8)		; 0x5398 0x00c8
	add.b	#1,200(r8)		; 0x53d8 0x00c8
	add.w	#1,200(r8)		; 0x5398 0x00c8
	add	#2,200(r8)		; 0x53a8 0x00c8
	add.b	#2,200(r8)		; 0x53e8 0x00c8
	add.w	#2,200(r8)		; 0x53a8 0x00c8
	add	#0ffffh,200(r8)		; 0x53b8 0x00c8
	add.b	#0ffh,200(r8)		; 0x53f8 0x00c8
	add.w	#0ffffh,200(r8)		; 0x53b8 0x00c8
	add	#-1,200(r8)		; 0x53b8 0x00c8
	add.b	#-1,200(r8)		; 0x53f8 0x00c8
	add.w	#-1,200(r8)		; 0x53b8 0x00c8
	add	#100,200(r8)		; 0x50b8 0x0064 0x00c8
	add.b	#100,200(r8)		; 0x50f8 0x0064 0x00c8
	add.w	#100,200(r8)		; 0x50b8 0x0064 0x00c8
	add	@r6,200(r8)		; 0x56a8 0x00c8
	add.b	@r6,200(r8)		; 0x56e8 0x00c8
	add.w	@r6,200(r8)		; 0x56a8 0x00c8
	add	42(r6),200(r8)		; 0x5698 0x002a 0x00c8
	add.b	42(r6),200(r8)		; 0x56d8 0x002a 0x00c8
	add.w	42(r6),200(r8)		; 0x5698 0x002a 0x00c8
	add	@r6,200(r8)		; 0x56a8 0x00c8
	add.b	@r6,200(r8)		; 0x56e8 0x00c8
	add.w	@r6,200(r8)		; 0x56a8 0x00c8
	add	@r6+,200(r8)		; 0x56b8 0x00c8
	add.b	@r6+,200(r8)		; 0x56f8 0x00c8
	add.w	@r6+,200(r8)		; 0x56b8 0x00c8
	add	&1234h,200(r8)		; 0x5298 0x1234 0x00c8
	add.b	&1234h,200(r8)		; 0x52d8 0x1234 0x00c8
	add.w	&1234h,200(r8)		; 0x5298 0x1234 0x00c8
	add	1234h,200(r8)		; 0x5098 0x0d30 0x00c8
	add.b	1234h,200(r8)		; 0x50d8 0x0d2a 0x00c8
	add.w	1234h,200(r8)		; 0x5098 0x0d24 0x00c8
	add	r4,&1234h		; 0x5482 0x1234
	add.b	r4,&1234h		; 0x54c2 0x1234
	add.w	r4,&1234h		; 0x5482 0x1234
	add	#4,&1234h		; 0x52a2 0x1234
	add.b	#4,&1234h		; 0x52e2 0x1234
	add.w	#4,&1234h		; 0x52a2 0x1234
	add	#8,&1234h		; 0x52b2 0x1234
	add.b	#8,&1234h		; 0x52f2 0x1234
	add.w	#8,&1234h		; 0x52b2 0x1234
	add	#0,&1234h		; 0x5382 0x1234
	add.b	#0,&1234h		; 0x53c2 0x1234
	add.w	#0,&1234h		; 0x5382 0x1234
	add	#1,&1234h		; 0x5392 0x1234
	add.b	#1,&1234h		; 0x53d2 0x1234
	add.w	#1,&1234h		; 0x5392 0x1234
	add	#2,&1234h		; 0x53a2 0x1234
	add.b	#2,&1234h		; 0x53e2 0x1234
	add.w	#2,&1234h		; 0x53a2 0x1234
	add	#0ffffh,&1234h		; 0x53b2 0x1234
	add.b	#0ffh,&1234h		; 0x53f2 0x1234
	add.w	#0ffffh,&1234h		; 0x53b2 0x1234
	add	#-1,&1234h		; 0x53b2 0x1234
	add.b	#-1,&1234h		; 0x53f2 0x1234
	add.w	#-1,&1234h		; 0x53b2 0x1234
	add	#100,&1234h		; 0x50b2 0x0064 0x1234
	add.b	#100,&1234h		; 0x50f2 0x0064 0x1234
	add.w	#100,&1234h		; 0x50b2 0x0064 0x1234
	add	@r6,&1234h		; 0x56a2 0x1234
	add.b	@r6,&1234h		; 0x56e2 0x1234
	add.w	@r6,&1234h		; 0x56a2 0x1234
	add	42(r6),&1234h		; 0x5692 0x002a 0x1234
	add.b	42(r6),&1234h		; 0x56d2 0x002a 0x1234
	add.w	42(r6),&1234h		; 0x5692 0x002a 0x1234
	add	@r6,&1234h		; 0x56a2 0x1234
	add.b	@r6,&1234h		; 0x56e2 0x1234
	add.w	@r6,&1234h		; 0x56a2 0x1234
	add	@r6+,&1234h		; 0x56b2 0x1234
	add.b	@r6+,&1234h		; 0x56f2 0x1234
	add.w	@r6+,&1234h		; 0x56b2 0x1234
	add	&1234h,&1234h		; 0x5292 0x1234 0x1234
	add.b	&1234h,&1234h		; 0x52d2 0x1234 0x1234
	add.w	&1234h,&1234h		; 0x5292 0x1234 0x1234
	add	1234h,&1234h		; 0x5092 0x0c64 0x1234
	add.b	1234h,&1234h		; 0x50d2 0x0c5e 0x1234
	add.w	1234h,&1234h		; 0x5092 0x0c58 0x1234
	add	r4,1234h		; 0x5480 0x0c52
	add.b	r4,1234h		; 0x54c0 0x0c4e
	add.w	r4,1234h		; 0x5480 0x0c4a
	add	#4,1234h		; 0x52a0 0x0c46
	add.b	#4,1234h		; 0x52e0 0x0c42
	add.w	#4,1234h		; 0x52a0 0x0c3e
	add	#8,1234h		; 0x52b0 0x0c3a
	add.b	#8,1234h		; 0x52f0 0x0c36
	add.w	#8,1234h		; 0x52b0 0x0c32
	add	#0,1234h		; 0x5380 0x0c2e
	add.b	#0,1234h		; 0x53c0 0x0c2a
	add.w	#0,1234h		; 0x5380 0x0c26
	add	#1,1234h		; 0x5390 0x0c22
	add.b	#1,1234h		; 0x53d0 0x0c1e
	add.w	#1,1234h		; 0x5390 0x0c1a
	add	#2,1234h		; 0x53a0 0x0c16
	add.b	#2,1234h		; 0x53e0 0x0c12
	add.w	#2,1234h		; 0x53a0 0x0c0e
	add	#0ffffh,1234h		; 0x53b0 0x0c0a
	add.b	#0ffh,1234h		; 0x53f0 0x0c06
	add.w	#0ffffh,1234h		; 0x53b0 0x0c02
	add	#-1,1234h		; 0x53b0 0x0bfe
	add.b	#-1,1234h		; 0x53f0 0x0bfa
	add.w	#-1,1234h		; 0x53b0 0x0bf6
	add	#100,1234h		; 0x50b0 0x0064 0x0bf0
	add.b	#100,1234h		; 0x50f0 0x0064 0x0bea
	add.w	#100,1234h		; 0x50b0 0x0064 0x0be4
	add	@r6,1234h		; 0x56a0 0x0be0
	add.b	@r6,1234h		; 0x56e0 0x0bdc
	add.w	@r6,1234h		; 0x56a0 0x0bd8
	add	42(r6),1234h		; 0x5690 0x002a 0x0bd2
	add.b	42(r6),1234h		; 0x56d0 0x002a 0x0bcc
	add.w	42(r6),1234h		; 0x5690 0x002a 0x0bc6
	add	@r6,1234h		; 0x56a0 0x0bc2
	add.b	@r6,1234h		; 0x56e0 0x0bbe
	add.w	@r6,1234h		; 0x56a0 0x0bba
	add	@r6+,1234h		; 0x56b0 0x0bb6
	add.b	@r6+,1234h		; 0x56f0 0x0bb2
	add.w	@r6+,1234h		; 0x56b0 0x0bae
	add	&1234h,1234h		; 0x5290 0x1234 0x0ba8
	add.b	&1234h,1234h		; 0x52d0 0x1234 0x0ba2
	add.w	&1234h,1234h		; 0x5290 0x1234 0x0b9c
	add	1234h,1234h		; 0x5090 0x0b98 0x0b96
	add.b	1234h,1234h		; 0x50d0 0x0b92 0x0b90
	add.w	1234h,1234h		; 0x5090 0x0b8c 0x0b8a
	addc	r4,r7			; 0x6407
	addc.b	r4,r7			; 0x6447
	addc.w	r4,r7			; 0x6407
	addc	#4,r7			; 0x6227
	addc.b	#4,r7			; 0x6267
	addc.w	#4,r7			; 0x6227
	addc	#8,r7			; 0x6237
	addc.b	#8,r7			; 0x6277
	addc.w	#8,r7			; 0x6237
	addc	#0,r7			; 0x6307
	addc.b	#0,r7			; 0x6347
	addc.w	#0,r7			; 0x6307
	addc	#1,r7			; 0x6317
	addc.b	#1,r7			; 0x6357
	addc.w	#1,r7			; 0x6317
	addc	#2,r7			; 0x6327
	addc.b	#2,r7			; 0x6367
	addc.w	#2,r7			; 0x6327
	addc	#0ffffh,r7		; 0x6337
	addc.b	#0ffh,r7		; 0x6377
	addc.w	#0ffffh,r7		; 0x6337
	addc	#-1,r7			; 0x6337
	addc.b	#-1,r7			; 0x6377
	addc.w	#-1,r7			; 0x6337
	addc	#100,r7			; 0x6037 0x0064
	addc.b	#100,r7			; 0x6077 0x0064
	addc.w	#100,r7			; 0x6037 0x0064
	addc	@r6,r7			; 0x6627
	addc.b	@r6,r7			; 0x6667
	addc.w	@r6,r7			; 0x6627
	addc	42(r6),r7		; 0x6617 0x002a
	addc.b	42(r6),r7		; 0x6657 0x002a
	addc.w	42(r6),r7		; 0x6617 0x002a
	addc	@r6,r7			; 0x6627
	addc.b	@r6,r7			; 0x6667
	addc.w	@r6,r7			; 0x6627
	addc	@r6+,r7			; 0x6637
	addc.b	@r6+,r7			; 0x6677
	addc.w	@r6+,r7			; 0x6637
	addc	&1234h,r7		; 0x6217 0x1234
	addc.b	&1234h,r7		; 0x6257 0x1234
	addc.w	&1234h,r7		; 0x6217 0x1234
	addc	1234h,r7		; 0x6017 0x0b20
	addc.b	1234h,r7		; 0x6057 0x0b1c
	addc.w	1234h,r7		; 0x6017 0x0b18
	addc	r4,200(r8)		; 0x6488 0x00c8
	addc.b	r4,200(r8)		; 0x64c8 0x00c8
	addc.w	r4,200(r8)		; 0x6488 0x00c8
	addc	#4,200(r8)		; 0x62a8 0x00c8
	addc.b	#4,200(r8)		; 0x62e8 0x00c8
	addc.w	#4,200(r8)		; 0x62a8 0x00c8
	addc	#8,200(r8)		; 0x62b8 0x00c8
	addc.b	#8,200(r8)		; 0x62f8 0x00c8
	addc.w	#8,200(r8)		; 0x62b8 0x00c8
	addc	#0,200(r8)		; 0x6388 0x00c8
	addc.b	#0,200(r8)		; 0x63c8 0x00c8
	addc.w	#0,200(r8)		; 0x6388 0x00c8
	addc	#1,200(r8)		; 0x6398 0x00c8
	addc.b	#1,200(r8)		; 0x63d8 0x00c8
	addc.w	#1,200(r8)		; 0x6398 0x00c8
	addc	#2,200(r8)		; 0x63a8 0x00c8
	addc.b	#2,200(r8)		; 0x63e8 0x00c8
	addc.w	#2,200(r8)		; 0x63a8 0x00c8
	addc	#0ffffh,200(r8)		; 0x63b8 0x00c8
	addc.b	#0ffh,200(r8)		; 0x63f8 0x00c8
	addc.w	#0ffffh,200(r8)		; 0x63b8 0x00c8
	addc	#-1,200(r8)		; 0x63b8 0x00c8
	addc.b	#-1,200(r8)		; 0x63f8 0x00c8
	addc.w	#-1,200(r8)		; 0x63b8 0x00c8
	addc	#100,200(r8)		; 0x60b8 0x0064 0x00c8
	addc.b	#100,200(r8)		; 0x60f8 0x0064 0x00c8
	addc.w	#100,200(r8)		; 0x60b8 0x0064 0x00c8
	addc	@r6,200(r8)		; 0x66a8 0x00c8
	addc.b	@r6,200(r8)		; 0x66e8 0x00c8
	addc.w	@r6,200(r8)		; 0x66a8 0x00c8
	addc	42(r6),200(r8)		; 0x6698 0x002a 0x00c8
	addc.b	42(r6),200(r8)		; 0x66d8 0x002a 0x00c8
	addc.w	42(r6),200(r8)		; 0x6698 0x002a 0x00c8
	addc	@r6,200(r8)		; 0x66a8 0x00c8
	addc.b	@r6,200(r8)		; 0x66e8 0x00c8
	addc.w	@r6,200(r8)		; 0x66a8 0x00c8
	addc	@r6+,200(r8)		; 0x66b8 0x00c8
	addc.b	@r6+,200(r8)		; 0x66f8 0x00c8
	addc.w	@r6+,200(r8)		; 0x66b8 0x00c8
	addc	&1234h,200(r8)		; 0x6298 0x1234 0x00c8
	addc.b	&1234h,200(r8)		; 0x62d8 0x1234 0x00c8
	addc.w	&1234h,200(r8)		; 0x6298 0x1234 0x00c8
	addc	1234h,200(r8)		; 0x6098 0x0a5a 0x00c8
	addc.b	1234h,200(r8)		; 0x60d8 0x0a54 0x00c8
	addc.w	1234h,200(r8)		; 0x6098 0x0a4e 0x00c8
	addc	r4,&1234h		; 0x6482 0x1234
	addc.b	r4,&1234h		; 0x64c2 0x1234
	addc.w	r4,&1234h		; 0x6482 0x1234
	addc	#4,&1234h		; 0x62a2 0x1234
	addc.b	#4,&1234h		; 0x62e2 0x1234
	addc.w	#4,&1234h		; 0x62a2 0x1234
	addc	#8,&1234h		; 0x62b2 0x1234
	addc.b	#8,&1234h		; 0x62f2 0x1234
	addc.w	#8,&1234h		; 0x62b2 0x1234
	addc	#0,&1234h		; 0x6382 0x1234
	addc.b	#0,&1234h		; 0x63c2 0x1234
	addc.w	#0,&1234h		; 0x6382 0x1234
	addc	#1,&1234h		; 0x6392 0x1234
	addc.b	#1,&1234h		; 0x63d2 0x1234
	addc.w	#1,&1234h		; 0x6392 0x1234
	addc	#2,&1234h		; 0x63a2 0x1234
	addc.b	#2,&1234h		; 0x63e2 0x1234
	addc.w	#2,&1234h		; 0x63a2 0x1234
	addc	#0ffffh,&1234h		; 0x63b2 0x1234
	addc.b	#0ffh,&1234h		; 0x63f2 0x1234
	addc.w	#0ffffh,&1234h		; 0x63b2 0x1234
	addc	#-1,&1234h		; 0x63b2 0x1234
	addc.b	#-1,&1234h		; 0x63f2 0x1234
	addc.w	#-1,&1234h		; 0x63b2 0x1234
	addc	#100,&1234h		; 0x60b2 0x0064 0x1234
	addc.b	#100,&1234h		; 0x60f2 0x0064 0x1234
	addc.w	#100,&1234h		; 0x60b2 0x0064 0x1234
	addc	@r6,&1234h		; 0x66a2 0x1234
	addc.b	@r6,&1234h		; 0x66e2 0x1234
	addc.w	@r6,&1234h		; 0x66a2 0x1234
	addc	42(r6),&1234h		; 0x6692 0x002a 0x1234
	addc.b	42(r6),&1234h		; 0x66d2 0x002a 0x1234
	addc.w	42(r6),&1234h		; 0x6692 0x002a 0x1234
	addc	@r6,&1234h		; 0x66a2 0x1234
	addc.b	@r6,&1234h		; 0x66e2 0x1234
	addc.w	@r6,&1234h		; 0x66a2 0x1234
	addc	@r6+,&1234h		; 0x66b2 0x1234
	addc.b	@r6+,&1234h		; 0x66f2 0x1234
	addc.w	@r6+,&1234h		; 0x66b2 0x1234
	addc	&1234h,&1234h		; 0x6292 0x1234 0x1234
	addc.b	&1234h,&1234h		; 0x62d2 0x1234 0x1234
	addc.w	&1234h,&1234h		; 0x6292 0x1234 0x1234
	addc	1234h,&1234h		; 0x6092 0x098e 0x1234
	addc.b	1234h,&1234h		; 0x60d2 0x0988 0x1234
	addc.w	1234h,&1234h		; 0x6092 0x0982 0x1234
	addc	r4,1234h		; 0x6480 0x097c
	addc.b	r4,1234h		; 0x64c0 0x0978
	addc.w	r4,1234h		; 0x6480 0x0974
	addc	#4,1234h		; 0x62a0 0x0970
	addc.b	#4,1234h		; 0x62e0 0x096c
	addc.w	#4,1234h		; 0x62a0 0x0968
	addc	#8,1234h		; 0x62b0 0x0964
	addc.b	#8,1234h		; 0x62f0 0x0960
	addc.w	#8,1234h		; 0x62b0 0x095c
	addc	#0,1234h		; 0x6380 0x0958
	addc.b	#0,1234h		; 0x63c0 0x0954
	addc.w	#0,1234h		; 0x6380 0x0950
	addc	#1,1234h		; 0x6390 0x094c
	addc.b	#1,1234h		; 0x63d0 0x0948
	addc.w	#1,1234h		; 0x6390 0x0944
	addc	#2,1234h		; 0x63a0 0x0940
	addc.b	#2,1234h		; 0x63e0 0x093c
	addc.w	#2,1234h		; 0x63a0 0x0938
	addc	#0ffffh,1234h		; 0x63b0 0x0934
	addc.b	#0ffh,1234h		; 0x63f0 0x0930
	addc.w	#0ffffh,1234h		; 0x63b0 0x092c
	addc	#-1,1234h		; 0x63b0 0x0928
	addc.b	#-1,1234h		; 0x63f0 0x0924
	addc.w	#-1,1234h		; 0x63b0 0x0920
	addc	#100,1234h		; 0x60b0 0x0064 0x091a
	addc.b	#100,1234h		; 0x60f0 0x0064 0x0914
	addc.w	#100,1234h		; 0x60b0 0x0064 0x090e
	addc	@r6,1234h		; 0x66a0 0x090a
	addc.b	@r6,1234h		; 0x66e0 0x0906
	addc.w	@r6,1234h		; 0x66a0 0x0902
	addc	42(r6),1234h		; 0x6690 0x002a 0x08fc
	addc.b	42(r6),1234h		; 0x66d0 0x002a 0x08f6
	addc.w	42(r6),1234h		; 0x6690 0x002a 0x08f0
	addc	@r6,1234h		; 0x66a0 0x08ec
	addc.b	@r6,1234h		; 0x66e0 0x08e8
	addc.w	@r6,1234h		; 0x66a0 0x08e4
	addc	@r6+,1234h		; 0x66b0 0x08e0
	addc.b	@r6+,1234h		; 0x66f0 0x08dc
	addc.w	@r6+,1234h		; 0x66b0 0x08d8
	addc	&1234h,1234h		; 0x6290 0x1234 0x08d2
	addc.b	&1234h,1234h		; 0x62d0 0x1234 0x08cc
	addc.w	&1234h,1234h		; 0x6290 0x1234 0x08c6
	addc	1234h,1234h		; 0x6090 0x09c2 0x08c0
	addc.b	1234h,1234h		; 0x60d0 0x08bc 0x08ba
	addc.w	1234h,1234h		; 0x6090 0x08b6 0x08b4
	sub	r4,r7			; 0x8407
	sub.b	r4,r7			; 0x8447
	sub.w	r4,r7			; 0x8407
	sub	#4,r7			; 0x8227
	sub.b	#4,r7			; 0x8267
	sub.w	#4,r7			; 0x8227
	sub	#8,r7			; 0x8237
	sub.b	#8,r7			; 0x8277
	sub.w	#8,r7			; 0x8237
	sub	#0,r7			; 0x8307
	sub.b	#0,r7			; 0x8347
	sub.w	#0,r7			; 0x8307
	sub	#1,r7			; 0x8317
	sub.b	#1,r7			; 0x8357
	sub.w	#1,r7			; 0x8317
	sub	#2,r7			; 0x8327
	sub.b	#2,r7			; 0x8367
	sub.w	#2,r7			; 0x8327
	sub	#0ffffh,r7		; 0x8337
	sub.b	#0ffh,r7		; 0x8377
	sub.w	#0ffffh,r7		; 0x8337
	sub	#-1,r7			; 0x8337
	sub.b	#-1,r7			; 0x8377
	sub.w	#-1,r7			; 0x8337
	sub	#100,r7			; 0x8037 0x0064
	sub.b	#100,r7			; 0x8077 0x0064
	sub.w	#100,r7			; 0x8037 0x0064
	sub	@r6,r7			; 0x8627
	sub.b	@r6,r7			; 0x8667
	sub.w	@r6,r7			; 0x8627
	sub	42(r6),r7		; 0x8617 0x002a
	sub.b	42(r6),r7		; 0x8657 0x002a
	sub.w	42(r6),r7		; 0x8617 0x002a
	sub	@r6,r7			; 0x8627
	sub.b	@r6,r7			; 0x8667
	sub.w	@r6,r7			; 0x8627
	sub	@r6+,r7			; 0x8637
	sub.b	@r6+,r7			; 0x8677
	sub.w	@r6+,r7			; 0x8637
	sub	&1234h,r7		; 0x8217 0x1234
	sub.b	&1234h,r7		; 0x8257 0x1234
	sub.w	&1234h,r7		; 0x8217 0x1234
	sub	1234h,r7		; 0x8017 0x084a
	sub.b	1234h,r7		; 0x8057 0x0846
	sub.w	1234h,r7		; 0x8017 0x0842
	sub	r4,200(r8)		; 0x8488 0x00c8
	sub.b	r4,200(r8)		; 0x84c8 0x00c8
	sub.w	r4,200(r8)		; 0x8488 0x00c8
	sub	#4,200(r8)		; 0x82a8 0x00c8
	sub.b	#4,200(r8)		; 0x82e8 0x00c8
	sub.w	#4,200(r8)		; 0x82a8 0x00c8
	sub	#8,200(r8)		; 0x82b8 0x00c8
	sub.b	#8,200(r8)		; 0x82f8 0x00c8
	sub.w	#8,200(r8)		; 0x82b8 0x00c8
	sub	#0,200(r8)		; 0x8388 0x00c8
	sub.b	#0,200(r8)		; 0x83c8 0x00c8
	sub.w	#0,200(r8)		; 0x8388 0x00c8
	sub	#1,200(r8)		; 0x8398 0x00c8
	sub.b	#1,200(r8)		; 0x83d8 0x00c8
	sub.w	#1,200(r8)		; 0x8398 0x00c8
	sub	#2,200(r8)		; 0x83a8 0x00c8
	sub.b	#2,200(r8)		; 0x83e8 0x00c8
	sub.w	#2,200(r8)		; 0x83a8 0x00c8
	sub	#0ffffh,200(r8)		; 0x83b8 0x00c8
	sub.b	#0ffh,200(r8)		; 0x83f8 0x00c8
	sub.w	#0ffffh,200(r8)		; 0x83b8 0x00c8
	sub	#-1,200(r8)		; 0x83b8 0x00c8
	sub.b	#-1,200(r8)		; 0x83f8 0x00c8
	sub.w	#-1,200(r8)		; 0x83b8 0x00c8
	sub	#100,200(r8)		; 0x80b8 0x0064 0x00c8
	sub.b	#100,200(r8)		; 0x80f8 0x0064 0x00c8
	sub.w	#100,200(r8)		; 0x80b8 0x0064 0x00c8
	sub	@r6,200(r8)		; 0x86a8 0x00c8
	sub.b	@r6,200(r8)		; 0x86e8 0x00c8
	sub.w	@r6,200(r8)		; 0x86a8 0x00c8
	sub	42(r6),200(r8)		; 0x8698 0x002a 0x00c8
	sub.b	42(r6),200(r8)		; 0x86d8 0x002a 0x00c8
	sub.w	42(r6),200(r8)		; 0x8698 0x002a 0x00c8
	sub	@r6,200(r8)		; 0x86a8 0x00c8
	sub.b	@r6,200(r8)		; 0x86e8 0x00c8
	sub.w	@r6,200(r8)		; 0x86a8 0x00c8
	sub	@r6+,200(r8)		; 0x86b8 0x00c8
	sub.b	@r6+,200(r8)		; 0x86f8 0x00c8
	sub.w	@r6+,200(r8)		; 0x86b8 0x00c8
	sub	&1234h,200(r8)		; 0x8298 0x1234 0x00c8
	sub.b	&1234h,200(r8)		; 0x82d8 0x1234 0x00c8
	sub.w	&1234h,200(r8)		; 0x8298 0x1234 0x00c8
	sub	1234h,200(r8)		; 0x8098 0x0784 0x00c8
	sub.b	1234h,200(r8)		; 0x80d8 0x077e 0x00c8
	sub.w	1234h,200(r8)		; 0x8098 0x0778 0x00c8
	sub	r4,&1234h		; 0x8482 0x1234
	sub.b	r4,&1234h		; 0x84c2 0x1234
	sub.w	r4,&1234h		; 0x8482 0x1234
	sub	#4,&1234h		; 0x82a2 0x1234
	sub.b	#4,&1234h		; 0x82e2 0x1234
	sub.w	#4,&1234h		; 0x82a2 0x1234
	sub	#8,&1234h		; 0x82b2 0x1234
	sub.b	#8,&1234h		; 0x82f2 0x1234
	sub.w	#8,&1234h		; 0x82b2 0x1234
	sub	#0,&1234h		; 0x8382 0x1234
	sub.b	#0,&1234h		; 0x83c2 0x1234
	sub.w	#0,&1234h		; 0x8382 0x1234
	sub	#1,&1234h		; 0x8392 0x1234
	sub.b	#1,&1234h		; 0x83d2 0x1234
	sub.w	#1,&1234h		; 0x8392 0x1234
	sub	#2,&1234h		; 0x83a2 0x1234
	sub.b	#2,&1234h		; 0x83e2 0x1234
	sub.w	#2,&1234h		; 0x83a2 0x1234
	sub	#0ffffh,&1234h		; 0x83b2 0x1234
	sub.b	#0ffh,&1234h		; 0x83f2 0x1234
	sub.w	#0ffffh,&1234h		; 0x83b2 0x1234
	sub	#-1,&1234h		; 0x83b2 0x1234
	sub.b	#-1,&1234h		; 0x83f2 0x1234
	sub.w	#-1,&1234h		; 0x83b2 0x1234
	sub	#100,&1234h		; 0x80b2 0x0064 0x1234
	sub.b	#100,&1234h		; 0x80f2 0x0064 0x1234
	sub.w	#100,&1234h		; 0x80b2 0x0064 0x1234
	sub	@r6,&1234h		; 0x86a2 0x1234
	sub.b	@r6,&1234h		; 0x86e2 0x1234
	sub.w	@r6,&1234h		; 0x86a2 0x1234
	sub	42(r6),&1234h		; 0x8692 0x002a 0x1234
	sub.b	42(r6),&1234h		; 0x86d2 0x002a 0x1234
	sub.w	42(r6),&1234h		; 0x8692 0x002a 0x1234
	sub	@r6,&1234h		; 0x86a2 0x1234
	sub.b	@r6,&1234h		; 0x86e2 0x1234
	sub.w	@r6,&1234h		; 0x86a2 0x1234
	sub	@r6+,&1234h		; 0x86b2 0x1234
	sub.b	@r6+,&1234h		; 0x86f2 0x1234
	sub.w	@r6+,&1234h		; 0x86b2 0x1234
	sub	&1234h,&1234h		; 0x8292 0x1234 0x1234
	sub.b	&1234h,&1234h		; 0x82d2 0x1234 0x1234
	sub.w	&1234h,&1234h		; 0x8292 0x1234 0x1234
	sub	1234h,&1234h		; 0x8092 0x06b8 0x1234
	sub.b	1234h,&1234h		; 0x80d2 0x06b2 0x1234
	sub.w	1234h,&1234h		; 0x8092 0x06ac 0x1234
	sub	r4,1234h		; 0x8480 0x06a6
	sub.b	r4,1234h		; 0x84c0 0x06a2
	sub.w	r4,1234h		; 0x8480 0x069e
	sub	#4,1234h		; 0x82a0 0x069a
	sub.b	#4,1234h		; 0x82e0 0x0696
	sub.w	#4,1234h		; 0x82a0 0x0692
	sub	#8,1234h		; 0x82b0 0x068e
	sub.b	#8,1234h		; 0x82f0 0x068a
	sub.w	#8,1234h		; 0x82b0 0x0686
	sub	#0,1234h		; 0x8380 0x0682
	sub.b	#0,1234h		; 0x83c0 0x067e
	sub.w	#0,1234h		; 0x8380 0x067a
	sub	#1,1234h		; 0x8390 0x0676
	sub.b	#1,1234h		; 0x83d0 0x0672
	sub.w	#1,1234h		; 0x8390 0x066e
	sub	#2,1234h		; 0x83a0 0x066a
	sub.b	#2,1234h		; 0x83e0 0x0666
	sub.w	#2,1234h		; 0x83a0 0x0662
	sub	#0ffffh,1234h		; 0x83b0 0x065e
	sub.b	#0ffh,1234h		; 0x83f0 0x065a
	sub.w	#0ffffh,1234h		; 0x83b0 0x0656
	sub	#-1,1234h		; 0x83b0 0x0652
	sub.b	#-1,1234h		; 0x83f0 0x064e
	sub.w	#-1,1234h		; 0x83b0 0x064a
	sub	#100,1234h		; 0x80b0 0x0064 0x0644
	sub.b	#100,1234h		; 0x80f0 0x0064 0x063e
	sub.w	#100,1234h		; 0x80b0 0x0064 0x0638
	sub	@r6,1234h		; 0x86a0 0x0634
	sub.b	@r6,1234h		; 0x86e0 0x0630
	sub.w	@r6,1234h		; 0x86a0 0x062c
	sub	42(r6),1234h		; 0x8690 0x002a 0x0626
	sub.b	42(r6),1234h		; 0x86d0 0x002a 0x0620
	sub.w	42(r6),1234h		; 0x8690 0x002a 0x061a
	sub	@r6,1234h		; 0x86a0 0x0616
	sub.b	@r6,1234h		; 0x86e0 0x0612
	sub.w	@r6,1234h		; 0x86a0 0x060e
	sub	@r6+,1234h		; 0x86b0 0x060a
	sub.b	@r6+,1234h		; 0x86f0 0x0606
	sub.w	@r6+,1234h		; 0x86b0 0x0602
	sub	&1234h,1234h		; 0x8290 0x1234 0x05fc
	sub.b	&1234h,1234h		; 0x82d0 0x1234 0x05f6
	sub.w	&1234h,1234h		; 0x8290 0x1234 0x05f0
	sub	1234h,1234h		; 0x8090 0x05ec 0x05ea
	sub.b	1234h,1234h		; 0x80d0 0x05e6 0x05e4
	sub.w	1234h,1234h		; 0x8090 0x05e0 0x05de
	subc	r4,r7			; 0x7407
	subc.b	r4,r7			; 0x7447
	subc.w	r4,r7			; 0x7407
	subc	#4,r7			; 0x7227
	subc.b	#4,r7			; 0x7267
	subc.w	#4,r7			; 0x7227
	subc	#8,r7			; 0x7237
	subc.b	#8,r7			; 0x7277
	subc.w	#8,r7			; 0x7237
	subc	#0,r7			; 0x7307
	subc.b	#0,r7			; 0x7347
	subc.w	#0,r7			; 0x7307
	subc	#1,r7			; 0x7317
	subc.b	#1,r7			; 0x7357
	subc.w	#1,r7			; 0x7317
	subc	#2,r7			; 0x7327
	subc.b	#2,r7			; 0x7367
	subc.w	#2,r7			; 0x7327
	subc	#0ffffh,r7		; 0x7337
	subc.b	#0ffh,r7		; 0x7377
	subc.w	#0ffffh,r7		; 0x7337
	subc	#-1,r7			; 0x7337
	subc.b	#-1,r7			; 0x7377
	subc.w	#-1,r7			; 0x7337
	subc	#100,r7			; 0x7037 0x0064
	subc.b	#100,r7			; 0x7077 0x0064
	subc.w	#100,r7			; 0x7037 0x0064
	subc	@r6,r7			; 0x7627
	subc.b	@r6,r7			; 0x7667
	subc.w	@r6,r7			; 0x7627
	subc	42(r6),r7		; 0x7617 0x002a
	subc.b	42(r6),r7		; 0x7657 0x002a
	subc.w	42(r6),r7		; 0x7617 0x002a
	subc	@r6,r7			; 0x7627
	subc.b	@r6,r7			; 0x7667
	subc.w	@r6,r7			; 0x7627
	subc	@r6+,r7			; 0x7637
	subc.b	@r6+,r7			; 0x7677
	subc.w	@r6+,r7			; 0x7637
	subc	&1234h,r7		; 0x7217 0x1234
	subc.b	&1234h,r7		; 0x7257 0x1234
	subc.w	&1234h,r7		; 0x7217 0x1234
	subc	1234h,r7		; 0x7017 0x0574
	subc.b	1234h,r7		; 0x7057 0x0570
	subc.w	1234h,r7		; 0x7017 0x056c
	subc	r4,200(r8)		; 0x7488 0x00c8
	subc.b	r4,200(r8)		; 0x74c8 0x00c8
	subc.w	r4,200(r8)		; 0x7488 0x00c8
	subc	#4,200(r8)		; 0x72a8 0x00c8
	subc.b	#4,200(r8)		; 0x72e8 0x00c8
	subc.w	#4,200(r8)		; 0x72a8 0x00c8
	subc	#8,200(r8)		; 0x72b8 0x00c8
	subc.b	#8,200(r8)		; 0x72f8 0x00c8
	subc.w	#8,200(r8)		; 0x72b8 0x00c8
	subc	#0,200(r8)		; 0x7388 0x00c8
	subc.b	#0,200(r8)		; 0x73c8 0x00c8
	subc.w	#0,200(r8)		; 0x7388 0x00c8
	subc	#1,200(r8)		; 0x7398 0x00c8
	subc.b	#1,200(r8)		; 0x73d8 0x00c8
	subc.w	#1,200(r8)		; 0x7398 0x00c8
	subc	#2,200(r8)		; 0x73a8 0x00c8
	subc.b	#2,200(r8)		; 0x73e8 0x00c8
	subc.w	#2,200(r8)		; 0x73a8 0x00c8
	subc	#0ffffh,200(r8)		; 0x73b8 0x00c8
	subc.b	#0ffh,200(r8)		; 0x73f8 0x00c8
	subc.w	#0ffffh,200(r8)		; 0x73b8 0x00c8
	subc	#-1,200(r8)		; 0x73b8 0x00c8
	subc.b	#-1,200(r8)		; 0x73f8 0x00c8
	subc.w	#-1,200(r8)		; 0x73b8 0x00c8
	subc	#100,200(r8)		; 0x70b8 0x0064 0x00c8
	subc.b	#100,200(r8)		; 0x70f8 0x0064 0x00c8
	subc.w	#100,200(r8)		; 0x70b8 0x0064 0x00c8
	subc	@r6,200(r8)		; 0x76a8 0x00c8
	subc.b	@r6,200(r8)		; 0x76e8 0x00c8
	subc.w	@r6,200(r8)		; 0x76a8 0x00c8
	subc	42(r6),200(r8)		; 0x7698 0x002a 0x00c8
	subc.b	42(r6),200(r8)		; 0x76d8 0x002a 0x00c8
	subc.w	42(r6),200(r8)		; 0x7698 0x002a 0x00c8
	subc	@r6,200(r8)		; 0x76a8 0x00c8
	subc.b	@r6,200(r8)		; 0x76e8 0x00c8
	subc.w	@r6,200(r8)		; 0x76a8 0x00c8
	subc	@r6+,200(r8)		; 0x76b8 0x00c8
	subc.b	@r6+,200(r8)		; 0x76f8 0x00c8
	subc.w	@r6+,200(r8)		; 0x76b8 0x00c8
	subc	&1234h,200(r8)		; 0x7298 0x1234 0x00c8
	subc.b	&1234h,200(r8)		; 0x72d8 0x1234 0x00c8
	subc.w	&1234h,200(r8)		; 0x7298 0x1234 0x00c8
	subc	1234h,200(r8)		; 0x7098 0x04ae 0x00c8
	subc.b	1234h,200(r8)		; 0x70d8 0x04a8 0x00c8
	subc.w	1234h,200(r8)		; 0x7098 0x04a2 0x00c8
	subc	r4,&1234h		; 0x7482 0x1234
	subc.b	r4,&1234h		; 0x74c2 0x1234
	subc.w	r4,&1234h		; 0x7482 0x1234
	subc	#4,&1234h		; 0x72a2 0x1234
	subc.b	#4,&1234h		; 0x72e2 0x1234
	subc.w	#4,&1234h		; 0x72a2 0x1234
	subc	#8,&1234h		; 0x72b2 0x1234
	subc.b	#8,&1234h		; 0x72f2 0x1234
	subc.w	#8,&1234h		; 0x72b2 0x1234
	subc	#0,&1234h		; 0x7382 0x1234
	subc.b	#0,&1234h		; 0x73c2 0x1234
	subc.w	#0,&1234h		; 0x7382 0x1234
	subc	#1,&1234h		; 0x7392 0x1234
	subc.b	#1,&1234h		; 0x73d2 0x1234
	subc.w	#1,&1234h		; 0x7392 0x1234
	subc	#2,&1234h		; 0x73a2 0x1234
	subc.b	#2,&1234h		; 0x73e2 0x1234
	subc.w	#2,&1234h		; 0x73a2 0x1234
	subc	#0ffffh,&1234h		; 0x73b2 0x1234
	subc.b	#0ffh,&1234h		; 0x73f2 0x1234
	subc.w	#0ffffh,&1234h		; 0x73b2 0x1234
	subc	#-1,&1234h		; 0x73b2 0x1234
	subc.b	#-1,&1234h		; 0x73f2 0x1234
	subc.w	#-1,&1234h		; 0x73b2 0x1234
	subc	#100,&1234h		; 0x70b2 0x0064 0x1234
	subc.b	#100,&1234h		; 0x70f2 0x0064 0x1234
	subc.w	#100,&1234h		; 0x70b2 0x0064 0x1234
	subc	@r6,&1234h		; 0x76a2 0x1234
	subc.b	@r6,&1234h		; 0x76e2 0x1234
	subc.w	@r6,&1234h		; 0x76a2 0x1234
	subc	42(r6),&1234h		; 0x7692 0x002a 0x1234
	subc.b	42(r6),&1234h		; 0x76d2 0x002a 0x1234
	subc.w	42(r6),&1234h		; 0x7692 0x002a 0x1234
	subc	@r6,&1234h		; 0x76a2 0x1234
	subc.b	@r6,&1234h		; 0x76e2 0x1234
	subc.w	@r6,&1234h		; 0x76a2 0x1234
	subc	@r6+,&1234h		; 0x76b2 0x1234
	subc.b	@r6+,&1234h		; 0x76f2 0x1234
	subc.w	@r6+,&1234h		; 0x76b2 0x1234
	subc	&1234h,&1234h		; 0x7292 0x1234 0x1234
	subc.b	&1234h,&1234h		; 0x72d2 0x1234 0x1234
	subc.w	&1234h,&1234h		; 0x7292 0x1234 0x1234
	subc	1234h,&1234h		; 0x7092 0x03e2 0x1234
	subc.b	1234h,&1234h		; 0x70d2 0x03dc 0x1234
	subc.w	1234h,&1234h		; 0x7092 0x03d6 0x1234
	subc	r4,1234h		; 0x7480 0x03d0
	subc.b	r4,1234h		; 0x74c0 0x03cc
	subc.w	r4,1234h		; 0x7480 0x03c8
	subc	#4,1234h		; 0x72a0 0x03c4
	subc.b	#4,1234h		; 0x72e0 0x03c0
	subc.w	#4,1234h		; 0x72a0 0x03bc
	subc	#8,1234h		; 0x72b0 0x03b8
	subc.b	#8,1234h		; 0x72f0 0x03b4
	subc.w	#8,1234h		; 0x72b0 0x03b0
	subc	#0,1234h		; 0x7380 0x03ac
	subc.b	#0,1234h		; 0x73c0 0x03a8
	subc.w	#0,1234h		; 0x7380 0x03a4
	subc	#1,1234h		; 0x7390 0x03a0
	subc.b	#1,1234h		; 0x73d0 0x039c
	subc.w	#1,1234h		; 0x7390 0x0398
	subc	#2,1234h		; 0x73a0 0x0394
	subc.b	#2,1234h		; 0x73e0 0x0390
	subc.w	#2,1234h		; 0x73a0 0x038c
	subc	#0ffffh,1234h		; 0x73b0 0x0388
	subc.b	#0ffh,1234h		; 0x73f0 0x0384
	subc.w	#0ffffh,1234h		; 0x73b0 0x0380
	subc	#-1,1234h		; 0x73b0 0x037c
	subc.b	#-1,1234h		; 0x73f0 0x0378
	subc.w	#-1,1234h		; 0x73b0 0x0374
	subc	#100,1234h		; 0x70b0 0x0064 0x036e
	subc.b	#100,1234h		; 0x70f0 0x0064 0x0368
	subc.w	#100,1234h		; 0x70b0 0x0064 0x0362
	subc	@r6,1234h		; 0x76a0 0x035e
	subc.b	@r6,1234h		; 0x76e0 0x035a
	subc.w	@r6,1234h		; 0x76a0 0x0356
	subc	42(r6),1234h		; 0x7690 0x002a 0x0350
	subc.b	42(r6),1234h		; 0x76d0 0x002a 0x034a
	subc.w	42(r6),1234h		; 0x7690 0x002a 0x0344
	subc	@r6,1234h		; 0x76a0 0x0340
	subc.b	@r6,1234h		; 0x76e0 0x033c
	subc.w	@r6,1234h		; 0x76a0 0x0338
	subc	@r6+,1234h		; 0x76b0 0x0334
	subc.b	@r6+,1234h		; 0x76f0 0x0330
	subc.w	@r6+,1234h		; 0x76b0 0x032c
	subc	&1234h,1234h		; 0x7290 0x1234 0x0326
	subc.b	&1234h,1234h		; 0x72d0 0x1234 0x0320
	subc.w	&1234h,1234h		; 0x7290 0x1234 0x031a
	subc	1234h,1234h		; 0x7090 0x0316 0x0314
	subc.b	1234h,1234h		; 0x70d0 0x0310 0x030e
	subc.w	1234h,1234h		; 0x7090 0x030a 0x0308
	cmp	r4,r7			; 0x9407
	cmp.b	r4,r7			; 0x9447
	cmp.w	r4,r7			; 0x9407
	cmp	#4,r7			; 0x9227
	cmp.b	#4,r7			; 0x9267
	cmp.w	#4,r7			; 0x9227
	cmp	#8,r7			; 0x9237
	cmp.b	#8,r7			; 0x9277
	cmp.w	#8,r7			; 0x9237
	cmp	#0,r7			; 0x9307
	cmp.b	#0,r7			; 0x9347
	cmp.w	#0,r7			; 0x9307
	cmp	#1,r7			; 0x9317
	cmp.b	#1,r7			; 0x9357
	cmp.w	#1,r7			; 0x9317
	cmp	#2,r7			; 0x9327
	cmp.b	#2,r7			; 0x9367
	cmp.w	#2,r7			; 0x9327
	cmp	#0ffffh,r7		; 0x9337
	cmp.b	#0ffh,r7		; 0x9377
	cmp.w	#0ffffh,r7		; 0x9337
	cmp	#-1,r7			; 0x9337
	cmp.b	#-1,r7			; 0x9377
	cmp.w	#-1,r7			; 0x9337
	cmp	#100,r7			; 0x9037 0x0064
	cmp.b	#100,r7			; 0x9077 0x0064
	cmp.w	#100,r7			; 0x9037 0x0064
	cmp	@r6,r7			; 0x9627
	cmp.b	@r6,r7			; 0x9667
	cmp.w	@r6,r7			; 0x9627
	cmp	42(r6),r7		; 0x9617 0x002a
	cmp.b	42(r6),r7		; 0x9657 0x002a
	cmp.w	42(r6),r7		; 0x9617 0x002a
	cmp	@r6,r7			; 0x9627
	cmp.b	@r6,r7			; 0x9667
	cmp.w	@r6,r7			; 0x9627
	cmp	@r6+,r7			; 0x9637
	cmp.b	@r6+,r7			; 0x9677
	cmp.w	@r6+,r7			; 0x9637
	cmp	&1234h,r7		; 0x9217 0x1234
	cmp.b	&1234h,r7		; 0x9257 0x1234
	cmp.w	&1234h,r7		; 0x9217 0x1234
	cmp	1234h,r7		; 0x9017 0x029e
	cmp.b	1234h,r7		; 0x9057 0x029a
	cmp.w	1234h,r7		; 0x9017 0x0296
	cmp	r4,200(r8)		; 0x9488 0x00c8
	cmp.b	r4,200(r8)		; 0x94c8 0x00c8
	cmp.w	r4,200(r8)		; 0x9488 0x00c8
	cmp	#4,200(r8)		; 0x92a8 0x00c8
	cmp.b	#4,200(r8)		; 0x92e8 0x00c8
	cmp.w	#4,200(r8)		; 0x92a8 0x00c8
	cmp	#8,200(r8)		; 0x92b8 0x00c8
	cmp.b	#8,200(r8)		; 0x92f8 0x00c8
	cmp.w	#8,200(r8)		; 0x92b8 0x00c8
	cmp	#0,200(r8)		; 0x9388 0x00c8
	cmp.b	#0,200(r8)		; 0x93c8 0x00c8
	cmp.w	#0,200(r8)		; 0x9388 0x00c8
	cmp	#1,200(r8)		; 0x9398 0x00c8
	cmp.b	#1,200(r8)		; 0x93d8 0x00c8
	cmp.w	#1,200(r8)		; 0x9398 0x00c8
	cmp	#2,200(r8)		; 0x93a8 0x00c8
	cmp.b	#2,200(r8)		; 0x93e8 0x00c8
	cmp.w	#2,200(r8)		; 0x93a8 0x00c8
	cmp	#0ffffh,200(r8)		; 0x93b8 0x00c8
	cmp.b	#0ffh,200(r8)		; 0x93f8 0x00c8
	cmp.w	#0ffffh,200(r8)		; 0x93b8 0x00c8
	cmp	#-1,200(r8)		; 0x93b8 0x00c8
	cmp.b	#-1,200(r8)		; 0x93f8 0x00c8
	cmp.w	#-1,200(r8)		; 0x93b8 0x00c8
	cmp	#100,200(r8)		; 0x90b8 0x0064 0x00c8
	cmp.b	#100,200(r8)		; 0x90f8 0x0064 0x00c8
	cmp.w	#100,200(r8)		; 0x90b8 0x0064 0x00c8
	cmp	@r6,200(r8)		; 0x96a8 0x00c8
	cmp.b	@r6,200(r8)		; 0x96e8 0x00c8
	cmp.w	@r6,200(r8)		; 0x96a8 0x00c8
	cmp	42(r6),200(r8)		; 0x9698 0x002a 0x00c8
	cmp.b	42(r6),200(r8)		; 0x96d8 0x002a 0x00c8
	cmp.w	42(r6),200(r8)		; 0x9698 0x002a 0x00c8
	cmp	@r6,200(r8)		; 0x96a8 0x00c8
	cmp.b	@r6,200(r8)		; 0x96e8 0x00c8
	cmp.w	@r6,200(r8)		; 0x96a8 0x00c8
	cmp	@r6+,200(r8)		; 0x96b8 0x00c8
	cmp.b	@r6+,200(r8)		; 0x96f8 0x00c8
	cmp.w	@r6+,200(r8)		; 0x96b8 0x00c8
	cmp	&1234h,200(r8)		; 0x9298 0x1234 0x00c8
	cmp.b	&1234h,200(r8)		; 0x92d8 0x1234 0x00c8
	cmp.w	&1234h,200(r8)		; 0x9298 0x1234 0x00c8
	cmp	1234h,200(r8)		; 0x9098 0x01d8 0x00c8
	cmp.b	1234h,200(r8)		; 0x90d8 0x01d2 0x00c8
	cmp.w	1234h,200(r8)		; 0x9098 0x01cc 0x00c8
	cmp	r4,&1234h		; 0x9482 0x1234
	cmp.b	r4,&1234h		; 0x94c2 0x1234
	cmp.w	r4,&1234h		; 0x9482 0x1234
	cmp	#4,&1234h		; 0x92a2 0x1234
	cmp.b	#4,&1234h		; 0x92e2 0x1234
	cmp.w	#4,&1234h		; 0x92a2 0x1234
	cmp	#8,&1234h		; 0x92b2 0x1234
	cmp.b	#8,&1234h		; 0x92f2 0x1234
	cmp.w	#8,&1234h		; 0x92b2 0x1234
	cmp	#0,&1234h		; 0x9382 0x1234
	cmp.b	#0,&1234h		; 0x93c2 0x1234
	cmp.w	#0,&1234h		; 0x9382 0x1234
	cmp	#1,&1234h		; 0x9392 0x1234
	cmp.b	#1,&1234h		; 0x93d2 0x1234
	cmp.w	#1,&1234h		; 0x9392 0x1234
	cmp	#2,&1234h		; 0x93a2 0x1234
	cmp.b	#2,&1234h		; 0x93e2 0x1234
	cmp.w	#2,&1234h		; 0x93a2 0x1234
	cmp	#0ffffh,&1234h		; 0x93b2 0x1234
	cmp.b	#0ffh,&1234h		; 0x93f2 0x1234
	cmp.w	#0ffffh,&1234h		; 0x93b2 0x1234
	cmp	#-1,&1234h		; 0x93b2 0x1234
	cmp.b	#-1,&1234h		; 0x93f2 0x1234
	cmp.w	#-1,&1234h		; 0x93b2 0x1234
	cmp	#100,&1234h		; 0x90b2 0x0064 0x1234
	cmp.b	#100,&1234h		; 0x90f2 0x0064 0x1234
	cmp.w	#100,&1234h		; 0x90b2 0x0064 0x1234
	cmp	@r6,&1234h		; 0x96a2 0x1234
	cmp.b	@r6,&1234h		; 0x96e2 0x1234
	cmp.w	@r6,&1234h		; 0x96a2 0x1234
	cmp	42(r6),&1234h		; 0x9692 0x002a 0x1234
	cmp.b	42(r6),&1234h		; 0x96d2 0x002a 0x1234
	cmp.w	42(r6),&1234h		; 0x9692 0x002a 0x1234
	cmp	@r6,&1234h		; 0x96a2 0x1234
	cmp.b	@r6,&1234h		; 0x96e2 0x1234
	cmp.w	@r6,&1234h		; 0x96a2 0x1234
	cmp	@r6+,&1234h		; 0x96b2 0x1234
	cmp.b	@r6+,&1234h		; 0x96f2 0x1234
	cmp.w	@r6+,&1234h		; 0x96b2 0x1234
	cmp	&1234h,&1234h		; 0x9292 0x1234 0x1234
	cmp.b	&1234h,&1234h		; 0x92d2 0x1234 0x1234
	cmp.w	&1234h,&1234h		; 0x9292 0x1234 0x1234
	cmp	1234h,&1234h		; 0x9092 0x010c 0x1234
	cmp.b	1234h,&1234h		; 0x90d2 0x0106 0x1234
	cmp.w	1234h,&1234h		; 0x9092 0x0100 0x1234
	cmp	r4,1234h		; 0x9480 0x00fa
	cmp.b	r4,1234h		; 0x94c0 0x00f6
	cmp.w	r4,1234h		; 0x9480 0x00f2
	cmp	#4,1234h		; 0x92a0 0x00ee
	cmp.b	#4,1234h		; 0x92e0 0x00ea
	cmp.w	#4,1234h		; 0x92a0 0x00e6
	cmp	#8,1234h		; 0x92b0 0x00e2
	cmp.b	#8,1234h		; 0x92f0 0x00de
	cmp.w	#8,1234h		; 0x92b0 0x00da
	cmp	#0,1234h		; 0x9380 0x00d6
	cmp.b	#0,1234h		; 0x93c0 0x00d2
	cmp.w	#0,1234h		; 0x9380 0x00ce
	cmp	#1,1234h		; 0x9390 0x00ca
	cmp.b	#1,1234h		; 0x93d0 0x00c6
	cmp.w	#1,1234h		; 0x9390 0x00c2
	cmp	#2,1234h		; 0x93a0 0x00be
	cmp.b	#2,1234h		; 0x93e0 0x00ba
	cmp.w	#2,1234h		; 0x93a0 0x00b6
	cmp	#0ffffh,1234h		; 0x93b0 0x00b2
	cmp.b	#0ffh,1234h		; 0x93f0 0x00ae
	cmp.w	#0ffffh,1234h		; 0x93b0 0x00aa
	cmp	#-1,1234h		; 0x93b0 0x00a6
	cmp.b	#-1,1234h		; 0x93f0 0x00a2
	cmp.w	#-1,1234h		; 0x93b0 0x009e
	cmp	#100,1234h		; 0x90b0 0x0064 0x0098
	cmp.b	#100,1234h		; 0x90f0 0x0064 0x0092
	cmp.w	#100,1234h		; 0x90b0 0x0064 0x008c
	cmp	@r6,1234h		; 0x96a0 0x0088
	cmp.b	@r6,1234h		; 0x96e0 0x0084
	cmp.w	@r6,1234h		; 0x96a0 0x0080
	cmp	42(r6),1234h		; 0x9690 0x002a 0x007a
	cmp.b	42(r6),1234h		; 0x96d0 0x002a 0x0074
	cmp.w	42(r6),1234h		; 0x9690 0x002a 0x006e
	cmp	@r6,1234h		; 0x96a0 0x006a
	cmp.b	@r6,1234h		; 0x96e0 0x0066
	cmp.w	@r6,1234h		; 0x96a0 0x0062
	cmp	@r6+,1234h		; 0x96b0 0x005e
	cmp.b	@r6+,1234h		; 0x96f0 0x005a
	cmp.w	@r6+,1234h		; 0x96b0 0x0056
	cmp	&1234h,1234h		; 0x9290 0x1234 0x0050
	cmp.b	&1234h,1234h		; 0x92d0 0x1234 0x004a
	cmp.w	&1234h,1234h		; 0x9290 0x1234 0x0044
	cmp	1234h,1234h		; 0x9090 0x0040 0x003e
	cmp.b	1234h,1234h		; 0x90d0 0x003a 0x0038
	cmp.w	1234h,1234h		; 0x9090 0x0034 0x0032
	dadd	r4,r7			; 0xa407
	dadd.b	r4,r7			; 0xa447
	dadd.w	r4,r7			; 0xa407
	dadd	#4,r7			; 0xa227
	dadd.b	#4,r7			; 0xa267
	dadd.w	#4,r7			; 0xa227
	dadd	#8,r7			; 0xa237
	dadd.b	#8,r7			; 0xa277
	dadd.w	#8,r7			; 0xa237
	dadd	#0,r7			; 0xa307
	dadd.b	#0,r7			; 0xa347
	dadd.w	#0,r7			; 0xa307
	dadd	#1,r7			; 0xa317
	dadd.b	#1,r7			; 0xa357
	dadd.w	#1,r7			; 0xa317
	dadd	#2,r7			; 0xa327
	dadd.b	#2,r7			; 0xa367
	dadd.w	#2,r7			; 0xa327
	dadd	#0ffffh,r7		; 0xa337
	dadd.b	#0ffh,r7		; 0xa377
	dadd.w	#0ffffh,r7		; 0xa337
	dadd	#-1,r7			; 0xa337
	dadd.b	#-1,r7			; 0xa377
	dadd.w	#-1,r7			; 0xa337
	dadd	#100,r7			; 0xa037 0x0064
	dadd.b	#100,r7			; 0xa077 0x0064
	dadd.w	#100,r7			; 0xa037 0x0064
	dadd	@r6,r7			; 0xa627
	dadd.b	@r6,r7			; 0xa667
	dadd.w	@r6,r7			; 0xa627
	dadd	42(r6),r7		; 0xa617 0x002a
	dadd.b	42(r6),r7		; 0xa657 0x002a
	dadd.w	42(r6),r7		; 0xa617 0x002a
	dadd	@r6,r7			; 0xa627
	dadd.b	@r6,r7			; 0xa667
	dadd.w	@r6,r7			; 0xa627
	dadd	@r6+,r7			; 0xa637
	dadd.b	@r6+,r7			; 0xa677
	dadd.w	@r6+,r7			; 0xa637
	dadd	&1234h,r7		; 0xa217 0x1234
	dadd.b	&1234h,r7		; 0xa257 0x1234
	dadd.w	&1234h,r7		; 0xa217 0x1234
	dadd	1234h,r7		; 0xa017 0xffc8
	dadd.b	1234h,r7		; 0xa057 0xffc4
	dadd.w	1234h,r7		; 0xa017 0xffc0
	dadd	r4,200(r8)		; 0xa488 0x00c8
	dadd.b	r4,200(r8)		; 0xa4c8 0x00c8
	dadd.w	r4,200(r8)		; 0xa488 0x00c8
	dadd	#4,200(r8)		; 0xa2a8 0x00c8
	dadd.b	#4,200(r8)		; 0xa2e8 0x00c8
	dadd.w	#4,200(r8)		; 0xa2a8 0x00c8
	dadd	#8,200(r8)		; 0xa2b8 0x00c8
	dadd.b	#8,200(r8)		; 0xa2f8 0x00c8
	dadd.w	#8,200(r8)		; 0xa2b8 0x00c8
	dadd	#0,200(r8)		; 0xa388 0x00c8
	dadd.b	#0,200(r8)		; 0xa3c8 0x00c8
	dadd.w	#0,200(r8)		; 0xa388 0x00c8
	dadd	#1,200(r8)		; 0xa398 0x00c8
	dadd.b	#1,200(r8)		; 0xa3d8 0x00c8
	dadd.w	#1,200(r8)		; 0xa398 0x00c8
	dadd	#2,200(r8)		; 0xa3a8 0x00c8
	dadd.b	#2,200(r8)		; 0xa3e8 0x00c8
	dadd.w	#2,200(r8)		; 0xa3a8 0x00c8
	dadd	#0ffffh,200(r8)		; 0xa3b8 0x00c8
	dadd.b	#0ffh,200(r8)		; 0xa3f8 0x00c8
	dadd.w	#0ffffh,200(r8)		; 0xa3b8 0x00c8
	dadd	#-1,200(r8)		; 0xa3b8 0x00c8
	dadd.b	#-1,200(r8)		; 0xa3f8 0x00c8
	dadd.w	#-1,200(r8)		; 0xa3b8 0x00c8
	dadd	#100,200(r8)		; 0xa0b8 0x0064 0x00c8
	dadd.b	#100,200(r8)		; 0xa0f8 0x0064 0x00c8
	dadd.w	#100,200(r8)		; 0xa0b8 0x0064 0x00c8
	dadd	@r6,200(r8)		; 0xa6a8 0x00c8
	dadd.b	@r6,200(r8)		; 0xa6e8 0x00c8
	dadd.w	@r6,200(r8)		; 0xa6a8 0x00c8
	dadd	42(r6),200(r8)		; 0xa698 0x002a 0x00c8
	dadd.b	42(r6),200(r8)		; 0xa6d8 0x002a 0x00c8
	dadd.w	42(r6),200(r8)		; 0xa698 0x002a 0x00c8
	dadd	@r6,200(r8)		; 0xa6a8 0x00c8
	dadd.b	@r6,200(r8)		; 0xa6e8 0x00c8
	dadd.w	@r6,200(r8)		; 0xa6a8 0x00c8
	dadd	@r6+,200(r8)		; 0xa6b8 0x00c8
	dadd.b	@r6+,200(r8)		; 0xa6f8 0x00c8
	dadd.w	@r6+,200(r8)		; 0xa6b8 0x00c8
	dadd	&1234h,200(r8)		; 0xa298 0x1234 0x00c8
	dadd.b	&1234h,200(r8)		; 0xa2d8 0x1234 0x00c8
	dadd.w	&1234h,200(r8)		; 0xa298 0x1234 0x00c8
	dadd	1234h,200(r8)		; 0xa098 0xffc2 0x00c8
	dadd.b	1234h,200(r8)		; 0xa0d8 0xfefc 0x00c8
	dadd.w	1234h,200(r8)		; 0xa098 0xfef6 0x00c8
	dadd	r4,&1234h		; 0xa482 0x1234
	dadd.b	r4,&1234h		; 0xa4c2 0x1234
	dadd.w	r4,&1234h		; 0xa482 0x1234
	dadd	#4,&1234h		; 0xa2a2 0x1234
	dadd.b	#4,&1234h		; 0xa2e2 0x1234
	dadd.w	#4,&1234h		; 0xa2a2 0x1234
	dadd	#8,&1234h		; 0xa2b2 0x1234
	dadd.b	#8,&1234h		; 0xa2f2 0x1234
	dadd.w	#8,&1234h		; 0xa2b2 0x1234
	dadd	#0,&1234h		; 0xa382 0x1234
	dadd.b	#0,&1234h		; 0xa3c2 0x1234
	dadd.w	#0,&1234h		; 0xa382 0x1234
	dadd	#1,&1234h		; 0xa392 0x1234
	dadd.b	#1,&1234h		; 0xa3d2 0x1234
	dadd.w	#1,&1234h		; 0xa392 0x1234
	dadd	#2,&1234h		; 0xa3a2 0x1234
	dadd.b	#2,&1234h		; 0xa3e2 0x1234
	dadd.w	#2,&1234h		; 0xa3a2 0x1234
	dadd	#0ffffh,&1234h		; 0xa3b2 0x1234
	dadd.b	#0ffh,&1234h		; 0xa3f2 0x1234
	dadd.w	#0ffffh,&1234h		; 0xa3b2 0x1234
	dadd	#-1,&1234h		; 0xa3b2 0x1234
	dadd.b	#-1,&1234h		; 0xa3f2 0x1234
	dadd.w	#-1,&1234h		; 0xa3b2 0x1234
	dadd	#100,&1234h		; 0xa0b2 0x0064 0x1234
	dadd.b	#100,&1234h		; 0xa0f2 0x0064 0x1234
	dadd.w	#100,&1234h		; 0xa0b2 0x0064 0x1234
	dadd	@r6,&1234h		; 0xa6a2 0x1234
	dadd.b	@r6,&1234h		; 0xa6e2 0x1234
	dadd.w	@r6,&1234h		; 0xa6a2 0x1234
	dadd	42(r6),&1234h		; 0xa692 0x002a 0x1234
	dadd.b	42(r6),&1234h		; 0xa6d2 0x002a 0x1234
	dadd.w	42(r6),&1234h		; 0xa692 0x002a 0x1234
	dadd	@r6,&1234h		; 0xa6a2 0x1234
	dadd.b	@r6,&1234h		; 0xa6e2 0x1234
	dadd.w	@r6,&1234h		; 0xa6a2 0x1234
	dadd	@r6+,&1234h		; 0xa6b2 0x1234
	dadd.b	@r6+,&1234h		; 0xa6f2 0x1234
	dadd.w	@r6+,&1234h		; 0xa6b2 0x1234
	dadd	&1234h,&1234h		; 0xa292 0x1234 0x1234
	dadd.b	&1234h,&1234h		; 0xa2d2 0x1234 0x1234
	dadd.w	&1234h,&1234h		; 0xa292 0x1234 0x1234
	dadd	1234h,&1234h		; 0xa092 0xfe36 0x1234
	dadd.b	1234h,&1234h		; 0xa0d2 0xfe30 0x1234
	dadd.w	1234h,&1234h		; 0xa092 0xfe2a 0x1234
	dadd	r4,1234h		; 0xa480 0xfe24
	dadd.b	r4,1234h		; 0xa4c0 0xfe20
	dadd.w	r4,1234h		; 0xa480 0xfe1c
	dadd	#4,1234h		; 0xa2a0 0xfe18
	dadd.b	#4,1234h		; 0xa2e0 0xfe14
	dadd.w	#4,1234h		; 0xa2a0 0xfe10
	dadd	#8,1234h		; 0xa2b0 0xfe0c
	dadd.b	#8,1234h		; 0xa2f0 0xfe08
	dadd.w	#8,1234h		; 0xa2b0 0xfe04
	dadd	#0,1234h		; 0xa380 0xfe00
	dadd.b	#0,1234h		; 0xa3c0 0xfdfc
	dadd.w	#0,1234h		; 0xa380 0xfdf8
	dadd	#1,1234h		; 0xa390 0xfdf4
	dadd.b	#1,1234h		; 0xa3d0 0xfdf0
	dadd.w	#1,1234h		; 0xa390 0xfdec
	dadd	#2,1234h		; 0xa3a0 0xfde8
	dadd.b	#2,1234h		; 0xa3e0 0xfde4
	dadd.w	#2,1234h		; 0xa3a0 0xfde0
	dadd	#0ffffh,1234h		; 0xa3b0 0xfddc
	dadd.b	#0ffh,1234h		; 0xa3f0 0xfdd8
	dadd.w	#0ffffh,1234h		; 0xa3b0 0xfdd4
	dadd	#-1,1234h		; 0xa3b0 0xfdd0
	dadd.b	#-1,1234h		; 0xa3f0 0xfdcc
	dadd.w	#-1,1234h		; 0xa3b0 0xfdc8
	dadd	#100,1234h		; 0xa0b0 0x0064 0xfdc2
	dadd.b	#100,1234h		; 0xa0f0 0x0064 0xfdbc
	dadd.w	#100,1234h		; 0xa0b0 0x0064 0xfdb6
	dadd	@r6,1234h		; 0xa6a0 0xfdb2
	dadd.b	@r6,1234h		; 0xa6e0 0xfdae
	dadd.w	@r6,1234h		; 0xa6a0 0xfdaa
	dadd	42(r6),1234h		; 0xa690 0x002a 0xfda4
	dadd.b	42(r6),1234h		; 0xa6d0 0x002a 0xfd9e
	dadd.w	42(r6),1234h		; 0xa690 0x002a 0xfd98
	dadd	@r6,1234h		; 0xa6a0 0xfd94
	dadd.b	@r6,1234h		; 0xa6e0 0xfd90
	dadd.w	@r6,1234h		; 0xa6a0 0xfd8c
	dadd	@r6+,1234h		; 0xa6b0 0xfd88
	dadd.b	@r6+,1234h		; 0xa6f0 0xfd84
	dadd.w	@r6+,1234h		; 0xa6b0 0xfd80
	dadd	&1234h,1234h		; 0xa290 0x1234 0xfd7a
	dadd.b	&1234h,1234h		; 0xa2d0 0x1234 0xfd74
	dadd.w	&1234h,1234h		; 0xa290 0x1234 0xfd6e
	dadd	1234h,1234h		; 0xa090 0xfd6a 0xfd68
	dadd.b	1234h,1234h		; 0xa0d0 0xfd64 0xfd62
	dadd.w	1234h,1234h		; 0xa090 0xfd5e 0xfd5c
	bit	r4,r7			; 0xb407
	bit.b	r4,r7			; 0xb447
	bit.w	r4,r7			; 0xb407
	bit	#4,r7			; 0xb227
	bit.b	#4,r7			; 0xb267
	bit.w	#4,r7			; 0xb227
	bit	#8,r7			; 0xb237
	bit.b	#8,r7			; 0xb277
	bit.w	#8,r7			; 0xb237
	bit	#0,r7			; 0xb307
	bit.b	#0,r7			; 0xb347
	bit.w	#0,r7			; 0xb307
	bit	#1,r7			; 0xb317
	bit.b	#1,r7			; 0xb357
	bit.w	#1,r7			; 0xb317
	bit	#2,r7			; 0xb327
	bit.b	#2,r7			; 0xb367
	bit.w	#2,r7			; 0xb327
	bit	#0ffffh,r7		; 0xb337
	bit.b	#0ffh,r7		; 0xb377
	bit.w	#0ffffh,r7		; 0xb337
	bit	#-1,r7			; 0xb337
	bit.b	#-1,r7			; 0xb377
	bit.w	#-1,r7			; 0xb337
	bit	#100,r7			; 0xb037 0x0064
	bit.b	#100,r7			; 0xb077 0x0064
	bit.w	#100,r7			; 0xb037 0x0064
	bit	@r6,r7			; 0xb627
	bit.b	@r6,r7			; 0xb667
	bit.w	@r6,r7			; 0xb627
	bit	42(r6),r7		; 0xb617 0x002a
	bit.b	42(r6),r7		; 0xb657 0x002a
	bit.w	42(r6),r7		; 0xb617 0x002a
	bit	@r6,r7			; 0xb627
	bit.b	@r6,r7			; 0xb667
	bit.w	@r6,r7			; 0xb627
	bit	@r6+,r7			; 0xb637
	bit.b	@r6+,r7			; 0xb677
	bit.w	@r6+,r7			; 0xb637
	bit	&1234h,r7		; 0xb217 0x1234
	bit.b	&1234h,r7		; 0xb257 0x1234
	bit.w	&1234h,r7		; 0xb217 0x1234
	bit	1234h,r7		; 0xb017 0xfcf2
	bit.b	1234h,r7		; 0xb057 0xfcee
	bit.w	1234h,r7		; 0xb017 0xfcea
	bit	r4,200(r8)		; 0xb488 0x00c8
	bit.b	r4,200(r8)		; 0xb4c8 0x00c8
	bit.w	r4,200(r8)		; 0xb488 0x00c8
	bit	#4,200(r8)		; 0xb2a8 0x00c8
	bit.b	#4,200(r8)		; 0xb2e8 0x00c8
	bit.w	#4,200(r8)		; 0xb2a8 0x00c8
	bit	#8,200(r8)		; 0xb2b8 0x00c8
	bit.b	#8,200(r8)		; 0xb2f8 0x00c8
	bit.w	#8,200(r8)		; 0xb2b8 0x00c8
	bit	#0,200(r8)		; 0xb388 0x00c8
	bit.b	#0,200(r8)		; 0xb3c8 0x00c8
	bit.w	#0,200(r8)		; 0xb388 0x00c8
	bit	#1,200(r8)		; 0xb398 0x00c8
	bit.b	#1,200(r8)		; 0xb3d8 0x00c8
	bit.w	#1,200(r8)		; 0xb398 0x00c8
	bit	#2,200(r8)		; 0xb3a8 0x00c8
	bit.b	#2,200(r8)		; 0xb3e8 0x00c8
	bit.w	#2,200(r8)		; 0xb3a8 0x00c8
	bit	#0ffffh,200(r8)		; 0xb3b8 0x00c8
	bit.b	#0ffh,200(r8)		; 0xb3f8 0x00c8
	bit.w	#0ffffh,200(r8)		; 0xb3b8 0x00c8
	bit	#-1,200(r8)		; 0xb3b8 0x00c8
	bit.b	#-1,200(r8)		; 0xb3f8 0x00c8
	bit.w	#-1,200(r8)		; 0xb3b8 0x00c8
	bit	#100,200(r8)		; 0xb0b8 0x0064 0x00c8
	bit.b	#100,200(r8)		; 0xb0f8 0x0064 0x00c8
	bit.w	#100,200(r8)		; 0xb0b8 0x0064 0x00c8
	bit	@r6,200(r8)		; 0xb6a8 0x00c8
	bit.b	@r6,200(r8)		; 0xb6e8 0x00c8
	bit.w	@r6,200(r8)		; 0xb6a8 0x00c8
	bit	42(r6),200(r8)		; 0xb698 0x002a 0x00c8
	bit.b	42(r6),200(r8)		; 0xb6d8 0x002a 0x00c8
	bit.w	42(r6),200(r8)		; 0xb698 0x002a 0x00c8
	bit	@r6,200(r8)		; 0xb6a8 0x00c8
	bit.b	@r6,200(r8)		; 0xb6e8 0x00c8
	bit.w	@r6,200(r8)		; 0xb6a8 0x00c8
	bit	@r6+,200(r8)		; 0xb6b8 0x00c8
	bit.b	@r6+,200(r8)		; 0xb6f8 0x00c8
	bit.w	@r6+,200(r8)		; 0xb6b8 0x00c8
	bit	&1234h,200(r8)		; 0xb298 0x1234 0x00c8
	bit.b	&1234h,200(r8)		; 0xb2d8 0x1234 0x00c8
	bit.w	&1234h,200(r8)		; 0xb298 0x1234 0x00c8
	bit	1234h,200(r8)		; 0xb098 0xfc2c 0x00c8
	bit.b	1234h,200(r8)		; 0xb0d8 0xfc26 0x00c8
	bit.w	1234h,200(r8)		; 0xb098 0xfc20 0x00c8
	bit	r4,&1234h		; 0xb482 0x1234
	bit.b	r4,&1234h		; 0xb4c2 0x1234
	bit.w	r4,&1234h		; 0xb482 0x1234
	bit	#4,&1234h		; 0xb2a2 0x1234
	bit.b	#4,&1234h		; 0xb2e2 0x1234
	bit.w	#4,&1234h		; 0xb2a2 0x1234
	bit	#8,&1234h		; 0xb2b2 0x1234
	bit.b	#8,&1234h		; 0xb2f2 0x1234
	bit.w	#8,&1234h		; 0xb2b2 0x1234
	bit	#0,&1234h		; 0xb382 0x1234
	bit.b	#0,&1234h		; 0xb3c2 0x1234
	bit.w	#0,&1234h		; 0xb382 0x1234
	bit	#1,&1234h		; 0xb392 0x1234
	bit.b	#1,&1234h		; 0xb3d2 0x1234
	bit.w	#1,&1234h		; 0xb392 0x1234
	bit	#2,&1234h		; 0xb3a2 0x1234
	bit.b	#2,&1234h		; 0xb3e2 0x1234
	bit.w	#2,&1234h		; 0xb3a2 0x1234
	bit	#0ffffh,&1234h		; 0xb3b2 0x1234
	bit.b	#0ffh,&1234h		; 0xb3f2 0x1234
	bit.w	#0ffffh,&1234h		; 0xb3b2 0x1234
	bit	#-1,&1234h		; 0xb3b2 0x1234
	bit.b	#-1,&1234h		; 0xb3f2 0x1234
	bit.w	#-1,&1234h		; 0xb3b2 0x1234
	bit	#100,&1234h		; 0xb0b2 0x0064 0x1234
	bit.b	#100,&1234h		; 0xb0f2 0x0064 0x1234
	bit.w	#100,&1234h		; 0xb0b2 0x0064 0x1234
	bit	@r6,&1234h		; 0xb6a2 0x1234
	bit.b	@r6,&1234h		; 0xb6e2 0x1234
	bit.w	@r6,&1234h		; 0xb6a2 0x1234
	bit	42(r6),&1234h		; 0xb692 0x002a 0x1234
	bit.b	42(r6),&1234h		; 0xb6d2 0x002a 0x1234
	bit.w	42(r6),&1234h		; 0xb692 0x002a 0x1234
	bit	@r6,&1234h		; 0xb6a2 0x1234
	bit.b	@r6,&1234h		; 0xb6e2 0x1234
	bit.w	@r6,&1234h		; 0xb6a2 0x1234
	bit	@r6+,&1234h		; 0xb6b2 0x1234
	bit.b	@r6+,&1234h		; 0xb6f2 0x1234
	bit.w	@r6+,&1234h		; 0xb6b2 0x1234
	bit	&1234h,&1234h		; 0xb292 0x1234 0x1234
	bit.b	&1234h,&1234h		; 0xb2d2 0x1234 0x1234
	bit.w	&1234h,&1234h		; 0xb292 0x1234 0x1234
	bit	1234h,&1234h		; 0xb092 0xfb60 0x1234
	bit.b	1234h,&1234h		; 0xb0d2 0xfb5a 0x1234
	bit.w	1234h,&1234h		; 0xb092 0xfb54 0x1234
	bit	r4,1234h		; 0xb480 0xfb4e
	bit.b	r4,1234h		; 0xb4c0 0xfb4a
	bit.w	r4,1234h		; 0xb480 0xfb46
	bit	#4,1234h		; 0xb2a0 0xfb42
	bit.b	#4,1234h		; 0xb2e0 0xfb3e
	bit.w	#4,1234h		; 0xb2a0 0xfb3a
	bit	#8,1234h		; 0xb2b0 0xfb36
	bit.b	#8,1234h		; 0xb2f0 0xfb32
	bit.w	#8,1234h		; 0xb2b0 0xfb2e
	bit	#0,1234h		; 0xb380 0xfb2a
	bit.b	#0,1234h		; 0xb3c0 0xfb26
	bit.w	#0,1234h		; 0xb380 0xfb22
	bit	#1,1234h		; 0xb390 0xfb1e
	bit.b	#1,1234h		; 0xb3d0 0xfb1a
	bit.w	#1,1234h		; 0xb390 0xfb16
	bit	#2,1234h		; 0xb3a0 0xfb12
	bit.b	#2,1234h		; 0xb3e0 0xfb0e
	bit.w	#2,1234h		; 0xb3a0 0xfb0a
	bit	#0ffffh,1234h		; 0xb3b0 0xfb06
	bit.b	#0ffh,1234h		; 0xb3f0 0xfb02
	bit.w	#0ffffh,1234h		; 0xb3b0 0xfafe
	bit	#-1,1234h		; 0xb3b0 0xfafa
	bit.b	#-1,1234h		; 0xb3f0 0xfaf6
	bit.w	#-1,1234h		; 0xb3b0 0xfaf2
	bit	#100,1234h		; 0xb0b0 0x0064 0xfaec
	bit.b	#100,1234h		; 0xb0f0 0x0064 0xfae6
	bit.w	#100,1234h		; 0xb0b0 0x0064 0xfae0
	bit	@r6,1234h		; 0xb6a0 0xfadc
	bit.b	@r6,1234h		; 0xb6e0 0xfad8
	bit.w	@r6,1234h		; 0xb6a0 0xfad4
	bit	42(r6),1234h		; 0xb690 0x002a 0xface
	bit.b	42(r6),1234h		; 0xb6d0 0x002a 0xfac8
	bit.w	42(r6),1234h		; 0xb690 0x002a 0xfac2
	bit	@r6,1234h		; 0xb6a0 0xfabe
	bit.b	@r6,1234h		; 0xb6e0 0xfaba
	bit.w	@r6,1234h		; 0xb6a0 0xfab6
	bit	@r6+,1234h		; 0xb6b0 0xfab2
	bit.b	@r6+,1234h		; 0xb6f0 0xfaae
	bit.w	@r6+,1234h		; 0xb6b0 0xfaaa
	bit	&1234h,1234h		; 0xb290 0x1234 0xfaa4
	bit.b	&1234h,1234h		; 0xb2d0 0x1234 0xfa9e
	bit.w	&1234h,1234h		; 0xb290 0x1234 0xfa98
	bit	1234h,1234h		; 0xb090 0xfa94 0xfa92
	bit.b	1234h,1234h		; 0xb0d0 0xfa8e 0xfa8c
	bit.w	1234h,1234h		; 0xb090 0xfa88 0xfa86
	bic	r4,r7			; 0xc407
	bic.b	r4,r7			; 0xc447
	bic.w	r4,r7			; 0xc407
	bic	#4,r7			; 0xc227
	bic.b	#4,r7			; 0xc267
	bic.w	#4,r7			; 0xc227
	bic	#8,r7			; 0xc237
	bic.b	#8,r7			; 0xc277
	bic.w	#8,r7			; 0xc237
	bic	#0,r7			; 0xc307
	bic.b	#0,r7			; 0xc347
	bic.w	#0,r7			; 0xc307
	bic	#1,r7			; 0xc317
	bic.b	#1,r7			; 0xc357
	bic.w	#1,r7			; 0xc317
	bic	#2,r7			; 0xc327
	bic.b	#2,r7			; 0xc367
	bic.w	#2,r7			; 0xc327
	bic	#0ffffh,r7		; 0xc337
	bic.b	#0ffh,r7		; 0xc377
	bic.w	#0ffffh,r7		; 0xc337
	bic	#-1,r7			; 0xc337
	bic.b	#-1,r7			; 0xc377
	bic.w	#-1,r7			; 0xc337
	bic	#100,r7			; 0xc037 0x0064
	bic.b	#100,r7			; 0xc077 0x0064
	bic.w	#100,r7			; 0xc037 0x0064
	bic	@r6,r7			; 0xc627
	bic.b	@r6,r7			; 0xc667
	bic.w	@r6,r7			; 0xc627
	bic	42(r6),r7		; 0xc617 0x002a
	bic.b	42(r6),r7		; 0xc657 0x002a
	bic.w	42(r6),r7		; 0xc617 0x002a
	bic	@r6,r7			; 0xc627
	bic.b	@r6,r7			; 0xc667
	bic.w	@r6,r7			; 0xc627
	bic	@r6+,r7			; 0xc637
	bic.b	@r6+,r7			; 0xc677
	bic.w	@r6+,r7			; 0xc637
	bic	&1234h,r7		; 0xc217 0x1234
	bic.b	&1234h,r7		; 0xc257 0x1234
	bic.w	&1234h,r7		; 0xc217 0x1234
	bic	1234h,r7		; 0xc017 0xfa1c
	bic.b	1234h,r7		; 0xc057 0xfa18
	bic.w	1234h,r7		; 0xc017 0xfa14
	bic	r4,200(r8)		; 0xc488 0x00c8
	bic.b	r4,200(r8)		; 0xc4c8 0x00c8
	bic.w	r4,200(r8)		; 0xc488 0x00c8
	bic	#4,200(r8)		; 0xc2a8 0x00c8
	bic.b	#4,200(r8)		; 0xc2e8 0x00c8
	bic.w	#4,200(r8)		; 0xc2a8 0x00c8
	bic	#8,200(r8)		; 0xc2b8 0x00c8
	bic.b	#8,200(r8)		; 0xc2f8 0x00c8
	bic.w	#8,200(r8)		; 0xc2b8 0x00c8
	bic	#0,200(r8)		; 0xc388 0x00c8
	bic.b	#0,200(r8)		; 0xc3c8 0x00c8
	bic.w	#0,200(r8)		; 0xc388 0x00c8
	bic	#1,200(r8)		; 0xc398 0x00c8
	bic.b	#1,200(r8)		; 0xc3d8 0x00c8
	bic.w	#1,200(r8)		; 0xc398 0x00c8
	bic	#2,200(r8)		; 0xc3a8 0x00c8
	bic.b	#2,200(r8)		; 0xc3e8 0x00c8
	bic.w	#2,200(r8)		; 0xc3a8 0x00c8
	bic	#0ffffh,200(r8)		; 0xc3b8 0x00c8
	bic.b	#0ffh,200(r8)		; 0xc3f8 0x00c8
	bic.w	#0ffffh,200(r8)		; 0xc3b8 0x00c8
	bic	#-1,200(r8)		; 0xc3b8 0x00c8
	bic.b	#-1,200(r8)		; 0xc3f8 0x00c8
	bic.w	#-1,200(r8)		; 0xc3b8 0x00c8
	bic	#100,200(r8)		; 0xc0b8 0x0064 0x00c8
	bic.b	#100,200(r8)		; 0xc0f8 0x0064 0x00c8
	bic.w	#100,200(r8)		; 0xc0b8 0x0064 0x00c8
	bic	@r6,200(r8)		; 0xc6a8 0x00c8
	bic.b	@r6,200(r8)		; 0xc6e8 0x00c8
	bic.w	@r6,200(r8)		; 0xc6a8 0x00c8
	bic	42(r6),200(r8)		; 0xc698 0x002a 0x00c8
	bic.b	42(r6),200(r8)		; 0xc6d8 0x002a 0x00c8
	bic.w	42(r6),200(r8)		; 0xc698 0x002a 0x00c8
	bic	@r6,200(r8)		; 0xc6a8 0x00c8
	bic.b	@r6,200(r8)		; 0xc6e8 0x00c8
	bic.w	@r6,200(r8)		; 0xc6a8 0x00c8
	bic	@r6+,200(r8)		; 0xc6b8 0x00c8
	bic.b	@r6+,200(r8)		; 0xc6f8 0x00c8
	bic.w	@r6+,200(r8)		; 0xc6b8 0x00c8
	bic	&1234h,200(r8)		; 0xc298 0x1234 0x00c8
	bic.b	&1234h,200(r8)		; 0xc2d8 0x1234 0x00c8
	bic.w	&1234h,200(r8)		; 0xc298 0x1234 0x00c8
	bic	1234h,200(r8)		; 0xc098 0xf956 0x00c8
	bic.b	1234h,200(r8)		; 0xc0d8 0xf950 0x00c8
	bic.w	1234h,200(r8)		; 0xc098 0xf94a 0x00c8
	bic	r4,&1234h		; 0xc482 0x1234
	bic.b	r4,&1234h		; 0xc4c2 0x1234
	bic.w	r4,&1234h		; 0xc482 0x1234
	bic	#4,&1234h		; 0xc2a2 0x1234
	bic.b	#4,&1234h		; 0xc2e2 0x1234
	bic.w	#4,&1234h		; 0xc2a2 0x1234
	bic	#8,&1234h		; 0xc2b2 0x1234
	bic.b	#8,&1234h		; 0xc2f2 0x1234
	bic.w	#8,&1234h		; 0xc2b2 0x1234
	bic	#0,&1234h		; 0xc382 0x1234
	bic.b	#0,&1234h		; 0xc3c2 0x1234
	bic.w	#0,&1234h		; 0xc382 0x1234
	bic	#1,&1234h		; 0xc392 0x1234
	bic.b	#1,&1234h		; 0xc3d2 0x1234
	bic.w	#1,&1234h		; 0xc392 0x1234
	bic	#2,&1234h		; 0xc3a2 0x1234
	bic.b	#2,&1234h		; 0xc3e2 0x1234
	bic.w	#2,&1234h		; 0xc3a2 0x1234
	bic	#0ffffh,&1234h		; 0xc3b2 0x1234
	bic.b	#0ffh,&1234h		; 0xc3f2 0x1234
	bic.w	#0ffffh,&1234h		; 0xc3b2 0x1234
	bic	#-1,&1234h		; 0xc3b2 0x1234
	bic.b	#-1,&1234h		; 0xc3f2 0x1234
	bic.w	#-1,&1234h		; 0xc3b2 0x1234
	bic	#100,&1234h		; 0xc0b2 0x0064 0x1234
	bic.b	#100,&1234h		; 0xc0f2 0x0064 0x1234
	bic.w	#100,&1234h		; 0xc0b2 0x0064 0x1234
	bic	@r6,&1234h		; 0xc6a2 0x1234
	bic.b	@r6,&1234h		; 0xc6e2 0x1234
	bic.w	@r6,&1234h		; 0xc6a2 0x1234
	bic	42(r6),&1234h		; 0xc692 0x002a 0x1234
	bic.b	42(r6),&1234h		; 0xc6d2 0x002a 0x1234
	bic.w	42(r6),&1234h		; 0xc692 0x002a 0x1234
	bic	@r6,&1234h		; 0xc6a2 0x1234
	bic.b	@r6,&1234h		; 0xc6e2 0x1234
	bic.w	@r6,&1234h		; 0xc6a2 0x1234
	bic	@r6+,&1234h		; 0xc6b2 0x1234
	bic.b	@r6+,&1234h		; 0xc6f2 0x1234
	bic.w	@r6+,&1234h		; 0xc6b2 0x1234
	bic	&1234h,&1234h		; 0xc292 0x1234 0x1234
	bic.b	&1234h,&1234h		; 0xc2d2 0x1234 0x1234
	bic.w	&1234h,&1234h		; 0xc292 0x1234 0x1234
	bic	1234h,&1234h		; 0xc092 0xf88a 0x1234
	bic.b	1234h,&1234h		; 0xc0d2 0xf884 0x1234
	bic.w	1234h,&1234h		; 0xc092 0xf87e 0x1234
	bic	r4,1234h		; 0xc480 0xf878
	bic.b	r4,1234h		; 0xc4c0 0xf874
	bic.w	r4,1234h		; 0xc480 0xf870
	bic	#4,1234h		; 0xc2a0 0xf86c
	bic.b	#4,1234h		; 0xc2e0 0xf868
	bic.w	#4,1234h		; 0xc2a0 0xf864
	bic	#8,1234h		; 0xc2b0 0xf860
	bic.b	#8,1234h		; 0xc2f0 0xf85c
	bic.w	#8,1234h		; 0xc2b0 0xf858
	bic	#0,1234h		; 0xc380 0xf854
	bic.b	#0,1234h		; 0xc3c0 0xf850
	bic.w	#0,1234h		; 0xc380 0xf84c
	bic	#1,1234h		; 0xc390 0xf848
	bic.b	#1,1234h		; 0xc3d0 0xf844
	bic.w	#1,1234h		; 0xc390 0xf840
	bic	#2,1234h		; 0xc3a0 0xf83c
	bic.b	#2,1234h		; 0xc3e0 0xf838
	bic.w	#2,1234h		; 0xc3a0 0xf834
	bic	#0ffffh,1234h		; 0xc3b0 0xf830
	bic.b	#0ffh,1234h		; 0xc3f0 0xf82c
	bic.w	#0ffffh,1234h		; 0xc3b0 0xf828
	bic	#-1,1234h		; 0xc3b0 0xf824
	bic.b	#-1,1234h		; 0xc3f0 0xf820
	bic.w	#-1,1234h		; 0xc3b0 0xf81c
	bic	#100,1234h		; 0xc0b0 0x0064 0xf816
	bic.b	#100,1234h		; 0xc0f0 0x0064 0xf810
	bic.w	#100,1234h		; 0xc0b0 0x0064 0xf80a
	bic	@r6,1234h		; 0xc6a0 0xf806
	bic.b	@r6,1234h		; 0xc6e0 0xf802
	bic.w	@r6,1234h		; 0xc6a0 0xf7fe
	bic	42(r6),1234h		; 0xc690 0x002a 0xf7f8
	bic.b	42(r6),1234h		; 0xc6d0 0x002a 0xf7f2
	bic.w	42(r6),1234h		; 0xc690 0x002a 0xf7ec
	bic	@r6,1234h		; 0xc6a0 0xf7e8
	bic.b	@r6,1234h		; 0xc6e0 0xf7e4
	bic.w	@r6,1234h		; 0xc6a0 0xf7e0
	bic	@r6+,1234h		; 0xc6b0 0xf7dc
	bic.b	@r6+,1234h		; 0xc6f0 0xf7d8
	bic.w	@r6+,1234h		; 0xc6b0 0xf7d4
	bic	&1234h,1234h		; 0xc290 0x1234 0xf7ce
	bic.b	&1234h,1234h		; 0xc2d0 0x1234 0xf7c8
	bic.w	&1234h,1234h		; 0xc290 0x1234 0xf7c2
	bic	1234h,1234h		; 0xc090 0xf7be 0xf7bc
	bic.b	1234h,1234h		; 0xc0d0 0xf7b8 0xf7b6
	bic.w	1234h,1234h		; 0xc090 0xf7b2 0xf7b0
	bis	r4,r7			; 0xd407
	bis.b	r4,r7			; 0xd447
	bis.w	r4,r7			; 0xd407
	bis	#4,r7			; 0xd227
	bis.b	#4,r7			; 0xd267
	bis.w	#4,r7			; 0xd227
	bis	#8,r7			; 0xd237
	bis.b	#8,r7			; 0xd277
	bis.w	#8,r7			; 0xd237
	bis	#0,r7			; 0xd307
	bis.b	#0,r7			; 0xd347
	bis.w	#0,r7			; 0xd307
	bis	#1,r7			; 0xd317
	bis.b	#1,r7			; 0xd357
	bis.w	#1,r7			; 0xd317
	bis	#2,r7			; 0xd327
	bis.b	#2,r7			; 0xd367
	bis.w	#2,r7			; 0xd327
	bis	#0ffffh,r7		; 0xd337
	bis.b	#0ffh,r7		; 0xd377
	bis.w	#0ffffh,r7		; 0xd337
	bis	#-1,r7			; 0xd337
	bis.b	#-1,r7			; 0xd377
	bis.w	#-1,r7			; 0xd337
	bis	#100,r7			; 0xd037 0x0064
	bis.b	#100,r7			; 0xd077 0x0064
	bis.w	#100,r7			; 0xd037 0x0064
	bis	@r6,r7			; 0xd627
	bis.b	@r6,r7			; 0xd667
	bis.w	@r6,r7			; 0xd627
	bis	42(r6),r7		; 0xd617 0x002a
	bis.b	42(r6),r7		; 0xd657 0x002a
	bis.w	42(r6),r7		; 0xd617 0x002a
	bis	@r6,r7			; 0xd627
	bis.b	@r6,r7			; 0xd667
	bis.w	@r6,r7			; 0xd627
	bis	@r6+,r7			; 0xd637
	bis.b	@r6+,r7			; 0xd677
	bis.w	@r6+,r7			; 0xd637
	bis	&1234h,r7		; 0xd217 0x1234
	bis.b	&1234h,r7		; 0xd257 0x1234
	bis.w	&1234h,r7		; 0xd217 0x1234
	bis	1234h,r7		; 0xd017 0xf746
	bis.b	1234h,r7		; 0xd057 0xf742
	bis.w	1234h,r7		; 0xd017 0xf73e
	bis	r4,200(r8)		; 0xd488 0x00c8
	bis.b	r4,200(r8)		; 0xd4c8 0x00c8
	bis.w	r4,200(r8)		; 0xd488 0x00c8
	bis	#4,200(r8)		; 0xd2a8 0x00c8
	bis.b	#4,200(r8)		; 0xd2e8 0x00c8
	bis.w	#4,200(r8)		; 0xd2a8 0x00c8
	bis	#8,200(r8)		; 0xd2b8 0x00c8
	bis.b	#8,200(r8)		; 0xd2f8 0x00c8
	bis.w	#8,200(r8)		; 0xd2b8 0x00c8
	bis	#0,200(r8)		; 0xd388 0x00c8
	bis.b	#0,200(r8)		; 0xd3c8 0x00c8
	bis.w	#0,200(r8)		; 0xd388 0x00c8
	bis	#1,200(r8)		; 0xd398 0x00c8
	bis.b	#1,200(r8)		; 0xd3d8 0x00c8
	bis.w	#1,200(r8)		; 0xd398 0x00c8
	bis	#2,200(r8)		; 0xd3a8 0x00c8
	bis.b	#2,200(r8)		; 0xd3e8 0x00c8
	bis.w	#2,200(r8)		; 0xd3a8 0x00c8
	bis	#0ffffh,200(r8)		; 0xd3b8 0x00c8
	bis.b	#0ffh,200(r8)		; 0xd3f8 0x00c8
	bis.w	#0ffffh,200(r8)		; 0xd3b8 0x00c8
	bis	#-1,200(r8)		; 0xd3b8 0x00c8
	bis.b	#-1,200(r8)		; 0xd3f8 0x00c8
	bis.w	#-1,200(r8)		; 0xd3b8 0x00c8
	bis	#100,200(r8)		; 0xd0b8 0x0064 0x00c8
	bis.b	#100,200(r8)		; 0xd0f8 0x0064 0x00c8
	bis.w	#100,200(r8)		; 0xd0b8 0x0064 0x00c8
	bis	@r6,200(r8)		; 0xd6a8 0x00c8
	bis.b	@r6,200(r8)		; 0xd6e8 0x00c8
	bis.w	@r6,200(r8)		; 0xd6a8 0x00c8
	bis	42(r6),200(r8)		; 0xd698 0x002a 0x00c8
	bis.b	42(r6),200(r8)		; 0xd6d8 0x002a 0x00c8
	bis.w	42(r6),200(r8)		; 0xd698 0x002a 0x00c8
	bis	@r6,200(r8)		; 0xd6a8 0x00c8
	bis.b	@r6,200(r8)		; 0xd6e8 0x00c8
	bis.w	@r6,200(r8)		; 0xd6a8 0x00c8
	bis	@r6+,200(r8)		; 0xd6b8 0x00c8
	bis.b	@r6+,200(r8)		; 0xd6f8 0x00c8
	bis.w	@r6+,200(r8)		; 0xd6b8 0x00c8
	bis	&1234h,200(r8)		; 0xd298 0x1234 0x00c8
	bis.b	&1234h,200(r8)		; 0xd2d8 0x1234 0x00c8
	bis.w	&1234h,200(r8)		; 0xd298 0x1234 0x00c8
	bis	1234h,200(r8)		; 0xd098 0xf680 0x00c8
	bis.b	1234h,200(r8)		; 0xd0d8 0xf67a 0x00c8
	bis.w	1234h,200(r8)		; 0xd098 0xf674 0x00c8
	bis	r4,&1234h		; 0xd482 0x1234
	bis.b	r4,&1234h		; 0xd4c2 0x1234
	bis.w	r4,&1234h		; 0xd482 0x1234
	bis	#4,&1234h		; 0xd2a2 0x1234
	bis.b	#4,&1234h		; 0xd2e2 0x1234
	bis.w	#4,&1234h		; 0xd2a2 0x1234
	bis	#8,&1234h		; 0xd2b2 0x1234
	bis.b	#8,&1234h		; 0xd2f2 0x1234
	bis.w	#8,&1234h		; 0xd2b2 0x1234
	bis	#0,&1234h		; 0xd382 0x1234
	bis.b	#0,&1234h		; 0xd3c2 0x1234
	bis.w	#0,&1234h		; 0xd382 0x1234
	bis	#1,&1234h		; 0xd392 0x1234
	bis.b	#1,&1234h		; 0xd3d2 0x1234
	bis.w	#1,&1234h		; 0xd392 0x1234
	bis	#2,&1234h		; 0xd3a2 0x1234
	bis.b	#2,&1234h		; 0xd3e2 0x1234
	bis.w	#2,&1234h		; 0xd3a2 0x1234
	bis	#0ffffh,&1234h		; 0xd3b2 0x1234
	bis.b	#0ffh,&1234h		; 0xd3f2 0x1234
	bis.w	#0ffffh,&1234h		; 0xd3b2 0x1234
	bis	#-1,&1234h		; 0xd3b2 0x1234
	bis.b	#-1,&1234h		; 0xd3f2 0x1234
	bis.w	#-1,&1234h		; 0xd3b2 0x1234
	bis	#100,&1234h		; 0xd0b2 0x0064 0x1234
	bis.b	#100,&1234h		; 0xd0f2 0x0064 0x1234
	bis.w	#100,&1234h		; 0xd0b2 0x0064 0x1234
	bis	@r6,&1234h		; 0xd6a2 0x1234
	bis.b	@r6,&1234h		; 0xd6e2 0x1234
	bis.w	@r6,&1234h		; 0xd6a2 0x1234
	bis	42(r6),&1234h		; 0xd692 0x002a 0x1234
	bis.b	42(r6),&1234h		; 0xd6d2 0x002a 0x1234
	bis.w	42(r6),&1234h		; 0xd692 0x002a 0x1234
	bis	@r6,&1234h		; 0xd6a2 0x1234
	bis.b	@r6,&1234h		; 0xd6e2 0x1234
	bis.w	@r6,&1234h		; 0xd6a2 0x1234
	bis	@r6+,&1234h		; 0xd6b2 0x1234
	bis.b	@r6+,&1234h		; 0xd6f2 0x1234
	bis.w	@r6+,&1234h		; 0xd6b2 0x1234
	bis	&1234h,&1234h		; 0xd292 0x1234 0x1234
	bis.b	&1234h,&1234h		; 0xd2d2 0x1234 0x1234
	bis.w	&1234h,&1234h		; 0xd292 0x1234 0x1234
	bis	1234h,&1234h		; 0xd092 0xf5b4 0x1234
	bis.b	1234h,&1234h		; 0xd0d2 0xf5ae 0x1234
	bis.w	1234h,&1234h		; 0xd092 0xf5a8 0x1234
	bis	r4,1234h		; 0xd480 0xf5a2
	bis.b	r4,1234h		; 0xd4c0 0xf59e
	bis.w	r4,1234h		; 0xd480 0xf59a
	bis	#4,1234h		; 0xd2a0 0xf596
	bis.b	#4,1234h		; 0xd2e0 0xf592
	bis.w	#4,1234h		; 0xd2a0 0xf58e
	bis	#8,1234h		; 0xd2b0 0xf58a
	bis.b	#8,1234h		; 0xd2f0 0xf586
	bis.w	#8,1234h		; 0xd2b0 0xf582
	bis	#0,1234h		; 0xd380 0xf57e
	bis.b	#0,1234h		; 0xd3c0 0xf57a
	bis.w	#0,1234h		; 0xd380 0xf576
	bis	#1,1234h		; 0xd390 0xf572
	bis.b	#1,1234h		; 0xd3d0 0xf56e
	bis.w	#1,1234h		; 0xd390 0xf56a
	bis	#2,1234h		; 0xd3a0 0xf566
	bis.b	#2,1234h		; 0xd3e0 0xf562
	bis.w	#2,1234h		; 0xd3a0 0xf55e
	bis	#0ffffh,1234h		; 0xd3b0 0xf55a
	bis.b	#0ffh,1234h		; 0xd3f0 0xf556
	bis.w	#0ffffh,1234h		; 0xd3b0 0xf552
	bis	#-1,1234h		; 0xd3b0 0xf54e
	bis.b	#-1,1234h		; 0xd3f0 0xf54a
	bis.w	#-1,1234h		; 0xd3b0 0xf546
	bis	#100,1234h		; 0xd0b0 0x0064 0xf540
	bis.b	#100,1234h		; 0xd0f0 0x0064 0xf53a
	bis.w	#100,1234h		; 0xd0b0 0x0064 0xf534
	bis	@r6,1234h		; 0xd6a0 0xf530
	bis.b	@r6,1234h		; 0xd6e0 0xf52c
	bis.w	@r6,1234h		; 0xd6a0 0xf528
	bis	42(r6),1234h		; 0xd690 0x002a 0xf522
	bis.b	42(r6),1234h		; 0xd6d0 0x002a 0xf51c
	bis.w	42(r6),1234h		; 0xd690 0x002a 0xf516
	bis	@r6,1234h		; 0xd6a0 0xf512
	bis.b	@r6,1234h		; 0xd6e0 0xf50e
	bis.w	@r6,1234h		; 0xd6a0 0xf50a
	bis	@r6+,1234h		; 0xd6b0 0xf506
	bis.b	@r6+,1234h		; 0xd6f0 0xf502
	bis.w	@r6+,1234h		; 0xd6b0 0xf4fe
	bis	&1234h,1234h		; 0xd290 0x1234 0xf4f8
	bis.b	&1234h,1234h		; 0xd2d0 0x1234 0xf4f2
	bis.w	&1234h,1234h		; 0xd290 0x1234 0xf4ec
	bis	1234h,1234h		; 0xd090 0xf4e8 0xf4e6
	bis.b	1234h,1234h		; 0xd0d0 0xf4e2 0xf4e0
	bis.w	1234h,1234h		; 0xd090 0xf4dc 0xf4da
	xor	r4,r7			; 0xe407
	xor.b	r4,r7			; 0xe447
	xor.w	r4,r7			; 0xe407
	xor	#4,r7			; 0xe227
	xor.b	#4,r7			; 0xe267
	xor.w	#4,r7			; 0xe227
	xor	#8,r7			; 0xe237
	xor.b	#8,r7			; 0xe277
	xor.w	#8,r7			; 0xe237
	xor	#0,r7			; 0xe307
	xor.b	#0,r7			; 0xe347
	xor.w	#0,r7			; 0xe307
	xor	#1,r7			; 0xe317
	xor.b	#1,r7			; 0xe357
	xor.w	#1,r7			; 0xe317
	xor	#2,r7			; 0xe327
	xor.b	#2,r7			; 0xe367
	xor.w	#2,r7			; 0xe327
	xor	#0ffffh,r7		; 0xe337
	xor.b	#0ffh,r7		; 0xe377
	xor.w	#0ffffh,r7		; 0xe337
	xor	#-1,r7			; 0xe337
	xor.b	#-1,r7			; 0xe377
	xor.w	#-1,r7			; 0xe337
	xor	#100,r7			; 0xe037 0x0064
	xor.b	#100,r7			; 0xe077 0x0064
	xor.w	#100,r7			; 0xe037 0x0064
	xor	@r6,r7			; 0xe627
	xor.b	@r6,r7			; 0xe667
	xor.w	@r6,r7			; 0xe627
	xor	42(r6),r7		; 0xe617 0x002a
	xor.b	42(r6),r7		; 0xe657 0x002a
	xor.w	42(r6),r7		; 0xe617 0x002a
	xor	@r6,r7			; 0xe627
	xor.b	@r6,r7			; 0xe667
	xor.w	@r6,r7			; 0xe627
	xor	@r6+,r7			; 0xe637
	xor.b	@r6+,r7			; 0xe677
	xor.w	@r6+,r7			; 0xe637
	xor	&1234h,r7		; 0xe217 0x1234
	xor.b	&1234h,r7		; 0xe257 0x1234
	xor.w	&1234h,r7		; 0xe217 0x1234
	xor	1234h,r7		; 0xe017 0xf470
	xor.b	1234h,r7		; 0xe057 0xf46c
	xor.w	1234h,r7		; 0xe017 0xf468
	xor	r4,200(r8)		; 0xe488 0x00c8
	xor.b	r4,200(r8)		; 0xe4c8 0x00c8
	xor.w	r4,200(r8)		; 0xe488 0x00c8
	xor	#4,200(r8)		; 0xe2a8 0x00c8
	xor.b	#4,200(r8)		; 0xe2e8 0x00c8
	xor.w	#4,200(r8)		; 0xe2a8 0x00c8
	xor	#8,200(r8)		; 0xe2b8 0x00c8
	xor.b	#8,200(r8)		; 0xe2f8 0x00c8
	xor.w	#8,200(r8)		; 0xe2b8 0x00c8
	xor	#0,200(r8)		; 0xe388 0x00c8
	xor.b	#0,200(r8)		; 0xe3c8 0x00c8
	xor.w	#0,200(r8)		; 0xe388 0x00c8
	xor	#1,200(r8)		; 0xe398 0x00c8
	xor.b	#1,200(r8)		; 0xe3d8 0x00c8
	xor.w	#1,200(r8)		; 0xe398 0x00c8
	xor	#2,200(r8)		; 0xe3a8 0x00c8
	xor.b	#2,200(r8)		; 0xe3e8 0x00c8
	xor.w	#2,200(r8)		; 0xe3a8 0x00c8
	xor	#0ffffh,200(r8)		; 0xe3b8 0x00c8
	xor.b	#0ffh,200(r8)		; 0xe3f8 0x00c8
	xor.w	#0ffffh,200(r8)		; 0xe3b8 0x00c8
	xor	#-1,200(r8)		; 0xe3b8 0x00c8
	xor.b	#-1,200(r8)		; 0xe3f8 0x00c8
	xor.w	#-1,200(r8)		; 0xe3b8 0x00c8
	xor	#100,200(r8)		; 0xe0b8 0x0064 0x00c8
	xor.b	#100,200(r8)		; 0xe0f8 0x0064 0x00c8
	xor.w	#100,200(r8)		; 0xe0b8 0x0064 0x00c8
	xor	@r6,200(r8)		; 0xe6a8 0x00c8
	xor.b	@r6,200(r8)		; 0xe6e8 0x00c8
	xor.w	@r6,200(r8)		; 0xe6a8 0x00c8
	xor	42(r6),200(r8)		; 0xe698 0x002a 0x00c8
	xor.b	42(r6),200(r8)		; 0xe6d8 0x002a 0x00c8
	xor.w	42(r6),200(r8)		; 0xe698 0x002a 0x00c8
	xor	@r6,200(r8)		; 0xe6a8 0x00c8
	xor.b	@r6,200(r8)		; 0xe6e8 0x00c8
	xor.w	@r6,200(r8)		; 0xe6a8 0x00c8
	xor	@r6+,200(r8)		; 0xe6b8 0x00c8
	xor.b	@r6+,200(r8)		; 0xe6f8 0x00c8
	xor.w	@r6+,200(r8)		; 0xe6b8 0x00c8
	xor	&1234h,200(r8)		; 0xe298 0x1234 0x00c8
	xor.b	&1234h,200(r8)		; 0xe2d8 0x1234 0x00c8
	xor.w	&1234h,200(r8)		; 0xe298 0x1234 0x00c8
	xor	1234h,200(r8)		; 0xe098 0xf3aa 0x00c8
	xor.b	1234h,200(r8)		; 0xe0d8 0xf3a4 0x00c8
	xor.w	1234h,200(r8)		; 0xe098 0xf39e 0x00c8
	xor	r4,&1234h		; 0xe482 0x1234
	xor.b	r4,&1234h		; 0xe4c2 0x1234
	xor.w	r4,&1234h		; 0xe482 0x1234
	xor	#4,&1234h		; 0xe2a2 0x1234
	xor.b	#4,&1234h		; 0xe2e2 0x1234
	xor.w	#4,&1234h		; 0xe2a2 0x1234
	xor	#8,&1234h		; 0xe2b2 0x1234
	xor.b	#8,&1234h		; 0xe2f2 0x1234
	xor.w	#8,&1234h		; 0xe2b2 0x1234
	xor	#0,&1234h		; 0xe382 0x1234
	xor.b	#0,&1234h		; 0xe3c2 0x1234
	xor.w	#0,&1234h		; 0xe382 0x1234
	xor	#1,&1234h		; 0xe392 0x1234
	xor.b	#1,&1234h		; 0xe3d2 0x1234
	xor.w	#1,&1234h		; 0xe392 0x1234
	xor	#2,&1234h		; 0xe3a2 0x1234
	xor.b	#2,&1234h		; 0xe3e2 0x1234
	xor.w	#2,&1234h		; 0xe3a2 0x1234
	xor	#0ffffh,&1234h		; 0xe3b2 0x1234
	xor.b	#0ffh,&1234h		; 0xe3f2 0x1234
	xor.w	#0ffffh,&1234h		; 0xe3b2 0x1234
	xor	#-1,&1234h		; 0xe3b2 0x1234
	xor.b	#-1,&1234h		; 0xe3f2 0x1234
	xor.w	#-1,&1234h		; 0xe3b2 0x1234
	xor	#100,&1234h		; 0xe0b2 0x0064 0x1234
	xor.b	#100,&1234h		; 0xe0f2 0x0064 0x1234
	xor.w	#100,&1234h		; 0xe0b2 0x0064 0x1234
	xor	@r6,&1234h		; 0xe6a2 0x1234
	xor.b	@r6,&1234h		; 0xe6e2 0x1234
	xor.w	@r6,&1234h		; 0xe6a2 0x1234
	xor	42(r6),&1234h		; 0xe692 0x002a 0x1234
	xor.b	42(r6),&1234h		; 0xe6d2 0x002a 0x1234
	xor.w	42(r6),&1234h		; 0xe692 0x002a 0x1234
	xor	@r6,&1234h		; 0xe6a2 0x1234
	xor.b	@r6,&1234h		; 0xe6e2 0x1234
	xor.w	@r6,&1234h		; 0xe6a2 0x1234
	xor	@r6+,&1234h		; 0xe6b2 0x1234
	xor.b	@r6+,&1234h		; 0xe6f2 0x1234
	xor.w	@r6+,&1234h		; 0xe6b2 0x1234
	xor	&1234h,&1234h		; 0xe292 0x1234 0x1234
	xor.b	&1234h,&1234h		; 0xe2d2 0x1234 0x1234
	xor.w	&1234h,&1234h		; 0xe292 0x1234 0x1234
	xor	1234h,&1234h		; 0xe092 0xf2de 0x1234
	xor.b	1234h,&1234h		; 0xe0d2 0xf2d8 0x1234
	xor.w	1234h,&1234h		; 0xe092 0xf2d2 0x1234
	xor	r4,1234h		; 0xe480 0xf2cc
	xor.b	r4,1234h		; 0xe4c0 0xf2c8
	xor.w	r4,1234h		; 0xe480 0xf2c4
	xor	#4,1234h		; 0xe2a0 0xf2c0
	xor.b	#4,1234h		; 0xe2e0 0xf2bc
	xor.w	#4,1234h		; 0xe2a0 0xf2b8
	xor	#8,1234h		; 0xe2b0 0xf2b4
	xor.b	#8,1234h		; 0xe2f0 0xf2b0
	xor.w	#8,1234h		; 0xe2b0 0xf2ac
	xor	#0,1234h		; 0xe380 0xf2a8
	xor.b	#0,1234h		; 0xe3c0 0xf2a4
	xor.w	#0,1234h		; 0xe380 0xf2a0
	xor	#1,1234h		; 0xe390 0xf29c
	xor.b	#1,1234h		; 0xe3d0 0xf298
	xor.w	#1,1234h		; 0xe390 0xf294
	xor	#2,1234h		; 0xe3a0 0xf290
	xor.b	#2,1234h		; 0xe3e0 0xf28c
	xor.w	#2,1234h		; 0xe3a0 0xf288
	xor	#0ffffh,1234h		; 0xe3b0 0xf284
	xor.b	#0ffh,1234h		; 0xe3f0 0xf280
	xor.w	#0ffffh,1234h		; 0xe3b0 0xf27c
	xor	#-1,1234h		; 0xe3b0 0xf278
	xor.b	#-1,1234h		; 0xe3f0 0xf274
	xor.w	#-1,1234h		; 0xe3b0 0xf270
	xor	#100,1234h		; 0xe0b0 0x0064 0xf26a
	xor.b	#100,1234h		; 0xe0f0 0x0064 0xf264
	xor.w	#100,1234h		; 0xe0b0 0x0064 0xf25e
	xor	@r6,1234h		; 0xe6a0 0xf25a
	xor.b	@r6,1234h		; 0xe6e0 0xf256
	xor.w	@r6,1234h		; 0xe6a0 0xf252
	xor	42(r6),1234h		; 0xe690 0x002a 0xf24c
	xor.b	42(r6),1234h		; 0xe6d0 0x002a 0xf246
	xor.w	42(r6),1234h		; 0xe690 0x002a 0xf240
	xor	@r6,1234h		; 0xe6a0 0xf23c
	xor.b	@r6,1234h		; 0xe6e0 0xf238
	xor.w	@r6,1234h		; 0xe6a0 0xf234
	xor	@r6+,1234h		; 0xe6b0 0xf230
	xor.b	@r6+,1234h		; 0xe6f0 0xf22c
	xor.w	@r6+,1234h		; 0xe6b0 0xf228
	xor	&1234h,1234h		; 0xe290 0x1234 0xf222
	xor.b	&1234h,1234h		; 0xe2d0 0x1234 0xf21c
	xor.w	&1234h,1234h		; 0xe290 0x1234 0xf216
	xor	1234h,1234h		; 0xe090 0xf212 0xf210
	xor.b	1234h,1234h		; 0xe0d0 0xf20c 0xf20a
	xor.w	1234h,1234h		; 0xe090 0xf206 0xf204
	and	r4,r7			; 0xf407
	and.b	r4,r7			; 0xf447
	and.w	r4,r7			; 0xf407
	and	#4,r7			; 0xf227
	and.b	#4,r7			; 0xf267
	and.w	#4,r7			; 0xf227
	and	#8,r7			; 0xf237
	and.b	#8,r7			; 0xf277
	and.w	#8,r7			; 0xf237
	and	#0,r7			; 0xf307
	and.b	#0,r7			; 0xf347
	and.w	#0,r7			; 0xf307
	and	#1,r7			; 0xf317
	and.b	#1,r7			; 0xf357
	and.w	#1,r7			; 0xf317
	and	#2,r7			; 0xf327
	and.b	#2,r7			; 0xf367
	and.w	#2,r7			; 0xf327
	and	#0ffffh,r7		; 0xf337
	and.b	#0ffh,r7		; 0xf377
	and.w	#0ffffh,r7		; 0xf337
	and	#-1,r7			; 0xf337
	and.b	#-1,r7			; 0xf377
	and.w	#-1,r7			; 0xf337
	and	#100,r7			; 0xf037 0x0064
	and.b	#100,r7			; 0xf077 0x0064
	and.w	#100,r7			; 0xf037 0x0064
	and	@r6,r7			; 0xf627
	and.b	@r6,r7			; 0xf667
	and.w	@r6,r7			; 0xf627
	and	42(r6),r7		; 0xf617 0x002a
	and.b	42(r6),r7		; 0xf657 0x002a
	and.w	42(r6),r7		; 0xf617 0x002a
	and	@r6,r7			; 0xf627
	and.b	@r6,r7			; 0xf667
	and.w	@r6,r7			; 0xf627
	and	@r6+,r7			; 0xf637
	and.b	@r6+,r7			; 0xf677
	and.w	@r6+,r7			; 0xf637
	and	&1234h,r7		; 0xf217 0x1234
	and.b	&1234h,r7		; 0xf257 0x1234
	and.w	&1234h,r7		; 0xf217 0x1234
	and	1234h,r7		; 0xf017 0xf19a
	and.b	1234h,r7		; 0xf057 0xf196
	and.w	1234h,r7		; 0xf017 0xf192
	and	r4,200(r8)		; 0xf488 0x00c8
	and.b	r4,200(r8)		; 0xf4c8 0x00c8
	and.w	r4,200(r8)		; 0xf488 0x00c8
	and	#4,200(r8)		; 0xf2a8 0x00c8
	and.b	#4,200(r8)		; 0xf2e8 0x00c8
	and.w	#4,200(r8)		; 0xf2a8 0x00c8
	and	#8,200(r8)		; 0xf2b8 0x00c8
	and.b	#8,200(r8)		; 0xf2f8 0x00c8
	and.w	#8,200(r8)		; 0xf2b8 0x00c8
	and	#0,200(r8)		; 0xf388 0x00c8
	and.b	#0,200(r8)		; 0xf3c8 0x00c8
	and.w	#0,200(r8)		; 0xf388 0x00c8
	and	#1,200(r8)		; 0xf398 0x00c8
	and.b	#1,200(r8)		; 0xf3d8 0x00c8
	and.w	#1,200(r8)		; 0xf398 0x00c8
	and	#2,200(r8)		; 0xf3a8 0x00c8
	and.b	#2,200(r8)		; 0xf3e8 0x00c8
	and.w	#2,200(r8)		; 0xf3a8 0x00c8
	and	#0ffffh,200(r8)		; 0xf3b8 0x00c8
	and.b	#0ffh,200(r8)		; 0xf3f8 0x00c8
	and.w	#0ffffh,200(r8)		; 0xf3b8 0x00c8
	and	#-1,200(r8)		; 0xf3b8 0x00c8
	and.b	#-1,200(r8)		; 0xf3f8 0x00c8
	and.w	#-1,200(r8)		; 0xf3b8 0x00c8
	and	#100,200(r8)		; 0xf0b8 0x0064 0x00c8
	and.b	#100,200(r8)		; 0xf0f8 0x0064 0x00c8
	and.w	#100,200(r8)		; 0xf0b8 0x0064 0x00c8
	and	@r6,200(r8)		; 0xf6a8 0x00c8
	and.b	@r6,200(r8)		; 0xf6e8 0x00c8
	and.w	@r6,200(r8)		; 0xf6a8 0x00c8
	and	42(r6),200(r8)		; 0xf698 0x002a 0x00c8
	and.b	42(r6),200(r8)		; 0xf6d8 0x002a 0x00c8
	and.w	42(r6),200(r8)		; 0xf698 0x002a 0x00c8
	and	@r6,200(r8)		; 0xf6a8 0x00c8
	and.b	@r6,200(r8)		; 0xf6e8 0x00c8
	and.w	@r6,200(r8)		; 0xf6a8 0x00c8
	and	@r6+,200(r8)		; 0xf6b8 0x00c8
	and.b	@r6+,200(r8)		; 0xf6f8 0x00c8
	and.w	@r6+,200(r8)		; 0xf6b8 0x00c8
	and	&1234h,200(r8)		; 0xf298 0x1234 0x00c8
	and.b	&1234h,200(r8)		; 0xf2d8 0x1234 0x00c8
	and.w	&1234h,200(r8)		; 0xf298 0x1234 0x00c8
	and	1234h,200(r8)		; 0xf098 0xf0d4 0x00c8
	and.b	1234h,200(r8)		; 0xf0d8 0xf0ce 0x00c8
	and.w	1234h,200(r8)		; 0xf098 0xf0c8 0x00c8
	and	r4,&1234h		; 0xf482 0x1234
	and.b	r4,&1234h		; 0xf4c2 0x1234
	and.w	r4,&1234h		; 0xf482 0x1234
	and	#4,&1234h		; 0xf2a2 0x1234
	and.b	#4,&1234h		; 0xf2e2 0x1234
	and.w	#4,&1234h		; 0xf2a2 0x1234
	and	#8,&1234h		; 0xf2b2 0x1234
	and.b	#8,&1234h		; 0xf2f2 0x1234
	and.w	#8,&1234h		; 0xf2b2 0x1234
	and	#0,&1234h		; 0xf382 0x1234
	and.b	#0,&1234h		; 0xf3c2 0x1234
	and.w	#0,&1234h		; 0xf382 0x1234
	and	#1,&1234h		; 0xf392 0x1234
	and.b	#1,&1234h		; 0xf3d2 0x1234
	and.w	#1,&1234h		; 0xf392 0x1234
	and	#2,&1234h		; 0xf3a2 0x1234
	and.b	#2,&1234h		; 0xf3e2 0x1234
	and.w	#2,&1234h		; 0xf3a2 0x1234
	and	#0ffffh,&1234h		; 0xf3b2 0x1234
	and.b	#0ffh,&1234h		; 0xf3f2 0x1234
	and.w	#0ffffh,&1234h		; 0xf3b2 0x1234
	and	#-1,&1234h		; 0xf3b2 0x1234
	and.b	#-1,&1234h		; 0xf3f2 0x1234
	and.w	#-1,&1234h		; 0xf3b2 0x1234
	and	#100,&1234h		; 0xf0b2 0x0064 0x1234
	and.b	#100,&1234h		; 0xf0f2 0x0064 0x1234
	and.w	#100,&1234h		; 0xf0b2 0x0064 0x1234
	and	@r6,&1234h		; 0xf6a2 0x1234
	and.b	@r6,&1234h		; 0xf6e2 0x1234
	and.w	@r6,&1234h		; 0xf6a2 0x1234
	and	42(r6),&1234h		; 0xf692 0x002a 0x1234
	and.b	42(r6),&1234h		; 0xf6d2 0x002a 0x1234
	and.w	42(r6),&1234h		; 0xf692 0x002a 0x1234
	and	@r6,&1234h		; 0xf6a2 0x1234
	and.b	@r6,&1234h		; 0xf6e2 0x1234
	and.w	@r6,&1234h		; 0xf6a2 0x1234
	and	@r6+,&1234h		; 0xf6b2 0x1234
	and.b	@r6+,&1234h		; 0xf6f2 0x1234
	and.w	@r6+,&1234h		; 0xf6b2 0x1234
	and	&1234h,&1234h		; 0xf292 0x1234 0x1234
	and.b	&1234h,&1234h		; 0xf2d2 0x1234 0x1234
	and.w	&1234h,&1234h		; 0xf292 0x1234 0x1234
	and	1234h,&1234h		; 0xf092 0xf008 0x1234
	and.b	1234h,&1234h		; 0xf0d2 0xf002 0x1234
	and.w	1234h,&1234h		; 0xf092 0xeffc 0x1234
	and	r4,1234h		; 0xf480 0xeff6
	and.b	r4,1234h		; 0xf4c0 0xeff2
	and.w	r4,1234h		; 0xf480 0xefee
	and	#4,1234h		; 0xf2a0 0xefea
	and.b	#4,1234h		; 0xf2e0 0xefe6
	and.w	#4,1234h		; 0xf2a0 0xefe2
	and	#8,1234h		; 0xf2b0 0xefde
	and.b	#8,1234h		; 0xf2f0 0xefda
	and.w	#8,1234h		; 0xf2b0 0xefd6
	and	#0,1234h		; 0xf380 0xefd2
	and.b	#0,1234h		; 0xf3c0 0xefce
	and.w	#0,1234h		; 0xf380 0xefca
	and	#1,1234h		; 0xf390 0xefc6
	and.b	#1,1234h		; 0xf3d0 0xefc2
	and.w	#1,1234h		; 0xf390 0xefbe
	and	#2,1234h		; 0xf3a0 0xefba
	and.b	#2,1234h		; 0xf3e0 0xefb6
	and.w	#2,1234h		; 0xf3a0 0xefb2
	and	#0ffffh,1234h		; 0xf3b0 0xefae
	and.b	#0ffh,1234h		; 0xf3f0 0xefaa
	and.w	#0ffffh,1234h		; 0xf3b0 0xefa6
	and	#-1,1234h		; 0xf3b0 0xefa2
	and.b	#-1,1234h		; 0xf3f0 0xef9e
	and.w	#-1,1234h		; 0xf3b0 0xef9a
	and	#100,1234h		; 0xf0b0 0x0064 0xef94
	and.b	#100,1234h		; 0xf0f0 0x0064 0xef8e
	and.w	#100,1234h		; 0xf0b0 0x0064 0xef88
	and	@r6,1234h		; 0xf6a0 0xef84
	and.b	@r6,1234h		; 0xf6e0 0xef80
	and.w	@r6,1234h		; 0xf6a0 0xef7c
	and	42(r6),1234h		; 0xf690 0x002a 0xef76
	and.b	42(r6),1234h		; 0xf6d0 0x002a 0xef70
	and.w	42(r6),1234h		; 0xf690 0x002a 0xef6a
	and	@r6,1234h		; 0xf6a0 0xef66
	and.b	@r6,1234h		; 0xf6e0 0xef62
	and.w	@r6,1234h		; 0xf6a0 0xef5e
	and	@r6+,1234h		; 0xf6b0 0xef5a
	and.b	@r6+,1234h		; 0xf6f0 0xef56
	and.w	@r6+,1234h		; 0xf6b0 0xef52
	and	&1234h,1234h		; 0xf290 0x1234 0xef4c
	and.b	&1234h,1234h		; 0xf2d0 0x1234 0xef46
	and.w	&1234h,1234h		; 0xf290 0x1234 0xef40
	and	1234h,1234h		; 0xf090 0xef3c 0xef3a
	and.b	1234h,1234h		; 0xf0d0 0xef36 0xef34
	and.w	1234h,1234h		; 0xf090 0xef30 0xef2e

	rrc	r7			; 0x1007
	rrc.b	r7			; 0x1047
	rrc.w	r7			; 0x1007
	rrc	200(r8)			; 0x1018 0x00c8
	rrc.b	200(r8)			; 0x1058 0x00c8
	rrc.w	200(r8)			; 0x1018 0x00c8
	rrc	@r6			; 0x1026
	rrc.b	@r6			; 0x1066
	rrc.w	@r6			; 0x1026
	rrc	@r6+			; 0x1036
	rrc.b	@r6+			; 0x1076
	rrc.w	@r6+			; 0x1036
	rrc	&1234h			; 0x1012 0x1234
	rrc.b	&1234h			; 0x1052 0x1234
	rrc.w	&1234h			; 0x1012 0x1234
	rrc	1234h			; 0x1010 0xef00
	rrc.b	1234h			; 0x1050 0xeefc
	rrc.w	1234h			; 0x1010 0xeef8
	rra	r7			; 0x1107
	rra.b	r7			; 0x1147
	rra.w	r7			; 0x1107
	rra	200(r8)			; 0x1118 0x00c8
	rra.b	200(r8)			; 0x1158 0x00c8
	rra.w	200(r8)			; 0x1118 0x00c8
	rra	@r6			; 0x1126
	rra.b	@r6			; 0x1166
	rra.w	@r6			; 0x1126
	rra	@r6+			; 0x1136
	rra.b	@r6+			; 0x1176
	rra.w	@r6+			; 0x1136
	rra	&1234h			; 0x1112 0x1234
	rra.b	&1234h			; 0x1152 0x1234
	rra.w	&1234h			; 0x1112 0x1234
	rra	1234h			; 0x1110 0xeeca
	rra.b	1234h			; 0x1150 0xeec6
	rra.w	1234h			; 0x1110 0xeec2
	push	r7			; 0x1207
	push.b	r7			; 0x1247
	push.w	r7			; 0x1207
        push	#4			; 0x1222
        push.b	#4			; 0x1262
        push.w	#4			; 0x1222
        push	#8			; 0x1232
        push.b	#8			; 0x1272
        push.w	#8			; 0x1232
        push	#0			; 0x1203
        push.b	#0			; 0x1243
        push.w	#0			; 0x1203
        push	#1			; 0x1213
        push.b	#1			; 0x1253
        push.w	#1			; 0x1213
        push	#2			; 0x1223
        push.b	#2			; 0x1263
        push.w	#2			; 0x1223
        push	#0ffffh			; 0x1233
        push.b	#0ffh			; 0x1273
        push.w	#0ffffh			; 0x1233
        push	#-1			; 0x1233
        push.b	#-1			; 0x1273
        push.w	#-1			; 0x1233
        push	#100			; 0x1230 0x0064
        push.b	#100			; 0x1270 0x0064
        push.w	#100			; 0x1230 0x0064
	push	200(r8)			; 0x1218 0x00c8
	push.b	200(r8)			; 0x1258 0x00c8
	push.w	200(r8)			; 0x1218 0x00c8
	push	@r6			; 0x1226
	push.b	@r6			; 0x1266
	push.w	@r6			; 0x1226
	push	@r6+			; 0x1236
	push.b	@r6+			; 0x1276
	push.w	@r6+			; 0x1236
	push	&1234h			; 0x1212 0x1234
	push.b	&1234h			; 0x1252 0x1234
	push.w	&1234h			; 0x1212 0x1234
	push	1234h			; 0x1210 0xee5e
	push.b	1234h			; 0x1250 0xee5a
	push.w	1234h			; 0x1210 0xee56
	swpb	r7			; 0x1087
	swpb.w	r7			; 0x1087
	swpb	200(r8)			; 0x1098 0x00c8
	swpb.w	200(r8)			; 0x1098 0x00c8
	swpb	@r6			; 0x10a6
	swpb.w	@r6			; 0x10a6
	swpb	@r6+			; 0x10b6
	swpb.w	@r6+			; 0x10b6
	swpb	&1234h			; 0x1092 0x1234
	swpb.w	&1234h			; 0x1092 0x1234
	swpb	1234h			; 0x1090 0xee36
	swpb.w	1234h			; 0x1090 0xee32
        call	#4			; 0x12a2
        call	#8			; 0x12b2
        call	#0			; 0x1283
        call	#1			; 0x1293
        call	#2			; 0x12a3
        call	#0ffffh			; 0x12b3
        call	#-1			; 0x12b3
        call	#100			; 0x12b0 0x0064
	call	200(r8)			; 0x1298 0x00c8
	call	@r6			; 0x12a6
	call	@r6+			; 0x12b6
	call	&1234h			; 0x1292 0x1234
	call	1234h			; 0x1290 0xee10
	reti				; 0x1300
	sxt	r7			; 0x1187
	sxt.w	r7			; 0x1187
	sxt	200(r8)			; 0x1198 0x00c8
	sxt.w	200(r8)			; 0x1198 0x00c8
	sxt	@r6			; 0x11a6
	sxt.w	@r6			; 0x11a6
	sxt	@r6+			; 0x11b6
	sxt.w	@r6+			; 0x11b6
	sxt	&1234h			; 0x1192 0x1234
	sxt.w	&1234h			; 0x1192 0x1234
	sxt	1234h			; 0x1190 0xedee
	sxt.w	1234h			; 0x1190 0xedea
	jeq	$+4			; 0x2401
	jz	$+4			; 0x2401
	jne	$+4			; 0x2001
	jnz	$+4			; 0x2001
	jc	$+4			; 0x2c01
	jnc	$+4			; 0x2801
	jn	$+4			; 0x3001
	jge	$+4			; 0x3401
	jl	$+4			; 0x3801
	jmp	$+4			; 0x3c01

	; emulated 430 instructions, no longer realized via macros

	adc	r7			; 0x6307
	adc.b	r7			; 0x6347
	adc.w	r7			; 0x6307
	adc	200(r8)			; 0x6388 0x00c8
	adc.b	200(r8)			; 0x63c8 0x00c8
	adc.w	200(r8)			; 0x6388 0x00c8
	adc	@r6			; 0x6386 0x0000
	adc.b	@r6			; 0x63c6 0x0000
	adc.w	@r6			; 0x6386 0x0000
	adc	&1234h			; 0x6382 0x1234
	adc.b	&1234h			; 0x63c2 0x1234
	adc.w	&1234h			; 0x6382 0x1234
	adc	1234h			; 0x6380 0xeda8
	adc.b	1234h			; 0x63c0 0xeda4
	adc.w	1234h			; 0x6380 0xeda0
	br	#0			; 0x4300
	br	#1			; 0x4310
	br	#2			; 0x4320
	br	#4			; 0x4220
	br	#8			; 0x4230
	br	#-1			; 0x4330
	br	#0ffffh			; 0x4330
	br	#100			; 0x4030 0x0064
	br	r7			; 0x4700
	br	200(r8)			; 0x4810 0x00c8
	br	@r6			; 0x4620
	br	@r6+			; 0x4630
	br	&1234h			; 0x4210 0x1234
	br	1234h			; 0x4010 0xed7c
	clr	r7			; 0x4307
	clr.b	r7			; 0x4347
	clr.w	r7			; 0x4307
	clr	200(r8)			; 0x4388 0x00c8
	clr.b	200(r8)			; 0x43c8 0x00c8
	clr.w	200(r8)			; 0x4388 0x00c8
	clr	@r6			; 0x4386 0x0000
	clr.b	@r6			; 0x43c6 0x0000
	clr.w	@r6			; 0x4386 0x0000
	clr	&1234h			; 0x4382 0x1234
	clr.b	&1234h			; 0x43c2 0x1234
	clr.w	&1234h			; 0x4382 0x1234
	clr	1234h			; 0x4380 0xed4e
	clr.b	1234h			; 0x43c0 0xed4a
	clr.w	1234h			; 0x4380 0xed46
	clrc				; 0xc312
	clrn				; 0xc222
	clrz				; 0xc322
	dadc	r7			; 0xa307
	dadc.b	r7			; 0xa347
	dadc.w	r7			; 0xa307
	dadc	200(r8)			; 0xa388 0x00c8
	dadc.b	200(r8)			; 0xa3c8 0x00c8
	dadc.w	200(r8)			; 0xa388 0x00c8
	dadc	@r6			; 0xa386 0x0000
	dadc.b	@r6			; 0xa3c6 0x0000
	dadc.w	@r6			; 0xa386 0x0000
	dadc	&1234h			; 0xa382 0x1234
	dadc.b	&1234h			; 0xa3c2 0x1234
	dadc.w	&1234h			; 0xa382 0x1234
	dadc	1234h			; 0xa380 0xed12
	dadc.b	1234h			; 0xa3c0 0xed0e
	dadc.w	1234h			; 0xa380 0xed0a
	dec	r7			; 0x8317
	dec.b	r7			; 0x8317
	dec.w	r7			; 0x8317
	dec	200(r8)			; 0x8398 0x00c8
	dec.b	200(r8)			; 0x83d8 0x00c8
	dec.w	200(r8)			; 0x8398 0x00c8
	dec	@r6			; 0x8396 0x0000
	dec.b	@r6			; 0x83d6 0x0000
	dec.w	@r6			; 0x8396 0x0000
	dec	&1234h			; 0x8392 0x1234
	dec.b	&1234h			; 0x83d2 0x1234
	dec.w	&1234h			; 0x8392 0x1234
	dec	1234h			; 0x8390 0xecdc
	dec.b	1234h			; 0x83d0 0xecd8
	dec.w	1234h			; 0x8390 0xecd4
	decd	r7			; 0x8327
	decd.b	r7			; 0x8327
	decd.w	r7			; 0x8327
	decd	200(r8)			; 0x83a8 0x00c8
	decd.b	200(r8)			; 0x83e8 0x00c8
	decd.w	200(r8)			; 0x83a8 0x00c8
	decd	@r6			; 0x83a6 0x0000
	decd.b	@r6			; 0x83e6 0x0000
	decd.w	@r6			; 0x83a6 0x0000
	decd	&1234h			; 0x83a2 0x1234
	decd.b	&1234h			; 0x83e2 0x1234
	decd.w	&1234h			; 0x83a2 0x1234
	decd	1234h			; 0x83a0 0xeca6
	decd.b	1234h			; 0x83e0 0xeca2
	decd.w	1234h			; 0x83a0 0xec9e
	dint				; 0xc232
	eint				; 0xd232
	inc	r7			; 0x5317
	inc.b	r7			; 0x5317
	inc.w	r7			; 0x5317
	inc	200(r8)			; 0x5398 0x00c8
	inc.b	200(r8)			; 0x53d8 0x00c8
	inc.w	200(r8)			; 0x5398 0x00c8
	inc	@r6			; 0x5396 0x0000
	inc.b	@r6			; 0x53d6 0x0000
	inc.w	@r6			; 0x5396 0x0000
	inc	&1234h			; 0x5392 0x1234
	inc.b	&1234h			; 0x53d2 0x1234
	inc.w	&1234h			; 0x5392 0x1234
	inc	1234h			; 0x5390 0xec6c
	inc.b	1234h			; 0x53d0 0xec68
	inc.w	1234h			; 0x5390 0xec64
	incd	r7			; 0x5327
	incd.b	r7			; 0x5327
	incd.w	r7			; 0x5327
	incd	200(r8)			; 0x53a8 0x00c8
	incd.b	200(r8)			; 0x53e8 0x00c8
	incd.w	200(r8)			; 0x53a8 0x00c8
	incd	@r6			; 0x53a6 0x0000
	incd.b	@r6			; 0x53e6 0x0000
	incd.w	@r6			; 0x53a6 0x0000
	incd	&1234h			; 0x53a2 0x1234
	incd.b	&1234h			; 0x53e2 0x1234
	incd.w	&1234h			; 0x53a2 0x1234
	incd	1234h			; 0x53a0 0xec36
	incd.b	1234h			; 0x53e0 0xec32
	incd.w	1234h			; 0x53a0 0xec2e
	inv	r7			; 0xe337
	inv.b	r7			; 0xe337
	inv.w	r7			; 0xe337
	inv	200(r8)			; 0xe3b8 0x00c8
	inv.b	200(r8)			; 0xe3f8 0x00c8
	inv.w	200(r8)			; 0xe3b8 0x00c8
	inv	@r6			; 0xe3b6 0x0000
	inv.b	@r6			; 0xe3f6 0x0000
	inv.w	@r6			; 0xe3b6 0x0000
	inv	&1234h			; 0xe3b2 0x1234
	inv.b	&1234h			; 0xe3f2 0x1234
	inv.w	&1234h			; 0xe3b2 0x1234
	inv	1234h			; 0xe3b0 0xec00
	inv.b	1234h			; 0xe3f0 0xebfc
	inv.w	1234h			; 0xe3b0 0xebf8
	nop				; 0x4303
	pop	r7			; 0x4137
	pop.b	r7			; 0x4177
	pop.w	r7			; 0x4137
	pop	200(r8)			; 0x41b8 0x00c8
	pop.b	200(r8)			; 0x41f8 0x00c8
	pop.w	200(r8)			; 0x41b8 0x00c8
	pop	@r6			; 0x41b6 0x0000
	pop.b	@r6			; 0x41f6 0x0000
	pop.w	@r6			; 0x41b6 0x0000
	pop	&1234h			; 0x41b2 0x1234
	pop.b	&1234h			; 0x41f2 0x1234
	pop.w	&1234h			; 0x41b2 0x1234
	pop	1234h			; 0x41b0 0xebc8
	pop.b	1234h			; 0x41f0 0xebc4
	pop.w	1234h			; 0x41b0 0xebc0
	ret				; 0x4130
	rla	r7			; 0x5707
	rla.b	r7			; 0x5747
	rla.w	r7			; 0x5707
	rla	200(r8)			; 0x5898 0x00c8 0x00c8
	rla.b	200(r8)			; 0x58d8 0x00c8 0x00c8
	rla.w	200(r8)			; 0x5898 0x00c8 0x00c8
	rla	@r6			; 0x56a6 0x0000
	rla.b	@r6			; 0x5ea6 0x0000
	rla.w	@r6			; 0x56a6 0x0000
	rla	@r6+			; 0x56b6 0xfffe (tricky, equals ADD @R6+,-2(R6))
	rla.b	@r6+			; 0x56f6 0xffff
	rla.w	@r6+			; 0x56b6 0xfffe
	rla	&1234h			; 0x5292 0x1234 0x1234
	rla.b	&1234h			; 0x52d2 0x1234 0x1234
	rla.w	&1234h			; 0x5292 0x1234 0x1234
	rla	1234h			; 0x5090 0xeb78 0xeb76
	rla.b	1234h			; 0x50d0 0xeb72 0xeb70
	rla.w	1234h			; 0x5090 0xeb6c 0xeb6a
	rlc	r7			; 0x6707
	rlc.b	r7			; 0x6747
	rlc.w	r7			; 0x6707
	rlc	200(r8)			; 0x6898 0x00c8 0x00c8
	rlc.b	200(r8)			; 0x68d8 0x00c8 0x00c8
	rlc.w	200(r8)			; 0x6898 0x00c8 0x00c8
	rlc	@r6			; 0x66a6 0x0000
	rlc.b	@r6			; 0x6ea6 0x0000
	rlc.w	@r6			; 0x66a6 0x0000
	rlc	@r6+			; 0x66b6 0xfffe (tricky, equals ADDC @R6+,-2(R6))
	rlc.b	@r6+			; 0x66f6 0xffff
	rlc.w	@r6+			; 0x66b6 0xfffe
	rlc	&1234h			; 0x6292 0x1234 0x1234
	rlc.b	&1234h			; 0x62d2 0x1234 0x1234
	rlc.w	&1234h			; 0x6292 0x1234 0x1234
	rlc	1234h			; 0x6090 0xeb24 0xeb22
	rlc.b	1234h			; 0x60d0 0xeb1e 0xeb1c
	rlc.w	1234h			; 0x6090 0xeb18 0xeb16
	sbc	r7			; 0x7307
	sbc.b	r7			; 0x7347
	sbc.w	r7			; 0x7307
	sbc	200(r8)			; 0x7388 0x00c8
	sbc.b	200(r8)			; 0x73c8 0x00c8
	sbc.w	200(r8)			; 0x7388 0x00c8
	sbc	@r6			; 0x7386 0x0000
	sbc.b	@r6			; 0x73c6 0x0000
	sbc.w	@r6			; 0x7386 0x0000
	sbc	&1234h			; 0x7382 0x1234
	sbc.b	&1234h			; 0x73c2 0x1234
	sbc.w	&1234h			; 0x7382 0x1234
	sbc	1234h			; 0x7380 0xeae8
	sbc.b	1234h			; 0x73c0 0xeae4
	sbc.w	1234h			; 0x7380 0xeae0
	setc				; 0xd312
	setn				; 0xd222
	setz				; 0xd322
	tst	r7			; 0x9307
	tst.b	r7			; 0x9347
	tst.w	r7			; 0x9307
	tst	200(r8)			; 0x9388 0x00c8
	tst.b	200(r8)			; 0x93c8 0x00c8
	tst.w	200(r8)			; 0x9388 0x00c8
	tst	@r6			; 0x9386 0x0000
	tst.b	@r6			; 0x93c6 0x0000
	tst.w	@r6			; 0x9386 0x0000
	tst	&1234h			; 0x9382 0x1234
	tst.b	&1234h			; 0x93c2 0x1234
	tst.w	&1234h			; 0x9382 0x1234
	tst	1234h			; 0x9380 0xeaac
	tst.b	1234h			; 0x93c0 0xeaa8
	tst.w	1234h			; 0x9380 0xeaa4

	; now to the 430X extended instructions

	cpu	msp430x

	org	10100h

	movx	r4,r7			; 0x1840 0x4407
        movx.b	r4,r7			; 0x1840 0x4447
        movx.w	r4,r7			; 0x1840 0x4407
	movx.a	r4,r7			; 0x1800 0x4447
        movx	#4,r7			; 0x1840 0x4227
        movx.b	#4,r7			; 0x1840 0x4267
        movx.w	#4,r7			; 0x1840 0x4227
        movx.a	#4,r7			; 0x1800 0x4267
        movx	#8,r7			; 0x1840 0x4237
        movx.b	#8,r7			; 0x1840 0x4277
        movx.w	#8,r7			; 0x1840 0x4237
        movx.a	#8,r7			; 0x1800 0x4277
        movx	#0,r7			; 0x1840 0x4307
        movx.b	#0,r7			; 0x1840 0x4347
        movx.w	#0,r7			; 0x1840 0x4307
        movx.a	#0,r7			; 0x1800 0x4347
        movx	#1,r7			; 0x1840 0x4317
        movx.b	#1,r7			; 0x1840 0x4357
        movx.w	#1,r7			; 0x1840 0x4317
        movx.a	#1,r7			; 0x1800 0x4357
        movx	#2,r7			; 0x1840 0x4327
        movx.b	#2,r7			; 0x1840 0x4367
        movx.w	#2,r7			; 0x1840 0x4327
        movx.a	#2,r7			; 0x1800 0x4367
        movx	#0ffffh,r7		; 0x1840 0x4337
        movx.b	#0ffh,r7		; 0x1840 0x4377
        movx.w	#0ffffh,r7		; 0x1840 0x4337
        movx.a	#0fffffh,r7		; 0x1800 0x4377
        movx	#-1,r7			; 0x1840 0x4337
        movx.b	#-1,r7			; 0x1840 0x4377
        movx.w	#-1,r7			; 0x1840 0x4337
        movx.a	#-1,r7			; 0x1800 0x4377
        movx	#100,r7			; 0x1840 0x4037 0x0064
        movx.b	#100,r7			; 0x1840 0x4077 0x0064
        movx.w	#100,r7			; 0x1840 0x4037 0x0064
        movx.a	#100000,r7		; 0x1880 0x4077 0x86a0
        movx	@r6,r7			; 0x1840 0x4627
        movx.b	@r6,r7			; 0x1840 0x4667
        movx.w	@r6,r7			; 0x1840 0x4627
        movx.a	@r6,r7			; 0x1800 0x4667
        movx	42(r6),r7		; 0x1840 0x4617 0x002a
        movx.b	42(r6),r7		; 0x1840 0x4657 0x002a
        movx.w	42(r6),r7		; 0x1840 0x4617 0x002a
        movx.a	42(r6),r7		; 0x1800 0x4657 0x002a
        movx	@r6,r7			; 0x1840 0x4627
        movx.b	@r6,r7			; 0x1840 0x4667
        movx.w	@r6,r7			; 0x1840 0x4627
        movx.a	@r6,r7			; 0x1800 0x4667
        movx	@r6+,r7			; 0x1840 0x4637
        movx.b	@r6+,r7			; 0x1840 0x4677
        movx.w	@r6+,r7			; 0x1840 0x4637
        movx.a	@r6+,r7			; 0x1800 0x4677
        movx	&12345h,r7		; 0x18c0 0x4217 0x2345
        movx.b	&12345h,r7		; 0x18c0 0x4257 0x2345
        movx.w	&12345h,r7		; 0x18c0 0x4217 0x2345
        movx.a	&12345h,r7		; 0x1880 0x4257 0x2345
        movx	65432h,r7		; 0x1ac0 0x4017 0x5236
        movx.b	65432h,r7		; 0x1ac0 0x4057 0x5230
        movx.w	65432h,r7		; 0x1ac0 0x4017 0x522a
        movx.a	65432h,r7		; 0x1a80 0x4057 0x5224
        movx	r4,200(r8)		; 0x1840 0x4488 0x00c8
        movx.b	r4,200(r8)		; 0x1840 0x44c8 0x00c8
        movx.w	r4,200(r8)		; 0x1840 0x4488 0x00c8
        movx.a	r4,200(r8)		; 0x1800 0x44c8 0x00c8
        movx	#4,200(r8)		; 0x1840 0x42a8 0x00c8
        movx.b	#4,200(r8)		; 0x1840 0x42e8 0x00c8
        movx.w	#4,200(r8)		; 0x1840 0x42a8 0x00c8
        movx.a	#4,200(r8)		; 0x1800 0x42e8 0x00c8
        movx	#8,200(r8)		; 0x1840 0x42b8 0x00c8
        movx.b	#8,200(r8)		; 0x1840 0x42f8 0x00c8
        movx.w	#8,200(r8)		; 0x1840 0x42b8 0x00c8
        movx.a	#8,200(r8)		; 0x1800 0x42f8 0x00c8
        movx	#0,200(r8)		; 0x1840 0x4388 0x00c8
        movx.b	#0,200(r8)		; 0x1840 0x43c8 0x00c8
        movx.w	#0,200(r8)		; 0x1840 0x4388 0x00c8
        movx.a	#0,200(r8)		; 0x1800 0x43c8 0x00c8
        movx	#1,200(r8)		; 0x1840 0x4398 0x00c8
        movx.b	#1,200(r8)		; 0x1840 0x43d8 0x00c8
        movx.w	#1,200(r8)		; 0x1840 0x4398 0x00c8
        movx.a	#1,200(r8)		; 0x1800 0x43d8 0x00c8
        movx	#2,200(r8)		; 0x1840 0x43a8 0x00c8
        movx.b	#2,200(r8)		; 0x1840 0x43e8 0x00c8
        movx.w	#2,200(r8)		; 0x1840 0x43a8 0x00c8
        movx.a	#2,200(r8)		; 0x1800 0x43e8 0x00c8
        movx	#0ffffh,200(r8)		; 0x1840 0x43b8 0x00c8
        movx.b	#0ffh,200(r8)		; 0x1840 0x43f8 0x00c8
        movx.w	#0ffffh,200(r8)		; 0x1840 0x43b8 0x00c8
        movx.a	#0fffffh,200(r8)	; 0x1800 0x43f8 0x00c8
        movx	#-1,200(r8)		; 0x1840 0x43b8 0x00c8
        movx.b	#-1,200(r8)		; 0x1840 0x43f8 0x00c8
        movx.w	#-1,200(r8)		; 0x1840 0x43b8 0x00c8
        movx.a	#-1,200(r8)		; 0x1800 0x43f8 0x00c8
        movx	#100,200(r8)		; 0x1840 0x40b8 0x0064 0x00c8
        movx.b	#100,200(r8)		; 0x1840 0x40f8 0x0064 0x00c8
        movx.w	#100,200(r8)		; 0x1840 0x40b8 0x0064 0x00c8
        movx.a	#100000,200(r8)		; 0x1880 0x40f8 0x86a0 0x00c8
        movx	@r6,200(r8)		; 0x1840 0x46a8 0x00c8
        movx.b	@r6,200(r8)		; 0x1840 0x46e8 0x00c8
        movx.w	@r6,200(r8)		; 0x1840 0x46a8 0x00c8
        movx.a	@r6,200(r8)		; 0x1800 0x46e8 0x00c8
        movx	42(r6),200(r8)		; 0x1840 0x4698 0x002a 0x00c8
        movx.b	42(r6),200(r8)		; 0x1840 0x46d8 0x002a 0x00c8
        movx.w	42(r6),200(r8)		; 0x1840 0x4698 0x002a 0x00c8
        movx.a	42(r6),200(r8)		; 0x1800 0x46d8 0x002a 0x00c8
        movx	@r6,200(r8)		; 0x1840 0x46a8 0x00c8
        movx.b	@r6,200(r8)		; 0x1840 0x46e8 0x00c8
        movx.w	@r6,200(r8)		; 0x1840 0x46a8 0x00c8
        movx.a	@r6,200(r8)		; 0x1800 0x46e8 0x00c8
        movx	@r6+,200(r8)		; 0x1840 0x46b8 0x00c8
        movx.b	@r6+,200(r8)		; 0x1840 0x46f8 0x00c8
        movx.w	@r6+,200(r8)		; 0x1840 0x46b8 0x00c8
        movx.a	@r6+,200(r8)		; 0x1800 0x46f8 0x00c8
        movx	&12345h,200(r8)		; 0x18c0 0x4298 0x2345 0x00c8
        movx.b	&12345h,200(r8)		; 0x18c0 0x42d8 0x2345 0x00c8
        movx.w	&12345h,200(r8)		; 0x18c0 0x4298 0x2345 0x00c8
        movx.a	&12345h,200(r8)		; 0x1880 0x42d8 0x2345 0x00c8
        movx	65432h,200(r8)		; 0x1ac0 0x4098 0x50b6 0x00c8
        movx.b	65432h,200(r8)		; 0x1ac0 0x40d8 0x50ae 0x00c8
        movx.w	65432h,200(r8)		; 0x1ac0 0x4098 0x50a6 0x00c8
        movx.a	65432h,200(r8)		; 0x1a80 0x40d8 0x509e 0x00c8
        movx	r4,&12345h		; 0x1841 0x4482 0x2345
        movx.b	r4,&12345h		; 0x1841 0x44c2 0x2345
        movx.w	r4,&12345h		; 0x1841 0x4482 0x2345
        movx.a	r4,&12345h		; 0x1801 0x44c2 0x2345
        movx	#4,&12345h		; 0x1841 0x42a2 0x2345
        movx.b	#4,&12345h		; 0x1841 0x42e2 0x2345
        movx.w	#4,&12345h		; 0x1841 0x42a2 0x2345
        movx.a	#4,&12345h		; 0x1801 0x42e2 0x2345
        movx	#8,&12345h		; 0x1841 0x42b2 0x2345
        movx.b	#8,&12345h		; 0x1841 0x42f2 0x2345
        movx.w	#8,&12345h		; 0x1841 0x42b2 0x2345
        movx.a	#8,&12345h		; 0x1801 0x42f2 0x2345
        movx	#0,&12345h		; 0x1841 0x4382 0x2345
        movx.b	#0,&12345h		; 0x1841 0x43c2 0x2345
        movx.w	#0,&12345h		; 0x1841 0x4382 0x2345
        movx.a	#0,&12345h		; 0x1801 0x43c2 0x2345
        movx	#1,&12345h		; 0x1841 0x4392 0x2345
        movx.b	#1,&12345h		; 0x1841 0x43d2 0x2345
        movx.w	#1,&12345h		; 0x1841 0x4392 0x2345
        movx.a	#1,&12345h		; 0x1801 0x43d2 0x2345
        movx	#2,&12345h		; 0x1841 0x43a2 0x2345
        movx.b	#2,&12345h		; 0x1841 0x43e2 0x2345
        movx.w	#2,&12345h		; 0x1841 0x43a2 0x2345
        movx.a	#2,&12345h		; 0x1801 0x43e2 0x2345
        movx	#0ffffh,&12345h		; 0x1841 0x43b2 0x2345
        movx.b	#0ffh,&12345h  		; 0x1841 0x43f2 0x2345
        movx.w	#0ffffh,&12345h		; 0x1841 0x43b2 0x2345
        movx.a	#0fffffh,&12345h	; 0x1801 0x43f2 0x2345
        movx	#-1,&12345h		; 0x1841 0x43b2 0x2345
        movx.b	#-1,&12345h		; 0x1841 0x43f2 0x2345
        movx.w	#-1,&12345h		; 0x1841 0x43b2 0x2345
        movx.a	#-1,&12345h		; 0x1801 0x43f2 0x2345
        movx	#100,&12345h		; 0x1841 0x40b2 0x0064 0x2345
        movx.b	#100,&12345h		; 0x1841 0x40f2 0x0064 0x2345
        movx.w	#100,&12345h		; 0x1841 0x40b2 0x0064 0x2345
        movx.a	#100000,&12345h		; 0x1881 0x40f2 0x86a0 0x2345
        movx	@r6,&12345h		; 0x1841 0x46a2 0x2345
        movx.b	@r6,&12345h		; 0x1841 0x46e2 0x2345
        movx.w	@r6,&12345h		; 0x1841 0x46a2 0x2345
        movx.a	@r6,&12345h		; 0x1801 0x46e2 0x2345
        movx	42(r6),&12345h		; 0x1841 0x4692 0x002a 0x2345
        movx.b	42(r6),&12345h		; 0x1841 0x46d2 0x002a 0x2345
        movx.w	42(r6),&12345h		; 0x1841 0x4692 0x002a 0x2345
        movx.a	42(r6),&12345h		; 0x1801 0x46d2 0x002a 0x2345
        movx	@r6,&12345h		; 0x1841 0x46a2 0x2345
        movx.b	@r6,&12345h		; 0x1841 0x46e2 0x2345
        movx.w	@r6,&12345h		; 0x1841 0x46a2 0x2345
        movx.a	@r6,&12345h		; 0x1801 0x46e2 0x2345
        movx	@r6+,&12345h		; 0x1841 0x46b2 0x2345
        movx.b	@r6+,&12345h		; 0x1841 0x46f2 0x2345
        movx.w	@r6+,&12345h		; 0x1841 0x46b2 0x2345
        movx.a	@r6+,&12345h		; 0x1801 0x46f2 0x2345
        movx	&12345h,&12345h		; 0x18c1 0x4292 0x2345 0x2345
        movx.b	&12345h,&12345h		; 0x18c1 0x42d2 0x2345 0x2345
        movx.w	&12345h,&12345h		; 0x18c1 0x4292 0x2345 0x2345
        movx.a	&12345h,&12345h		; 0x1881 0x42d2 0x2345 0x2345
        movx	65432h,&12345h		; 0x1ac1 0x4092 0x4f2e 0x2345
        movx.b	65432h,&12345h		; 0x1ac1 0x40d2 0x4f26 0x2345
        movx.w	65432h,&12345h		; 0x1ac1 0x4092 0x4f1e 0x2345
        movx.a	65432h,&12345h		; 0x1a81 0x40d2 0x4f16 0x2345
        movx	r4,65432h		; 0x1845 0x4480 0x4f0e
        movx.b	r4,65432h		; 0x1845 0x44c0 0x4f08
        movx.w	r4,65432h		; 0x1845 0x4480 0x4f02
        movx.a	r4,65432h		; 0x1805 0x44c0 0x4efc
        movx	#4,65432h		; 0x1845 0x42a0 0x4ef6
        movx.b	#4,65432h		; 0x1845 0x42e0 0x4ef0
        movx.w	#4,65432h		; 0x1845 0x42a0 0x4eea
        movx.a	#4,65432h		; 0x1805 0x42e0 0x4ee4
        movx	#8,65432h		; 0x1845 0x42b0 0x4ede
        movx.b	#8,65432h		; 0x1845 0x42f0 0x4ed8
        movx.w	#8,65432h		; 0x1845 0x42b0 0x4ed2
        movx.a	#8,65432h		; 0x1805 0x42f0 0x4ecc
        movx	#0,65432h		; 0x1845 0x4380 0x4ec6
        movx.b	#0,65432h		; 0x1845 0x43c0 0x4ec0
        movx.w	#0,65432h		; 0x1845 0x4380 0x4eba
        movx.a	#0,65432h		; 0x1805 0x43c0 0x4eb4
        movx	#1,65432h		; 0x1845 0x4390 0x4eae
        movx.b	#1,65432h		; 0x1845 0x43d0 0x4ea8
        movx.w	#1,65432h		; 0x1845 0x4390 0x4ea2
        movx.a	#1,65432h		; 0x1805 0x43d0 0x4e9c
        movx	#2,65432h		; 0x1845 0x43a0 0x4e96
        movx.b	#2,65432h		; 0x1845 0x43e0 0x4e90
        movx.w	#2,65432h		; 0x1845 0x43a0 0x4e8a
        movx.a	#2,65432h		; 0x1805 0x43e0 0x4e84
        movx	#0ffffh,65432h		; 0x1845 0x43b0 0x4e7e
        movx.b	#0ffh,65432h  		; 0x1845 0x43f0 0x4e78
        movx.w	#0ffffh,65432h		; 0x1845 0x43b0 0x4e72
        movx.a	#0fffffh,65432h		; 0x1805 0x43f0 0x4e6c
        movx	#-1,65432h		; 0x1845 0x43b0 0x4e66
        movx.b	#-1,65432h		; 0x1845 0x43f0 0x4e60
        movx.w	#-1,65432h		; 0x1845 0x43b0 0x4e5a
        movx.a	#-1,65432h		; 0x1805 0x43f0 0x4e54
        movx	#100,65432h		; 0x1845 0x40b0 0x0064 0x4e4c
        movx.b	#100,65432h		; 0x1845 0x40f0 0x0064 0x4e44
        movx.w	#100,65432h		; 0x1845 0x40b0 0x0064 0x4e3c
        movx.a	#100000,65432h		; 0x1885 0x40f0 0x86a0 0x4e34
        movx	@r6,65432h		; 0x1845 0x46a0 0x4e2e
        movx.b	@r6,65432h		; 0x1845 0x46e0 0x4e28
        movx.w	@r6,65432h		; 0x1845 0x46a0 0x4e22
        movx.a	@r6,65432h		; 0x1805 0x46e0 0x4e1c
        movx	42(r6),65432h		; 0x1845 0x4690 0x002a 0x4e14
        movx.b	42(r6),65432h		; 0x1845 0x46d0 0x002a 0x4e0c
        movx.w	42(r6),65432h		; 0x1845 0x4690 0x002a 0x4e04
        movx.a	42(r6),65432h		; 0x1805 0x46d0 0x002a 0x4dfc
        movx	@r6,65432h		; 0x1845 0x46a0 0x4df6
        movx.b	@r6,65432h		; 0x1845 0x46e0 0x4df0
        movx.w	@r6,65432h		; 0x1845 0x46a0 0x4dea
        movx.a	@r6,65432h		; 0x1805 0x46e0 0x4de4
        movx	@r6+,65432h		; 0x1845 0x46b0 0x4dde
        movx.b	@r6+,65432h		; 0x1845 0x46f0 0x4dd8
        movx.w	@r6+,65432h		; 0x1845 0x46b0 0x4dd2
        movx.a	@r6+,65432h		; 0x1805 0x46f0 0x4dcc
        movx	&12345h,65432h		; 0x18c5 0x4290 0x2345 0x4dc4
        movx.b	&12345h,65432h		; 0x18c5 0x42d0 0x2345 0x4dbc
        movx.w	&12345h,65432h		; 0x18c5 0x4290 0x2345 0x4db4
        movx.a	&12345h,65432h		; 0x1885 0x42d0 0x2345 0x4dac
        movx	65432h,65432h		; 0x1ac5 0x4090 0x4da6 0x4da4
        movx.b	65432h,65432h		; 0x1ac5 0x40d0 0x4d9e 0x4d9c
        movx.w	65432h,65432h		; 0x1ac5 0x4090 0x4d96 0x4d94
        movx.a	65432h,65432h		; 0x1a85 0x40d0 0x4d8e 0x4d8c
	addx	r4,r7			; 0x1840 0x5407
        addx.b	r4,r7			; 0x1840 0x5447
        addx.w	r4,r7			; 0x1840 0x5407
	addx.a	r4,r7			; 0x1800 0x5447
        addx	#4,r7			; 0x1840 0x5227
        addx.b	#4,r7			; 0x1840 0x5267
        addx.w	#4,r7			; 0x1840 0x5227
        addx.a	#4,r7			; 0x1800 0x5267
        addx	#8,r7			; 0x1840 0x5237
        addx.b	#8,r7			; 0x1840 0x5277
        addx.w	#8,r7			; 0x1840 0x5237
        addx.a	#8,r7			; 0x1800 0x5277
        addx	#0,r7			; 0x1840 0x5307
        addx.b	#0,r7			; 0x1840 0x5347
        addx.w	#0,r7			; 0x1840 0x5307
        addx.a	#0,r7			; 0x1800 0x5347
        addx	#1,r7			; 0x1840 0x5317
        addx.b	#1,r7			; 0x1840 0x5357
        addx.w	#1,r7			; 0x1840 0x5317
        addx.a	#1,r7			; 0x1800 0x5357
        addx	#2,r7			; 0x1840 0x5327
        addx.b	#2,r7			; 0x1840 0x5367
        addx.w	#2,r7			; 0x1840 0x5327
        addx.a	#2,r7			; 0x1800 0x5367
        addx	#0ffffh,r7		; 0x1840 0x5337
        addx.b	#0ffh,r7		; 0x1840 0x5377
        addx.w	#0ffffh,r7		; 0x1840 0x5337
        addx.a	#0fffffh,r7		; 0x1800 0x5377
        addx	#-1,r7			; 0x1840 0x5337
        addx.b	#-1,r7			; 0x1840 0x5377
        addx.w	#-1,r7			; 0x1840 0x5337
        addx.a	#-1,r7			; 0x1800 0x5377
        addx	#100,r7			; 0x1840 0x5037 0x0064
        addx.b	#100,r7			; 0x1840 0x5077 0x0064
        addx.w	#100,r7			; 0x1840 0x5037 0x0064
        addx.a	#100000,r7		; 0x1880 0x5077 0x86a0
        addx	@r6,r7			; 0x1840 0x5627
        addx.b	@r6,r7			; 0x1840 0x5667
        addx.w	@r6,r7			; 0x1840 0x5627
        addx.a	@r6,r7			; 0x1800 0x5667
        addx	42(r6),r7		; 0x1840 0x5617 0x002a
        addx.b	42(r6),r7		; 0x1840 0x5657 0x002a
        addx.w	42(r6),r7		; 0x1840 0x5617 0x002a
        addx.a	42(r6),r7		; 0x1800 0x5657 0x002a
        addx	@r6,r7			; 0x1840 0x5627
        addx.b	@r6,r7			; 0x1840 0x5667
        addx.w	@r6,r7			; 0x1840 0x5627
        addx.a	@r6,r7			; 0x1800 0x5667
        addx	@r6+,r7			; 0x1840 0x5637
        addx.b	@r6+,r7			; 0x1840 0x5677
        addx.w	@r6+,r7			; 0x1840 0x5637
        addx.a	@r6+,r7			; 0x1800 0x5677
        addx	&12345h,r7		; 0x18c0 0x5217 0x2345
        addx.b	&12345h,r7		; 0x18c0 0x5257 0x2345
        addx.w	&12345h,r7		; 0x18c0 0x5217 0x2345
        addx.a	&12345h,r7		; 0x1880 0x5257 0x2345
        addx	65432h,r7		; 0x1ac0 0x5017 0x4c8e
        addx.b	65432h,r7		; 0x1ac0 0x5057 0x4c88
        addx.w	65432h,r7		; 0x1ac0 0x5017 0x4c82
        addx.a	65432h,r7		; 0x1a80 0x5057 0x4c7c
        addx	r4,200(r8)		; 0x1840 0x5488 0x00c8
        addx.b	r4,200(r8)		; 0x1840 0x54c8 0x00c8
        addx.w	r4,200(r8)		; 0x1840 0x5488 0x00c8
        addx.a	r4,200(r8)		; 0x1800 0x54c8 0x00c8
        addx	#4,200(r8)		; 0x1840 0x52a8 0x00c8
        addx.b	#4,200(r8)		; 0x1840 0x52e8 0x00c8
        addx.w	#4,200(r8)		; 0x1840 0x52a8 0x00c8
        addx.a	#4,200(r8)		; 0x1800 0x52e8 0x00c8
        addx	#8,200(r8)		; 0x1840 0x52b8 0x00c8
        addx.b	#8,200(r8)		; 0x1840 0x52f8 0x00c8
        addx.w	#8,200(r8)		; 0x1840 0x52b8 0x00c8
        addx.a	#8,200(r8)		; 0x1800 0x52f8 0x00c8
        addx	#0,200(r8)		; 0x1840 0x5388 0x00c8
        addx.b	#0,200(r8)		; 0x1840 0x53c8 0x00c8
        addx.w	#0,200(r8)		; 0x1840 0x5388 0x00c8
        addx.a	#0,200(r8)		; 0x1800 0x53c8 0x00c8
        addx	#1,200(r8)		; 0x1840 0x5398 0x00c8
        addx.b	#1,200(r8)		; 0x1840 0x53d8 0x00c8
        addx.w	#1,200(r8)		; 0x1840 0x5398 0x00c8
        addx.a	#1,200(r8)		; 0x1800 0x53d8 0x00c8
        addx	#2,200(r8)		; 0x1840 0x53a8 0x00c8
        addx.b	#2,200(r8)		; 0x1840 0x53e8 0x00c8
        addx.w	#2,200(r8)		; 0x1840 0x53a8 0x00c8
        addx.a	#2,200(r8)		; 0x1800 0x53e8 0x00c8
        addx	#0ffffh,200(r8)		; 0x1840 0x53b8 0x00c8
        addx.b	#0ffh,200(r8)		; 0x1840 0x53f8 0x00c8
        addx.w	#0ffffh,200(r8)		; 0x1840 0x53b8 0x00c8
        addx.a	#0fffffh,200(r8)	; 0x1800 0x53f8 0x00c8
        addx	#-1,200(r8)		; 0x1840 0x53b8 0x00c8
        addx.b	#-1,200(r8)		; 0x1840 0x53f8 0x00c8
        addx.w	#-1,200(r8)		; 0x1840 0x53b8 0x00c8
        addx.a	#-1,200(r8)		; 0x1800 0x53f8 0x00c8
        addx	#100,200(r8)		; 0x1840 0x50b8 0x0064 0x00c8
        addx.b	#100,200(r8)		; 0x1840 0x50f8 0x0064 0x00c8
        addx.w	#100,200(r8)		; 0x1840 0x50b8 0x0064 0x00c8
        addx.a	#100000,200(r8)		; 0x1880 0x50f8 0x86a0 0x00c8
        addx	@r6,200(r8)		; 0x1840 0x56a8 0x00c8
        addx.b	@r6,200(r8)		; 0x1840 0x56e8 0x00c8
        addx.w	@r6,200(r8)		; 0x1840 0x56a8 0x00c8
        addx.a	@r6,200(r8)		; 0x1800 0x56e8 0x00c8
        addx	42(r6),200(r8)		; 0x1840 0x5698 0x002a 0x00c8
        addx.b	42(r6),200(r8)		; 0x1840 0x56d8 0x002a 0x00c8
        addx.w	42(r6),200(r8)		; 0x1840 0x5698 0x002a 0x00c8
        addx.a	42(r6),200(r8)		; 0x1800 0x56d8 0x002a 0x00c8
        addx	@r6,200(r8)		; 0x1840 0x56a8 0x00c8
        addx.b	@r6,200(r8)		; 0x1840 0x56e8 0x00c8
        addx.w	@r6,200(r8)		; 0x1840 0x56a8 0x00c8
        addx.a	@r6,200(r8)		; 0x1800 0x56e8 0x00c8
        addx	@r6+,200(r8)		; 0x1840 0x56b8 0x00c8
        addx.b	@r6+,200(r8)		; 0x1840 0x56f8 0x00c8
        addx.w	@r6+,200(r8)		; 0x1840 0x56b8 0x00c8
        addx.a	@r6+,200(r8)		; 0x1800 0x56f8 0x00c8
        addx	&12345h,200(r8)		; 0x18c0 0x5298 0x2345 0x00c8
        addx.b	&12345h,200(r8)		; 0x18c0 0x52d8 0x2345 0x00c8
        addx.w	&12345h,200(r8)		; 0x18c0 0x5298 0x2345 0x00c8
        addx.a	&12345h,200(r8)		; 0x1880 0x52d8 0x2345 0x00c8
        addx	65432h,200(r8)		; 0x1ac0 0x5098 0x4b0e 0x00c8
        addx.b	65432h,200(r8)		; 0x1ac0 0x50d8 0x4b06 0x00c8
        addx.w	65432h,200(r8)		; 0x1ac0 0x5098 0x4afe 0x00c8
        addx.a	65432h,200(r8)		; 0x1ac0 0x50d8 0x4af6 0x00c8
        addx	r4,&12345h		; 0x1841 0x5482 0x2345
        addx.b	r4,&12345h		; 0x1841 0x54c2 0x2345
        addx.w	r4,&12345h		; 0x1841 0x5482 0x2345
        addx.a	r4,&12345h		; 0x1801 0x54c2 0x2345
        addx	#4,&12345h		; 0x1841 0x52a2 0x2345
        addx.b	#4,&12345h		; 0x1841 0x52e2 0x2345
        addx.w	#4,&12345h		; 0x1841 0x52a2 0x2345
        addx.a	#4,&12345h		; 0x1801 0x52e2 0x2345
        addx	#8,&12345h		; 0x1841 0x52b2 0x2345
        addx.b	#8,&12345h		; 0x1841 0x52f2 0x2345
        addx.w	#8,&12345h		; 0x1841 0x52b2 0x2345
        addx.a	#8,&12345h		; 0x1801 0x52f2 0x2345
        addx	#0,&12345h		; 0x1841 0x5382 0x2345
        addx.b	#0,&12345h		; 0x1841 0x53c2 0x2345
        addx.w	#0,&12345h		; 0x1841 0x5382 0x2345
        addx.a	#0,&12345h		; 0x1801 0x53c2 0x2345
        addx	#1,&12345h		; 0x1841 0x5392 0x2345
        addx.b	#1,&12345h		; 0x1841 0x53d2 0x2345
        addx.w	#1,&12345h		; 0x1841 0x5392 0x2345
        addx.a	#1,&12345h		; 0x1801 0x53d2 0x2345
        addx	#2,&12345h		; 0x1841 0x53a2 0x2345
        addx.b	#2,&12345h		; 0x1841 0x53e2 0x2345
        addx.w	#2,&12345h		; 0x1841 0x53a2 0x2345
        addx.a	#2,&12345h		; 0x1801 0x53e2 0x2345
        addx	#0ffffh,&12345h		; 0x1841 0x53b2 0x2345
        addx.b	#0ffh,&12345h  		; 0x1841 0x53f2 0x2345
        addx.w	#0ffffh,&12345h		; 0x1841 0x53b2 0x2345
        addx.a	#0fffffh,&12345h	; 0x1801 0x53f2 0x2345
        addx	#-1,&12345h		; 0x1841 0x53b2 0x2345
        addx.b	#-1,&12345h		; 0x1841 0x53f2 0x2345
        addx.w	#-1,&12345h		; 0x1841 0x53b2 0x2345
        addx.a	#-1,&12345h		; 0x1801 0x53f2 0x2345
        addx	#100,&12345h		; 0x1841 0x50b2 0x0064 0x2345
        addx.b	#100,&12345h		; 0x1841 0x50f2 0x0064 0x2345
        addx.w	#100,&12345h		; 0x1841 0x50b2 0x0064 0x2345
        addx.a	#100000,&12345h		; 0x1881 0x50f2 0x86a0 0x2345
        addx	@r6,&12345h		; 0x1841 0x56a2 0x2345
        addx.b	@r6,&12345h		; 0x1841 0x56e2 0x2345
        addx.w	@r6,&12345h		; 0x1841 0x56a2 0x2345
        addx.a	@r6,&12345h		; 0x1801 0x56e2 0x2345
        addx	42(r6),&12345h		; 0x1841 0x5692 0x002a 0x2345
        addx.b	42(r6),&12345h		; 0x1841 0x56d2 0x002a 0x2345
        addx.w	42(r6),&12345h		; 0x1841 0x5692 0x002a 0x2345
        addx.a	42(r6),&12345h		; 0x1801 0x56d2 0x002a 0x2345
        addx	@r6,&12345h		; 0x1841 0x56a2 0x2345
        addx.b	@r6,&12345h		; 0x1841 0x56e2 0x2345
        addx.w	@r6,&12345h		; 0x1841 0x56a2 0x2345
        addx.a	@r6,&12345h		; 0x1801 0x56e2 0x2345
        addx	@r6+,&12345h		; 0x1841 0x56b2 0x2345
        addx.b	@r6+,&12345h		; 0x1841 0x56f2 0x2345
        addx.w	@r6+,&12345h		; 0x1841 0x56b2 0x2345
        addx.a	@r6+,&12345h		; 0x1801 0x56f2 0x2345
        addx	&12345h,&12345h		; 0x18c1 0x5292 0x2345 0x2345
        addx.b	&12345h,&12345h		; 0x18c1 0x52d2 0x2345 0x2345
        addx.w	&12345h,&12345h		; 0x18c1 0x5292 0x2345 0x2345
        addx.a	&12345h,&12345h		; 0x1881 0x52d2 0x2345 0x2345
        addx	65432h,&12345h		; 0x1ac1 0x5092 0x4986 0x2345
        addx.b	65432h,&12345h		; 0x1ac1 0x50d2 0x497e 0x2345
        addx.w	65432h,&12345h		; 0x1ac1 0x5092 0x4976 0x2345
        addx.a	65432h,&12345h		; 0x1a81 0x50d2 0x496e 0x2345
        addx	r4,65432h		; 0x1845 0x5480 0x4966
        addx.b	r4,65432h		; 0x1845 0x54c0 0x4960
        addx.w	r4,65432h		; 0x1845 0x5480 0x495a
        addx.a	r4,65432h		; 0x1805 0x54c0 0x4954
        addx	#4,65432h		; 0x1845 0x52a0 0x494e
        addx.b	#4,65432h		; 0x1845 0x52e0 0x4948
        addx.w	#4,65432h		; 0x1845 0x52a0 0x4942
        addx.a	#4,65432h		; 0x1805 0x52e0 0x493c
        addx	#8,65432h		; 0x1845 0x52b0 0x4936
        addx.b	#8,65432h		; 0x1845 0x52f0 0x4930
        addx.w	#8,65432h		; 0x1845 0x52b0 0x492a
        addx.a	#8,65432h		; 0x1805 0x52f0 0x4924
        addx	#0,65432h		; 0x1845 0x5380 0x491e
        addx.b	#0,65432h		; 0x1845 0x53c0 0x4918
        addx.w	#0,65432h		; 0x1845 0x5380 0x4912
        addx.a	#0,65432h		; 0x1805 0x53c0 0x490c
        addx	#1,65432h		; 0x1845 0x5390 0x4906
        addx.b	#1,65432h		; 0x1845 0x53d0 0x4900
        addx.w	#1,65432h		; 0x1845 0x5390 0x48fa
        addx.a	#1,65432h		; 0x1805 0x53d0 0x48f4
        addx	#2,65432h		; 0x1845 0x53a0 0x48ee
        addx.b	#2,65432h		; 0x1845 0x53e0 0x48e8
        addx.w	#2,65432h		; 0x1845 0x53a0 0x48e2
        addx.a	#2,65432h		; 0x1805 0x53e0 0x48dc
        addx	#0ffffh,65432h		; 0x1845 0x53b0 0x48d6
        addx.b	#0ffh,65432h  		; 0x1845 0x53f0 0x48d0
        addx.w	#0ffffh,65432h		; 0x1845 0x53b0 0x48ca
        addx.a	#0fffffh,65432h		; 0x1805 0x53f0 0x48c4
        addx	#-1,65432h		; 0x1845 0x53b0 0x48be
        addx.b	#-1,65432h		; 0x1845 0x53f0 0x48b8
        addx.w	#-1,65432h		; 0x1845 0x53b0 0x48b2
        addx.a	#-1,65432h		; 0x1805 0x53f0 0x48ac
        addx	#100,65432h		; 0x1845 0x50b0 0x0064 0x48a4
        addx.b	#100,65432h		; 0x1845 0x50f0 0x0064 0x489c
        addx.w	#100,65432h		; 0x1845 0x50b0 0x0064 0x4894
        addx.a	#100000,65432h		; 0x1885 0x50f0 0x86a0 0x488c
        addx	@r6,65432h		; 0x1845 0x56a0 0x4886
        addx.b	@r6,65432h		; 0x1845 0x56e0 0x4880
        addx.w	@r6,65432h		; 0x1845 0x56a0 0x487a
        addx.a	@r6,65432h		; 0x1805 0x56e0 0x4874
        addx	42(r6),65432h		; 0x1845 0x5690 0x002a 0x486c
        addx.b	42(r6),65432h		; 0x1845 0x56d0 0x002a 0x4864
        addx.w	42(r6),65432h		; 0x1845 0x5690 0x002a 0x485c
        addx.a	42(r6),65432h		; 0x1805 0x56d0 0x002a 0x4854
        addx	@r6,65432h		; 0x1845 0x56a0 0x484e
        addx.b	@r6,65432h		; 0x1845 0x56e0 0x4848
        addx.w	@r6,65432h		; 0x1845 0x56a0 0x4842
        addx.a	@r6,65432h		; 0x1805 0x56e0 0x483c
        addx	@r6+,65432h		; 0x1845 0x56b0 0x4836
        addx.b	@r6+,65432h		; 0x1845 0x56f0 0x4830
        addx.w	@r6+,65432h		; 0x1845 0x56b0 0x482a
        addx.a	@r6+,65432h		; 0x1805 0x56f0 0x4824
        addx	&12345h,65432h		; 0x18c5 0x5290 0x2345 0x481c
        addx.b	&12345h,65432h		; 0x18c5 0x52d0 0x2345 0x4814
        addx.w	&12345h,65432h		; 0x18c5 0x5290 0x2345 0x480c
        addx.a	&12345h,65432h		; 0x1885 0x52d0 0x2345 0x4804
        addx	65432h,65432h		; 0x1ac5 0x5090 0x47fe 0x47fc
        addx.b	65432h,65432h		; 0x1ac5 0x50d0 0x47f6 0x47f4
        addx.w	65432h,65432h		; 0x1ac5 0x5090 0x47ee 0x47ec
        addx.a	65432h,65432h		; 0x1a85 0x50d0 0x47e6 0x47e4
	addcx	r4,r7			; 0x1840 0x6407
        addcx.b	r4,r7			; 0x1840 0x6447
        addcx.w	r4,r7			; 0x1840 0x6407
	addcx.a	r4,r7			; 0x1800 0x6447
        addcx	#4,r7			; 0x1840 0x6227
        addcx.b	#4,r7			; 0x1840 0x6267
        addcx.w	#4,r7			; 0x1840 0x6227
        addcx.a	#4,r7			; 0x1800 0x6267
        addcx	#8,r7			; 0x1840 0x6237
        addcx.b	#8,r7			; 0x1840 0x6277
        addcx.w	#8,r7			; 0x1840 0x6237
        addcx.a	#8,r7			; 0x1800 0x6277
        addcx	#0,r7			; 0x1840 0x6307
        addcx.b	#0,r7			; 0x1840 0x6347
        addcx.w	#0,r7			; 0x1840 0x6307
        addcx.a	#0,r7			; 0x1800 0x6347
        addcx	#1,r7			; 0x1840 0x6317
        addcx.b	#1,r7			; 0x1840 0x6357
        addcx.w	#1,r7			; 0x1840 0x6317
        addcx.a	#1,r7			; 0x1800 0x6357
        addcx	#2,r7			; 0x1840 0x6327
        addcx.b	#2,r7			; 0x1840 0x6367
        addcx.w	#2,r7			; 0x1840 0x6327
        addcx.a	#2,r7			; 0x1800 0x6367
        addcx	#0ffffh,r7		; 0x1840 0x6337
        addcx.b	#0ffh,r7		; 0x1840 0x6377
        addcx.w	#0ffffh,r7		; 0x1840 0x6337
        addcx.a	#0fffffh,r7		; 0x1800 0x6377
        addcx	#-1,r7			; 0x1840 0x6337
        addcx.b	#-1,r7			; 0x1840 0x6377
        addcx.w	#-1,r7			; 0x1840 0x6337
        addcx.a	#-1,r7			; 0x1800 0x6377
        addcx	#100,r7			; 0x1840 0x6037 0x0064
        addcx.b	#100,r7			; 0x1840 0x6077 0x0064
        addcx.w	#100,r7			; 0x1840 0x6037 0x0064
        addcx.a	#100000,r7		; 0x1880 0x6077 0x86a0
        addcx	@r6,r7			; 0x1840 0x6627
        addcx.b	@r6,r7			; 0x1840 0x6667
        addcx.w	@r6,r7			; 0x1840 0x6627
        addcx.a	@r6,r7			; 0x1800 0x6667
        addcx	42(r6),r7		; 0x1840 0x6617 0x002a
        addcx.b	42(r6),r7		; 0x1840 0x6657 0x002a
        addcx.w	42(r6),r7		; 0x1840 0x6617 0x002a
        addcx.a	42(r6),r7		; 0x1800 0x6657 0x002a
        addcx	@r6,r7			; 0x1840 0x6627
        addcx.b	@r6,r7			; 0x1840 0x6667
        addcx.w	@r6,r7			; 0x1840 0x6627
        addcx.a	@r6,r7			; 0x1800 0x6667
        addcx	@r6+,r7			; 0x1840 0x6637
        addcx.b	@r6+,r7			; 0x1840 0x6677
        addcx.w	@r6+,r7			; 0x1840 0x6637
        addcx.a	@r6+,r7			; 0x1800 0x6677
        addcx	&12345h,r7		; 0x18c0 0x6217 0x2345
        addcx.b	&12345h,r7		; 0x18c0 0x6257 0x2345
        addcx.w	&12345h,r7		; 0x18c0 0x6217 0x2345
        addcx.a	&12345h,r7		; 0x1880 0x6257 0x2345
        addcx	65432h,r7		; 0x1ac0 0x6017 0x46e6
        addcx.b	65432h,r7		; 0x1ac0 0x6057 0x46e0
        addcx.w	65432h,r7		; 0x1ac0 0x6017 0x46da
        addcx.a	65432h,r7		; 0x1a80 0x6057 0x46d4
        addcx	r4,200(r8)		; 0x1840 0x6488 0x00c8
        addcx.b	r4,200(r8)		; 0x1840 0x64c8 0x00c8
        addcx.w	r4,200(r8)		; 0x1840 0x6488 0x00c8
        addcx.a	r4,200(r8)		; 0x1800 0x64c8 0x00c8
        addcx	#4,200(r8)		; 0x1840 0x62a8 0x00c8
        addcx.b	#4,200(r8)		; 0x1840 0x62e8 0x00c8
        addcx.w	#4,200(r8)		; 0x1840 0x62a8 0x00c8
        addcx.a	#4,200(r8)		; 0x1800 0x62e8 0x00c8
        addcx	#8,200(r8)		; 0x1840 0x62b8 0x00c8
        addcx.b	#8,200(r8)		; 0x1840 0x62f8 0x00c8
        addcx.w	#8,200(r8)		; 0x1840 0x62b8 0x00c8
        addcx.a	#8,200(r8)		; 0x1800 0x62f8 0x00c8
        addcx	#0,200(r8)		; 0x1840 0x6388 0x00c8
        addcx.b	#0,200(r8)		; 0x1840 0x63c8 0x00c8
        addcx.w	#0,200(r8)		; 0x1840 0x6388 0x00c8
        addcx.a	#0,200(r8)		; 0x1800 0x63c8 0x00c8
        addcx	#1,200(r8)		; 0x1840 0x6398 0x00c8
        addcx.b	#1,200(r8)		; 0x1840 0x63d8 0x00c8
        addcx.w	#1,200(r8)		; 0x1840 0x6398 0x00c8
        addcx.a	#1,200(r8)		; 0x1800 0x63d8 0x00c8
        addcx	#2,200(r8)		; 0x1840 0x63a8 0x00c8
        addcx.b	#2,200(r8)		; 0x1840 0x63e8 0x00c8
        addcx.w	#2,200(r8)		; 0x1840 0x63a8 0x00c8
        addcx.a	#2,200(r8)		; 0x1800 0x63e8 0x00c8
        addcx	#0ffffh,200(r8)		; 0x1840 0x63b8 0x00c8
        addcx.b	#0ffh,200(r8)		; 0x1840 0x63f8 0x00c8
        addcx.w	#0ffffh,200(r8)		; 0x1840 0x63b8 0x00c8
        addcx.a	#0fffffh,200(r8)	; 0x1800 0x63f8 0x00c8
        addcx	#-1,200(r8)		; 0x1840 0x63b8 0x00c8
        addcx.b	#-1,200(r8)		; 0x1840 0x63f8 0x00c8
        addcx.w	#-1,200(r8)		; 0x1840 0x63b8 0x00c8
        addcx.a	#-1,200(r8)		; 0x1800 0x63f8 0x00c8
        addcx	#100,200(r8)		; 0x1840 0x60b8 0x0064 0x00c8
        addcx.b	#100,200(r8)		; 0x1840 0x60f8 0x0064 0x00c8
        addcx.w	#100,200(r8)		; 0x1840 0x60b8 0x0064 0x00c8
        addcx.a	#100000,200(r8)		; 0x1880 0x60f8 0x86a0 0x00c8
        addcx	@r6,200(r8)		; 0x1840 0x66a8 0x00c8
        addcx.b	@r6,200(r8)		; 0x1840 0x66e8 0x00c8
        addcx.w	@r6,200(r8)		; 0x1840 0x66a8 0x00c8
        addcx.a	@r6,200(r8)		; 0x1800 0x66e8 0x00c8
        addcx	42(r6),200(r8)		; 0x1840 0x6698 0x002a 0x00c8
        addcx.b	42(r6),200(r8)		; 0x1840 0x66d8 0x002a 0x00c8
        addcx.w	42(r6),200(r8)		; 0x1840 0x6698 0x002a 0x00c8
        addcx.a	42(r6),200(r8)		; 0x1800 0x66d8 0x002a 0x00c8
        addcx	@r6,200(r8)		; 0x1840 0x66a8 0x00c8
        addcx.b	@r6,200(r8)		; 0x1840 0x66e8 0x00c8
        addcx.w	@r6,200(r8)		; 0x1840 0x66a8 0x00c8
        addcx.a	@r6,200(r8)		; 0x1800 0x66e8 0x00c8
        addcx	@r6+,200(r8)		; 0x1840 0x66b8 0x00c8
        addcx.b	@r6+,200(r8)		; 0x1840 0x66f8 0x00c8
        addcx.w	@r6+,200(r8)		; 0x1840 0x66b8 0x00c8
        addcx.a	@r6+,200(r8)		; 0x1800 0x66f8 0x00c8
        addcx	&12345h,200(r8)		; 0x18c0 0x6298 0x2345 0x00c8
        addcx.b	&12345h,200(r8)		; 0x18c0 0x62d8 0x2345 0x00c8
        addcx.w	&12345h,200(r8)		; 0x18c0 0x6298 0x2345 0x00c8
        addcx.a	&12345h,200(r8)		; 0x1880 0x62d8 0x2345 0x00c8
        addcx	65432h,200(r8)		; 0x1ac0 0x6098 0x4566 0x00c8
        addcx.b	65432h,200(r8)		; 0x1ac0 0x60d8 0x455e 0x00c8
        addcx.w	65432h,200(r8)		; 0x1ac0 0x6098 0x4556 0x00c8
        addcx.a	65432h,200(r8)		; 0x1ac0 0x60d8 0x454e 0x00c8
        addcx	r4,&12345h		; 0x1841 0x6482 0x2345
        addcx.b	r4,&12345h		; 0x1841 0x64c2 0x2345
        addcx.w	r4,&12345h		; 0x1841 0x6482 0x2345
        addcx.a	r4,&12345h		; 0x1801 0x64c2 0x2345
        addcx	#4,&12345h		; 0x1841 0x62a2 0x2345
        addcx.b	#4,&12345h		; 0x1841 0x62e2 0x2345
        addcx.w	#4,&12345h		; 0x1841 0x62a2 0x2345
        addcx.a	#4,&12345h		; 0x1801 0x62e2 0x2345
        addcx	#8,&12345h		; 0x1841 0x62b2 0x2345
        addcx.b	#8,&12345h		; 0x1841 0x62f2 0x2345
        addcx.w	#8,&12345h		; 0x1841 0x62b2 0x2345
        addcx.a	#8,&12345h		; 0x1801 0x62f2 0x2345
        addcx	#0,&12345h		; 0x1841 0x6382 0x2345
        addcx.b	#0,&12345h		; 0x1841 0x63c2 0x2345
        addcx.w	#0,&12345h		; 0x1841 0x6382 0x2345
        addcx.a	#0,&12345h		; 0x1801 0x63c2 0x2345
        addcx	#1,&12345h		; 0x1841 0x6392 0x2345
        addcx.b	#1,&12345h		; 0x1841 0x63d2 0x2345
        addcx.w	#1,&12345h		; 0x1841 0x6392 0x2345
        addcx.a	#1,&12345h		; 0x1801 0x63d2 0x2345
        addcx	#2,&12345h		; 0x1841 0x63a2 0x2345
        addcx.b	#2,&12345h		; 0x1841 0x63e2 0x2345
        addcx.w	#2,&12345h		; 0x1841 0x63a2 0x2345
        addcx.a	#2,&12345h		; 0x1801 0x63e2 0x2345
        addcx	#0ffffh,&12345h		; 0x1841 0x63b2 0x2345
        addcx.b	#0ffh,&12345h  		; 0x1841 0x63f2 0x2345
        addcx.w	#0ffffh,&12345h		; 0x1841 0x63b2 0x2345
        addcx.a	#0fffffh,&12345h	; 0x1801 0x63f2 0x2345
        addcx	#-1,&12345h		; 0x1841 0x63b2 0x2345
        addcx.b	#-1,&12345h		; 0x1841 0x63f2 0x2345
        addcx.w	#-1,&12345h		; 0x1841 0x63b2 0x2345
        addcx.a	#-1,&12345h		; 0x1801 0x63f2 0x2345
        addcx	#100,&12345h		; 0x1841 0x60b2 0x0064 0x2345
        addcx.b	#100,&12345h		; 0x1841 0x60f2 0x0064 0x2345
        addcx.w	#100,&12345h		; 0x1841 0x60b2 0x0064 0x2345
        addcx.a	#100000,&12345h		; 0x1881 0x60f2 0x86a0 0x2345
        addcx	@r6,&12345h		; 0x1841 0x66a2 0x2345
        addcx.b	@r6,&12345h		; 0x1841 0x66e2 0x2345
        addcx.w	@r6,&12345h		; 0x1841 0x66a2 0x2345
        addcx.a	@r6,&12345h		; 0x1801 0x66e2 0x2345
        addcx	42(r6),&12345h		; 0x1841 0x6692 0x002a 0x2345
        addcx.b	42(r6),&12345h		; 0x1841 0x66d2 0x002a 0x2345
        addcx.w	42(r6),&12345h		; 0x1841 0x6692 0x002a 0x2345
        addcx.a	42(r6),&12345h		; 0x1801 0x66d2 0x002a 0x2345
        addcx	@r6,&12345h		; 0x1841 0x66a2 0x2345
        addcx.b	@r6,&12345h		; 0x1841 0x66e2 0x2345
        addcx.w	@r6,&12345h		; 0x1841 0x66a2 0x2345
        addcx.a	@r6,&12345h		; 0x1801 0x66e2 0x2345
        addcx	@r6+,&12345h		; 0x1841 0x66b2 0x2345
        addcx.b	@r6+,&12345h		; 0x1841 0x66f2 0x2345
        addcx.w	@r6+,&12345h		; 0x1841 0x66b2 0x2345
        addcx.a	@r6+,&12345h		; 0x1801 0x66f2 0x2345
        addcx	&12345h,&12345h		; 0x18c1 0x6292 0x2345 0x2345
        addcx.b	&12345h,&12345h		; 0x18c1 0x62d2 0x2345 0x2345
        addcx.w	&12345h,&12345h		; 0x18c1 0x6292 0x2345 0x2345
        addcx.a	&12345h,&12345h		; 0x1881 0x62d2 0x2345 0x2345
        addcx	65432h,&12345h		; 0x1ac1 0x6092 0x43de 0x2345
        addcx.b	65432h,&12345h		; 0x1ac1 0x60d2 0x43d6 0x2345
        addcx.w	65432h,&12345h		; 0x1ac1 0x6092 0x43ce 0x2345
        addcx.a	65432h,&12345h		; 0x1a81 0x60d2 0x43c6 0x2345
        addcx	r4,65432h		; 0x1845 0x6480 0x43be
        addcx.b	r4,65432h		; 0x1845 0x64c0 0x43b8
        addcx.w	r4,65432h		; 0x1845 0x6480 0x43b2
        addcx.a	r4,65432h		; 0x1805 0x64c0 0x43ac
        addcx	#4,65432h		; 0x1845 0x62a0 0x43a6
        addcx.b	#4,65432h		; 0x1845 0x62e0 0x43a0
        addcx.w	#4,65432h		; 0x1845 0x62a0 0x439a
        addcx.a	#4,65432h		; 0x1805 0x62e0 0x4394
        addcx	#8,65432h		; 0x1845 0x62b0 0x438e
        addcx.b	#8,65432h		; 0x1845 0x62f0 0x4388
        addcx.w	#8,65432h		; 0x1845 0x62b0 0x4382
        addcx.a	#8,65432h		; 0x1805 0x62f0 0x437c
        addcx	#0,65432h		; 0x1845 0x6380 0x4376
        addcx.b	#0,65432h		; 0x1845 0x63c0 0x4370
        addcx.w	#0,65432h		; 0x1845 0x6380 0x436a
        addcx.a	#0,65432h		; 0x1805 0x63c0 0x4364
        addcx	#1,65432h		; 0x1845 0x6390 0x435e
        addcx.b	#1,65432h		; 0x1845 0x63d0 0x4358
        addcx.w	#1,65432h		; 0x1845 0x6390 0x4352
        addcx.a	#1,65432h		; 0x1805 0x63d0 0x434c
        addcx	#2,65432h		; 0x1845 0x63a0 0x4346
        addcx.b	#2,65432h		; 0x1845 0x63e0 0x4340
        addcx.w	#2,65432h		; 0x1845 0x63a0 0x433a
        addcx.a	#2,65432h		; 0x1805 0x63e0 0x4334
        addcx	#0ffffh,65432h		; 0x1845 0x63b0 0x432e
        addcx.b	#0ffh,65432h  		; 0x1845 0x63f0 0x4328
        addcx.w	#0ffffh,65432h		; 0x1845 0x63b0 0x4322
        addcx.a	#0fffffh,65432h		; 0x1805 0x63f0 0x431c
        addcx	#-1,65432h		; 0x1845 0x63b0 0x4316
        addcx.b	#-1,65432h		; 0x1845 0x63f0 0x4310
        addcx.w	#-1,65432h		; 0x1845 0x63b0 0x430a
        addcx.a	#-1,65432h		; 0x1805 0x63f0 0x4304
        addcx	#100,65432h		; 0x1845 0x60b0 0x0064 0x42fc
        addcx.b	#100,65432h		; 0x1845 0x60f0 0x0064 0x42f4
        addcx.w	#100,65432h		; 0x1845 0x60b0 0x0064 0x42ec
        addcx.a	#100000,65432h		; 0x1885 0x60f0 0x86a0 0x42e4
        addcx	@r6,65432h		; 0x1845 0x66a0 0x42de
        addcx.b	@r6,65432h		; 0x1845 0x66e0 0x42d8
        addcx.w	@r6,65432h		; 0x1845 0x66a0 0x42d2
        addcx.a	@r6,65432h		; 0x1805 0x66e0 0x42cc
        addcx	42(r6),65432h		; 0x1845 0x6690 0x002a 0x42c4
        addcx.b	42(r6),65432h		; 0x1845 0x66d0 0x002a 0x42bc
        addcx.w	42(r6),65432h		; 0x1845 0x6690 0x002a 0x42b4
        addcx.a	42(r6),65432h		; 0x1805 0x66d0 0x002a 0x42ac
        addcx	@r6,65432h		; 0x1845 0x66a0 0x42a6
        addcx.b	@r6,65432h		; 0x1845 0x66e0 0x42a0
        addcx.w	@r6,65432h		; 0x1845 0x66a0 0x429a
        addcx.a	@r6,65432h		; 0x1805 0x66e0 0x4294
        addcx	@r6+,65432h		; 0x1845 0x66b0 0x428e
        addcx.b	@r6+,65432h		; 0x1845 0x66f0 0x4288
        addcx.w	@r6+,65432h		; 0x1845 0x66b0 0x4282
        addcx.a	@r6+,65432h		; 0x1805 0x66f0 0x427c
        addcx	&12345h,65432h		; 0x18c5 0x6290 0x2345 0x4274
        addcx.b	&12345h,65432h		; 0x18c5 0x62d0 0x2345 0x426c
        addcx.w	&12345h,65432h		; 0x18c5 0x6290 0x2345 0x4264
        addcx.a	&12345h,65432h		; 0x1885 0x62d0 0x2345 0x425c
        addcx	65432h,65432h		; 0x1ac5 0x6090 0x4256 0x4254
        addcx.b	65432h,65432h		; 0x1ac5 0x60d0 0x424e 0x424c
        addcx.w	65432h,65432h		; 0x1ac5 0x6090 0x4246 0x4244
        addcx.a	65432h,65432h		; 0x1a85 0x60d0 0x423e 0x423c
	subx	r4,r7			; 0x1840 0x8407
        subx.b	r4,r7			; 0x1840 0x8447
        subx.w	r4,r7			; 0x1840 0x8407
	subx.a	r4,r7			; 0x1800 0x8447
        subx	#4,r7			; 0x1840 0x8227
        subx.b	#4,r7			; 0x1840 0x8267
        subx.w	#4,r7			; 0x1840 0x8227
        subx.a	#4,r7			; 0x1800 0x8267
        subx	#8,r7			; 0x1840 0x8237
        subx.b	#8,r7			; 0x1840 0x8277
        subx.w	#8,r7			; 0x1840 0x8237
        subx.a	#8,r7			; 0x1800 0x8277
        subx	#0,r7			; 0x1840 0x8307
        subx.b	#0,r7			; 0x1840 0x8347
        subx.w	#0,r7			; 0x1840 0x8307
        subx.a	#0,r7			; 0x1800 0x8347
        subx	#1,r7			; 0x1840 0x8317
        subx.b	#1,r7			; 0x1840 0x8357
        subx.w	#1,r7			; 0x1840 0x8317
        subx.a	#1,r7			; 0x1800 0x8357
        subx	#2,r7			; 0x1840 0x8327
        subx.b	#2,r7			; 0x1840 0x8367
        subx.w	#2,r7			; 0x1840 0x8327
        subx.a	#2,r7			; 0x1800 0x8367
        subx	#0ffffh,r7		; 0x1840 0x8337
        subx.b	#0ffh,r7		; 0x1840 0x8377
        subx.w	#0ffffh,r7		; 0x1840 0x8337
        subx.a	#0fffffh,r7		; 0x1800 0x8377
        subx	#-1,r7			; 0x1840 0x8337
        subx.b	#-1,r7			; 0x1840 0x8377
        subx.w	#-1,r7			; 0x1840 0x8337
        subx.a	#-1,r7			; 0x1800 0x8377
        subx	#100,r7			; 0x1840 0x8037 0x0064
        subx.b	#100,r7			; 0x1840 0x8077 0x0064
        subx.w	#100,r7			; 0x1840 0x8037 0x0064
        subx.a	#100000,r7		; 0x1880 0x8077 0x86a0
        subx	@r6,r7			; 0x1840 0x8627
        subx.b	@r6,r7			; 0x1840 0x8667
        subx.w	@r6,r7			; 0x1840 0x8627
        subx.a	@r6,r7			; 0x1800 0x8667
        subx	42(r6),r7		; 0x1840 0x8617 0x002a
        subx.b	42(r6),r7		; 0x1840 0x8657 0x002a
        subx.w	42(r6),r7		; 0x1840 0x8617 0x002a
        subx.a	42(r6),r7		; 0x1800 0x8657 0x002a
        subx	@r6,r7			; 0x1840 0x8627
        subx.b	@r6,r7			; 0x1840 0x8667
        subx.w	@r6,r7			; 0x1840 0x8627
        subx.a	@r6,r7			; 0x1800 0x8667
        subx	@r6+,r7			; 0x1840 0x8637
        subx.b	@r6+,r7			; 0x1840 0x8677
        subx.w	@r6+,r7			; 0x1840 0x8637
        subx.a	@r6+,r7			; 0x1800 0x8677
        subx	&12345h,r7		; 0x18c0 0x8217 0x2345
        subx.b	&12345h,r7		; 0x18c0 0x8257 0x2345
        subx.w	&12345h,r7		; 0x18c0 0x8217 0x2345
        subx.a	&12345h,r7		; 0x1880 0x8257 0x2345
        subx	65432h,r7		; 0x1ac0 0x8017 0x413e
        subx.b	65432h,r7		; 0x1ac0 0x8057 0x4138
        subx.w	65432h,r7		; 0x1ac0 0x8017 0x4132
        subx.a	65432h,r7		; 0x1a80 0x8057 0x412c
        subx	r4,200(r8)		; 0x1840 0x8488 0x00c8
        subx.b	r4,200(r8)		; 0x1840 0x84c8 0x00c8
        subx.w	r4,200(r8)		; 0x1840 0x8488 0x00c8
        subx.a	r4,200(r8)		; 0x1800 0x84c8 0x00c8
        subx	#4,200(r8)		; 0x1840 0x82a8 0x00c8
        subx.b	#4,200(r8)		; 0x1840 0x82e8 0x00c8
        subx.w	#4,200(r8)		; 0x1840 0x82a8 0x00c8
        subx.a	#4,200(r8)		; 0x1800 0x82e8 0x00c8
        subx	#8,200(r8)		; 0x1840 0x82b8 0x00c8
        subx.b	#8,200(r8)		; 0x1840 0x82f8 0x00c8
        subx.w	#8,200(r8)		; 0x1840 0x82b8 0x00c8
        subx.a	#8,200(r8)		; 0x1800 0x82f8 0x00c8
        subx	#0,200(r8)		; 0x1840 0x8388 0x00c8
        subx.b	#0,200(r8)		; 0x1840 0x83c8 0x00c8
        subx.w	#0,200(r8)		; 0x1840 0x8388 0x00c8
        subx.a	#0,200(r8)		; 0x1800 0x83c8 0x00c8
        subx	#1,200(r8)		; 0x1840 0x8398 0x00c8
        subx.b	#1,200(r8)		; 0x1840 0x83d8 0x00c8
        subx.w	#1,200(r8)		; 0x1840 0x8398 0x00c8
        subx.a	#1,200(r8)		; 0x1800 0x83d8 0x00c8
        subx	#2,200(r8)		; 0x1840 0x83a8 0x00c8
        subx.b	#2,200(r8)		; 0x1840 0x83e8 0x00c8
        subx.w	#2,200(r8)		; 0x1840 0x83a8 0x00c8
        subx.a	#2,200(r8)		; 0x1800 0x83e8 0x00c8
        subx	#0ffffh,200(r8)		; 0x1840 0x83b8 0x00c8
        subx.b	#0ffh,200(r8)		; 0x1840 0x83f8 0x00c8
        subx.w	#0ffffh,200(r8)		; 0x1840 0x83b8 0x00c8
        subx.a	#0fffffh,200(r8)	; 0x1800 0x83f8 0x00c8
        subx	#-1,200(r8)		; 0x1840 0x83b8 0x00c8
        subx.b	#-1,200(r8)		; 0x1840 0x83f8 0x00c8
        subx.w	#-1,200(r8)		; 0x1840 0x83b8 0x00c8
        subx.a	#-1,200(r8)		; 0x1800 0x83f8 0x00c8
        subx	#100,200(r8)		; 0x1840 0x80b8 0x0064 0x00c8
        subx.b	#100,200(r8)		; 0x1840 0x80f8 0x0064 0x00c8
        subx.w	#100,200(r8)		; 0x1840 0x80b8 0x0064 0x00c8
        subx.a	#100000,200(r8)		; 0x1880 0x80f8 0x86a0 0x00c8
        subx	@r6,200(r8)		; 0x1840 0x86a8 0x00c8
        subx.b	@r6,200(r8)		; 0x1840 0x86e8 0x00c8
        subx.w	@r6,200(r8)		; 0x1840 0x86a8 0x00c8
        subx.a	@r6,200(r8)		; 0x1800 0x86e8 0x00c8
        subx	42(r6),200(r8)		; 0x1840 0x8698 0x002a 0x00c8
        subx.b	42(r6),200(r8)		; 0x1840 0x86d8 0x002a 0x00c8
        subx.w	42(r6),200(r8)		; 0x1840 0x8698 0x002a 0x00c8
        subx.a	42(r6),200(r8)		; 0x1800 0x86d8 0x002a 0x00c8
        subx	@r6,200(r8)		; 0x1840 0x86a8 0x00c8
        subx.b	@r6,200(r8)		; 0x1840 0x86e8 0x00c8
        subx.w	@r6,200(r8)		; 0x1840 0x86a8 0x00c8
        subx.a	@r6,200(r8)		; 0x1800 0x86e8 0x00c8
        subx	@r6+,200(r8)		; 0x1840 0x86b8 0x00c8
        subx.b	@r6+,200(r8)		; 0x1840 0x86f8 0x00c8
        subx.w	@r6+,200(r8)		; 0x1840 0x86b8 0x00c8
        subx.a	@r6+,200(r8)		; 0x1800 0x86f8 0x00c8
        subx	&12345h,200(r8)		; 0x18c0 0x8298 0x2345 0x00c8
        subx.b	&12345h,200(r8)		; 0x18c0 0x82d8 0x2345 0x00c8
        subx.w	&12345h,200(r8)		; 0x18c0 0x8298 0x2345 0x00c8
        subx.a	&12345h,200(r8)		; 0x1880 0x82d8 0x2345 0x00c8
        subx	65432h,200(r8)		; 0x1ac0 0x8098 0x3fbe 0x00c8
        subx.b	65432h,200(r8)		; 0x1ac0 0x80d8 0x3fb6 0x00c8
        subx.w	65432h,200(r8)		; 0x1ac0 0x8098 0x3fae 0x00c8
        subx.a	65432h,200(r8)		; 0x1a80 0x80d8 0x3fa6 0x00c8
        subx	r4,&12345h		; 0x1841 0x8482 0x2345
        subx.b	r4,&12345h		; 0x1841 0x84c2 0x2345
        subx.w	r4,&12345h		; 0x1841 0x8482 0x2345
        subx.a	r4,&12345h		; 0x1801 0x84c2 0x2345
        subx	#4,&12345h		; 0x1841 0x82a2 0x2345
        subx.b	#4,&12345h		; 0x1841 0x82e2 0x2345
        subx.w	#4,&12345h		; 0x1841 0x82a2 0x2345
        subx.a	#4,&12345h		; 0x1801 0x82e2 0x2345
        subx	#8,&12345h		; 0x1841 0x82b2 0x2345
        subx.b	#8,&12345h		; 0x1841 0x82f2 0x2345
        subx.w	#8,&12345h		; 0x1841 0x82b2 0x2345
        subx.a	#8,&12345h		; 0x1801 0x82f2 0x2345
        subx	#0,&12345h		; 0x1841 0x8382 0x2345
        subx.b	#0,&12345h		; 0x1841 0x83c2 0x2345
        subx.w	#0,&12345h		; 0x1841 0x8382 0x2345
        subx.a	#0,&12345h		; 0x1801 0x83c2 0x2345
        subx	#1,&12345h		; 0x1841 0x8392 0x2345
        subx.b	#1,&12345h		; 0x1841 0x83d2 0x2345
        subx.w	#1,&12345h		; 0x1841 0x8392 0x2345
        subx.a	#1,&12345h		; 0x1801 0x83d2 0x2345
        subx	#2,&12345h		; 0x1841 0x83a2 0x2345
        subx.b	#2,&12345h		; 0x1841 0x83e2 0x2345
        subx.w	#2,&12345h		; 0x1841 0x83a2 0x2345
        subx.a	#2,&12345h		; 0x1801 0x83e2 0x2345
        subx	#0ffffh,&12345h		; 0x1841 0x83b2 0x2345
        subx.b	#0ffh,&12345h  		; 0x1841 0x83f2 0x2345
        subx.w	#0ffffh,&12345h		; 0x1841 0x83b2 0x2345
        subx.a	#0fffffh,&12345h	; 0x1801 0x83f2 0x2345
        subx	#-1,&12345h		; 0x1841 0x83b2 0x2345
        subx.b	#-1,&12345h		; 0x1841 0x83f2 0x2345
        subx.w	#-1,&12345h		; 0x1841 0x83b2 0x2345
        subx.a	#-1,&12345h		; 0x1801 0x83f2 0x2345
        subx	#100,&12345h		; 0x1841 0x80b2 0x0064 0x2345
        subx.b	#100,&12345h		; 0x1841 0x80f2 0x0064 0x2345
        subx.w	#100,&12345h		; 0x1841 0x80b2 0x0064 0x2345
        subx.a	#100000,&12345h		; 0x1881 0x80f2 0x86a0 0x2345
        subx	@r6,&12345h		; 0x1841 0x86a2 0x2345
        subx.b	@r6,&12345h		; 0x1841 0x86e2 0x2345
        subx.w	@r6,&12345h		; 0x1841 0x86a2 0x2345
        subx.a	@r6,&12345h		; 0x1801 0x86e2 0x2345
        subx	42(r6),&12345h		; 0x1841 0x8692 0x002a 0x2345
        subx.b	42(r6),&12345h		; 0x1841 0x86d2 0x002a 0x2345
        subx.w	42(r6),&12345h		; 0x1841 0x8692 0x002a 0x2345
        subx.a	42(r6),&12345h		; 0x1801 0x86d2 0x002a 0x2345
        subx	@r6,&12345h		; 0x1841 0x86a2 0x2345
        subx.b	@r6,&12345h		; 0x1841 0x86e2 0x2345
        subx.w	@r6,&12345h		; 0x1841 0x86a2 0x2345
        subx.a	@r6,&12345h		; 0x1801 0x86e2 0x2345
        subx	@r6+,&12345h		; 0x1841 0x86b2 0x2345
        subx.b	@r6+,&12345h		; 0x1841 0x86f2 0x2345
        subx.w	@r6+,&12345h		; 0x1841 0x86b2 0x2345
        subx.a	@r6+,&12345h		; 0x1801 0x86f2 0x2345
        subx	&12345h,&12345h		; 0x18c1 0x8292 0x2345 0x2345
        subx.b	&12345h,&12345h		; 0x18c1 0x82d2 0x2345 0x2345
        subx.w	&12345h,&12345h		; 0x18c1 0x8292 0x2345 0x2345
        subx.a	&12345h,&12345h		; 0x1881 0x82d2 0x2345 0x2345
        subx	65432h,&12345h		; 0x1ac1 0x8092 0x3e36 0x2345
        subx.b	65432h,&12345h		; 0x1ac1 0x80d2 0x3e2e 0x2345
        subx.w	65432h,&12345h		; 0x1ac1 0x8092 0x3e26 0x2345
        subx.a	65432h,&12345h		; 0x1a81 0x80d2 0x3e1e 0x2345
        subx	r4,65432h		; 0x1845 0x8480 0x3e16
        subx.b	r4,65432h		; 0x1845 0x84c0 0x3e10
        subx.w	r4,65432h		; 0x1845 0x8480 0x3e0a
        subx.a	r4,65432h		; 0x1805 0x84c0 0x3e04
        subx	#4,65432h		; 0x1845 0x82a0 0x3dfe
        subx.b	#4,65432h		; 0x1845 0x82e0 0x3df8
        subx.w	#4,65432h		; 0x1845 0x82a0 0x3df2
        subx.a	#4,65432h		; 0x1805 0x82e0 0x3dec
        subx	#8,65432h		; 0x1845 0x82b0 0x3de6
        subx.b	#8,65432h		; 0x1845 0x82f0 0x3de0
        subx.w	#8,65432h		; 0x1845 0x82b0 0x3dda
        subx.a	#8,65432h		; 0x1805 0x82f0 0x3dd4
        subx	#0,65432h		; 0x1845 0x8380 0x3dce
        subx.b	#0,65432h		; 0x1845 0x83c0 0x3dc8
        subx.w	#0,65432h		; 0x1845 0x8380 0x3dc2
        subx.a	#0,65432h		; 0x1805 0x83c0 0x3dbc
        subx	#1,65432h		; 0x1845 0x8390 0x3db6
        subx.b	#1,65432h		; 0x1845 0x83d0 0x3db0
        subx.w	#1,65432h		; 0x1845 0x8390 0x3daa
        subx.a	#1,65432h		; 0x1805 0x83d0 0x3da4
        subx	#2,65432h		; 0x1845 0x83a0 0x3d9e
        subx.b	#2,65432h		; 0x1845 0x83e0 0x3d98
        subx.w	#2,65432h		; 0x1845 0x83a0 0x3d92
        subx.a	#2,65432h		; 0x1805 0x83e0 0x3d8c
        subx	#0ffffh,65432h		; 0x1845 0x83b0 0x3d86
        subx.b	#0ffh,65432h  		; 0x1845 0x83f0 0x3d80
        subx.w	#0ffffh,65432h		; 0x1845 0x83b0 0x3d7a
        subx.a	#0fffffh,65432h		; 0x1805 0x83f0 0x3d74
        subx	#-1,65432h		; 0x1845 0x83b0 0x3d6e
        subx.b	#-1,65432h		; 0x1845 0x83f0 0x3d68
        subx.w	#-1,65432h		; 0x1845 0x83b0 0x3d62
        subx.a	#-1,65432h		; 0x1805 0x83f0 0x3d5c
        subx	#100,65432h		; 0x1845 0x80b0 0x0064 0x3d54
        subx.b	#100,65432h		; 0x1845 0x80f0 0x0064 0x3d4c
        subx.w	#100,65432h		; 0x1845 0x80b0 0x0064 0x3d44
        subx.a	#100000,65432h		; 0x1885 0x80f0 0x86a0 0x3d3c
        subx	@r6,65432h		; 0x1845 0x86a0 0x3d36
        subx.b	@r6,65432h		; 0x1845 0x86e0 0x3d30
        subx.w	@r6,65432h		; 0x1845 0x86a0 0x3d2a
        subx.a	@r6,65432h		; 0x1805 0x86e0 0x3d24
        subx	42(r6),65432h		; 0x1845 0x8690 0x002a 0x3d1c
        subx.b	42(r6),65432h		; 0x1845 0x86d0 0x002a 0x3d14
        subx.w	42(r6),65432h		; 0x1845 0x8690 0x002a 0x3d0c
        subx.a	42(r6),65432h		; 0x1805 0x86d0 0x002a 0x3d04
        subx	@r6,65432h		; 0x1845 0x86a0 0x3cfe
        subx.b	@r6,65432h		; 0x1845 0x86e0 0x3cf8
        subx.w	@r6,65432h		; 0x1845 0x86a0 0x3cf2
        subx.a	@r6,65432h		; 0x1805 0x86e0 0x3cec
        subx	@r6+,65432h		; 0x1845 0x86b0 0x3ce6
        subx.b	@r6+,65432h		; 0x1845 0x86f0 0x3ce0
        subx.w	@r6+,65432h		; 0x1845 0x86b0 0x3cda
        subx.a	@r6+,65432h		; 0x1805 0x86f0 0x3cd4
        subx	&12345h,65432h		; 0x18c5 0x8290 0x2345 0x3ccc
        subx.b	&12345h,65432h		; 0x18c5 0x82d0 0x2345 0x3cc4
        subx.w	&12345h,65432h		; 0x18c5 0x8290 0x2345 0x3cbc
        subx.a	&12345h,65432h		; 0x1885 0x82d0 0x2345 0x3cb4
        subx	65432h,65432h		; 0x1ac5 0x8090 0x3cae 0x3cac
        subx.b	65432h,65432h		; 0x1ac5 0x80d0 0x3ca6 0x3ca4
        subx.w	65432h,65432h		; 0x1ac5 0x8090 0x3c9e 0x3c9c
        subx.a	65432h,65432h		; 0x1a85 0x80d0 0x3c96 0x3c94
	subcx	r4,r7			; 0x1840 0x7407
        subcx.b	r4,r7			; 0x1840 0x7447
        subcx.w	r4,r7			; 0x1840 0x7407
	subcx.a	r4,r7			; 0x1800 0x7447
        subcx	#4,r7			; 0x1840 0x7227
        subcx.b	#4,r7			; 0x1840 0x7267
        subcx.w	#4,r7			; 0x1840 0x7227
        subcx.a	#4,r7			; 0x1800 0x7267
        subcx	#8,r7			; 0x1840 0x7237
        subcx.b	#8,r7			; 0x1840 0x7277
        subcx.w	#8,r7			; 0x1840 0x7237
        subcx.a	#8,r7			; 0x1800 0x7277
        subcx	#0,r7			; 0x1840 0x7307
        subcx.b	#0,r7			; 0x1840 0x7347
        subcx.w	#0,r7			; 0x1840 0x7307
        subcx.a	#0,r7			; 0x1800 0x7347
        subcx	#1,r7			; 0x1840 0x7317
        subcx.b	#1,r7			; 0x1840 0x7357
        subcx.w	#1,r7			; 0x1840 0x7317
        subcx.a	#1,r7			; 0x1800 0x7357
        subcx	#2,r7			; 0x1840 0x7327
        subcx.b	#2,r7			; 0x1840 0x7367
        subcx.w	#2,r7			; 0x1840 0x7327
        subcx.a	#2,r7			; 0x1800 0x7367
        subcx	#0ffffh,r7		; 0x1840 0x7337
        subcx.b	#0ffh,r7		; 0x1840 0x7377
        subcx.w	#0ffffh,r7		; 0x1840 0x7337
        subcx.a	#0fffffh,r7		; 0x1800 0x7377
        subcx	#-1,r7			; 0x1840 0x7337
        subcx.b	#-1,r7			; 0x1840 0x7377
        subcx.w	#-1,r7			; 0x1840 0x7337
        subcx.a	#-1,r7			; 0x1800 0x7377
        subcx	#100,r7			; 0x1840 0x7037 0x0064
        subcx.b	#100,r7			; 0x1840 0x7077 0x0064
        subcx.w	#100,r7			; 0x1840 0x7037 0x0064
        subcx.a	#100000,r7		; 0x1880 0x7077 0x86a0
        subcx	@r6,r7			; 0x1840 0x7627
        subcx.b	@r6,r7			; 0x1840 0x7667
        subcx.w	@r6,r7			; 0x1840 0x7627
        subcx.a	@r6,r7			; 0x1800 0x7667
        subcx	42(r6),r7		; 0x1840 0x7617 0x002a
        subcx.b	42(r6),r7		; 0x1840 0x7657 0x002a
        subcx.w	42(r6),r7		; 0x1840 0x7617 0x002a
        subcx.a	42(r6),r7		; 0x1800 0x7657 0x002a
        subcx	@r6,r7			; 0x1840 0x7627
        subcx.b	@r6,r7			; 0x1840 0x7667
        subcx.w	@r6,r7			; 0x1840 0x7627
        subcx.a	@r6,r7			; 0x1800 0x7667
        subcx	@r6+,r7			; 0x1840 0x7637
        subcx.b	@r6+,r7			; 0x1840 0x7677
        subcx.w	@r6+,r7			; 0x1840 0x7637
        subcx.a	@r6+,r7			; 0x1800 0x7677
        subcx	&12345h,r7		; 0x18c0 0x7217 0x2345
        subcx.b	&12345h,r7		; 0x18c0 0x7257 0x2345
        subcx.w	&12345h,r7		; 0x18c0 0x7217 0x2345
        subcx.a	&12345h,r7		; 0x1880 0x7257 0x2345
        subcx	65432h,r7		; 0x1ac0 0x7017 0x3b96
        subcx.b	65432h,r7		; 0x1ac0 0x7057 0x3b90
        subcx.w	65432h,r7		; 0x1ac0 0x7017 0x3b8a
        subcx.a	65432h,r7		; 0x1a80 0x7057 0x3b84
        subcx	r4,200(r8)		; 0x1840 0x7488 0x00c8
        subcx.b	r4,200(r8)		; 0x1840 0x74c8 0x00c8
        subcx.w	r4,200(r8)		; 0x1840 0x7488 0x00c8
        subcx.a	r4,200(r8)		; 0x1800 0x74c8 0x00c8
        subcx	#4,200(r8)		; 0x1840 0x72a8 0x00c8
        subcx.b	#4,200(r8)		; 0x1840 0x72e8 0x00c8
        subcx.w	#4,200(r8)		; 0x1840 0x72a8 0x00c8
        subcx.a	#4,200(r8)		; 0x1800 0x72e8 0x00c8
        subcx	#8,200(r8)		; 0x1840 0x72b8 0x00c8
        subcx.b	#8,200(r8)		; 0x1840 0x72f8 0x00c8
        subcx.w	#8,200(r8)		; 0x1840 0x72b8 0x00c8
        subcx.a	#8,200(r8)		; 0x1800 0x72f8 0x00c8
        subcx	#0,200(r8)		; 0x1840 0x7388 0x00c8
        subcx.b	#0,200(r8)		; 0x1840 0x73c8 0x00c8
        subcx.w	#0,200(r8)		; 0x1840 0x7388 0x00c8
        subcx.a	#0,200(r8)		; 0x1800 0x73c8 0x00c8
        subcx	#1,200(r8)		; 0x1840 0x7398 0x00c8
        subcx.b	#1,200(r8)		; 0x1840 0x73d8 0x00c8
        subcx.w	#1,200(r8)		; 0x1840 0x7398 0x00c8
        subcx.a	#1,200(r8)		; 0x1800 0x73d8 0x00c8
        subcx	#2,200(r8)		; 0x1840 0x73a8 0x00c8
        subcx.b	#2,200(r8)		; 0x1840 0x73e8 0x00c8
        subcx.w	#2,200(r8)		; 0x1840 0x73a8 0x00c8
        subcx.a	#2,200(r8)		; 0x1800 0x73e8 0x00c8
        subcx	#0ffffh,200(r8)		; 0x1840 0x73b8 0x00c8
        subcx.b	#0ffh,200(r8)		; 0x1840 0x73f8 0x00c8
        subcx.w	#0ffffh,200(r8)		; 0x1840 0x73b8 0x00c8
        subcx.a	#0fffffh,200(r8)	; 0x1800 0x73f8 0x00c8
        subcx	#-1,200(r8)		; 0x1840 0x73b8 0x00c8
        subcx.b	#-1,200(r8)		; 0x1840 0x73f8 0x00c8
        subcx.w	#-1,200(r8)		; 0x1840 0x73b8 0x00c8
        subcx.a	#-1,200(r8)		; 0x1800 0x73f8 0x00c8
        subcx	#100,200(r8)		; 0x1840 0x70b8 0x0064 0x00c8
        subcx.b	#100,200(r8)		; 0x1840 0x70f8 0x0064 0x00c8
        subcx.w	#100,200(r8)		; 0x1840 0x70b8 0x0064 0x00c8
        subcx.a	#100000,200(r8)		; 0x1880 0x70f8 0x86a0 0x00c8
        subcx	@r6,200(r8)		; 0x1840 0x76a8 0x00c8
        subcx.b	@r6,200(r8)		; 0x1840 0x76e8 0x00c8
        subcx.w	@r6,200(r8)		; 0x1840 0x76a8 0x00c8
        subcx.a	@r6,200(r8)		; 0x1800 0x76e8 0x00c8
        subcx	42(r6),200(r8)		; 0x1840 0x7698 0x002a 0x00c8
        subcx.b	42(r6),200(r8)		; 0x1840 0x76d8 0x002a 0x00c8
        subcx.w	42(r6),200(r8)		; 0x1840 0x7698 0x002a 0x00c8
        subcx.a	42(r6),200(r8)		; 0x1800 0x76d8 0x002a 0x00c8
        subcx	@r6,200(r8)		; 0x1840 0x76a8 0x00c8
        subcx.b	@r6,200(r8)		; 0x1840 0x76e8 0x00c8
        subcx.w	@r6,200(r8)		; 0x1840 0x76a8 0x00c8
        subcx.a	@r6,200(r8)		; 0x1800 0x76e8 0x00c8
        subcx	@r6+,200(r8)		; 0x1840 0x76b8 0x00c8
        subcx.b	@r6+,200(r8)		; 0x1840 0x76f8 0x00c8
        subcx.w	@r6+,200(r8)		; 0x1840 0x76b8 0x00c8
        subcx.a	@r6+,200(r8)		; 0x1800 0x76f8 0x00c8
        subcx	&12345h,200(r8)		; 0x18c0 0x7298 0x2345 0x00c8
        subcx.b	&12345h,200(r8)		; 0x18c0 0x72d8 0x2345 0x00c8
        subcx.w	&12345h,200(r8)		; 0x18c0 0x7298 0x2345 0x00c8
        subcx.a	&12345h,200(r8)		; 0x1880 0x72d8 0x2345 0x00c8
        subcx	65432h,200(r8)		; 0x1ac0 0x7098 0x3a16 0x00c8
        subcx.b	65432h,200(r8)		; 0x1ac0 0x70d8 0x3a0e 0x00c8
        subcx.w	65432h,200(r8)		; 0x1ac0 0x7098 0x3a06 0x00c8
        subcx.a	65432h,200(r8)		; 0x1ac0 0x70d8 0x39fe 0x00c8
        subcx	r4,&12345h		; 0x1841 0x7482 0x2345
        subcx.b	r4,&12345h		; 0x1841 0x74c2 0x2345
        subcx.w	r4,&12345h		; 0x1841 0x7482 0x2345
        subcx.a	r4,&12345h		; 0x1801 0x74c2 0x2345
        subcx	#4,&12345h		; 0x1841 0x72a2 0x2345
        subcx.b	#4,&12345h		; 0x1841 0x72e2 0x2345
        subcx.w	#4,&12345h		; 0x1841 0x72a2 0x2345
        subcx.a	#4,&12345h		; 0x1801 0x72e2 0x2345
        subcx	#8,&12345h		; 0x1841 0x72b2 0x2345
        subcx.b	#8,&12345h		; 0x1841 0x72f2 0x2345
        subcx.w	#8,&12345h		; 0x1841 0x72b2 0x2345
        subcx.a	#8,&12345h		; 0x1801 0x72f2 0x2345
        subcx	#0,&12345h		; 0x1841 0x7382 0x2345
        subcx.b	#0,&12345h		; 0x1841 0x73c2 0x2345
        subcx.w	#0,&12345h		; 0x1841 0x7382 0x2345
        subcx.a	#0,&12345h		; 0x1801 0x73c2 0x2345
        subcx	#1,&12345h		; 0x1841 0x7392 0x2345
        subcx.b	#1,&12345h		; 0x1841 0x73d2 0x2345
        subcx.w	#1,&12345h		; 0x1841 0x7392 0x2345
        subcx.a	#1,&12345h		; 0x1801 0x73d2 0x2345
        subcx	#2,&12345h		; 0x1841 0x73a2 0x2345
        subcx.b	#2,&12345h		; 0x1841 0x73e2 0x2345
        subcx.w	#2,&12345h		; 0x1841 0x73a2 0x2345
        subcx.a	#2,&12345h		; 0x1801 0x73e2 0x2345
        subcx	#0ffffh,&12345h		; 0x1841 0x73b2 0x2345
        subcx.b	#0ffh,&12345h  		; 0x1841 0x73f2 0x2345
        subcx.w	#0ffffh,&12345h		; 0x1841 0x73b2 0x2345
        subcx.a	#0fffffh,&12345h	; 0x1801 0x73f2 0x2345
        subcx	#-1,&12345h		; 0x1841 0x73b2 0x2345
        subcx.b	#-1,&12345h		; 0x1841 0x73f2 0x2345
        subcx.w	#-1,&12345h		; 0x1841 0x73b2 0x2345
        subcx.a	#-1,&12345h		; 0x1801 0x73f2 0x2345
        subcx	#100,&12345h		; 0x1841 0x70b2 0x0064 0x2345
        subcx.b	#100,&12345h		; 0x1841 0x70f2 0x0064 0x2345
        subcx.w	#100,&12345h		; 0x1841 0x70b2 0x0064 0x2345
        subcx.a	#100000,&12345h		; 0x1881 0x70f2 0x86a0 0x2345
        subcx	@r6,&12345h		; 0x1841 0x76a2 0x2345
        subcx.b	@r6,&12345h		; 0x1841 0x76e2 0x2345
        subcx.w	@r6,&12345h		; 0x1841 0x76a2 0x2345
        subcx.a	@r6,&12345h		; 0x1801 0x76e2 0x2345
        subcx	42(r6),&12345h		; 0x1841 0x7692 0x002a 0x2345
        subcx.b	42(r6),&12345h		; 0x1841 0x76d2 0x002a 0x2345
        subcx.w	42(r6),&12345h		; 0x1841 0x7692 0x002a 0x2345
        subcx.a	42(r6),&12345h		; 0x1801 0x76d2 0x002a 0x2345
        subcx	@r6,&12345h		; 0x1841 0x76a2 0x2345
        subcx.b	@r6,&12345h		; 0x1841 0x76e2 0x2345
        subcx.w	@r6,&12345h		; 0x1841 0x76a2 0x2345
        subcx.a	@r6,&12345h		; 0x1801 0x76e2 0x2345
        subcx	@r6+,&12345h		; 0x1841 0x76b2 0x2345
        subcx.b	@r6+,&12345h		; 0x1841 0x76f2 0x2345
        subcx.w	@r6+,&12345h		; 0x1841 0x76b2 0x2345
        subcx.a	@r6+,&12345h		; 0x1801 0x76f2 0x2345
        subcx	&12345h,&12345h		; 0x18c1 0x7292 0x2345 0x2345
        subcx.b	&12345h,&12345h		; 0x18c1 0x72d2 0x2345 0x2345
        subcx.w	&12345h,&12345h		; 0x18c1 0x7292 0x2345 0x2345
        subcx.a	&12345h,&12345h		; 0x1881 0x72d2 0x2345 0x2345
        subcx	65432h,&12345h		; 0x1ac1 0x7092 0x388e 0x2345
        subcx.b	65432h,&12345h		; 0x1ac1 0x70d2 0x3886 0x2345
        subcx.w	65432h,&12345h		; 0x1ac1 0x7092 0x387e 0x2345
        subcx.a	65432h,&12345h		; 0x1a81 0x70d2 0x3876 0x2345
        subcx	r4,65432h		; 0x1845 0x7480 0x386e
        subcx.b	r4,65432h		; 0x1845 0x74c0 0x3868
        subcx.w	r4,65432h		; 0x1845 0x7480 0x3862
        subcx.a	r4,65432h		; 0x1805 0x74c0 0x385c
        subcx	#4,65432h		; 0x1845 0x72a0 0x3856
        subcx.b	#4,65432h		; 0x1845 0x72e0 0x3850
        subcx.w	#4,65432h		; 0x1845 0x72a0 0x384a
        subcx.a	#4,65432h		; 0x1805 0x72e0 0x3844
        subcx	#8,65432h		; 0x1845 0x72b0 0x383e
        subcx.b	#8,65432h		; 0x1845 0x72f0 0x3838
        subcx.w	#8,65432h		; 0x1845 0x72b0 0x3832
        subcx.a	#8,65432h		; 0x1805 0x72f0 0x382c
        subcx	#0,65432h		; 0x1845 0x7380 0x3826
        subcx.b	#0,65432h		; 0x1845 0x73c0 0x3820
        subcx.w	#0,65432h		; 0x1845 0x7380 0x381a
        subcx.a	#0,65432h		; 0x1805 0x73c0 0x3814
        subcx	#1,65432h		; 0x1845 0x7390 0x380e
        subcx.b	#1,65432h		; 0x1845 0x73d0 0x3808
        subcx.w	#1,65432h		; 0x1845 0x7390 0x3802
        subcx.a	#1,65432h		; 0x1805 0x73d0 0x37fc
        subcx	#2,65432h		; 0x1845 0x73a0 0x37f6
        subcx.b	#2,65432h		; 0x1845 0x73e0 0x37f0
        subcx.w	#2,65432h		; 0x1845 0x73a0 0x37ea
        subcx.a	#2,65432h		; 0x1805 0x73e0 0x37e4
        subcx	#0ffffh,65432h		; 0x1845 0x73b0 0x37de
        subcx.b	#0ffh,65432h  		; 0x1845 0x73f0 0x37d8
        subcx.w	#0ffffh,65432h		; 0x1845 0x73b0 0x37d2
        subcx.a	#0fffffh,65432h		; 0x1805 0x73f0 0x37cc
        subcx	#-1,65432h		; 0x1845 0x73b0 0x37c6
        subcx.b	#-1,65432h		; 0x1845 0x73f0 0x37c0
        subcx.w	#-1,65432h		; 0x1845 0x73b0 0x37ba
        subcx.a	#-1,65432h		; 0x1805 0x73f0 0x37b4
        subcx	#100,65432h		; 0x1845 0x70b0 0x0064 0x37ac
        subcx.b	#100,65432h		; 0x1845 0x70f0 0x0064 0x37a4
        subcx.w	#100,65432h		; 0x1845 0x70b0 0x0064 0x379c
        subcx.a	#100000,65432h		; 0x1885 0x70f0 0x86a0 0x3794
        subcx	@r6,65432h		; 0x1845 0x76a0 0x378e
        subcx.b	@r6,65432h		; 0x1845 0x76e0 0x3788
        subcx.w	@r6,65432h		; 0x1845 0x76a0 0x3782
        subcx.a	@r6,65432h		; 0x1805 0x76e0 0x377c
        subcx	42(r6),65432h		; 0x1845 0x7690 0x002a 0x3774
        subcx.b	42(r6),65432h		; 0x1845 0x76d0 0x002a 0x376c
        subcx.w	42(r6),65432h		; 0x1845 0x7690 0x002a 0x3764
        subcx.a	42(r6),65432h		; 0x1805 0x76d0 0x002a 0x375c
        subcx	@r6,65432h		; 0x1845 0x76a0 0x3756
        subcx.b	@r6,65432h		; 0x1845 0x76e0 0x3750
        subcx.w	@r6,65432h		; 0x1845 0x76a0 0x374a
        subcx.a	@r6,65432h		; 0x1805 0x76e0 0x3744
        subcx	@r6+,65432h		; 0x1845 0x76b0 0x373e
        subcx.b	@r6+,65432h		; 0x1845 0x76f0 0x3738
        subcx.w	@r6+,65432h		; 0x1845 0x76b0 0x3732
        subcx.a	@r6+,65432h		; 0x1805 0x76f0 0x372c
        subcx	&12345h,65432h		; 0x18c5 0x7290 0x2345 0x3724
        subcx.b	&12345h,65432h		; 0x18c5 0x72d0 0x2345 0x371c
        subcx.w	&12345h,65432h		; 0x18c5 0x7290 0x2345 0x3714
        subcx.a	&12345h,65432h		; 0x1885 0x72d0 0x2345 0x370c
        subcx	65432h,65432h		; 0x1ac5 0x7090 0x3706 0x3704
        subcx.b	65432h,65432h		; 0x1ac5 0x70d0 0x36fe 0x36fc
        subcx.w	65432h,65432h		; 0x1ac5 0x7090 0x36f6 0x36f4
        subcx.a	65432h,65432h		; 0x1a85 0x70d0 0x36ee 0x36ec
	cmpx	r4,r7			; 0x1840 0x9407
        cmpx.b	r4,r7			; 0x1840 0x9447
        cmpx.w	r4,r7			; 0x1840 0x9407
	cmpx.a	r4,r7			; 0x1800 0x9447
        cmpx	#4,r7			; 0x1840 0x9227
        cmpx.b	#4,r7			; 0x1840 0x9267
        cmpx.w	#4,r7			; 0x1840 0x9227
        cmpx.a	#4,r7			; 0x1800 0x9267
        cmpx	#8,r7			; 0x1840 0x9237
        cmpx.b	#8,r7			; 0x1840 0x9277
        cmpx.w	#8,r7			; 0x1840 0x9237
        cmpx.a	#8,r7			; 0x1800 0x9277
        cmpx	#0,r7			; 0x1840 0x9307
        cmpx.b	#0,r7			; 0x1840 0x9347
        cmpx.w	#0,r7			; 0x1840 0x9307
        cmpx.a	#0,r7			; 0x1800 0x9347
        cmpx	#1,r7			; 0x1840 0x9317
        cmpx.b	#1,r7			; 0x1840 0x9357
        cmpx.w	#1,r7			; 0x1840 0x9317
        cmpx.a	#1,r7			; 0x1800 0x9357
        cmpx	#2,r7			; 0x1840 0x9327
        cmpx.b	#2,r7			; 0x1840 0x9367
        cmpx.w	#2,r7			; 0x1840 0x9327
        cmpx.a	#2,r7			; 0x1800 0x9367
        cmpx	#0ffffh,r7		; 0x1840 0x9337
        cmpx.b	#0ffh,r7		; 0x1840 0x9377
        cmpx.w	#0ffffh,r7		; 0x1840 0x9337
        cmpx.a	#0fffffh,r7		; 0x1800 0x9377
        cmpx	#-1,r7			; 0x1840 0x9337
        cmpx.b	#-1,r7			; 0x1840 0x9377
        cmpx.w	#-1,r7			; 0x1840 0x9337
        cmpx.a	#-1,r7			; 0x1800 0x9377
        cmpx	#100,r7			; 0x1840 0x9037 0x0064
        cmpx.b	#100,r7			; 0x1840 0x9077 0x0064
        cmpx.w	#100,r7			; 0x1840 0x9037 0x0064
        cmpx.a	#100000,r7		; 0x1880 0x9077 0x86a0
        cmpx	@r6,r7			; 0x1840 0x9627
        cmpx.b	@r6,r7			; 0x1840 0x9667
        cmpx.w	@r6,r7			; 0x1840 0x9627
        cmpx.a	@r6,r7			; 0x1800 0x9667
        cmpx	42(r6),r7		; 0x1840 0x9617 0x002a
        cmpx.b	42(r6),r7		; 0x1840 0x9657 0x002a
        cmpx.w	42(r6),r7		; 0x1840 0x9617 0x002a
        cmpx.a	42(r6),r7		; 0x1800 0x9657 0x002a
        cmpx	@r6,r7			; 0x1840 0x9627
        cmpx.b	@r6,r7			; 0x1840 0x9667
        cmpx.w	@r6,r7			; 0x1840 0x9627
        cmpx.a	@r6,r7			; 0x1800 0x9667
        cmpx	@r6+,r7			; 0x1840 0x9637
        cmpx.b	@r6+,r7			; 0x1840 0x9677
        cmpx.w	@r6+,r7			; 0x1840 0x9637
        cmpx.a	@r6+,r7			; 0x1800 0x9677
        cmpx	&12345h,r7		; 0x18c0 0x9217 0x2345
        cmpx.b	&12345h,r7		; 0x18c0 0x9257 0x2345
        cmpx.w	&12345h,r7		; 0x18c0 0x9217 0x2345
        cmpx.a	&12345h,r7		; 0x1880 0x9257 0x2345
        cmpx	65432h,r7		; 0x1ac0 0x9017 0x35ee
        cmpx.b	65432h,r7		; 0x1ac0 0x9057 0x35e8
        cmpx.w	65432h,r7		; 0x1ac0 0x9017 0x35e2
        cmpx.a	65432h,r7		; 0x1a80 0x9057 0x35dc
        cmpx	r4,200(r8)		; 0x1840 0x9488 0x00c8
        cmpx.b	r4,200(r8)		; 0x1840 0x94c8 0x00c8
        cmpx.w	r4,200(r8)		; 0x1840 0x9488 0x00c8
        cmpx.a	r4,200(r8)		; 0x1800 0x94c8 0x00c8
        cmpx	#4,200(r8)		; 0x1840 0x92a8 0x00c8
        cmpx.b	#4,200(r8)		; 0x1840 0x92e8 0x00c8
        cmpx.w	#4,200(r8)		; 0x1840 0x92a8 0x00c8
        cmpx.a	#4,200(r8)		; 0x1800 0x92e8 0x00c8
        cmpx	#8,200(r8)		; 0x1840 0x92b8 0x00c8
        cmpx.b	#8,200(r8)		; 0x1840 0x92f8 0x00c8
        cmpx.w	#8,200(r8)		; 0x1840 0x92b8 0x00c8
        cmpx.a	#8,200(r8)		; 0x1800 0x92f8 0x00c8
        cmpx	#0,200(r8)		; 0x1840 0x9388 0x00c8
        cmpx.b	#0,200(r8)		; 0x1840 0x93c8 0x00c8
        cmpx.w	#0,200(r8)		; 0x1840 0x9388 0x00c8
        cmpx.a	#0,200(r8)		; 0x1800 0x93c8 0x00c8
        cmpx	#1,200(r8)		; 0x1840 0x9398 0x00c8
        cmpx.b	#1,200(r8)		; 0x1840 0x93d8 0x00c8
        cmpx.w	#1,200(r8)		; 0x1840 0x9398 0x00c8
        cmpx.a	#1,200(r8)		; 0x1800 0x93d8 0x00c8
        cmpx	#2,200(r8)		; 0x1840 0x93a8 0x00c8
        cmpx.b	#2,200(r8)		; 0x1840 0x93e8 0x00c8
        cmpx.w	#2,200(r8)		; 0x1840 0x93a8 0x00c8
        cmpx.a	#2,200(r8)		; 0x1800 0x93e8 0x00c8
        cmpx	#0ffffh,200(r8)		; 0x1840 0x93b8 0x00c8
        cmpx.b	#0ffh,200(r8)		; 0x1840 0x93f8 0x00c8
        cmpx.w	#0ffffh,200(r8)		; 0x1840 0x93b8 0x00c8
        cmpx.a	#0fffffh,200(r8)	; 0x1800 0x93f8 0x00c8
        cmpx	#-1,200(r8)		; 0x1840 0x93b8 0x00c8
        cmpx.b	#-1,200(r8)		; 0x1840 0x93f8 0x00c8
        cmpx.w	#-1,200(r8)		; 0x1840 0x93b8 0x00c8
        cmpx.a	#-1,200(r8)		; 0x1800 0x93f8 0x00c8
        cmpx	#100,200(r8)		; 0x1840 0x90b8 0x0064 0x00c8
        cmpx.b	#100,200(r8)		; 0x1840 0x90f8 0x0064 0x00c8
        cmpx.w	#100,200(r8)		; 0x1840 0x90b8 0x0064 0x00c8
        cmpx.a	#100000,200(r8)		; 0x1880 0x90f8 0x86a0 0x00c8
        cmpx	@r6,200(r8)		; 0x1840 0x96a8 0x00c8
        cmpx.b	@r6,200(r8)		; 0x1840 0x96e8 0x00c8
        cmpx.w	@r6,200(r8)		; 0x1840 0x96a8 0x00c8
        cmpx.a	@r6,200(r8)		; 0x1800 0x96e8 0x00c8
        cmpx	42(r6),200(r8)		; 0x1840 0x9698 0x002a 0x00c8
        cmpx.b	42(r6),200(r8)		; 0x1840 0x96d8 0x002a 0x00c8
        cmpx.w	42(r6),200(r8)		; 0x1840 0x9698 0x002a 0x00c8
        cmpx.a	42(r6),200(r8)		; 0x1800 0x96d8 0x002a 0x00c8
        cmpx	@r6,200(r8)		; 0x1840 0x96a8 0x00c8
        cmpx.b	@r6,200(r8)		; 0x1840 0x96e8 0x00c8
        cmpx.w	@r6,200(r8)		; 0x1840 0x96a8 0x00c8
        cmpx.a	@r6,200(r8)		; 0x1800 0x96e8 0x00c8
        cmpx	@r6+,200(r8)		; 0x1840 0x96b8 0x00c8
        cmpx.b	@r6+,200(r8)		; 0x1840 0x96f8 0x00c8
        cmpx.w	@r6+,200(r8)		; 0x1840 0x96b8 0x00c8
        cmpx.a	@r6+,200(r8)		; 0x1800 0x96f8 0x00c8
        cmpx	&12345h,200(r8)		; 0x18c0 0x9298 0x2345 0x00c8
        cmpx.b	&12345h,200(r8)		; 0x18c0 0x92d8 0x2345 0x00c8
        cmpx.w	&12345h,200(r8)		; 0x18c0 0x9298 0x2345 0x00c8
        cmpx.a	&12345h,200(r8)		; 0x1880 0x92d8 0x2345 0x00c8
        cmpx	65432h,200(r8)		; 0x1ac0 0x9098 0x346e 0x00c8
        cmpx.b	65432h,200(r8)		; 0x1ac0 0x90d8 0x3466 0x00c8
        cmpx.w	65432h,200(r8)		; 0x1ac0 0x9098 0x345e 0x00c8
        cmpx.a	65432h,200(r8)		; 0x1a80 0x90d8 0x3456 0x00c8
        cmpx	r4,&12345h		; 0x1841 0x9482 0x2345
        cmpx.b	r4,&12345h		; 0x1841 0x94c2 0x2345
        cmpx.w	r4,&12345h		; 0x1841 0x9482 0x2345
        cmpx.a	r4,&12345h		; 0x1801 0x94c2 0x2345
        cmpx	#4,&12345h		; 0x1841 0x92a2 0x2345
        cmpx.b	#4,&12345h		; 0x1841 0x92e2 0x2345
        cmpx.w	#4,&12345h		; 0x1841 0x92a2 0x2345
        cmpx.a	#4,&12345h		; 0x1801 0x92e2 0x2345
        cmpx	#8,&12345h		; 0x1841 0x92b2 0x2345
        cmpx.b	#8,&12345h		; 0x1841 0x92f2 0x2345
        cmpx.w	#8,&12345h		; 0x1841 0x92b2 0x2345
        cmpx.a	#8,&12345h		; 0x1801 0x92f2 0x2345
        cmpx	#0,&12345h		; 0x1841 0x9382 0x2345
        cmpx.b	#0,&12345h		; 0x1841 0x93c2 0x2345
        cmpx.w	#0,&12345h		; 0x1841 0x9382 0x2345
        cmpx.a	#0,&12345h		; 0x1801 0x93c2 0x2345
        cmpx	#1,&12345h		; 0x1841 0x9392 0x2345
        cmpx.b	#1,&12345h		; 0x1841 0x93d2 0x2345
        cmpx.w	#1,&12345h		; 0x1841 0x9392 0x2345
        cmpx.a	#1,&12345h		; 0x1801 0x93d2 0x2345
        cmpx	#2,&12345h		; 0x1841 0x93a2 0x2345
        cmpx.b	#2,&12345h		; 0x1841 0x93e2 0x2345
        cmpx.w	#2,&12345h		; 0x1841 0x93a2 0x2345
        cmpx.a	#2,&12345h		; 0x1801 0x93e2 0x2345
        cmpx	#0ffffh,&12345h		; 0x1841 0x93b2 0x2345
        cmpx.b	#0ffh,&12345h  		; 0x1841 0x93f2 0x2345
        cmpx.w	#0ffffh,&12345h		; 0x1841 0x93b2 0x2345
        cmpx.a	#0fffffh,&12345h	; 0x1801 0x93f2 0x2345
        cmpx	#-1,&12345h		; 0x1841 0x93b2 0x2345
        cmpx.b	#-1,&12345h		; 0x1841 0x93f2 0x2345
        cmpx.w	#-1,&12345h		; 0x1841 0x93b2 0x2345
        cmpx.a	#-1,&12345h		; 0x1801 0x93f2 0x2345
        cmpx	#100,&12345h		; 0x1841 0x90b2 0x0064 0x2345
        cmpx.b	#100,&12345h		; 0x1841 0x90f2 0x0064 0x2345
        cmpx.w	#100,&12345h		; 0x1841 0x90b2 0x0064 0x2345
        cmpx.a	#100000,&12345h		; 0x1881 0x90f2 0x86a0 0x2345
        cmpx	@r6,&12345h		; 0x1841 0x96a2 0x2345
        cmpx.b	@r6,&12345h		; 0x1841 0x96e2 0x2345
        cmpx.w	@r6,&12345h		; 0x1841 0x96a2 0x2345
        cmpx.a	@r6,&12345h		; 0x1801 0x96e2 0x2345
        cmpx	42(r6),&12345h		; 0x1841 0x9692 0x002a 0x2345
        cmpx.b	42(r6),&12345h		; 0x1841 0x96d2 0x002a 0x2345
        cmpx.w	42(r6),&12345h		; 0x1841 0x9692 0x002a 0x2345
        cmpx.a	42(r6),&12345h		; 0x1801 0x96d2 0x002a 0x2345
        cmpx	@r6,&12345h		; 0x1841 0x96a2 0x2345
        cmpx.b	@r6,&12345h		; 0x1841 0x96e2 0x2345
        cmpx.w	@r6,&12345h		; 0x1841 0x96a2 0x2345
        cmpx.a	@r6,&12345h		; 0x1801 0x96e2 0x2345
        cmpx	@r6+,&12345h		; 0x1841 0x96b2 0x2345
        cmpx.b	@r6+,&12345h		; 0x1841 0x96f2 0x2345
        cmpx.w	@r6+,&12345h		; 0x1841 0x96b2 0x2345
        cmpx.a	@r6+,&12345h		; 0x1801 0x96f2 0x2345
        cmpx	&12345h,&12345h		; 0x18c1 0x9292 0x2345 0x2345
        cmpx.b	&12345h,&12345h		; 0x18c1 0x92d2 0x2345 0x2345
        cmpx.w	&12345h,&12345h		; 0x18c1 0x9292 0x2345 0x2345
        cmpx.a	&12345h,&12345h		; 0x1881 0x92d2 0x2345 0x2345
        cmpx	65432h,&12345h		; 0x1ac1 0x9092 0x32e6 0x2345
        cmpx.b	65432h,&12345h		; 0x1ac1 0x90d2 0x32de 0x2345
        cmpx.w	65432h,&12345h		; 0x1ac1 0x9092 0x32d6 0x2345
        cmpx.a	65432h,&12345h		; 0x1a81 0x90d2 0x32ce 0x2345
        cmpx	r4,65432h		; 0x1845 0x9480 0x32c6
        cmpx.b	r4,65432h		; 0x1845 0x94c0 0x32c0
        cmpx.w	r4,65432h		; 0x1845 0x9480 0x32ba
        cmpx.a	r4,65432h		; 0x1805 0x94c0 0x32b4
        cmpx	#4,65432h		; 0x1845 0x92a0 0x32ae
        cmpx.b	#4,65432h		; 0x1845 0x92e0 0x32a8
        cmpx.w	#4,65432h		; 0x1845 0x92a0 0x32a2
        cmpx.a	#4,65432h		; 0x1805 0x92e0 0x329c
        cmpx	#8,65432h		; 0x1845 0x92b0 0x3296
        cmpx.b	#8,65432h		; 0x1845 0x92f0 0x3290
        cmpx.w	#8,65432h		; 0x1845 0x92b0 0x328a
        cmpx.a	#8,65432h		; 0x1805 0x92f0 0x3284
        cmpx	#0,65432h		; 0x1845 0x9380 0x327e
        cmpx.b	#0,65432h		; 0x1845 0x93c0 0x3278
        cmpx.w	#0,65432h		; 0x1845 0x9380 0x3272
        cmpx.a	#0,65432h		; 0x1805 0x93c0 0x326c
        cmpx	#1,65432h		; 0x1845 0x9390 0x3266
        cmpx.b	#1,65432h		; 0x1845 0x93d0 0x3260
        cmpx.w	#1,65432h		; 0x1845 0x9390 0x325a
        cmpx.a	#1,65432h		; 0x1805 0x93d0 0x3254
        cmpx	#2,65432h		; 0x1845 0x93a0 0x324e
        cmpx.b	#2,65432h		; 0x1845 0x93e0 0x3248
        cmpx.w	#2,65432h		; 0x1845 0x93a0 0x3242
        cmpx.a	#2,65432h		; 0x1805 0x93e0 0x323c
        cmpx	#0ffffh,65432h		; 0x1845 0x93b0 0x3236
        cmpx.b	#0ffh,65432h  		; 0x1845 0x93f0 0x3230
        cmpx.w	#0ffffh,65432h		; 0x1845 0x93b0 0x322a
        cmpx.a	#0fffffh,65432h		; 0x1805 0x93f0 0x3224
        cmpx	#-1,65432h		; 0x1845 0x93b0 0x321e
        cmpx.b	#-1,65432h		; 0x1845 0x93f0 0x3218
        cmpx.w	#-1,65432h		; 0x1845 0x93b0 0x3212
        cmpx.a	#-1,65432h		; 0x1805 0x93f0 0x320c
        cmpx	#100,65432h		; 0x1845 0x90b0 0x0064 0x3204
        cmpx.b	#100,65432h		; 0x1845 0x90f0 0x0064 0x31fc
        cmpx.w	#100,65432h		; 0x1845 0x90b0 0x0064 0x31f4
        cmpx.a	#100000,65432h		; 0x1885 0x90f0 0x86a0 0x31ec
        cmpx	@r6,65432h		; 0x1845 0x96a0 0x31e6
        cmpx.b	@r6,65432h		; 0x1845 0x96e0 0x31e0
        cmpx.w	@r6,65432h		; 0x1845 0x96a0 0x31da
        cmpx.a	@r6,65432h		; 0x1805 0x96e0 0x31d4
        cmpx	42(r6),65432h		; 0x1845 0x9690 0x002a 0x31cc
        cmpx.b	42(r6),65432h		; 0x1845 0x96d0 0x002a 0x31c4
        cmpx.w	42(r6),65432h		; 0x1845 0x9690 0x002a 0x31bc
        cmpx.a	42(r6),65432h		; 0x1805 0x96d0 0x002a 0x31b4
        cmpx	@r6,65432h		; 0x1845 0x96a0 0x31ae
        cmpx.b	@r6,65432h		; 0x1845 0x96e0 0x31a8
        cmpx.w	@r6,65432h		; 0x1845 0x96a0 0x31a2
        cmpx.a	@r6,65432h		; 0x1805 0x96e0 0x319c
        cmpx	@r6+,65432h		; 0x1845 0x96b0 0x3196
        cmpx.b	@r6+,65432h		; 0x1845 0x96f0 0x3190
        cmpx.w	@r6+,65432h		; 0x1845 0x96b0 0x318a
        cmpx.a	@r6+,65432h		; 0x1805 0x96f0 0x3184
        cmpx	&12345h,65432h		; 0x18c5 0x9290 0x2345 0x317c
        cmpx.b	&12345h,65432h		; 0x18c5 0x92d0 0x2345 0x3174
        cmpx.w	&12345h,65432h		; 0x18c5 0x9290 0x2345 0x316c
        cmpx.a	&12345h,65432h		; 0x1885 0x92d0 0x2345 0x3164
        cmpx	65432h,65432h		; 0x1ac5 0x9090 0x315e 0x315c
        cmpx.b	65432h,65432h		; 0x1ac5 0x90d0 0x3156 0x3154
        cmpx.w	65432h,65432h		; 0x1ac5 0x9090 0x314e 0x314c
        cmpx.a	65432h,65432h		; 0x1a85 0x90d0 0x3146 0x3144
	daddx	r4,r7			; 0x1840 0xa407
        daddx.b	r4,r7			; 0x1840 0xa447
        daddx.w	r4,r7			; 0x1840 0xa407
	daddx.a	r4,r7			; 0x1800 0xa447
        daddx	#4,r7			; 0x1840 0xa227
        daddx.b	#4,r7			; 0x1840 0xa267
        daddx.w	#4,r7			; 0x1840 0xa227
        daddx.a	#4,r7			; 0x1800 0xa267
        daddx	#8,r7			; 0x1840 0xa237
        daddx.b	#8,r7			; 0x1840 0xa277
        daddx.w	#8,r7			; 0x1840 0xa237
        daddx.a	#8,r7			; 0x1800 0xa277
        daddx	#0,r7			; 0x1840 0xa307
        daddx.b	#0,r7			; 0x1840 0xa347
        daddx.w	#0,r7			; 0x1840 0xa307
        daddx.a	#0,r7			; 0x1800 0xa347
        daddx	#1,r7			; 0x1840 0xa317
        daddx.b	#1,r7			; 0x1840 0xa357
        daddx.w	#1,r7			; 0x1840 0xa317
        daddx.a	#1,r7			; 0x1800 0xa357
        daddx	#2,r7			; 0x1840 0xa327
        daddx.b	#2,r7			; 0x1840 0xa367
        daddx.w	#2,r7			; 0x1840 0xa327
        daddx.a	#2,r7			; 0x1800 0xa367
        daddx	#0ffffh,r7		; 0x1840 0xa337
        daddx.b	#0ffh,r7		; 0x1840 0xa377
        daddx.w	#0ffffh,r7		; 0x1840 0xa337
        daddx.a	#0fffffh,r7		; 0x1800 0xa377
        daddx	#-1,r7			; 0x1840 0xa337
        daddx.b	#-1,r7			; 0x1840 0xa377
        daddx.w	#-1,r7			; 0x1840 0xa337
        daddx.a	#-1,r7			; 0x1800 0xa377
        daddx	#100,r7			; 0x1840 0xa037 0x0064
        daddx.b	#100,r7			; 0x1840 0xa077 0x0064
        daddx.w	#100,r7			; 0x1840 0xa037 0x0064
        daddx.a	#100000,r7		; 0x1880 0xa077 0x86a0
        daddx	@r6,r7			; 0x1840 0xa627
        daddx.b	@r6,r7			; 0x1840 0xa667
        daddx.w	@r6,r7			; 0x1840 0xa627
        daddx.a	@r6,r7			; 0x1800 0xa667
        daddx	42(r6),r7		; 0x1840 0xa617 0x002a
        daddx.b	42(r6),r7		; 0x1840 0xa657 0x002a
        daddx.w	42(r6),r7		; 0x1840 0xa617 0x002a
        daddx.a	42(r6),r7		; 0x1800 0xa657 0x002a
        daddx	@r6,r7			; 0x1840 0xa627
        daddx.b	@r6,r7			; 0x1840 0xa667
        daddx.w	@r6,r7			; 0x1840 0xa627
        daddx.a	@r6,r7			; 0x1800 0xa667
        daddx	@r6+,r7			; 0x1840 0xa637
        daddx.b	@r6+,r7			; 0x1840 0xa677
        daddx.w	@r6+,r7			; 0x1840 0xa637
        daddx.a	@r6+,r7			; 0x1800 0xa677
        daddx	&12345h,r7		; 0x18c0 0xa217 0x2345
        daddx.b	&12345h,r7		; 0x18c0 0xa257 0x2345
        daddx.w	&12345h,r7		; 0x18c0 0xa217 0x2345
        daddx.a	&12345h,r7		; 0x1880 0xa257 0x2345
        daddx	65432h,r7		; 0x1ac0 0xa017 0x3046
        daddx.b	65432h,r7		; 0x1ac0 0xa057 0x3040
        daddx.w	65432h,r7		; 0x1ac0 0xa017 0x303a
        daddx.a	65432h,r7		; 0x1a80 0xa057 0x3034
        daddx	r4,200(r8)		; 0x1840 0xa488 0x00c8
        daddx.b	r4,200(r8)		; 0x1840 0xa4c8 0x00c8
        daddx.w	r4,200(r8)		; 0x1840 0xa488 0x00c8
        daddx.a	r4,200(r8)		; 0x1800 0xa4c8 0x00c8
        daddx	#4,200(r8)		; 0x1840 0xa2a8 0x00c8
        daddx.b	#4,200(r8)		; 0x1840 0xa2e8 0x00c8
        daddx.w	#4,200(r8)		; 0x1840 0xa2a8 0x00c8
        daddx.a	#4,200(r8)		; 0x1800 0xa2e8 0x00c8
        daddx	#8,200(r8)		; 0x1840 0xa2b8 0x00c8
        daddx.b	#8,200(r8)		; 0x1840 0xa2f8 0x00c8
        daddx.w	#8,200(r8)		; 0x1840 0xa2b8 0x00c8
        daddx.a	#8,200(r8)		; 0x1800 0xa2f8 0x00c8
        daddx	#0,200(r8)		; 0x1840 0xa388 0x00c8
        daddx.b	#0,200(r8)		; 0x1840 0xa3c8 0x00c8
        daddx.w	#0,200(r8)		; 0x1840 0xa388 0x00c8
        daddx.a	#0,200(r8)		; 0x1800 0xa3c8 0x00c8
        daddx	#1,200(r8)		; 0x1840 0xa398 0x00c8
        daddx.b	#1,200(r8)		; 0x1840 0xa3d8 0x00c8
        daddx.w	#1,200(r8)		; 0x1840 0xa398 0x00c8
        daddx.a	#1,200(r8)		; 0x1800 0xa3d8 0x00c8
        daddx	#2,200(r8)		; 0x1840 0xa3a8 0x00c8
        daddx.b	#2,200(r8)		; 0x1840 0xa3e8 0x00c8
        daddx.w	#2,200(r8)		; 0x1840 0xa3a8 0x00c8
        daddx.a	#2,200(r8)		; 0x1800 0xa3e8 0x00c8
        daddx	#0ffffh,200(r8)		; 0x1840 0xa3b8 0x00c8
        daddx.b	#0ffh,200(r8)		; 0x1840 0xa3f8 0x00c8
        daddx.w	#0ffffh,200(r8)		; 0x1840 0xa3b8 0x00c8
        daddx.a	#0fffffh,200(r8)	; 0x1800 0xa3f8 0x00c8
        daddx	#-1,200(r8)		; 0x1840 0xa3b8 0x00c8
        daddx.b	#-1,200(r8)		; 0x1840 0xa3f8 0x00c8
        daddx.w	#-1,200(r8)		; 0x1840 0xa3b8 0x00c8
        daddx.a	#-1,200(r8)		; 0x1800 0xa3f8 0x00c8
        daddx	#100,200(r8)		; 0x1840 0xa0b8 0x0064 0x00c8
        daddx.b	#100,200(r8)		; 0x1840 0xa0f8 0x0064 0x00c8
        daddx.w	#100,200(r8)		; 0x1840 0xa0b8 0x0064 0x00c8
        daddx.a	#100000,200(r8)		; 0x1880 0xa0f8 0x86a0 0x00c8
        daddx	@r6,200(r8)		; 0x1840 0xa6a8 0x00c8
        daddx.b	@r6,200(r8)		; 0x1840 0xa6e8 0x00c8
        daddx.w	@r6,200(r8)		; 0x1840 0xa6a8 0x00c8
        daddx.a	@r6,200(r8)		; 0x1800 0xa6e8 0x00c8
        daddx	42(r6),200(r8)		; 0x1840 0xa698 0x002a 0x00c8
        daddx.b	42(r6),200(r8)		; 0x1840 0xa6d8 0x002a 0x00c8
        daddx.w	42(r6),200(r8)		; 0x1840 0xa698 0x002a 0x00c8
        daddx.a	42(r6),200(r8)		; 0x1800 0xa6d8 0x002a 0x00c8
        daddx	@r6,200(r8)		; 0x1840 0xa6a8 0x00c8
        daddx.b	@r6,200(r8)		; 0x1840 0xa6e8 0x00c8
        daddx.w	@r6,200(r8)		; 0x1840 0xa6a8 0x00c8
        daddx.a	@r6,200(r8)		; 0x1800 0xa6e8 0x00c8
        daddx	@r6+,200(r8)		; 0x1840 0xa6b8 0x00c8
        daddx.b	@r6+,200(r8)		; 0x1840 0xa6f8 0x00c8
        daddx.w	@r6+,200(r8)		; 0x1840 0xa6b8 0x00c8
        daddx.a	@r6+,200(r8)		; 0x1800 0xa6f8 0x00c8
        daddx	&12345h,200(r8)		; 0x18c0 0xa298 0x2345 0x00c8
        daddx.b	&12345h,200(r8)		; 0x18c0 0xa2d8 0x2345 0x00c8
        daddx.w	&12345h,200(r8)		; 0x18c0 0xa298 0x2345 0x00c8
        daddx.a	&12345h,200(r8)		; 0x1880 0xa2d8 0x2345 0x00c8
        daddx	65432h,200(r8)		; 0x1ac0 0xa098 0x2ec6 0x00c8
        daddx.b	65432h,200(r8)		; 0x1ac0 0xa0d8 0x2ebe 0x00c8
        daddx.w	65432h,200(r8)		; 0x1ac0 0xa098 0x2eb6 0x00c8
        daddx.a	65432h,200(r8)		; 0x1ac0 0xa0d8 0x2eae 0x00c8
        daddx	r4,&12345h		; 0x1841 0xa482 0x2345
        daddx.b	r4,&12345h		; 0x1841 0xa4c2 0x2345
        daddx.w	r4,&12345h		; 0x1841 0xa482 0x2345
        daddx.a	r4,&12345h		; 0x1801 0xa4c2 0x2345
        daddx	#4,&12345h		; 0x1841 0xa2a2 0x2345
        daddx.b	#4,&12345h		; 0x1841 0xa2e2 0x2345
        daddx.w	#4,&12345h		; 0x1841 0xa2a2 0x2345
        daddx.a	#4,&12345h		; 0x1801 0xa2e2 0x2345
        daddx	#8,&12345h		; 0x1841 0xa2b2 0x2345
        daddx.b	#8,&12345h		; 0x1841 0xa2f2 0x2345
        daddx.w	#8,&12345h		; 0x1841 0xa2b2 0x2345
        daddx.a	#8,&12345h		; 0x1801 0xa2f2 0x2345
        daddx	#0,&12345h		; 0x1841 0xa382 0x2345
        daddx.b	#0,&12345h		; 0x1841 0xa3c2 0x2345
        daddx.w	#0,&12345h		; 0x1841 0xa382 0x2345
        daddx.a	#0,&12345h		; 0x1801 0xa3c2 0x2345
        daddx	#1,&12345h		; 0x1841 0xa392 0x2345
        daddx.b	#1,&12345h		; 0x1841 0xa3d2 0x2345
        daddx.w	#1,&12345h		; 0x1841 0xa392 0x2345
        daddx.a	#1,&12345h		; 0x1801 0xa3d2 0x2345
        daddx	#2,&12345h		; 0x1841 0xa3a2 0x2345
        daddx.b	#2,&12345h		; 0x1841 0xa3e2 0x2345
        daddx.w	#2,&12345h		; 0x1841 0xa3a2 0x2345
        daddx.a	#2,&12345h		; 0x1801 0xa3e2 0x2345
        daddx	#0ffffh,&12345h		; 0x1841 0xa3b2 0x2345
        daddx.b	#0ffh,&12345h  		; 0x1841 0xa3f2 0x2345
        daddx.w	#0ffffh,&12345h		; 0x1841 0xa3b2 0x2345
        daddx.a	#0fffffh,&12345h	; 0x1801 0xa3f2 0x2345
        daddx	#-1,&12345h		; 0x1841 0xa3b2 0x2345
        daddx.b	#-1,&12345h		; 0x1841 0xa3f2 0x2345
        daddx.w	#-1,&12345h		; 0x1841 0xa3b2 0x2345
        daddx.a	#-1,&12345h		; 0x1801 0xa3f2 0x2345
        daddx	#100,&12345h		; 0x1841 0xa0b2 0x0064 0x2345
        daddx.b	#100,&12345h		; 0x1841 0xa0f2 0x0064 0x2345
        daddx.w	#100,&12345h		; 0x1841 0xa0b2 0x0064 0x2345
        daddx.a	#100000,&12345h		; 0x1881 0xa0f2 0x86a0 0x2345
        daddx	@r6,&12345h		; 0x1841 0xa6a2 0x2345
        daddx.b	@r6,&12345h		; 0x1841 0xa6e2 0x2345
        daddx.w	@r6,&12345h		; 0x1841 0xa6a2 0x2345
        daddx.a	@r6,&12345h		; 0x1801 0xa6e2 0x2345
        daddx	42(r6),&12345h		; 0x1841 0xa692 0x002a 0x2345
        daddx.b	42(r6),&12345h		; 0x1841 0xa6d2 0x002a 0x2345
        daddx.w	42(r6),&12345h		; 0x1841 0xa692 0x002a 0x2345
        daddx.a	42(r6),&12345h		; 0x1801 0xa6d2 0x002a 0x2345
        daddx	@r6,&12345h		; 0x1841 0xa6a2 0x2345
        daddx.b	@r6,&12345h		; 0x1841 0xa6e2 0x2345
        daddx.w	@r6,&12345h		; 0x1841 0xa6a2 0x2345
        daddx.a	@r6,&12345h		; 0x1801 0xa6e2 0x2345
        daddx	@r6+,&12345h		; 0x1841 0xa6b2 0x2345
        daddx.b	@r6+,&12345h		; 0x1841 0xa6f2 0x2345
        daddx.w	@r6+,&12345h		; 0x1841 0xa6b2 0x2345
        daddx.a	@r6+,&12345h		; 0x1801 0xa6f2 0x2345
        daddx	&12345h,&12345h		; 0x18c1 0xa292 0x2345 0x2345
        daddx.b	&12345h,&12345h		; 0x18c1 0xa2d2 0x2345 0x2345
        daddx.w	&12345h,&12345h		; 0x18c1 0xa292 0x2345 0x2345
        daddx.a	&12345h,&12345h		; 0x1881 0xa2d2 0x2345 0x2345
        daddx	65432h,&12345h		; 0x1ac1 0xa092 0x2d3e 0x2345
        daddx.b	65432h,&12345h		; 0x1ac1 0xa0d2 0x2d36 0x2345
        daddx.w	65432h,&12345h		; 0x1ac1 0xa092 0x2d2e 0x2345
        daddx.a	65432h,&12345h		; 0x1a81 0xa0d2 0x2d26 0x2345
        daddx	r4,65432h		; 0x1845 0xa480 0x2d1e
        daddx.b	r4,65432h		; 0x1845 0xa4c0 0x2d18
        daddx.w	r4,65432h		; 0x1845 0xa480 0x2d12
        daddx.a	r4,65432h		; 0x1805 0xa4c0 0x2d0c
        daddx	#4,65432h		; 0x1845 0xa2a0 0x2d06
        daddx.b	#4,65432h		; 0x1845 0xa2e0 0x2d00
        daddx.w	#4,65432h		; 0x1845 0xa2a0 0x2cfa
        daddx.a	#4,65432h		; 0x1805 0xa2e0 0x2cf4
        daddx	#8,65432h		; 0x1845 0xa2b0 0x2cee
        daddx.b	#8,65432h		; 0x1845 0xa2f0 0x2ce8
        daddx.w	#8,65432h		; 0x1845 0xa2b0 0x2ce2
        daddx.a	#8,65432h		; 0x1805 0xa2f0 0x2cdc
        daddx	#0,65432h		; 0x1845 0xa380 0x2cd6
        daddx.b	#0,65432h		; 0x1845 0xa3c0 0x2cd0
        daddx.w	#0,65432h		; 0x1845 0xa380 0x2cca
        daddx.a	#0,65432h		; 0x1805 0xa3c0 0x2cc4
        daddx	#1,65432h		; 0x1845 0xa390 0x2cbe
        daddx.b	#1,65432h		; 0x1845 0xa3d0 0x2cb8
        daddx.w	#1,65432h		; 0x1845 0xa390 0x2cb2
        daddx.a	#1,65432h		; 0x1805 0xa3d0 0x2cac
        daddx	#2,65432h		; 0x1845 0xa3a0 0x2ca6
        daddx.b	#2,65432h		; 0x1845 0xa3e0 0x2ca0
        daddx.w	#2,65432h		; 0x1845 0xa3a0 0x2c9a
        daddx.a	#2,65432h		; 0x1805 0xa3e0 0x2c94
        daddx	#0ffffh,65432h		; 0x1845 0xa3b0 0x2c8e
        daddx.b	#0ffh,65432h  		; 0x1845 0xa3f0 0x2c88
        daddx.w	#0ffffh,65432h		; 0x1845 0xa3b0 0x2c82
        daddx.a	#0fffffh,65432h		; 0x1805 0xa3f0 0x2c7c
        daddx	#-1,65432h		; 0x1845 0xa3b0 0x2c76
        daddx.b	#-1,65432h		; 0x1845 0xa3f0 0x2c70
        daddx.w	#-1,65432h		; 0x1845 0xa3b0 0x2c6a
        daddx.a	#-1,65432h		; 0x1805 0xa3f0 0x2c64
        daddx	#100,65432h		; 0x1845 0xa0b0 0x0064 0x2c5c
        daddx.b	#100,65432h		; 0x1845 0xa0f0 0x0064 0x2c54
        daddx.w	#100,65432h		; 0x1845 0xa0b0 0x0064 0x2c4c
        daddx.a	#100000,65432h		; 0x1885 0xa0f0 0x86a0 0x2c44
        daddx	@r6,65432h		; 0x1845 0xa6a0 0x2c3e
        daddx.b	@r6,65432h		; 0x1845 0xa6e0 0x2c38
        daddx.w	@r6,65432h		; 0x1845 0xa6a0 0x2c32
        daddx.a	@r6,65432h		; 0x1805 0xa6e0 0x2c2c
        daddx	42(r6),65432h		; 0x1845 0xa690 0x002a 0x2c24
        daddx.b	42(r6),65432h		; 0x1845 0xa6d0 0x002a 0x2c1c
        daddx.w	42(r6),65432h		; 0x1845 0xa690 0x002a 0x2c14
        daddx.a	42(r6),65432h		; 0x1805 0xa6d0 0x002a 0x2c0c
        daddx	@r6,65432h		; 0x1845 0xa6a0 0x2c06
        daddx.b	@r6,65432h		; 0x1845 0xa6e0 0x2c00
        daddx.w	@r6,65432h		; 0x1845 0xa6a0 0x2bfa
        daddx.a	@r6,65432h		; 0x1805 0xa6e0 0x2bf4
        daddx	@r6+,65432h		; 0x1845 0xa6b0 0x2bee
        daddx.b	@r6+,65432h		; 0x1845 0xa6f0 0x2be8
        daddx.w	@r6+,65432h		; 0x1845 0xa6b0 0x2be2
        daddx.a	@r6+,65432h		; 0x1805 0xa6f0 0x2bdc
        daddx	&12345h,65432h		; 0x18c5 0xa290 0x2345 0x2bd4
        daddx.b	&12345h,65432h		; 0x18c5 0xa2d0 0x2345 0x2bcc
        daddx.w	&12345h,65432h		; 0x18c5 0xa290 0x2345 0x2bc4
        daddx.a	&12345h,65432h		; 0x1885 0xa2d0 0x2345 0x2bbc
        daddx	65432h,65432h		; 0x1ac5 0xa090 0x2bb6 0x2bb4
        daddx.b	65432h,65432h		; 0x1ac5 0xa0d0 0x2bae 0x2bac
        daddx.w	65432h,65432h		; 0x1ac5 0xa090 0x2ba6 0x2ba4
        daddx.a	65432h,65432h		; 0x1a85 0xa0d0 0x2b9e 0x2b9c
	bitx	r4,r7			; 0x1840 0xb407
        bitx.b	r4,r7			; 0x1840 0xb447
        bitx.w	r4,r7			; 0x1840 0xb407
	bitx.a	r4,r7			; 0x1800 0xb447
        bitx	#4,r7			; 0x1840 0xb227
        bitx.b	#4,r7			; 0x1840 0xb267
        bitx.w	#4,r7			; 0x1840 0xb227
        bitx.a	#4,r7			; 0x1800 0xb267
        bitx	#8,r7			; 0x1840 0xb237
        bitx.b	#8,r7			; 0x1840 0xb277
        bitx.w	#8,r7			; 0x1840 0xb237
        bitx.a	#8,r7			; 0x1800 0xb277
        bitx	#0,r7			; 0x1840 0xb307
        bitx.b	#0,r7			; 0x1840 0xb347
        bitx.w	#0,r7			; 0x1840 0xb307
        bitx.a	#0,r7			; 0x1800 0xb347
        bitx	#1,r7			; 0x1840 0xb317
        bitx.b	#1,r7			; 0x1840 0xb357
        bitx.w	#1,r7			; 0x1840 0xb317
        bitx.a	#1,r7			; 0x1800 0xb357
        bitx	#2,r7			; 0x1840 0xb327
        bitx.b	#2,r7			; 0x1840 0xb367
        bitx.w	#2,r7			; 0x1840 0xb327
        bitx.a	#2,r7			; 0x1800 0xb367
        bitx	#0ffffh,r7		; 0x1840 0xb337
        bitx.b	#0ffh,r7		; 0x1840 0xb377
        bitx.w	#0ffffh,r7		; 0x1840 0xb337
        bitx.a	#0fffffh,r7		; 0x1800 0xb377
        bitx	#-1,r7			; 0x1840 0xb337
        bitx.b	#-1,r7			; 0x1840 0xb377
        bitx.w	#-1,r7			; 0x1840 0xb337
        bitx.a	#-1,r7			; 0x1800 0xb377
        bitx	#100,r7			; 0x1840 0xb037 0x0064
        bitx.b	#100,r7			; 0x1840 0xb077 0x0064
        bitx.w	#100,r7			; 0x1840 0xb037 0x0064
        bitx.a	#100000,r7		; 0x1880 0xb077 0x86a0
        bitx	@r6,r7			; 0x1840 0xb627
        bitx.b	@r6,r7			; 0x1840 0xb667
        bitx.w	@r6,r7			; 0x1840 0xb627
        bitx.a	@r6,r7			; 0x1800 0xb667
        bitx	42(r6),r7		; 0x1840 0xb617 0x002a
        bitx.b	42(r6),r7		; 0x1840 0xb657 0x002a
        bitx.w	42(r6),r7		; 0x1840 0xb617 0x002a
        bitx.a	42(r6),r7		; 0x1800 0xb657 0x002a
        bitx	@r6,r7			; 0x1840 0xb627
        bitx.b	@r6,r7			; 0x1840 0xb667
        bitx.w	@r6,r7			; 0x1840 0xb627
        bitx.a	@r6,r7			; 0x1800 0xb667
        bitx	@r6+,r7			; 0x1840 0xb637
        bitx.b	@r6+,r7			; 0x1840 0xb677
        bitx.w	@r6+,r7			; 0x1840 0xb637
        bitx.a	@r6+,r7			; 0x1800 0xb677
        bitx	&12345h,r7		; 0x18c0 0xb217 0x2345
        bitx.b	&12345h,r7		; 0x18c0 0xb257 0x2345
        bitx.w	&12345h,r7		; 0x18c0 0xb217 0x2345
        bitx.a	&12345h,r7		; 0x1880 0xb257 0x2345
        bitx	65432h,r7		; 0x1ac0 0xb017 0x2a9e
        bitx.b	65432h,r7		; 0x1ac0 0xb057 0x2a98
        bitx.w	65432h,r7		; 0x1ac0 0xb017 0x2a92
        bitx.a	65432h,r7		; 0x1a80 0xb057 0x2a8c
        bitx	r4,200(r8)		; 0x1840 0xb488 0x00c8
        bitx.b	r4,200(r8)		; 0x1840 0xb4c8 0x00c8
        bitx.w	r4,200(r8)		; 0x1840 0xb488 0x00c8
        bitx.a	r4,200(r8)		; 0x1800 0xb4c8 0x00c8
        bitx	#4,200(r8)		; 0x1840 0xb2a8 0x00c8
        bitx.b	#4,200(r8)		; 0x1840 0xb2e8 0x00c8
        bitx.w	#4,200(r8)		; 0x1840 0xb2a8 0x00c8
        bitx.a	#4,200(r8)		; 0x1800 0xb2e8 0x00c8
        bitx	#8,200(r8)		; 0x1840 0xb2b8 0x00c8
        bitx.b	#8,200(r8)		; 0x1840 0xb2f8 0x00c8
        bitx.w	#8,200(r8)		; 0x1840 0xb2b8 0x00c8
        bitx.a	#8,200(r8)		; 0x1800 0xb2f8 0x00c8
        bitx	#0,200(r8)		; 0x1840 0xb388 0x00c8
        bitx.b	#0,200(r8)		; 0x1840 0xb3c8 0x00c8
        bitx.w	#0,200(r8)		; 0x1840 0xb388 0x00c8
        bitx.a	#0,200(r8)		; 0x1800 0xb3c8 0x00c8
        bitx	#1,200(r8)		; 0x1840 0xb398 0x00c8
        bitx.b	#1,200(r8)		; 0x1840 0xb3d8 0x00c8
        bitx.w	#1,200(r8)		; 0x1840 0xb398 0x00c8
        bitx.a	#1,200(r8)		; 0x1800 0xb3d8 0x00c8
        bitx	#2,200(r8)		; 0x1840 0xb3a8 0x00c8
        bitx.b	#2,200(r8)		; 0x1840 0xb3e8 0x00c8
        bitx.w	#2,200(r8)		; 0x1840 0xb3a8 0x00c8
        bitx.a	#2,200(r8)		; 0x1800 0xb3e8 0x00c8
        bitx	#0ffffh,200(r8)		; 0x1840 0xb3b8 0x00c8
        bitx.b	#0ffh,200(r8)		; 0x1840 0xb3f8 0x00c8
        bitx.w	#0ffffh,200(r8)		; 0x1840 0xb3b8 0x00c8
        bitx.a	#0fffffh,200(r8)	; 0x1800 0xb3f8 0x00c8
        bitx	#-1,200(r8)		; 0x1840 0xb3b8 0x00c8
        bitx.b	#-1,200(r8)		; 0x1840 0xb3f8 0x00c8
        bitx.w	#-1,200(r8)		; 0x1840 0xb3b8 0x00c8
        bitx.a	#-1,200(r8)		; 0x1800 0xb3f8 0x00c8
        bitx	#100,200(r8)		; 0x1840 0xb0b8 0x0064 0x00c8
        bitx.b	#100,200(r8)		; 0x1840 0xb0f8 0x0064 0x00c8
        bitx.w	#100,200(r8)		; 0x1840 0xb0b8 0x0064 0x00c8
        bitx.a	#100000,200(r8)		; 0x1880 0xb0f8 0x86a0 0x00c8
        bitx	@r6,200(r8)		; 0x1840 0xb6a8 0x00c8
        bitx.b	@r6,200(r8)		; 0x1840 0xb6e8 0x00c8
        bitx.w	@r6,200(r8)		; 0x1840 0xb6a8 0x00c8
        bitx.a	@r6,200(r8)		; 0x1800 0xb6e8 0x00c8
        bitx	42(r6),200(r8)		; 0x1840 0xb698 0x002a 0x00c8
        bitx.b	42(r6),200(r8)		; 0x1840 0xb6d8 0x002a 0x00c8
        bitx.w	42(r6),200(r8)		; 0x1840 0xb698 0x002a 0x00c8
        bitx.a	42(r6),200(r8)		; 0x1800 0xb6d8 0x002a 0x00c8
        bitx	@r6,200(r8)		; 0x1840 0xb6a8 0x00c8
        bitx.b	@r6,200(r8)		; 0x1840 0xb6e8 0x00c8
        bitx.w	@r6,200(r8)		; 0x1840 0xb6a8 0x00c8
        bitx.a	@r6,200(r8)		; 0x1800 0xb6e8 0x00c8
        bitx	@r6+,200(r8)		; 0x1840 0xb6b8 0x00c8
        bitx.b	@r6+,200(r8)		; 0x1840 0xb6f8 0x00c8
        bitx.w	@r6+,200(r8)		; 0x1840 0xb6b8 0x00c8
        bitx.a	@r6+,200(r8)		; 0x1800 0xb6f8 0x00c8
        bitx	&12345h,200(r8)		; 0x18c0 0xb298 0x2345 0x00c8
        bitx.b	&12345h,200(r8)		; 0x18c0 0xb2d8 0x2345 0x00c8
        bitx.w	&12345h,200(r8)		; 0x18c0 0xb298 0x2345 0x00c8
        bitx.a	&12345h,200(r8)		; 0x1880 0xb2d8 0x2345 0x00c8
        bitx	65432h,200(r8)		; 0x1ac0 0xb098 0x291e 0x00c8
        bitx.b	65432h,200(r8)		; 0x1ac0 0xb0d8 0x2916 0x00c8
        bitx.w	65432h,200(r8)		; 0x1ac0 0xb098 0x290e 0x00c8
        bitx.a	65432h,200(r8)		; 0x1ac0 0xb0d8 0x2906 0x00c8
        bitx	r4,&12345h		; 0x1841 0xb482 0x2345
        bitx.b	r4,&12345h		; 0x1841 0xb4c2 0x2345
        bitx.w	r4,&12345h		; 0x1841 0xb482 0x2345
        bitx.a	r4,&12345h		; 0x1801 0xb4c2 0x2345
        bitx	#4,&12345h		; 0x1841 0xb2a2 0x2345
        bitx.b	#4,&12345h		; 0x1841 0xb2e2 0x2345
        bitx.w	#4,&12345h		; 0x1841 0xb2a2 0x2345
        bitx.a	#4,&12345h		; 0x1801 0xb2e2 0x2345
        bitx	#8,&12345h		; 0x1841 0xb2b2 0x2345
        bitx.b	#8,&12345h		; 0x1841 0xb2f2 0x2345
        bitx.w	#8,&12345h		; 0x1841 0xb2b2 0x2345
        bitx.a	#8,&12345h		; 0x1801 0xb2f2 0x2345
        bitx	#0,&12345h		; 0x1841 0xb382 0x2345
        bitx.b	#0,&12345h		; 0x1841 0xb3c2 0x2345
        bitx.w	#0,&12345h		; 0x1841 0xb382 0x2345
        bitx.a	#0,&12345h		; 0x1801 0xb3c2 0x2345
        bitx	#1,&12345h		; 0x1841 0xb392 0x2345
        bitx.b	#1,&12345h		; 0x1841 0xb3d2 0x2345
        bitx.w	#1,&12345h		; 0x1841 0xb392 0x2345
        bitx.a	#1,&12345h		; 0x1801 0xb3d2 0x2345
        bitx	#2,&12345h		; 0x1841 0xb3a2 0x2345
        bitx.b	#2,&12345h		; 0x1841 0xb3e2 0x2345
        bitx.w	#2,&12345h		; 0x1841 0xb3a2 0x2345
        bitx.a	#2,&12345h		; 0x1801 0xb3e2 0x2345
        bitx	#0ffffh,&12345h		; 0x1841 0xb3b2 0x2345
        bitx.b	#0ffh,&12345h  		; 0x1841 0xb3f2 0x2345
        bitx.w	#0ffffh,&12345h		; 0x1841 0xb3b2 0x2345
        bitx.a	#0fffffh,&12345h	; 0x1801 0xb3f2 0x2345
        bitx	#-1,&12345h		; 0x1841 0xb3b2 0x2345
        bitx.b	#-1,&12345h		; 0x1841 0xb3f2 0x2345
        bitx.w	#-1,&12345h		; 0x1841 0xb3b2 0x2345
        bitx.a	#-1,&12345h		; 0x1801 0xb3f2 0x2345
        bitx	#100,&12345h		; 0x1841 0xb0b2 0x0064 0x2345
        bitx.b	#100,&12345h		; 0x1841 0xb0f2 0x0064 0x2345
        bitx.w	#100,&12345h		; 0x1841 0xb0b2 0x0064 0x2345
        bitx.a	#100000,&12345h		; 0x1881 0xb0f2 0x86a0 0x2345
        bitx	@r6,&12345h		; 0x1841 0xb6a2 0x2345
        bitx.b	@r6,&12345h		; 0x1841 0xb6e2 0x2345
        bitx.w	@r6,&12345h		; 0x1841 0xb6a2 0x2345
        bitx.a	@r6,&12345h		; 0x1801 0xb6e2 0x2345
        bitx	42(r6),&12345h		; 0x1841 0xb692 0x002a 0x2345
        bitx.b	42(r6),&12345h		; 0x1841 0xb6d2 0x002a 0x2345
        bitx.w	42(r6),&12345h		; 0x1841 0xb692 0x002a 0x2345
        bitx.a	42(r6),&12345h		; 0x1801 0xb6d2 0x002a 0x2345
        bitx	@r6,&12345h		; 0x1841 0xb6a2 0x2345
        bitx.b	@r6,&12345h		; 0x1841 0xb6e2 0x2345
        bitx.w	@r6,&12345h		; 0x1841 0xb6a2 0x2345
        bitx.a	@r6,&12345h		; 0x1801 0xb6e2 0x2345
        bitx	@r6+,&12345h		; 0x1841 0xb6b2 0x2345
        bitx.b	@r6+,&12345h		; 0x1841 0xb6f2 0x2345
        bitx.w	@r6+,&12345h		; 0x1841 0xb6b2 0x2345
        bitx.a	@r6+,&12345h		; 0x1801 0xb6f2 0x2345
        bitx	&12345h,&12345h		; 0x18c1 0xb292 0x2345 0x2345
        bitx.b	&12345h,&12345h		; 0x18c1 0xb2d2 0x2345 0x2345
        bitx.w	&12345h,&12345h		; 0x18c1 0xb292 0x2345 0x2345
        bitx.a	&12345h,&12345h		; 0x1881 0xb2d2 0x2345 0x2345
        bitx	65432h,&12345h		; 0x1ac1 0xb092 0x2796 0x2345
        bitx.b	65432h,&12345h		; 0x1ac1 0xb0d2 0x278e 0x2345
        bitx.w	65432h,&12345h		; 0x1ac1 0xb092 0x2786 0x2345
        bitx.a	65432h,&12345h		; 0x1a81 0xb0d2 0x277e 0x2345
        bitx	r4,65432h		; 0x1845 0xb480 0x2776
        bitx.b	r4,65432h		; 0x1845 0xb4c0 0x2770
        bitx.w	r4,65432h		; 0x1845 0xb480 0x276a
        bitx.a	r4,65432h		; 0x1805 0xb4c0 0x2764
        bitx	#4,65432h		; 0x1845 0xb2a0 0x275e
        bitx.b	#4,65432h		; 0x1845 0xb2e0 0x2758
        bitx.w	#4,65432h		; 0x1845 0xb2a0 0x2752
        bitx.a	#4,65432h		; 0x1805 0xb2e0 0x274c
        bitx	#8,65432h		; 0x1845 0xb2b0 0x2746
        bitx.b	#8,65432h		; 0x1845 0xb2f0 0x2740
        bitx.w	#8,65432h		; 0x1845 0xb2b0 0x273a
        bitx.a	#8,65432h		; 0x1805 0xb2f0 0x2734
        bitx	#0,65432h		; 0x1845 0xb380 0x272e
        bitx.b	#0,65432h		; 0x1845 0xb3c0 0x2728
        bitx.w	#0,65432h		; 0x1845 0xb380 0x2722
        bitx.a	#0,65432h		; 0x1805 0xb3c0 0x271c
        bitx	#1,65432h		; 0x1845 0xb390 0x2716
        bitx.b	#1,65432h		; 0x1845 0xb3d0 0x2710
        bitx.w	#1,65432h		; 0x1845 0xb390 0x270a
        bitx.a	#1,65432h		; 0x1805 0xb3d0 0x2704
        bitx	#2,65432h		; 0x1845 0xb3a0 0x26fe
        bitx.b	#2,65432h		; 0x1845 0xb3e0 0x26f8
        bitx.w	#2,65432h		; 0x1845 0xb3a0 0x26f2
        bitx.a	#2,65432h		; 0x1805 0xb3e0 0x26ec
        bitx	#0ffffh,65432h		; 0x1845 0xb3b0 0x26e6
        bitx.b	#0ffh,65432h  		; 0x1845 0xb3f0 0x26e0
        bitx.w	#0ffffh,65432h		; 0x1845 0xb3b0 0x26da
        bitx.a	#0fffffh,65432h		; 0x1805 0xb3f0 0x26d4
        bitx	#-1,65432h		; 0x1845 0xb3b0 0x26ce
        bitx.b	#-1,65432h		; 0x1845 0xb3f0 0x26c8
        bitx.w	#-1,65432h		; 0x1845 0xb3b0 0x26c2
        bitx.a	#-1,65432h		; 0x1805 0xb3f0 0x26bc
        bitx	#100,65432h		; 0x1845 0xb0b0 0x0064 0x26b4
        bitx.b	#100,65432h		; 0x1845 0xb0f0 0x0064 0x26ac
        bitx.w	#100,65432h		; 0x1845 0xb0b0 0x0064 0x26a4
        bitx.a	#100000,65432h		; 0x1885 0xb0f0 0x86a0 0x269c
        bitx	@r6,65432h		; 0x1845 0xb6a0 0x2696
        bitx.b	@r6,65432h		; 0x1845 0xb6e0 0x2690
        bitx.w	@r6,65432h		; 0x1845 0xb6a0 0x268a
        bitx.a	@r6,65432h		; 0x1805 0xb6e0 0x2684
        bitx	42(r6),65432h		; 0x1845 0xb690 0x002a 0x267c
        bitx.b	42(r6),65432h		; 0x1845 0xb6d0 0x002a 0x2674
        bitx.w	42(r6),65432h		; 0x1845 0xb690 0x002a 0x266c
        bitx.a	42(r6),65432h		; 0x1805 0xb6d0 0x002a 0x2664
        bitx	@r6,65432h		; 0x1845 0xb6a0 0x265e
        bitx.b	@r6,65432h		; 0x1845 0xb6e0 0x2658
        bitx.w	@r6,65432h		; 0x1845 0xb6a0 0x2652
        bitx.a	@r6,65432h		; 0x1805 0xb6e0 0x264c
        bitx	@r6+,65432h		; 0x1845 0xb6b0 0x2646
        bitx.b	@r6+,65432h		; 0x1845 0xb6f0 0x2640
        bitx.w	@r6+,65432h		; 0x1845 0xb6b0 0x263a
        bitx.a	@r6+,65432h		; 0x1805 0xb6f0 0x2634
        bitx	&12345h,65432h		; 0x18c5 0xb290 0x2345 0x262c
        bitx.b	&12345h,65432h		; 0x18c5 0xb2d0 0x2345 0x2624
        bitx.w	&12345h,65432h		; 0x18c5 0xb290 0x2345 0x261c
        bitx.a	&12345h,65432h		; 0x1885 0xb2d0 0x2345 0x2614
        bitx	65432h,65432h		; 0x1ac5 0xb090 0x260e 0x260c
        bitx.b	65432h,65432h		; 0x1ac5 0xb0d0 0x2606 0x2604
        bitx.w	65432h,65432h		; 0x1ac5 0xb090 0x25fe 0x25fc
        bitx.a	65432h,65432h		; 0x1a85 0xb0d0 0x25f6 0x25f4
	bicx	r4,r7			; 0x1840 0xc407
        bicx.b	r4,r7			; 0x1840 0xc447
        bicx.w	r4,r7			; 0x1840 0xc407
	bicx.a	r4,r7			; 0x1800 0xc447
        bicx	#4,r7			; 0x1840 0xc227
        bicx.b	#4,r7			; 0x1840 0xc267
        bicx.w	#4,r7			; 0x1840 0xc227
        bicx.a	#4,r7			; 0x1800 0xc267
        bicx	#8,r7			; 0x1840 0xc237
        bicx.b	#8,r7			; 0x1840 0xc277
        bicx.w	#8,r7			; 0x1840 0xc237
        bicx.a	#8,r7			; 0x1800 0xc277
        bicx	#0,r7			; 0x1840 0xc307
        bicx.b	#0,r7			; 0x1840 0xc347
        bicx.w	#0,r7			; 0x1840 0xc307
        bicx.a	#0,r7			; 0x1800 0xc347
        bicx	#1,r7			; 0x1840 0xc317
        bicx.b	#1,r7			; 0x1840 0xc357
        bicx.w	#1,r7			; 0x1840 0xc317
        bicx.a	#1,r7			; 0x1800 0xc357
        bicx	#2,r7			; 0x1840 0xc327
        bicx.b	#2,r7			; 0x1840 0xc367
        bicx.w	#2,r7			; 0x1840 0xc327
        bicx.a	#2,r7			; 0x1800 0xc367
        bicx	#0ffffh,r7		; 0x1840 0xc337
        bicx.b	#0ffh,r7		; 0x1840 0xc377
        bicx.w	#0ffffh,r7		; 0x1840 0xc337
        bicx.a	#0fffffh,r7		; 0x1800 0xc377
        bicx	#-1,r7			; 0x1840 0xc337
        bicx.b	#-1,r7			; 0x1840 0xc377
        bicx.w	#-1,r7			; 0x1840 0xc337
        bicx.a	#-1,r7			; 0x1800 0xc377
        bicx	#100,r7			; 0x1840 0xc037 0x0064
        bicx.b	#100,r7			; 0x1840 0xc077 0x0064
        bicx.w	#100,r7			; 0x1840 0xc037 0x0064
        bicx.a	#100000,r7		; 0x1880 0xc077 0x86a0
        bicx	@r6,r7			; 0x1840 0xc627
        bicx.b	@r6,r7			; 0x1840 0xc667
        bicx.w	@r6,r7			; 0x1840 0xc627
        bicx.a	@r6,r7			; 0x1800 0xc667
        bicx	42(r6),r7		; 0x1840 0xc617 0x002a
        bicx.b	42(r6),r7		; 0x1840 0xc657 0x002a
        bicx.w	42(r6),r7		; 0x1840 0xc617 0x002a
        bicx.a	42(r6),r7		; 0x1800 0xc657 0x002a
        bicx	@r6,r7			; 0x1840 0xc627
        bicx.b	@r6,r7			; 0x1840 0xc667
        bicx.w	@r6,r7			; 0x1840 0xc627
        bicx.a	@r6,r7			; 0x1800 0xc667
        bicx	@r6+,r7			; 0x1840 0xc637
        bicx.b	@r6+,r7			; 0x1840 0xc677
        bicx.w	@r6+,r7			; 0x1840 0xc637
        bicx.a	@r6+,r7			; 0x1800 0xc677
        bicx	&12345h,r7		; 0x18c0 0xc217 0x2345
        bicx.b	&12345h,r7		; 0x18c0 0xc257 0x2345
        bicx.w	&12345h,r7		; 0x18c0 0xc217 0x2345
        bicx.a	&12345h,r7		; 0x1880 0xc257 0x2345
        bicx	65432h,r7		; 0x1ac0 0xc017 0x24f6
        bicx.b	65432h,r7		; 0x1ac0 0xc057 0x24f0
        bicx.w	65432h,r7		; 0x1ac0 0xc017 0x24ea
        bicx.a	65432h,r7		; 0x1a80 0xc057 0x24e4
        bicx	r4,200(r8)		; 0x1840 0xc488 0x00c8
        bicx.b	r4,200(r8)		; 0x1840 0xc4c8 0x00c8
        bicx.w	r4,200(r8)		; 0x1840 0xc488 0x00c8
        bicx.a	r4,200(r8)		; 0x1800 0xc4c8 0x00c8
        bicx	#4,200(r8)		; 0x1840 0xc2a8 0x00c8
        bicx.b	#4,200(r8)		; 0x1840 0xc2e8 0x00c8
        bicx.w	#4,200(r8)		; 0x1840 0xc2a8 0x00c8
        bicx.a	#4,200(r8)		; 0x1800 0xc2e8 0x00c8
        bicx	#8,200(r8)		; 0x1840 0xc2b8 0x00c8
        bicx.b	#8,200(r8)		; 0x1840 0xc2f8 0x00c8
        bicx.w	#8,200(r8)		; 0x1840 0xc2b8 0x00c8
        bicx.a	#8,200(r8)		; 0x1800 0xc2f8 0x00c8
        bicx	#0,200(r8)		; 0x1840 0xc388 0x00c8
        bicx.b	#0,200(r8)		; 0x1840 0xc3c8 0x00c8
        bicx.w	#0,200(r8)		; 0x1840 0xc388 0x00c8
        bicx.a	#0,200(r8)		; 0x1800 0xc3c8 0x00c8
        bicx	#1,200(r8)		; 0x1840 0xc398 0x00c8
        bicx.b	#1,200(r8)		; 0x1840 0xc3d8 0x00c8
        bicx.w	#1,200(r8)		; 0x1840 0xc398 0x00c8
        bicx.a	#1,200(r8)		; 0x1800 0xc3d8 0x00c8
        bicx	#2,200(r8)		; 0x1840 0xc3a8 0x00c8
        bicx.b	#2,200(r8)		; 0x1840 0xc3e8 0x00c8
        bicx.w	#2,200(r8)		; 0x1840 0xc3a8 0x00c8
        bicx.a	#2,200(r8)		; 0x1800 0xc3e8 0x00c8
        bicx	#0ffffh,200(r8)		; 0x1840 0xc3b8 0x00c8
        bicx.b	#0ffh,200(r8)		; 0x1840 0xc3f8 0x00c8
        bicx.w	#0ffffh,200(r8)		; 0x1840 0xc3b8 0x00c8
        bicx.a	#0fffffh,200(r8)	; 0x1800 0xc3f8 0x00c8
        bicx	#-1,200(r8)		; 0x1840 0xc3b8 0x00c8
        bicx.b	#-1,200(r8)		; 0x1840 0xc3f8 0x00c8
        bicx.w	#-1,200(r8)		; 0x1840 0xc3b8 0x00c8
        bicx.a	#-1,200(r8)		; 0x1800 0xc3f8 0x00c8
        bicx	#100,200(r8)		; 0x1840 0xc0b8 0x0064 0x00c8
        bicx.b	#100,200(r8)		; 0x1840 0xc0f8 0x0064 0x00c8
        bicx.w	#100,200(r8)		; 0x1840 0xc0b8 0x0064 0x00c8
        bicx.a	#100000,200(r8)		; 0x1880 0xc0f8 0x86a0 0x00c8
        bicx	@r6,200(r8)		; 0x1840 0xc6a8 0x00c8
        bicx.b	@r6,200(r8)		; 0x1840 0xc6e8 0x00c8
        bicx.w	@r6,200(r8)		; 0x1840 0xc6a8 0x00c8
        bicx.a	@r6,200(r8)		; 0x1800 0xc6e8 0x00c8
        bicx	42(r6),200(r8)		; 0x1840 0xc698 0x002a 0x00c8
        bicx.b	42(r6),200(r8)		; 0x1840 0xc6d8 0x002a 0x00c8
        bicx.w	42(r6),200(r8)		; 0x1840 0xc698 0x002a 0x00c8
        bicx.a	42(r6),200(r8)		; 0x1800 0xc6d8 0x002a 0x00c8
        bicx	@r6,200(r8)		; 0x1840 0xc6a8 0x00c8
        bicx.b	@r6,200(r8)		; 0x1840 0xc6e8 0x00c8
        bicx.w	@r6,200(r8)		; 0x1840 0xc6a8 0x00c8
        bicx.a	@r6,200(r8)		; 0x1800 0xc6e8 0x00c8
        bicx	@r6+,200(r8)		; 0x1840 0xc6b8 0x00c8
        bicx.b	@r6+,200(r8)		; 0x1840 0xc6f8 0x00c8
        bicx.w	@r6+,200(r8)		; 0x1840 0xc6b8 0x00c8
        bicx.a	@r6+,200(r8)		; 0x1800 0xc6f8 0x00c8
        bicx	&12345h,200(r8)		; 0x18c0 0xc298 0x2345 0x00c8
        bicx.b	&12345h,200(r8)		; 0x18c0 0xc2d8 0x2345 0x00c8
        bicx.w	&12345h,200(r8)		; 0x18c0 0xc298 0x2345 0x00c8
        bicx.a	&12345h,200(r8)		; 0x1880 0xc2d8 0x2345 0x00c8
        bicx	65432h,200(r8)		; 0x1ac0 0xc098 0x2376 0x00c8
        bicx.b	65432h,200(r8)		; 0x1ac0 0xc0d8 0x236e 0x00c8
        bicx.w	65432h,200(r8)		; 0x1ac0 0xc098 0x2366 0x00c8
        bicx.a	65432h,200(r8)		; 0x1a80 0xc0d8 0x235e 0x00c8
        bicx	r4,&12345h		; 0x1841 0xc482 0x2345
        bicx.b	r4,&12345h		; 0x1841 0xc4c2 0x2345
        bicx.w	r4,&12345h		; 0x1841 0xc482 0x2345
        bicx.a	r4,&12345h		; 0x1801 0xc4c2 0x2345
        bicx	#4,&12345h		; 0x1841 0xc2a2 0x2345
        bicx.b	#4,&12345h		; 0x1841 0xc2e2 0x2345
        bicx.w	#4,&12345h		; 0x1841 0xc2a2 0x2345
        bicx.a	#4,&12345h		; 0x1801 0xc2e2 0x2345
        bicx	#8,&12345h		; 0x1841 0xc2b2 0x2345
        bicx.b	#8,&12345h		; 0x1841 0xc2f2 0x2345
        bicx.w	#8,&12345h		; 0x1841 0xc2b2 0x2345
        bicx.a	#8,&12345h		; 0x1801 0xc2f2 0x2345
        bicx	#0,&12345h		; 0x1841 0xc382 0x2345
        bicx.b	#0,&12345h		; 0x1841 0xc3c2 0x2345
        bicx.w	#0,&12345h		; 0x1841 0xc382 0x2345
        bicx.a	#0,&12345h		; 0x1801 0xc3c2 0x2345
        bicx	#1,&12345h		; 0x1841 0xc392 0x2345
        bicx.b	#1,&12345h		; 0x1841 0xc3d2 0x2345
        bicx.w	#1,&12345h		; 0x1841 0xc392 0x2345
        bicx.a	#1,&12345h		; 0x1801 0xc3d2 0x2345
        bicx	#2,&12345h		; 0x1841 0xc3a2 0x2345
        bicx.b	#2,&12345h		; 0x1841 0xc3e2 0x2345
        bicx.w	#2,&12345h		; 0x1841 0xc3a2 0x2345
        bicx.a	#2,&12345h		; 0x1801 0xc3e2 0x2345
        bicx	#0ffffh,&12345h		; 0x1841 0xc3b2 0x2345
        bicx.b	#0ffh,&12345h  		; 0x1841 0xc3f2 0x2345
        bicx.w	#0ffffh,&12345h		; 0x1841 0xc3b2 0x2345
        bicx.a	#0fffffh,&12345h	; 0x1801 0xc3f2 0x2345
        bicx	#-1,&12345h		; 0x1841 0xc3b2 0x2345
        bicx.b	#-1,&12345h		; 0x1841 0xc3f2 0x2345
        bicx.w	#-1,&12345h		; 0x1841 0xc3b2 0x2345
        bicx.a	#-1,&12345h		; 0x1801 0xc3f2 0x2345
        bicx	#100,&12345h		; 0x1841 0xc0b2 0x0064 0x2345
        bicx.b	#100,&12345h		; 0x1841 0xc0f2 0x0064 0x2345
        bicx.w	#100,&12345h		; 0x1841 0xc0b2 0x0064 0x2345
        bicx.a	#100000,&12345h		; 0x1881 0xc0f2 0x86a0 0x2345
        bicx	@r6,&12345h		; 0x1841 0xc6a2 0x2345
        bicx.b	@r6,&12345h		; 0x1841 0xc6e2 0x2345
        bicx.w	@r6,&12345h		; 0x1841 0xc6a2 0x2345
        bicx.a	@r6,&12345h		; 0x1801 0xc6e2 0x2345
        bicx	42(r6),&12345h		; 0x1841 0xc692 0x002a 0x2345
        bicx.b	42(r6),&12345h		; 0x1841 0xc6d2 0x002a 0x2345
        bicx.w	42(r6),&12345h		; 0x1841 0xc692 0x002a 0x2345
        bicx.a	42(r6),&12345h		; 0x1801 0xc6d2 0x002a 0x2345
        bicx	@r6,&12345h		; 0x1841 0xc6a2 0x2345
        bicx.b	@r6,&12345h		; 0x1841 0xc6e2 0x2345
        bicx.w	@r6,&12345h		; 0x1841 0xc6a2 0x2345
        bicx.a	@r6,&12345h		; 0x1801 0xc6e2 0x2345
        bicx	@r6+,&12345h		; 0x1841 0xc6b2 0x2345
        bicx.b	@r6+,&12345h		; 0x1841 0xc6f2 0x2345
        bicx.w	@r6+,&12345h		; 0x1841 0xc6b2 0x2345
        bicx.a	@r6+,&12345h		; 0x1801 0xc6f2 0x2345
        bicx	&12345h,&12345h		; 0x18c1 0xc292 0x2345 0x2345
        bicx.b	&12345h,&12345h		; 0x18c1 0xc2d2 0x2345 0x2345
        bicx.w	&12345h,&12345h		; 0x18c1 0xc292 0x2345 0x2345
        bicx.a	&12345h,&12345h		; 0x1881 0xc2d2 0x2345 0x2345
        bicx	65432h,&12345h		; 0x1ac1 0xc092 0x21ee 0x2345
        bicx.b	65432h,&12345h		; 0x1ac1 0xc0d2 0x21e6 0x2345
        bicx.w	65432h,&12345h		; 0x1ac1 0xc092 0x21de 0x2345
        bicx.a	65432h,&12345h		; 0x1a81 0xc0d2 0x21d6 0x2345
        bicx	r4,65432h		; 0x1845 0xc480 0x21ce
        bicx.b	r4,65432h		; 0x1845 0xc4c0 0x21c8
        bicx.w	r4,65432h		; 0x1845 0xc480 0x21c2
        bicx.a	r4,65432h		; 0x1805 0xc4c0 0x21bc
        bicx	#4,65432h		; 0x1845 0xc2a0 0x21b6
        bicx.b	#4,65432h		; 0x1845 0xc2e0 0x21b0
        bicx.w	#4,65432h		; 0x1845 0xc2a0 0x21aa
        bicx.a	#4,65432h		; 0x1805 0xc2e0 0x21a4
        bicx	#8,65432h		; 0x1845 0xc2b0 0x219e
        bicx.b	#8,65432h		; 0x1845 0xc2f0 0x2198
        bicx.w	#8,65432h		; 0x1845 0xc2b0 0x2192
        bicx.a	#8,65432h		; 0x1805 0xc2f0 0x218c
        bicx	#0,65432h		; 0x1845 0xc380 0x2186
        bicx.b	#0,65432h		; 0x1845 0xc3c0 0x2180
        bicx.w	#0,65432h		; 0x1845 0xc380 0x217a
        bicx.a	#0,65432h		; 0x1805 0xc3c0 0x2174
        bicx	#1,65432h		; 0x1845 0xc390 0x216e
        bicx.b	#1,65432h		; 0x1845 0xc3d0 0x2168
        bicx.w	#1,65432h		; 0x1845 0xc390 0x2162
        bicx.a	#1,65432h		; 0x1805 0xc3d0 0x215c
        bicx	#2,65432h		; 0x1845 0xc3a0 0x2156
        bicx.b	#2,65432h		; 0x1845 0xc3e0 0x2150
        bicx.w	#2,65432h		; 0x1845 0xc3a0 0x214a
        bicx.a	#2,65432h		; 0x1805 0xc3e0 0x2144
        bicx	#0ffffh,65432h		; 0x1845 0xc3b0 0x213e
        bicx.b	#0ffh,65432h  		; 0x1845 0xc3f0 0x2138
        bicx.w	#0ffffh,65432h		; 0x1845 0xc3b0 0x2132
        bicx.a	#0fffffh,65432h		; 0x1805 0xc3f0 0x212c
        bicx	#-1,65432h		; 0x1845 0xc3b0 0x2126
        bicx.b	#-1,65432h		; 0x1845 0xc3f0 0x2120
        bicx.w	#-1,65432h		; 0x1845 0xc3b0 0x211a
        bicx.a	#-1,65432h		; 0x1805 0xc3f0 0x2114
        bicx	#100,65432h		; 0x1845 0xc0b0 0x0064 0x210c
        bicx.b	#100,65432h		; 0x1845 0xc0f0 0x0064 0x2104
        bicx.w	#100,65432h		; 0x1845 0xc0b0 0x0064 0x20fc
        bicx.a	#100000,65432h		; 0x1885 0xc0f0 0x86a0 0x20f4
        bicx	@r6,65432h		; 0x1845 0xc6a0 0x20ee
        bicx.b	@r6,65432h		; 0x1845 0xc6e0 0x20e8
        bicx.w	@r6,65432h		; 0x1845 0xc6a0 0x20e2
        bicx.a	@r6,65432h		; 0x1805 0xc6e0 0x20d2
        bicx	42(r6),65432h		; 0x1845 0xc690 0x002a 0x20d4
        bicx.b	42(r6),65432h		; 0x1845 0xc6d0 0x002a 0x20cc
        bicx.w	42(r6),65432h		; 0x1845 0xc690 0x002a 0x20c4
        bicx.a	42(r6),65432h		; 0x1805 0xc6d0 0x002a 0x20bc
        bicx	@r6,65432h		; 0x1845 0xc6a0 0x20b6
        bicx.b	@r6,65432h		; 0x1845 0xc6e0 0x20b0
        bicx.w	@r6,65432h		; 0x1845 0xc6a0 0x20aa
        bicx.a	@r6,65432h		; 0x1805 0xc6e0 0x20a4
        bicx	@r6+,65432h		; 0x1845 0xc6b0 0x209e
        bicx.b	@r6+,65432h		; 0x1845 0xc6f0 0x2098
        bicx.w	@r6+,65432h		; 0x1845 0xc6b0 0x2092
        bicx.a	@r6+,65432h		; 0x1805 0xc6f0 0x208c
        bicx	&12345h,65432h		; 0x18c5 0xc290 0x2345 0x2084
        bicx.b	&12345h,65432h		; 0x18c5 0xc2d0 0x2345 0x207c
        bicx.w	&12345h,65432h		; 0x18c5 0xc290 0x2345 0x2074
        bicx.a	&12345h,65432h		; 0x1885 0xc2d0 0x2345 0x206c
        bicx	65432h,65432h		; 0x1ac5 0xc090 0x2066 0x2064
        bicx.b	65432h,65432h		; 0x1ac5 0xc0d0 0x205e 0x205c
        bicx.w	65432h,65432h		; 0x1ac5 0xc090 0x2056 0x2054
        bicx.a	65432h,65432h		; 0x1a85 0xc0d0 0x204e 0x204c
	bisx	r4,r7			; 0x1840 0xd407
        bisx.b	r4,r7			; 0x1840 0xd447
        bisx.w	r4,r7			; 0x1840 0xd407
	bisx.a	r4,r7			; 0x1800 0xd447
        bisx	#4,r7			; 0x1840 0xd227
        bisx.b	#4,r7			; 0x1840 0xd267
        bisx.w	#4,r7			; 0x1840 0xd227
        bisx.a	#4,r7			; 0x1800 0xd267
        bisx	#8,r7			; 0x1840 0xd237
        bisx.b	#8,r7			; 0x1840 0xd277
        bisx.w	#8,r7			; 0x1840 0xd237
        bisx.a	#8,r7			; 0x1800 0xd277
        bisx	#0,r7			; 0x1840 0xd307
        bisx.b	#0,r7			; 0x1840 0xd347
        bisx.w	#0,r7			; 0x1840 0xd307
        bisx.a	#0,r7			; 0x1800 0xd347
        bisx	#1,r7			; 0x1840 0xd317
        bisx.b	#1,r7			; 0x1840 0xd357
        bisx.w	#1,r7			; 0x1840 0xd317
        bisx.a	#1,r7			; 0x1800 0xd357
        bisx	#2,r7			; 0x1840 0xd327
        bisx.b	#2,r7			; 0x1840 0xd367
        bisx.w	#2,r7			; 0x1840 0xd327
        bisx.a	#2,r7			; 0x1800 0xd367
        bisx	#0ffffh,r7		; 0x1840 0xd337
        bisx.b	#0ffh,r7		; 0x1840 0xd377
        bisx.w	#0ffffh,r7		; 0x1840 0xd337
        bisx.a	#0fffffh,r7		; 0x1800 0xd377
        bisx	#-1,r7			; 0x1840 0xd337
        bisx.b	#-1,r7			; 0x1840 0xd377
        bisx.w	#-1,r7			; 0x1840 0xd337
        bisx.a	#-1,r7			; 0x1800 0xd377
        bisx	#100,r7			; 0x1840 0xd037 0x0064
        bisx.b	#100,r7			; 0x1840 0xd077 0x0064
        bisx.w	#100,r7			; 0x1840 0xd037 0x0064
        bisx.a	#100000,r7		; 0x1880 0xd077 0x86a0
        bisx	@r6,r7			; 0x1840 0xd627
        bisx.b	@r6,r7			; 0x1840 0xd667
        bisx.w	@r6,r7			; 0x1840 0xd627
        bisx.a	@r6,r7			; 0x1800 0xd667
        bisx	42(r6),r7		; 0x1840 0xd617 0x002a
        bisx.b	42(r6),r7		; 0x1840 0xd657 0x002a
        bisx.w	42(r6),r7		; 0x1840 0xd617 0x002a
        bisx.a	42(r6),r7		; 0x1800 0xd657 0x002a
        bisx	@r6,r7			; 0x1840 0xd627
        bisx.b	@r6,r7			; 0x1840 0xd667
        bisx.w	@r6,r7			; 0x1840 0xd627
        bisx.a	@r6,r7			; 0x1800 0xd667
        bisx	@r6+,r7			; 0x1840 0xd637
        bisx.b	@r6+,r7			; 0x1840 0xd677
        bisx.w	@r6+,r7			; 0x1840 0xd637
        bisx.a	@r6+,r7			; 0x1800 0xd677
        bisx	&12345h,r7		; 0x18c0 0xd217 0x2345
        bisx.b	&12345h,r7		; 0x18c0 0xd257 0x2345
        bisx.w	&12345h,r7		; 0x18c0 0xd217 0x2345
        bisx.a	&12345h,r7		; 0x1880 0xd257 0x2345
        bisx	65432h,r7		; 0x1ac0 0xd017 0x1f4e
        bisx.b	65432h,r7		; 0x1ac0 0xd057 0x1f48
        bisx.w	65432h,r7		; 0x1ac0 0xd017 0x1f42
        bisx.a	65432h,r7		; 0x1a80 0xd057 0x1f3c
        bisx	r4,200(r8)		; 0x1840 0xd488 0x00c8
        bisx.b	r4,200(r8)		; 0x1840 0xd4c8 0x00c8
        bisx.w	r4,200(r8)		; 0x1840 0xd488 0x00c8
        bisx.a	r4,200(r8)		; 0x1800 0xd4c8 0x00c8
        bisx	#4,200(r8)		; 0x1840 0xd2a8 0x00c8
        bisx.b	#4,200(r8)		; 0x1840 0xd2e8 0x00c8
        bisx.w	#4,200(r8)		; 0x1840 0xd2a8 0x00c8
        bisx.a	#4,200(r8)		; 0x1800 0xd2e8 0x00c8
        bisx	#8,200(r8)		; 0x1840 0xd2b8 0x00c8
        bisx.b	#8,200(r8)		; 0x1840 0xd2f8 0x00c8
        bisx.w	#8,200(r8)		; 0x1840 0xd2b8 0x00c8
        bisx.a	#8,200(r8)		; 0x1800 0xd2f8 0x00c8
        bisx	#0,200(r8)		; 0x1840 0xd388 0x00c8
        bisx.b	#0,200(r8)		; 0x1840 0xd3c8 0x00c8
        bisx.w	#0,200(r8)		; 0x1840 0xd388 0x00c8
        bisx.a	#0,200(r8)		; 0x1800 0xd3c8 0x00c8
        bisx	#1,200(r8)		; 0x1840 0xd398 0x00c8
        bisx.b	#1,200(r8)		; 0x1840 0xd3d8 0x00c8
        bisx.w	#1,200(r8)		; 0x1840 0xd398 0x00c8
        bisx.a	#1,200(r8)		; 0x1800 0xd3d8 0x00c8
        bisx	#2,200(r8)		; 0x1840 0xd3a8 0x00c8
        bisx.b	#2,200(r8)		; 0x1840 0xd3e8 0x00c8
        bisx.w	#2,200(r8)		; 0x1840 0xd3a8 0x00c8
        bisx.a	#2,200(r8)		; 0x1800 0xd3e8 0x00c8
        bisx	#0ffffh,200(r8)		; 0x1840 0xd3b8 0x00c8
        bisx.b	#0ffh,200(r8)		; 0x1840 0xd3f8 0x00c8
        bisx.w	#0ffffh,200(r8)		; 0x1840 0xd3b8 0x00c8
        bisx.a	#0fffffh,200(r8)	; 0x1800 0xd3f8 0x00c8
        bisx	#-1,200(r8)		; 0x1840 0xd3b8 0x00c8
        bisx.b	#-1,200(r8)		; 0x1840 0xd3f8 0x00c8
        bisx.w	#-1,200(r8)		; 0x1840 0xd3b8 0x00c8
        bisx.a	#-1,200(r8)		; 0x1800 0xd3f8 0x00c8
        bisx	#100,200(r8)		; 0x1840 0xd0b8 0x0064 0x00c8
        bisx.b	#100,200(r8)		; 0x1840 0xd0f8 0x0064 0x00c8
        bisx.w	#100,200(r8)		; 0x1840 0xd0b8 0x0064 0x00c8
        bisx.a	#100000,200(r8)		; 0x1880 0xd0f8 0x86a0 0x00c8
        bisx	@r6,200(r8)		; 0x1840 0xd6a8 0x00c8
        bisx.b	@r6,200(r8)		; 0x1840 0xd6e8 0x00c8
        bisx.w	@r6,200(r8)		; 0x1840 0xd6a8 0x00c8
        bisx.a	@r6,200(r8)		; 0x1800 0xd6e8 0x00c8
        bisx	42(r6),200(r8)		; 0x1840 0xd698 0x002a 0x00c8
        bisx.b	42(r6),200(r8)		; 0x1840 0xd6d8 0x002a 0x00c8
        bisx.w	42(r6),200(r8)		; 0x1840 0xd698 0x002a 0x00c8
        bisx.a	42(r6),200(r8)		; 0x1800 0xd6d8 0x002a 0x00c8
        bisx	@r6,200(r8)		; 0x1840 0xd6a8 0x00c8
        bisx.b	@r6,200(r8)		; 0x1840 0xd6e8 0x00c8
        bisx.w	@r6,200(r8)		; 0x1840 0xd6a8 0x00c8
        bisx.a	@r6,200(r8)		; 0x1800 0xd6e8 0x00c8
        bisx	@r6+,200(r8)		; 0x1840 0xd6b8 0x00c8
        bisx.b	@r6+,200(r8)		; 0x1840 0xd6f8 0x00c8
        bisx.w	@r6+,200(r8)		; 0x1840 0xd6b8 0x00c8
        bisx.a	@r6+,200(r8)		; 0x1800 0xd6f8 0x00c8
        bisx	&12345h,200(r8)		; 0x18c0 0xd298 0x2345 0x00c8
        bisx.b	&12345h,200(r8)		; 0x18c0 0xd2d8 0x2345 0x00c8
        bisx.w	&12345h,200(r8)		; 0x18c0 0xd298 0x2345 0x00c8
        bisx.a	&12345h,200(r8)		; 0x1880 0xd2d8 0x2345 0x00c8
        bisx	65432h,200(r8)		; 0x1ac0 0xd098 0x1dce 0x00c8
        bisx.b	65432h,200(r8)		; 0x1ac0 0xd0d8 0x1dc6 0x00c8
        bisx.w	65432h,200(r8)		; 0x1ac0 0xd098 0x1dbe 0x00c8
        bisx.a	65432h,200(r8)		; 0x1ac0 0xd0d8 0x1db6 0x00c8
        bisx	r4,&12345h		; 0x1841 0xd482 0x2345
        bisx.b	r4,&12345h		; 0x1841 0xd4c2 0x2345
        bisx.w	r4,&12345h		; 0x1841 0xd482 0x2345
        bisx.a	r4,&12345h		; 0x1801 0xd4c2 0x2345
        bisx	#4,&12345h		; 0x1841 0xd2a2 0x2345
        bisx.b	#4,&12345h		; 0x1841 0xd2e2 0x2345
        bisx.w	#4,&12345h		; 0x1841 0xd2a2 0x2345
        bisx.a	#4,&12345h		; 0x1801 0xd2e2 0x2345
        bisx	#8,&12345h		; 0x1841 0xd2b2 0x2345
        bisx.b	#8,&12345h		; 0x1841 0xd2f2 0x2345
        bisx.w	#8,&12345h		; 0x1841 0xd2b2 0x2345
        bisx.a	#8,&12345h		; 0x1801 0xd2f2 0x2345
        bisx	#0,&12345h		; 0x1841 0xd382 0x2345
        bisx.b	#0,&12345h		; 0x1841 0xd3c2 0x2345
        bisx.w	#0,&12345h		; 0x1841 0xd382 0x2345
        bisx.a	#0,&12345h		; 0x1801 0xd3c2 0x2345
        bisx	#1,&12345h		; 0x1841 0xd392 0x2345
        bisx.b	#1,&12345h		; 0x1841 0xd3d2 0x2345
        bisx.w	#1,&12345h		; 0x1841 0xd392 0x2345
        bisx.a	#1,&12345h		; 0x1801 0xd3d2 0x2345
        bisx	#2,&12345h		; 0x1841 0xd3a2 0x2345
        bisx.b	#2,&12345h		; 0x1841 0xd3e2 0x2345
        bisx.w	#2,&12345h		; 0x1841 0xd3a2 0x2345
        bisx.a	#2,&12345h		; 0x1801 0xd3e2 0x2345
        bisx	#0ffffh,&12345h		; 0x1841 0xd3b2 0x2345
        bisx.b	#0ffh,&12345h  		; 0x1841 0xd3f2 0x2345
        bisx.w	#0ffffh,&12345h		; 0x1841 0xd3b2 0x2345
        bisx.a	#0fffffh,&12345h	; 0x1801 0xd3f2 0x2345
        bisx	#-1,&12345h		; 0x1841 0xd3b2 0x2345
        bisx.b	#-1,&12345h		; 0x1841 0xd3f2 0x2345
        bisx.w	#-1,&12345h		; 0x1841 0xd3b2 0x2345
        bisx.a	#-1,&12345h		; 0x1801 0xd3f2 0x2345
        bisx	#100,&12345h		; 0x1841 0xd0b2 0x0064 0x2345
        bisx.b	#100,&12345h		; 0x1841 0xd0f2 0x0064 0x2345
        bisx.w	#100,&12345h		; 0x1841 0xd0b2 0x0064 0x2345
        bisx.a	#100000,&12345h		; 0x1881 0xd0f2 0x86a0 0x2345
        bisx	@r6,&12345h		; 0x1841 0xd6a2 0x2345
        bisx.b	@r6,&12345h		; 0x1841 0xd6e2 0x2345
        bisx.w	@r6,&12345h		; 0x1841 0xd6a2 0x2345
        bisx.a	@r6,&12345h		; 0x1801 0xd6e2 0x2345
        bisx	42(r6),&12345h		; 0x1841 0xd692 0x002a 0x2345
        bisx.b	42(r6),&12345h		; 0x1841 0xd6d2 0x002a 0x2345
        bisx.w	42(r6),&12345h		; 0x1841 0xd692 0x002a 0x2345
        bisx.a	42(r6),&12345h		; 0x1801 0xd6d2 0x002a 0x2345
        bisx	@r6,&12345h		; 0x1841 0xd6a2 0x2345
        bisx.b	@r6,&12345h		; 0x1841 0xd6e2 0x2345
        bisx.w	@r6,&12345h		; 0x1841 0xd6a2 0x2345
        bisx.a	@r6,&12345h		; 0x1801 0xd6e2 0x2345
        bisx	@r6+,&12345h		; 0x1841 0xd6b2 0x2345
        bisx.b	@r6+,&12345h		; 0x1841 0xd6f2 0x2345
        bisx.w	@r6+,&12345h		; 0x1841 0xd6b2 0x2345
        bisx.a	@r6+,&12345h		; 0x1801 0xd6f2 0x2345
        bisx	&12345h,&12345h		; 0x18c1 0xd292 0x2345 0x2345
        bisx.b	&12345h,&12345h		; 0x18c1 0xd2d2 0x2345 0x2345
        bisx.w	&12345h,&12345h		; 0x18c1 0xd292 0x2345 0x2345
        bisx.a	&12345h,&12345h		; 0x1881 0xd2d2 0x2345 0x2345
        bisx	65432h,&12345h		; 0x1ac1 0xd092 0x1c46 0x2345
        bisx.b	65432h,&12345h		; 0x1ac1 0xd0d2 0x1c3e 0x2345
        bisx.w	65432h,&12345h		; 0x1ac1 0xd092 0x1c36 0x2345
        bisx.a	65432h,&12345h		; 0x1a81 0xd0d2 0x1c2e 0x2345
        bisx	r4,65432h		; 0x1845 0xd480 0x1c26
        bisx.b	r4,65432h		; 0x1845 0xd4c0 0x1c20
        bisx.w	r4,65432h		; 0x1845 0xd480 0x1c1a
        bisx.a	r4,65432h		; 0x1805 0xd4c0 0x1c14
        bisx	#4,65432h		; 0x1845 0xd2a0 0x1c0e
        bisx.b	#4,65432h		; 0x1845 0xd2e0 0x1c08
        bisx.w	#4,65432h		; 0x1845 0xd2a0 0x1c02
        bisx.a	#4,65432h		; 0x1805 0xd2e0 0x1bf2
        bisx	#8,65432h		; 0x1845 0xd2b0 0x1bf6
        bisx.b	#8,65432h		; 0x1845 0xd2f0 0x1bf0
        bisx.w	#8,65432h		; 0x1845 0xd2b0 0x1bea
        bisx.a	#8,65432h		; 0x1805 0xd2f0 0x1be4
        bisx	#0,65432h		; 0x1845 0xd380 0x1bde
        bisx.b	#0,65432h		; 0x1845 0xd3c0 0x1bd8
        bisx.w	#0,65432h		; 0x1845 0xd380 0x1bd2
        bisx.a	#0,65432h		; 0x1805 0xd3c0 0x1bcc
        bisx	#1,65432h		; 0x1845 0xd390 0x1bc6
        bisx.b	#1,65432h		; 0x1845 0xd3d0 0x1bc0
        bisx.w	#1,65432h		; 0x1845 0xd390 0x1bba
        bisx.a	#1,65432h		; 0x1805 0xd3d0 0x1bb4
        bisx	#2,65432h		; 0x1845 0xd3a0 0x1bae
        bisx.b	#2,65432h		; 0x1845 0xd3e0 0x1ba8
        bisx.w	#2,65432h		; 0x1845 0xd3a0 0x1ba2
        bisx.a	#2,65432h		; 0x1805 0xd3e0 0x1b9c
        bisx	#0ffffh,65432h		; 0x1845 0xd3b0 0x1b96
        bisx.b	#0ffh,65432h  		; 0x1845 0xd3f0 0x1b90
        bisx.w	#0ffffh,65432h		; 0x1845 0xd3b0 0x1b8a
        bisx.a	#0fffffh,65432h		; 0x1805 0xd3f0 0x1b84
        bisx	#-1,65432h		; 0x1845 0xd3b0 0x1b7e
        bisx.b	#-1,65432h		; 0x1845 0xd3f0 0x1b78
        bisx.w	#-1,65432h		; 0x1845 0xd3b0 0x1b72
        bisx.a	#-1,65432h		; 0x1805 0xd3f0 0x1b6c
        bisx	#100,65432h		; 0x1845 0xd0b0 0x0064 0x1b64
        bisx.b	#100,65432h		; 0x1845 0xd0f0 0x0064 0x1b5c
        bisx.w	#100,65432h		; 0x1845 0xd0b0 0x0064 0x1b54
        bisx.a	#100000,65432h		; 0x1885 0xd0f0 0x86a0 0x1b4c
        bisx	@r6,65432h		; 0x1845 0xd6a0 0x1b46
        bisx.b	@r6,65432h		; 0x1845 0xd6e0 0x1b40
        bisx.w	@r6,65432h		; 0x1845 0xd6a0 0x1b3a
        bisx.a	@r6,65432h		; 0x1805 0xd6e0 0x1b34
        bisx	42(r6),65432h		; 0x1845 0xd690 0x002a 0x1b2c
        bisx.b	42(r6),65432h		; 0x1845 0xd6d0 0x002a 0x1b24
        bisx.w	42(r6),65432h		; 0x1845 0xd690 0x002a 0x1b1c
        bisx.a	42(r6),65432h		; 0x1805 0xd6d0 0x002a 0x1b14
        bisx	@r6,65432h		; 0x1845 0xd6a0 0x1b0e
        bisx.b	@r6,65432h		; 0x1845 0xd6e0 0x1b08
        bisx.w	@r6,65432h		; 0x1845 0xd6a0 0x1b02
        bisx.a	@r6,65432h		; 0x1805 0xd6e0 0x1afc
        bisx	@r6+,65432h		; 0x1845 0xd6b0 0x1af6
        bisx.b	@r6+,65432h		; 0x1845 0xd6f0 0x1af0
        bisx.w	@r6+,65432h		; 0x1845 0xd6b0 0x1aea
        bisx.a	@r6+,65432h		; 0x1805 0xd6f0 0x1ae4
        bisx	&12345h,65432h		; 0x18c5 0xd290 0x2345 0x1adc
        bisx.b	&12345h,65432h		; 0x18c5 0xd2d0 0x2345 0x1ad4
        bisx.w	&12345h,65432h		; 0x18c5 0xd290 0x2345 0x1acc
        bisx.a	&12345h,65432h		; 0x1885 0xd2d0 0x2345 0x1ac4
        bisx	65432h,65432h		; 0x1ac5 0xd090 0x1abe 0x1abc
        bisx.b	65432h,65432h		; 0x1ac5 0xd0d0 0x1ab6 0x1ab4
        bisx.w	65432h,65432h		; 0x1ac5 0xd090 0x1aae 0x1aac
        bisx.a	65432h,65432h		; 0x1a85 0xd0d0 0x1aa6 0x1aa4
	xorx	r4,r7			; 0x1840 0xe407
        xorx.b	r4,r7			; 0x1840 0xe447
        xorx.w	r4,r7			; 0x1840 0xe407
	xorx.a	r4,r7			; 0x1800 0xe447
        xorx	#4,r7			; 0x1840 0xe227
        xorx.b	#4,r7			; 0x1840 0xe267
        xorx.w	#4,r7			; 0x1840 0xe227
        xorx.a	#4,r7			; 0x1800 0xe267
        xorx	#8,r7			; 0x1840 0xe237
        xorx.b	#8,r7			; 0x1840 0xe277
        xorx.w	#8,r7			; 0x1840 0xe237
        xorx.a	#8,r7			; 0x1800 0xe277
        xorx	#0,r7			; 0x1840 0xe307
        xorx.b	#0,r7			; 0x1840 0xe347
        xorx.w	#0,r7			; 0x1840 0xe307
        xorx.a	#0,r7			; 0x1800 0xe347
        xorx	#1,r7			; 0x1840 0xe317
        xorx.b	#1,r7			; 0x1840 0xe357
        xorx.w	#1,r7			; 0x1840 0xe317
        xorx.a	#1,r7			; 0x1800 0xe357
        xorx	#2,r7			; 0x1840 0xe327
        xorx.b	#2,r7			; 0x1840 0xe367
        xorx.w	#2,r7			; 0x1840 0xe327
        xorx.a	#2,r7			; 0x1800 0xe367
        xorx	#0ffffh,r7		; 0x1840 0xe337
        xorx.b	#0ffh,r7		; 0x1840 0xe377
        xorx.w	#0ffffh,r7		; 0x1840 0xe337
        xorx.a	#0fffffh,r7		; 0x1800 0xe377
        xorx	#-1,r7			; 0x1840 0xe337
        xorx.b	#-1,r7			; 0x1840 0xe377
        xorx.w	#-1,r7			; 0x1840 0xe337
        xorx.a	#-1,r7			; 0x1800 0xe377
        xorx	#100,r7			; 0x1840 0xe037 0x0064
        xorx.b	#100,r7			; 0x1840 0xe077 0x0064
        xorx.w	#100,r7			; 0x1840 0xe037 0x0064
        xorx.a	#100000,r7		; 0x1880 0xe077 0x86a0
        xorx	@r6,r7			; 0x1840 0xe627
        xorx.b	@r6,r7			; 0x1840 0xe667
        xorx.w	@r6,r7			; 0x1840 0xe627
        xorx.a	@r6,r7			; 0x1800 0xe667
        xorx	42(r6),r7		; 0x1840 0xe617 0x002a
        xorx.b	42(r6),r7		; 0x1840 0xe657 0x002a
        xorx.w	42(r6),r7		; 0x1840 0xe617 0x002a
        xorx.a	42(r6),r7		; 0x1800 0xe657 0x002a
        xorx	@r6,r7			; 0x1840 0xe627
        xorx.b	@r6,r7			; 0x1840 0xe667
        xorx.w	@r6,r7			; 0x1840 0xe627
        xorx.a	@r6,r7			; 0x1800 0xe667
        xorx	@r6+,r7			; 0x1840 0xe637
        xorx.b	@r6+,r7			; 0x1840 0xe677
        xorx.w	@r6+,r7			; 0x1840 0xe637
        xorx.a	@r6+,r7			; 0x1800 0xe677
        xorx	&12345h,r7		; 0x18c0 0xe217 0x2345
        xorx.b	&12345h,r7		; 0x18c0 0xe257 0x2345
        xorx.w	&12345h,r7		; 0x18c0 0xe217 0x2345
        xorx.a	&12345h,r7		; 0x1880 0xe257 0x2345
        xorx	65432h,r7		; 0x1ac0 0xe017 0x19a6
        xorx.b	65432h,r7		; 0x1ac0 0xe057 0x19a0
        xorx.w	65432h,r7		; 0x1ac0 0xe017 0x199a
        xorx.a	65432h,r7		; 0x1a80 0xe057 0x1994
        xorx	r4,200(r8)		; 0x1840 0xe488 0x00c8
        xorx.b	r4,200(r8)		; 0x1840 0xe4c8 0x00c8
        xorx.w	r4,200(r8)		; 0x1840 0xe488 0x00c8
        xorx.a	r4,200(r8)		; 0x1800 0xe4c8 0x00c8
        xorx	#4,200(r8)		; 0x1840 0xe2a8 0x00c8
        xorx.b	#4,200(r8)		; 0x1840 0xe2e8 0x00c8
        xorx.w	#4,200(r8)		; 0x1840 0xe2a8 0x00c8
        xorx.a	#4,200(r8)		; 0x1800 0xe2e8 0x00c8
        xorx	#8,200(r8)		; 0x1840 0xe2b8 0x00c8
        xorx.b	#8,200(r8)		; 0x1840 0xe2f8 0x00c8
        xorx.w	#8,200(r8)		; 0x1840 0xe2b8 0x00c8
        xorx.a	#8,200(r8)		; 0x1800 0xe2f8 0x00c8
        xorx	#0,200(r8)		; 0x1840 0xe388 0x00c8
        xorx.b	#0,200(r8)		; 0x1840 0xe3c8 0x00c8
        xorx.w	#0,200(r8)		; 0x1840 0xe388 0x00c8
        xorx.a	#0,200(r8)		; 0x1800 0xe3c8 0x00c8
        xorx	#1,200(r8)		; 0x1840 0xe398 0x00c8
        xorx.b	#1,200(r8)		; 0x1840 0xe3d8 0x00c8
        xorx.w	#1,200(r8)		; 0x1840 0xe398 0x00c8
        xorx.a	#1,200(r8)		; 0x1800 0xe3d8 0x00c8
        xorx	#2,200(r8)		; 0x1840 0xe3a8 0x00c8
        xorx.b	#2,200(r8)		; 0x1840 0xe3e8 0x00c8
        xorx.w	#2,200(r8)		; 0x1840 0xe3a8 0x00c8
        xorx.a	#2,200(r8)		; 0x1800 0xe3e8 0x00c8
        xorx	#0ffffh,200(r8)		; 0x1840 0xe3b8 0x00c8
        xorx.b	#0ffh,200(r8)		; 0x1840 0xe3f8 0x00c8
        xorx.w	#0ffffh,200(r8)		; 0x1840 0xe3b8 0x00c8
        xorx.a	#0fffffh,200(r8)	; 0x1800 0xe3f8 0x00c8
        xorx	#-1,200(r8)		; 0x1840 0xe3b8 0x00c8
        xorx.b	#-1,200(r8)		; 0x1840 0xe3f8 0x00c8
        xorx.w	#-1,200(r8)		; 0x1840 0xe3b8 0x00c8
        xorx.a	#-1,200(r8)		; 0x1800 0xe3f8 0x00c8
        xorx	#100,200(r8)		; 0x1840 0xe0b8 0x0064 0x00c8
        xorx.b	#100,200(r8)		; 0x1840 0xe0f8 0x0064 0x00c8
        xorx.w	#100,200(r8)		; 0x1840 0xe0b8 0x0064 0x00c8
        xorx.a	#100000,200(r8)		; 0x1880 0xe0f8 0x86a0 0x00c8
        xorx	@r6,200(r8)		; 0x1840 0xe6a8 0x00c8
        xorx.b	@r6,200(r8)		; 0x1840 0xe6e8 0x00c8
        xorx.w	@r6,200(r8)		; 0x1840 0xe6a8 0x00c8
        xorx.a	@r6,200(r8)		; 0x1800 0xe6e8 0x00c8
        xorx	42(r6),200(r8)		; 0x1840 0xe698 0x002a 0x00c8
        xorx.b	42(r6),200(r8)		; 0x1840 0xe6d8 0x002a 0x00c8
        xorx.w	42(r6),200(r8)		; 0x1840 0xe698 0x002a 0x00c8
        xorx.a	42(r6),200(r8)		; 0x1800 0xe6d8 0x002a 0x00c8
        xorx	@r6,200(r8)		; 0x1840 0xe6a8 0x00c8
        xorx.b	@r6,200(r8)		; 0x1840 0xe6e8 0x00c8
        xorx.w	@r6,200(r8)		; 0x1840 0xe6a8 0x00c8
        xorx.a	@r6,200(r8)		; 0x1800 0xe6e8 0x00c8
        xorx	@r6+,200(r8)		; 0x1840 0xe6b8 0x00c8
        xorx.b	@r6+,200(r8)		; 0x1840 0xe6f8 0x00c8
        xorx.w	@r6+,200(r8)		; 0x1840 0xe6b8 0x00c8
        xorx.a	@r6+,200(r8)		; 0x1800 0xe6f8 0x00c8
        xorx	&12345h,200(r8)		; 0x18c0 0xe298 0x2345 0x00c8
        xorx.b	&12345h,200(r8)		; 0x18c0 0xe2d8 0x2345 0x00c8
        xorx.w	&12345h,200(r8)		; 0x18c0 0xe298 0x2345 0x00c8
        xorx.a	&12345h,200(r8)		; 0x1880 0xe2d8 0x2345 0x00c8
        xorx	65432h,200(r8)		; 0x1ac0 0xe098 0x1826 0x00c8
        xorx.b	65432h,200(r8)		; 0x1ac0 0xe0d8 0x181e 0x00c8
        xorx.w	65432h,200(r8)		; 0x1ac0 0xe098 0x1816 0x00c8
        xorx.a	65432h,200(r8)		; 0x1ac0 0xe0d8 0x180e 0x00c8
        xorx	r4,&12345h		; 0x1841 0xe482 0x2345
        xorx.b	r4,&12345h		; 0x1841 0xe4c2 0x2345
        xorx.w	r4,&12345h		; 0x1841 0xe482 0x2345
        xorx.a	r4,&12345h		; 0x1801 0xe4c2 0x2345
        xorx	#4,&12345h		; 0x1841 0xe2a2 0x2345
        xorx.b	#4,&12345h		; 0x1841 0xe2e2 0x2345
        xorx.w	#4,&12345h		; 0x1841 0xe2a2 0x2345
        xorx.a	#4,&12345h		; 0x1801 0xe2e2 0x2345
        xorx	#8,&12345h		; 0x1841 0xe2b2 0x2345
        xorx.b	#8,&12345h		; 0x1841 0xe2f2 0x2345
        xorx.w	#8,&12345h		; 0x1841 0xe2b2 0x2345
        xorx.a	#8,&12345h		; 0x1801 0xe2f2 0x2345
        xorx	#0,&12345h		; 0x1841 0xe382 0x2345
        xorx.b	#0,&12345h		; 0x1841 0xe3c2 0x2345
        xorx.w	#0,&12345h		; 0x1841 0xe382 0x2345
        xorx.a	#0,&12345h		; 0x1801 0xe3c2 0x2345
        xorx	#1,&12345h		; 0x1841 0xe392 0x2345
        xorx.b	#1,&12345h		; 0x1841 0xe3d2 0x2345
        xorx.w	#1,&12345h		; 0x1841 0xe392 0x2345
        xorx.a	#1,&12345h		; 0x1801 0xe3d2 0x2345
        xorx	#2,&12345h		; 0x1841 0xe3a2 0x2345
        xorx.b	#2,&12345h		; 0x1841 0xe3e2 0x2345
        xorx.w	#2,&12345h		; 0x1841 0xe3a2 0x2345
        xorx.a	#2,&12345h		; 0x1801 0xe3e2 0x2345
        xorx	#0ffffh,&12345h		; 0x1841 0xe3b2 0x2345
        xorx.b	#0ffh,&12345h  		; 0x1841 0xe3f2 0x2345
        xorx.w	#0ffffh,&12345h		; 0x1841 0xe3b2 0x2345
        xorx.a	#0fffffh,&12345h	; 0x1801 0xe3f2 0x2345
        xorx	#-1,&12345h		; 0x1841 0xe3b2 0x2345
        xorx.b	#-1,&12345h		; 0x1841 0xe3f2 0x2345
        xorx.w	#-1,&12345h		; 0x1841 0xe3b2 0x2345
        xorx.a	#-1,&12345h		; 0x1801 0xe3f2 0x2345
        xorx	#100,&12345h		; 0x1841 0xe0b2 0x0064 0x2345
        xorx.b	#100,&12345h		; 0x1841 0xe0f2 0x0064 0x2345
        xorx.w	#100,&12345h		; 0x1841 0xe0b2 0x0064 0x2345
        xorx.a	#100000,&12345h		; 0x1881 0xe0f2 0x86a0 0x2345
        xorx	@r6,&12345h		; 0x1841 0xe6a2 0x2345
        xorx.b	@r6,&12345h		; 0x1841 0xe6e2 0x2345
        xorx.w	@r6,&12345h		; 0x1841 0xe6a2 0x2345
        xorx.a	@r6,&12345h		; 0x1801 0xe6e2 0x2345
        xorx	42(r6),&12345h		; 0x1841 0xe692 0x002a 0x2345
        xorx.b	42(r6),&12345h		; 0x1841 0xe6d2 0x002a 0x2345
        xorx.w	42(r6),&12345h		; 0x1841 0xe692 0x002a 0x2345
        xorx.a	42(r6),&12345h		; 0x1801 0xe6d2 0x002a 0x2345
        xorx	@r6,&12345h		; 0x1841 0xe6a2 0x2345
        xorx.b	@r6,&12345h		; 0x1841 0xe6e2 0x2345
        xorx.w	@r6,&12345h		; 0x1841 0xe6a2 0x2345
        xorx.a	@r6,&12345h		; 0x1801 0xe6e2 0x2345
        xorx	@r6+,&12345h		; 0x1841 0xe6b2 0x2345
        xorx.b	@r6+,&12345h		; 0x1841 0xe6f2 0x2345
        xorx.w	@r6+,&12345h		; 0x1841 0xe6b2 0x2345
        xorx.a	@r6+,&12345h		; 0x1801 0xe6f2 0x2345
        xorx	&12345h,&12345h		; 0x18c1 0xe292 0x2345 0x2345
        xorx.b	&12345h,&12345h		; 0x18c1 0xe2d2 0x2345 0x2345
        xorx.w	&12345h,&12345h		; 0x18c1 0xe292 0x2345 0x2345
        xorx.a	&12345h,&12345h		; 0x1881 0xe2d2 0x2345 0x2345
        xorx	65432h,&12345h		; 0x1ac1 0xe092 0x169e 0x2345
        xorx.b	65432h,&12345h		; 0x1ac1 0xe0d2 0x1696 0x2345
        xorx.w	65432h,&12345h		; 0x1ac1 0xe092 0x168e 0x2345
        xorx.a	65432h,&12345h		; 0x1a81 0xe0d2 0x1686 0x2345
        xorx	r4,65432h		; 0x1845 0xe480 0x167e
        xorx.b	r4,65432h		; 0x1845 0xe4c0 0x1678
        xorx.w	r4,65432h		; 0x1845 0xe480 0x1672
        xorx.a	r4,65432h		; 0x1805 0xe4c0 0x166c
        xorx	#4,65432h		; 0x1845 0xe2a0 0x1666
        xorx.b	#4,65432h		; 0x1845 0xe2e0 0x1660
        xorx.w	#4,65432h		; 0x1845 0xe2a0 0x165a
        xorx.a	#4,65432h		; 0x1805 0xe2e0 0x1654
        xorx	#8,65432h		; 0x1845 0xe2b0 0x164e
        xorx.b	#8,65432h		; 0x1845 0xe2f0 0x1648
        xorx.w	#8,65432h		; 0x1845 0xe2b0 0x1642
        xorx.a	#8,65432h		; 0x1805 0xe2f0 0x163c
        xorx	#0,65432h		; 0x1845 0xe380 0x1636
        xorx.b	#0,65432h		; 0x1845 0xe3c0 0x1630
        xorx.w	#0,65432h		; 0x1845 0xe380 0x162a
        xorx.a	#0,65432h		; 0x1805 0xe3c0 0x1624
        xorx	#1,65432h		; 0x1845 0xe390 0x161e
        xorx.b	#1,65432h		; 0x1845 0xe3d0 0x1618
        xorx.w	#1,65432h		; 0x1845 0xe390 0x1612
        xorx.a	#1,65432h		; 0x1805 0xe3d0 0x160c
        xorx	#2,65432h		; 0x1845 0xe3a0 0x1606
        xorx.b	#2,65432h		; 0x1845 0xe3e0 0x1600
        xorx.w	#2,65432h		; 0x1845 0xe3a0 0x15fa
        xorx.a	#2,65432h		; 0x1805 0xe3e0 0x15f4
        xorx	#0ffffh,65432h		; 0x1845 0xe3b0 0x15ee
        xorx.b	#0ffh,65432h  		; 0x1845 0xe3f0 0x15e8
        xorx.w	#0ffffh,65432h		; 0x1845 0xe3b0 0x15e2
        xorx.a	#0fffffh,65432h		; 0x1805 0xe3f0 0x15dc
        xorx	#-1,65432h		; 0x1845 0xe3b0 0x15d6
        xorx.b	#-1,65432h		; 0x1845 0xe3f0 0x15d0
        xorx.w	#-1,65432h		; 0x1845 0xe3b0 0x15ca
        xorx.a	#-1,65432h		; 0x1805 0xe3f0 0x15c4
        xorx	#100,65432h		; 0x1845 0xe0b0 0x0064 0x15bc
        xorx.b	#100,65432h		; 0x1845 0xe0f0 0x0064 0x15b4
        xorx.w	#100,65432h		; 0x1845 0xe0b0 0x0064 0x15ac
        xorx.a	#100000,65432h		; 0x1885 0xe0f0 0x86a0 0x15a4
        xorx	@r6,65432h		; 0x1845 0xe6a0 0x159e
        xorx.b	@r6,65432h		; 0x1845 0xe6e0 0x1598
        xorx.w	@r6,65432h		; 0x1845 0xe6a0 0x1592
        xorx.a	@r6,65432h		; 0x1805 0xe6e0 0x158c
        xorx	42(r6),65432h		; 0x1845 0xe690 0x002a 0x1584
        xorx.b	42(r6),65432h		; 0x1845 0xe6d0 0x002a 0x157c
        xorx.w	42(r6),65432h		; 0x1845 0xe690 0x002a 0x1574
        xorx.a	42(r6),65432h		; 0x1805 0xe6d0 0x002a 0x156c
        xorx	@r6,65432h		; 0x1845 0xe6a0 0x1566
        xorx.b	@r6,65432h		; 0x1845 0xe6e0 0x1560
        xorx.w	@r6,65432h		; 0x1845 0xe6a0 0x155a
        xorx.a	@r6,65432h		; 0x1805 0xe6e0 0x1554
        xorx	@r6+,65432h		; 0x1845 0xe6b0 0x154e
        xorx.b	@r6+,65432h		; 0x1845 0xe6f0 0x1548
        xorx.w	@r6+,65432h		; 0x1845 0xe6b0 0x1542
        xorx.a	@r6+,65432h		; 0x1805 0xe6f0 0x153c
        xorx	&12345h,65432h		; 0x18c5 0xe290 0x2345 0x1534
        xorx.b	&12345h,65432h		; 0x18c5 0xe2d0 0x2345 0x152c
        xorx.w	&12345h,65432h		; 0x18c5 0xe290 0x2345 0x1524
        xorx.a	&12345h,65432h		; 0x1885 0xe2d0 0x2345 0x151c
        xorx	65432h,65432h		; 0x1ac5 0xe090 0x1516 0x1514
        xorx.b	65432h,65432h		; 0x1ac5 0xe0d0 0x150e 0x150c
        xorx.w	65432h,65432h		; 0x1ac5 0xe090 0x1506 0x1504
        xorx.a	65432h,65432h		; 0x1a85 0xe0d0 0x14fe 0x14fc
	andx	r4,r7			; 0x1840 0xf407
        andx.b	r4,r7			; 0x1840 0xf447
        andx.w	r4,r7			; 0x1840 0xf407
	andx.a	r4,r7			; 0x1800 0xf447
        andx	#4,r7			; 0x1840 0xf227
        andx.b	#4,r7			; 0x1840 0xf267
        andx.w	#4,r7			; 0x1840 0xf227
        andx.a	#4,r7			; 0x1800 0xf267
        andx	#8,r7			; 0x1840 0xf237
        andx.b	#8,r7			; 0x1840 0xf277
        andx.w	#8,r7			; 0x1840 0xf237
        andx.a	#8,r7			; 0x1800 0xf277
        andx	#0,r7			; 0x1840 0xf307
        andx.b	#0,r7			; 0x1840 0xf347
        andx.w	#0,r7			; 0x1840 0xf307
        andx.a	#0,r7			; 0x1800 0xf347
        andx	#1,r7			; 0x1840 0xf317
        andx.b	#1,r7			; 0x1840 0xf357
        andx.w	#1,r7			; 0x1840 0xf317
        andx.a	#1,r7			; 0x1800 0xf357
        andx	#2,r7			; 0x1840 0xf327
        andx.b	#2,r7			; 0x1840 0xf367
        andx.w	#2,r7			; 0x1840 0xf327
        andx.a	#2,r7			; 0x1800 0xf367
        andx	#0ffffh,r7		; 0x1840 0xf337
        andx.b	#0ffh,r7		; 0x1840 0xf377
        andx.w	#0ffffh,r7		; 0x1840 0xf337
        andx.a	#0fffffh,r7		; 0x1800 0xf377
        andx	#-1,r7			; 0x1840 0xf337
        andx.b	#-1,r7			; 0x1840 0xf377
        andx.w	#-1,r7			; 0x1840 0xf337
        andx.a	#-1,r7			; 0x1800 0xf377
        andx	#100,r7			; 0x1840 0xf037 0x0064
        andx.b	#100,r7			; 0x1840 0xf077 0x0064
        andx.w	#100,r7			; 0x1840 0xf037 0x0064
        andx.a	#100000,r7		; 0x1880 0xf077 0x86a0
        andx	@r6,r7			; 0x1840 0xf627
        andx.b	@r6,r7			; 0x1840 0xf667
        andx.w	@r6,r7			; 0x1840 0xf627
        andx.a	@r6,r7			; 0x1800 0xf667
        andx	42(r6),r7		; 0x1840 0xf617 0x002a
        andx.b	42(r6),r7		; 0x1840 0xf657 0x002a
        andx.w	42(r6),r7		; 0x1840 0xf617 0x002a
        andx.a	42(r6),r7		; 0x1800 0xf657 0x002a
        andx	@r6,r7			; 0x1840 0xf627
        andx.b	@r6,r7			; 0x1840 0xf667
        andx.w	@r6,r7			; 0x1840 0xf627
        andx.a	@r6,r7			; 0x1800 0xf667
        andx	@r6+,r7			; 0x1840 0xf637
        andx.b	@r6+,r7			; 0x1840 0xf677
        andx.w	@r6+,r7			; 0x1840 0xf637
        andx.a	@r6+,r7			; 0x1800 0xf677
        andx	&12345h,r7		; 0x18c0 0xf217 0x2345
        andx.b	&12345h,r7		; 0x18c0 0xf257 0x2345
        andx.w	&12345h,r7		; 0x18c0 0xf217 0x2345
        andx.a	&12345h,r7		; 0x1880 0xf257 0x2345
        andx	65432h,r7		; 0x1ac0 0xf017 0x13fe
        andx.b	65432h,r7		; 0x1ac0 0xf057 0x13f8
        andx.w	65432h,r7		; 0x1ac0 0xf017 0x13f2
        andx.a	65432h,r7		; 0x1a80 0xf057 0x13ec
        andx	r4,200(r8)		; 0x1840 0xf488 0x00c8
        andx.b	r4,200(r8)		; 0x1840 0xf4c8 0x00c8
        andx.w	r4,200(r8)		; 0x1840 0xf488 0x00c8
        andx.a	r4,200(r8)		; 0x1800 0xf4c8 0x00c8
        andx	#4,200(r8)		; 0x1840 0xf2a8 0x00c8
        andx.b	#4,200(r8)		; 0x1840 0xf2e8 0x00c8
        andx.w	#4,200(r8)		; 0x1840 0xf2a8 0x00c8
        andx.a	#4,200(r8)		; 0x1800 0xf2e8 0x00c8
        andx	#8,200(r8)		; 0x1840 0xf2b8 0x00c8
        andx.b	#8,200(r8)		; 0x1840 0xf2f8 0x00c8
        andx.w	#8,200(r8)		; 0x1840 0xf2b8 0x00c8
        andx.a	#8,200(r8)		; 0x1800 0xf2f8 0x00c8
        andx	#0,200(r8)		; 0x1840 0xf388 0x00c8
        andx.b	#0,200(r8)		; 0x1840 0xf3c8 0x00c8
        andx.w	#0,200(r8)		; 0x1840 0xf388 0x00c8
        andx.a	#0,200(r8)		; 0x1800 0xf3c8 0x00c8
        andx	#1,200(r8)		; 0x1840 0xf398 0x00c8
        andx.b	#1,200(r8)		; 0x1840 0xf3d8 0x00c8
        andx.w	#1,200(r8)		; 0x1840 0xf398 0x00c8
        andx.a	#1,200(r8)		; 0x1800 0xf3d8 0x00c8
        andx	#2,200(r8)		; 0x1840 0xf3a8 0x00c8
        andx.b	#2,200(r8)		; 0x1840 0xf3e8 0x00c8
        andx.w	#2,200(r8)		; 0x1840 0xf3a8 0x00c8
        andx.a	#2,200(r8)		; 0x1800 0xf3e8 0x00c8
        andx	#0ffffh,200(r8)		; 0x1840 0xf3b8 0x00c8
        andx.b	#0ffh,200(r8)		; 0x1840 0xf3f8 0x00c8
        andx.w	#0ffffh,200(r8)		; 0x1840 0xf3b8 0x00c8
        andx.a	#0fffffh,200(r8)	; 0x1800 0xf3f8 0x00c8
        andx	#-1,200(r8)		; 0x1840 0xf3b8 0x00c8
        andx.b	#-1,200(r8)		; 0x1840 0xf3f8 0x00c8
        andx.w	#-1,200(r8)		; 0x1840 0xf3b8 0x00c8
        andx.a	#-1,200(r8)		; 0x1800 0xf3f8 0x00c8
        andx	#100,200(r8)		; 0x1840 0xf0b8 0x0064 0x00c8
        andx.b	#100,200(r8)		; 0x1840 0xf0f8 0x0064 0x00c8
        andx.w	#100,200(r8)		; 0x1840 0xf0b8 0x0064 0x00c8
        andx.a	#100000,200(r8)		; 0x1880 0xf0f8 0x86a0 0x00c8
        andx	@r6,200(r8)		; 0x1840 0xf6a8 0x00c8
        andx.b	@r6,200(r8)		; 0x1840 0xf6e8 0x00c8
        andx.w	@r6,200(r8)		; 0x1840 0xf6a8 0x00c8
        andx.a	@r6,200(r8)		; 0x1800 0xf6e8 0x00c8
        andx	42(r6),200(r8)		; 0x1840 0xf698 0x002a 0x00c8
        andx.b	42(r6),200(r8)		; 0x1840 0xf6d8 0x002a 0x00c8
        andx.w	42(r6),200(r8)		; 0x1840 0xf698 0x002a 0x00c8
        andx.a	42(r6),200(r8)		; 0x1800 0xf6d8 0x002a 0x00c8
        andx	@r6,200(r8)		; 0x1840 0xf6a8 0x00c8
        andx.b	@r6,200(r8)		; 0x1840 0xf6e8 0x00c8
        andx.w	@r6,200(r8)		; 0x1840 0xf6a8 0x00c8
        andx.a	@r6,200(r8)		; 0x1800 0xf6e8 0x00c8
        andx	@r6+,200(r8)		; 0x1840 0xf6b8 0x00c8
        andx.b	@r6+,200(r8)		; 0x1840 0xf6f8 0x00c8
        andx.w	@r6+,200(r8)		; 0x1840 0xf6b8 0x00c8
        andx.a	@r6+,200(r8)		; 0x1800 0xf6f8 0x00c8
        andx	&12345h,200(r8)		; 0x18c0 0xf298 0x2345 0x00c8
        andx.b	&12345h,200(r8)		; 0x18c0 0xf2d8 0x2345 0x00c8
        andx.w	&12345h,200(r8)		; 0x18c0 0xf298 0x2345 0x00c8
        andx.a	&12345h,200(r8)		; 0x1880 0xf2d8 0x2345 0x00c8
        andx	65432h,200(r8)		; 0x1ac0 0xf098 0x127e 0x00c8
        andx.b	65432h,200(r8)		; 0x1ac0 0xf0d8 0x1276 0x00c8
        andx.w	65432h,200(r8)		; 0x1ac0 0xf098 0x126e 0x00c8
        andx.a	65432h,200(r8)		; 0x1ac0 0xf0d8 0x1266 0x00c8
        andx	r4,&12345h		; 0x1841 0xf482 0x2345
        andx.b	r4,&12345h		; 0x1841 0xf4c2 0x2345
        andx.w	r4,&12345h		; 0x1841 0xf482 0x2345
        andx.a	r4,&12345h		; 0x1801 0xf4c2 0x2345
        andx	#4,&12345h		; 0x1841 0xf2a2 0x2345
        andx.b	#4,&12345h		; 0x1841 0xf2e2 0x2345
        andx.w	#4,&12345h		; 0x1841 0xf2a2 0x2345
        andx.a	#4,&12345h		; 0x1801 0xf2e2 0x2345
        andx	#8,&12345h		; 0x1841 0xf2b2 0x2345
        andx.b	#8,&12345h		; 0x1841 0xf2f2 0x2345
        andx.w	#8,&12345h		; 0x1841 0xf2b2 0x2345
        andx.a	#8,&12345h		; 0x1801 0xf2f2 0x2345
        andx	#0,&12345h		; 0x1841 0xf382 0x2345
        andx.b	#0,&12345h		; 0x1841 0xf3c2 0x2345
        andx.w	#0,&12345h		; 0x1841 0xf382 0x2345
        andx.a	#0,&12345h		; 0x1801 0xf3c2 0x2345
        andx	#1,&12345h		; 0x1841 0xf392 0x2345
        andx.b	#1,&12345h		; 0x1841 0xf3d2 0x2345
        andx.w	#1,&12345h		; 0x1841 0xf392 0x2345
        andx.a	#1,&12345h		; 0x1801 0xf3d2 0x2345
        andx	#2,&12345h		; 0x1841 0xf3a2 0x2345
        andx.b	#2,&12345h		; 0x1841 0xf3e2 0x2345
        andx.w	#2,&12345h		; 0x1841 0xf3a2 0x2345
        andx.a	#2,&12345h		; 0x1801 0xf3e2 0x2345
        andx	#0ffffh,&12345h		; 0x1841 0xf3b2 0x2345
        andx.b	#0ffh,&12345h  		; 0x1841 0xf3f2 0x2345
        andx.w	#0ffffh,&12345h		; 0x1841 0xf3b2 0x2345
        andx.a	#0fffffh,&12345h	; 0x1801 0xf3f2 0x2345
        andx	#-1,&12345h		; 0x1841 0xf3b2 0x2345
        andx.b	#-1,&12345h		; 0x1841 0xf3f2 0x2345
        andx.w	#-1,&12345h		; 0x1841 0xf3b2 0x2345
        andx.a	#-1,&12345h		; 0x1801 0xf3f2 0x2345
        andx	#100,&12345h		; 0x1841 0xf0b2 0x0064 0x2345
        andx.b	#100,&12345h		; 0x1841 0xf0f2 0x0064 0x2345
        andx.w	#100,&12345h		; 0x1841 0xf0b2 0x0064 0x2345
        andx.a	#100000,&12345h		; 0x1881 0xf0f2 0x86a0 0x2345
        andx	@r6,&12345h		; 0x1841 0xf6a2 0x2345
        andx.b	@r6,&12345h		; 0x1841 0xf6e2 0x2345
        andx.w	@r6,&12345h		; 0x1841 0xf6a2 0x2345
        andx.a	@r6,&12345h		; 0x1801 0xf6e2 0x2345
        andx	42(r6),&12345h		; 0x1841 0xf692 0x002a 0x2345
        andx.b	42(r6),&12345h		; 0x1841 0xf6d2 0x002a 0x2345
        andx.w	42(r6),&12345h		; 0x1841 0xf692 0x002a 0x2345
        andx.a	42(r6),&12345h		; 0x1801 0xf6d2 0x002a 0x2345
        andx	@r6,&12345h		; 0x1841 0xf6a2 0x2345
        andx.b	@r6,&12345h		; 0x1841 0xf6e2 0x2345
        andx.w	@r6,&12345h		; 0x1841 0xf6a2 0x2345
        andx.a	@r6,&12345h		; 0x1801 0xf6e2 0x2345
        andx	@r6+,&12345h		; 0x1841 0xf6b2 0x2345
        andx.b	@r6+,&12345h		; 0x1841 0xf6f2 0x2345
        andx.w	@r6+,&12345h		; 0x1841 0xf6b2 0x2345
        andx.a	@r6+,&12345h		; 0x1801 0xf6f2 0x2345
        andx	&12345h,&12345h		; 0x18c1 0xf292 0x2345 0x2345
        andx.b	&12345h,&12345h		; 0x18c1 0xf2d2 0x2345 0x2345
        andx.w	&12345h,&12345h		; 0x18c1 0xf292 0x2345 0x2345
        andx.a	&12345h,&12345h		; 0x1881 0xf2d2 0x2345 0x2345
        andx	65432h,&12345h		; 0x1ac1 0xf092 0x10f6 0x2345
        andx.b	65432h,&12345h		; 0x1ac1 0xf0d2 0x10ee 0x2345
        andx.w	65432h,&12345h		; 0x1ac1 0xf092 0x10e6 0x2345
        andx.a	65432h,&12345h		; 0x1a81 0xf0d2 0x10de 0x2345
        andx	r4,65432h		; 0x1845 0xf480 0x10d6
        andx.b	r4,65432h		; 0x1845 0xf4c0 0x10d0
        andx.w	r4,65432h		; 0x1845 0xf480 0x10ca
        andx.a	r4,65432h		; 0x1805 0xf4c0 0x10c4
        andx	#4,65432h		; 0x1845 0xf2a0 0x10be
        andx.b	#4,65432h		; 0x1845 0xf2e0 0x10b8
        andx.w	#4,65432h		; 0x1845 0xf2a0 0x10b2
        andx.a	#4,65432h		; 0x1805 0xf2e0 0x10ac
        andx	#8,65432h		; 0x1845 0xf2b0 0x10a6
        andx.b	#8,65432h		; 0x1845 0xf2f0 0x10a0
        andx.w	#8,65432h		; 0x1845 0xf2b0 0x109a
        andx.a	#8,65432h		; 0x1805 0xf2f0 0x1094
        andx	#0,65432h		; 0x1845 0xf380 0x108e
        andx.b	#0,65432h		; 0x1845 0xf3c0 0x1088
        andx.w	#0,65432h		; 0x1845 0xf380 0x1082
        andx.a	#0,65432h		; 0x1805 0xf3c0 0x107c
        andx	#1,65432h		; 0x1845 0xf390 0x1076
        andx.b	#1,65432h		; 0x1845 0xf3d0 0x1070
        andx.w	#1,65432h		; 0x1845 0xf390 0x106a
        andx.a	#1,65432h		; 0x1805 0xf3d0 0x1064
        andx	#2,65432h		; 0x1845 0xf3a0 0x105e
        andx.b	#2,65432h		; 0x1845 0xf3e0 0x1058
        andx.w	#2,65432h		; 0x1845 0xf3a0 0x1052
        andx.a	#2,65432h		; 0x1805 0xf3e0 0x104c
        andx	#0ffffh,65432h		; 0x1845 0xf3b0 0x1046
        andx.b	#0ffh,65432h  		; 0x1845 0xf3f0 0x1040
        andx.w	#0ffffh,65432h		; 0x1845 0xf3b0 0x103a
        andx.a	#0fffffh,65432h		; 0x1805 0xf3f0 0x1034
        andx	#-1,65432h		; 0x1845 0xf3b0 0x102e
        andx.b	#-1,65432h		; 0x1845 0xf3f0 0x1028
        andx.w	#-1,65432h		; 0x1845 0xf3b0 0x1022
        andx.a	#-1,65432h		; 0x1805 0xf3f0 0x101c
        andx	#100,65432h		; 0x1845 0xf0b0 0x0064 0x1014
        andx.b	#100,65432h		; 0x1845 0xf0f0 0x0064 0x100c
        andx.w	#100,65432h		; 0x1845 0xf0b0 0x0064 0x1004
        andx.a	#100000,65432h		; 0x1885 0xf0f0 0x86a0 0x0ffc
        andx	@r6,65432h		; 0x1845 0xf6a0 0x0ff6
        andx.b	@r6,65432h		; 0x1845 0xf6e0 0x0ff0
        andx.w	@r6,65432h		; 0x1845 0xf6a0 0x0fea
        andx.a	@r6,65432h		; 0x1805 0xf6e0 0x0fe4
        andx	42(r6),65432h		; 0x1845 0xf690 0x002a 0x0fdc
        andx.b	42(r6),65432h		; 0x1845 0xf6d0 0x002a 0x0fd4
        andx.w	42(r6),65432h		; 0x1845 0xf690 0x002a 0x0fcc
        andx.a	42(r6),65432h		; 0x1805 0xf6d0 0x002a 0x0fc4
        andx	@r6,65432h		; 0x1845 0xf6a0 0x0fbe
        andx.b	@r6,65432h		; 0x1845 0xf6e0 0x0fb8
        andx.w	@r6,65432h		; 0x1845 0xf6a0 0x0fb2
        andx.a	@r6,65432h		; 0x1805 0xf6e0 0x0fac
        andx	@r6+,65432h		; 0x1845 0xf6b0 0x0fa6
        andx.b	@r6+,65432h		; 0x1845 0xf6f0 0x0fa0
        andx.w	@r6+,65432h		; 0x1845 0xf6b0 0x0f9a
        andx.a	@r6+,65432h		; 0x1805 0xf6f0 0x0f94
        andx	&12345h,65432h		; 0x18c5 0xf290 0x2345 0x0f8c
        andx.b	&12345h,65432h		; 0x18c5 0xf2d0 0x2345 0x0f84
        andx.w	&12345h,65432h		; 0x18c5 0xf290 0x2345 0x0f7c
        andx.a	&12345h,65432h		; 0x1885 0xf2d0 0x2345 0x0f74
        andx	65432h,65432h		; 0x1ac5 0xf090 0x0f6e 0x0f6c
        andx.b	65432h,65432h		; 0x1ac5 0xf0d0 0x0f66 0x0f64
        andx.w	65432h,65432h		; 0x1ac5 0xf090 0x0f5e 0x0f5c
        andx.a	65432h,65432h		; 0x1a85 0xf0d0 0x0f56 0x0f54

	rrcx	r7			; 0x1840 0x1007
	rrcx.b	r7			; 0x1840 0x1047
	rrcx.w	r7			; 0x1840 0x1007
	rrcx.a	r7			; 0x1800 0x1047
	rrcx	200(r8)			; 0x1840 0x1018 0x00c8
	rrcx.b	200(r8)			; 0x1840 0x1058 0x00c8
	rrcx.w	200(r8)			; 0x1840 0x1018 0x00c8
	rrcx.a	200(r8)			; 0x1800 0x1058 0x00c8
	rrcx	@r6			; 0x1840 0x1026
	rrcx.b	@r6			; 0x1840 0x1066
	rrcx.w	@r6			; 0x1840 0x1026
	rrcx.a	@r6			; 0x1800 0x1066
	rrcx	@r6+			; 0x1840 0x1036
	rrcx.b	@r6+			; 0x1840 0x1076
	rrcx.w	@r6+			; 0x1840 0x1036
	rrcx.a	@r6+			; 0x1800 0x1076
	rrcx	&12345h			; 0x18c0 0x1012 0x2345
	rrcx.b	&12345h			; 0x18c0 0x1052 0x2345
	rrcx.w	&12345h			; 0x18c0 0x1012 0x2345
	rrcx.a	&12345h			; 0x1880 0x1052 0x2345
	rrcx	65432h			; 0x1ac0 0x1010 0x0eee
	rrcx.b	65432h			; 0x1ac0 0x1050 0x0ee8
	rrcx.w	65432h			; 0x1ac0 0x1010 0x0ee2
	rrcx.a	65432h			; 0x1a80 0x1050 0x0edc
	rrax	r7			; 0x1840 0x1107
	rrax.b	r7			; 0x1840 0x1147
	rrax.w	r7			; 0x1840 0x1107
	rrax.a	r7			; 0x1800 0x1147
	rrax	200(r8)			; 0x1840 0x1118 0x00c8
	rrax.b	200(r8)			; 0x1840 0x1158 0x00c8
	rrax.w	200(r8)			; 0x1840 0x1118 0x00c8
	rrax.a	200(r8)			; 0x1800 0x1158 0x00c8
	rrax	@r6			; 0x1840 0x1126
	rrax.b	@r6			; 0x1840 0x1166
	rrax.w	@r6			; 0x1840 0x1126
	rrax.a	@r6			; 0x1800 0x1166
	rrax	@r6+			; 0x1840 0x1136
	rrax.b	@r6+			; 0x1840 0x1176
	rrax.w	@r6+			; 0x1840 0x1136
	rrax.a	@r6+			; 0x1800 0x1176
	rrax	&12345h			; 0x18c0 0x1112 0x2345
	rrax.b	&12345h			; 0x18c0 0x1152 0x2345
	rrax.w	&12345h			; 0x18c0 0x1112 0x2345
	rrax.a	&12345h			; 0x1880 0x1152 0x2345
	rrax	65432h			; 0x1ac0 0x1110 0x0e76
	rrax.b	65432h			; 0x1ac0 0x1150 0x0e70
	rrax.w	65432h			; 0x1ac0 0x1110 0x0e6a
	rrax.a	65432h			; 0x1a80 0x1150 0x0e64
	; what about rrux?
	pushx	r7			; 0x1840 0x1207
	pushx.b	r7			; 0x1840 0x1247
	pushx.w	r7			; 0x1840 0x1207
	pushx.a	r7			; 0x1800 0x1247
        pushx	#4			; 0x1840 0x1222
        pushx.b	#4			; 0x1840 0x1262
        pushx.w	#4			; 0x1840 0x1222
        pushx.a	#4			; 0x1800 0x1262
        pushx	#8			; 0x1840 0x1232
        pushx.b	#8			; 0x1840 0x1272
        pushx.w	#8			; 0x1840 0x1232
        pushx.a	#8			; 0x1800 0x1272
        pushx	#0			; 0x1840 0x1203
        pushx.b	#0			; 0x1840 0x1243
        pushx.w	#0			; 0x1840 0x1203
        pushx.a	#0			; 0x1800 0x1243
        pushx	#1			; 0x1840 0x1213
        pushx.b	#1			; 0x1840 0x1253
        pushx.w	#1			; 0x1840 0x1213
        pushx.a	#1			; 0x1800 0x1253
        pushx	#2			; 0x1840 0x1223
        pushx.b	#2			; 0x1840 0x1263
        pushx.w	#2			; 0x1840 0x1223
        pushx.a	#2			; 0x1800 0x1263
        pushx	#0ffffh			; 0x1840 0x1233
        pushx.b	#0ffh			; 0x1840 0x1273
        pushx.w	#0ffffh			; 0x1840 0x1233
        pushx.a	#0fffffh		; 0x1800 0x1273
        pushx	#-1			; 0x1840 0x1233
        pushx.b	#-1			; 0x1840 0x1273
        pushx.w	#-1			; 0x1840 0x1233
        pushx.a	#-1			; 0x1800 0x1273
        pushx	#100			; 0x1840 0x1230 0x0064
        pushx.b	#100			; 0x1840 0x1270 0x0064
        pushx.w	#100			; 0x1840 0x1230 0x0064
        pushx.a	#100000			; 0x1880 0x1270 0x86a0
	pushx	200(r8)			; 0x1840 0x1218 0x00c8
	pushx.b	200(r8)			; 0x1840 0x1258 0x00c8
	pushx.w	200(r8)			; 0x1840 0x1218 0x00c8
	pushx.a	200(r8)			; 0x1800 0x1258 0x00c8
	pushx	@r6			; 0x1840 0x1226
	pushx.b	@r6			; 0x1840 0x1266
	pushx.w	@r6			; 0x1840 0x1226
	pushx.a	@r6			; 0x1800 0x1266
	pushx	@r6+			; 0x1840 0x1236
	pushx.b	@r6+			; 0x1840 0x1276
	pushx.w	@r6+			; 0x1840 0x1236
	pushx.a	@r6+			; 0x1800 0x1276
	pushx	&12345h			; 0x18c0 0x1212 0x2345
	pushx.b	&12345h			; 0x18c0 0x1252 0x2345
	pushx.w	&12345h			; 0x18c0 0x1212 0x2345
	pushx.a	&12345h			; 0x1880 0x1252 0x2345
	pushx	65432h			; 0x1ac0 0x1210 0x0d76
	pushx.b	65432h			; 0x1ac0 0x1250 0x0d70
	pushx.w	65432h			; 0x1ac0 0x1210 0x0d6a
	pushx.a	65432h			; 0x1a80 0x1250 0x0d64
	swpbx	r7			; 0x1840 0x1087
	swpbx.w	r7			; 0x1840 0x1087
	swpbx.a	r7			; 0x1800 0x1087
	swpbx	200(r8)			; 0x1840 0x1098 0x00c8
	swpbx.w	200(r8)			; 0x1840 0x1098 0x00c8
	swpbx.a	200(r8)			; 0x1800 0x1098 0x00c8
	swpbx	@r6			; 0x1840 0x10a6
	swpbx.w	@r6			; 0x1840 0x10a6
	swpbx.a	@r6			; 0x1800 0x10a6
	swpbx	@r6+			; 0x1840 0x10b6
	swpbx.w	@r6+			; 0x1840 0x10b6
	swpbx.a	@r6+			; 0x1800 0x10b6
	swpbx	&12345h			; 0x18c0 0x1092 0x2345
	swpbx.w	&12345h			; 0x18c0 0x1092 0x2345
	swpbx.a	&12345h			; 0x1880 0x1092 0x2345
	swpbx	65432h			; 0x1ac0 0x1090 0x0d16
	swpbx.w	65432h			; 0x1ac0 0x1090 0x0d10
	swpbx.a	65432h			; 0x1a80 0x1090 0x0d0a
	sxtx	r7			; 0x1840 0x1187
	sxtx.w	r7			; 0x1840 0x1187
	sxtx.a	r7			; 0x1800 0x1187
	sxtx	200(r8)			; 0x1840 0x1198 0x00c8
	sxtx.w	200(r8)			; 0x1840 0x1198 0x00c8
	sxtx.a	200(r8)			; 0x1800 0x1198 0x00c8
	sxtx	@r6			; 0x1840 0x11a6
	sxtx.w	@r6			; 0x1840 0x11a6
	sxtx.a	@r6			; 0x1800 0x11a6
	sxtx	@r6+			; 0x1840 0x11b6
	sxtx.w	@r6+			; 0x1840 0x11b6
	sxtx.a	@r6+			; 0x1800 0x11b6
	sxtx	&12345h			; 0x18c0 0x1192 0x2345
	sxtx.w	&12345h			; 0x18c0 0x1192 0x2345
	sxtx.a	&12345h			; 0x1880 0x1192 0x2345
	sxtx	65432h			; 0x1ac0 0x1190 0x0cbc
	sxtx.w	65432h			; 0x1ac0 0x1190 0x0cb6
	sxtx.a	65432h			; 0x1a80 0x1190 0x0cb0
	calla	r7			; 0x1347
	calla	2000(r4)		; 0x1354 0x07d0
	;calla	200000(r4)
	;calla	-50000(r4)
	;calla	50000(r4)
	calla	@r5			; 0x1365
	calla	@r14+			; 0x137e
	calla	&98765h			; 0x1389 0x8765
	calla	$+10			; 0x1390 0x0008
	calla	100(pc)			; 0x1390 0x0064
	calla	#87654h			; 0x13b8 0x7654
	pushm.a	#4,r3			; 0x1433
	pushm.w	#5,r7			; 0x1547
	popm.a	#3,r10			; 0x1628
	popm.w	#5,r6			; 0x1742
	rrcm.a	#1,r4			; 0x0044
	rram.a	#2,r5			; 0x0545
	rlam.a	#3,r6			; 0x0a46
	rrum.a	#4,r7			; 0x0f47
	rrcm.w	#4,r8			; 0x0c58
	rram.w	#3,r9			; 0x0959
	rlam.w	#2,r10			; 0x065a
	rrum.w	#1,r11			; 0x035b

	; emulated 430X instructions, never realized via macros

	adcx	r7			; 0x1840 0x6307
	adcx.b	r7			; 0x1840 0x6347
	adcx.w	r7			; 0x1840 0x6307
	adcx.a	r7			; 0x1800 0x6347
	adcx	200(r8)			; 0x1840 0x6388 0x00c8
	adcx.b	200(r8)			; 0x1840 0x63c8 0x00c8
	adcx.w	200(r8)			; 0x1840 0x6388 0x00c8
	adcx.a	200(r8)			; 0x1800 0x63c8 0x00c8
	adcx	@r6			; 0x1840 0x6386 0x0000
	adcx.b	@r6			; 0x1840 0x63c6 0x0000
	adcx.w	@r6			; 0x1840 0x6386 0x0000
	adcx.a	@r6			; 0x1800 0x63c6 0x0000
	adcx	&12345h			; 0x1841 0x6382 0x2345
	adcx.b	&12345h			; 0x1841 0x63c2 0x2345
	adcx.w	&12345h			; 0x1841 0x6382 0x2345
	adcx.a	&12345h			; 0x1801 0x63c2 0x2345
	adcx	65432h			; 0x1845 0x6380 0x0c20
	adcx.b	65432h			; 0x1845 0x63c0 0x0c1a
	adcx.w	65432h			; 0x1845 0x6380 0x0c14
	adcx.a	65432h			; 0x1805 0x63c0 0x0c0e
	bra	r7			; 0x07c0
	bra	@r6			; 0x0600
	bra	@r6+			; 0x0610
	bra	&12345h			; 0x0120 0x2345
	bra	2345h(r6)		; 0x0630 0x2345
	bra	#12345h			; 0x0180 0x2345
	bra	$+100h			; 0x0030 0x00fe
	reta				; 0x0110
	clra	r7			; 0x4307
	clrx	r7			; 0x1840 0x4307
	clrx.b	r7			; 0x1840 0x4347
	clrx.w	r7			; 0x1840 0x4307
	clrx.a	r7			; 0x1800 0x4347
	clrx	200(r8)			; 0x1840 0x4388 0x00c8
	clrx.b	200(r8)			; 0x1840 0x43c8 0x00c8
	clrx.w	200(r8)			; 0x1840 0x4388 0x00c8
	clrx.a	200(r8)			; 0x1800 0x43c8 0x00c8
	clrx	@r6			; 0x1840 0x4386 0x0000
	clrx.b	@r6			; 0x1840 0x43c6 0x0000
	clrx.w	@r6			; 0x1840 0x4386 0x0000
	clrx.a	@r6			; 0x1800 0x43c6 0x0000
	clrx	&12345h			; 0x1841 0x4382 0x2345
	clrx.b	&12345h			; 0x1841 0x43c2 0x2345
	clrx.w	&12345h			; 0x1841 0x4382 0x2345
	clrx.a	&12345h			; 0x1801 0x43c2 0x2345
	clrx	65432h			; 0x1845 0x4380 0x0b96
	clrx.b	65432h			; 0x1845 0x43c0 0x0b90
	clrx.w	65432h			; 0x1845 0x4380 0x0b8a
	clrx.a	65432h			; 0x1805 0x43c0 0x0b84
	dadcx	r7			; 0x1840 0xa307
	dadcx.b	r7			; 0x1840 0xa347
	dadcx.w	r7			; 0x1840 0xa307
	dadcx.a	r7			; 0x1800 0xa347
	dadcx	200(r8)			; 0x1840 0xa388 0x00c8
	dadcx.b	200(r8)			; 0x1840 0xa3c8 0x00c8
	dadcx.w	200(r8)			; 0x1840 0xa388 0x00c8
	dadcx.a	200(r8)			; 0x1800 0xa3c8 0x00c8
	dadcx	@r6			; 0x1840 0xa386 0x0000
	dadcx.b	@r6			; 0x1840 0xa3c6 0x0000
	dadcx.w	@r6			; 0x1840 0xa386 0x0000
	dadcx.a	@r6			; 0x1800 0xa3c6 0x0000
	dadcx	&12345h			; 0x1841 0xa382 0x2345
	dadcx.b	&12345h			; 0x1841 0xa3c2 0x2345
	dadcx.w	&12345h			; 0x1841 0xa382 0x2345
	dadcx.a	&12345h			; 0x1801 0xa3c2 0x2345
	dadcx	65432h			; 0x1845 0xa380 0x0b26
	dadcx.b	65432h			; 0x1845 0xa3c0 0x0b20
	dadcx.w	65432h			; 0x1845 0xa380 0x0b1a
	dadcx.a	65432h			; 0x1805 0xa3c0 0x0b14
	decx	r7			; 0x1840 0x8317
	decx.b	r7			; 0x1840 0x8357
	decx.w	r7			; 0x1840 0x8317
	decx.a	r7			; 0x1800 0x8357
	decx	200(r8)			; 0x1840 0x8398 0x00c8
	decx.b	200(r8)			; 0x1840 0x83d8 0x00c8
	decx.w	200(r8)			; 0x1840 0x8398 0x00c8
	decx.a	200(r8)			; 0x1800 0x83d8 0x00c8
	decx	@r6			; 0x1840 0x8396 0x0000
	decx.b	@r6			; 0x1840 0x83d6 0x0000
	decx.w	@r6			; 0x1840 0x8396 0x0000
	decx.a	@r6			; 0x1800 0x83d6 0x0000
	decx	&12345h			; 0x1841 0x8392 0x2345
	decx.b	&12345h			; 0x1841 0x83d2 0x2345
	decx.w	&12345h			; 0x1841 0x8392 0x2345
	decx.a	&12345h			; 0x1801 0x83d2 0x2345
	decx	65432h			; 0x1845 0x8390 0x0ab6
	decx.b	65432h			; 0x1845 0x83d0 0x0ab0
	decx.w	65432h			; 0x1845 0x8390 0x0aaa
	decx.a	65432h			; 0x1805 0x83d0 0x0aa4
	decda	r7			; 0x00b7 0x0002
	decdx	r7			; 0x1840 0x8327
	decdx.b	r7			; 0x1840 0x8367
	decdx.w	r7			; 0x1840 0x8327
	decdx.a	r7			; 0x1800 0x8367
	decdx	200(r8)			; 0x1840 0x83a8 0x00c8
	decdx.b	200(r8)			; 0x1840 0x83e8 0x00c8
	decdx.w	200(r8)			; 0x1840 0x83a8 0x00c8
	decdx.a	200(r8)			; 0x1800 0x83e8 0x00c8
	decdx	@r6			; 0x1840 0x83a6 0x0000
	decdx.b	@r6			; 0x1840 0x83e6 0x0000
	decdx.w	@r6			; 0x1840 0x83a6 0x0000
	decdx.a	@r6			; 0x1800 0x83e6 0x0000
	decdx	&12345h			; 0x1841 0x83a2 0x2345
	decdx.b	&12345h			; 0x1841 0x83e2 0x2345
	decdx.w	&12345h			; 0x1841 0x83a2 0x2345
	decdx.a	&12345h			; 0x1801 0x83e2 0x2345
	decdx	65432h			; 0x1845 0x83a0 0x0a42
	decdx.b	65432h			; 0x1845 0x83e0 0x0a3c
	decdx.w	65432h			; 0x1845 0x83a0 0x0a36
	decdx.a	65432h			; 0x1805 0x83e0 0x0a30
	incx	r7			; 0x1840 0x5317
	incx.b	r7			; 0x1840 0x5357
	incx.w	r7			; 0x1840 0x5317
	incx.a	r7			; 0x1800 0x5357
	incx	200(r8)			; 0x1840 0x5398 0x00c8
	incx.b	200(r8)			; 0x1840 0x53d8 0x00c8
	incx.w	200(r8)			; 0x1840 0x5398 0x00c8
	incx.a	200(r8)			; 0x1800 0x53d8 0x00c8
	incx	@r6			; 0x1840 0x5396 0x0000
	incx.b	@r6			; 0x1840 0x53d6 0x0000
	incx.w	@r6			; 0x1840 0x5396 0x0000
	incx.a	@r6			; 0x1800 0x53d6 0x0000
	incx	&12345h			; 0x1841 0x5392 0x2345
	incx.b	&12345h			; 0x1841 0x53d2 0x2345
	incx.w	&12345h			; 0x1841 0x5392 0x2345
	incx.a	&12345h			; 0x1801 0x53d2 0x2345
	incx	65432h			; 0x1845 0x5390 0x09d2
	incx.b	65432h			; 0x1845 0x53d0 0x09cc
	incx.w	65432h			; 0x1845 0x5390 0x09c6
	incx.a	65432h			; 0x1805 0x53d0 0x09c0
	incda	r7			; 0x00a7 0x0002
	incdx	r7			; 0x1840 0x5327
	incdx.b	r7			; 0x1840 0x5367
	incdx.w	r7			; 0x1840 0x5327
	incdx.a	r7			; 0x1800 0x5367
	incdx	200(r8)			; 0x1840 0x53a8 0x00c8
	incdx.b	200(r8)			; 0x1840 0x53e8 0x00c8
	incdx.w	200(r8)			; 0x1840 0x53a8 0x00c8
	incdx.a	200(r8)			; 0x1800 0x53e8 0x00c8
	incdx	@r6			; 0x1840 0x53a6 0x0000
	incdx.b	@r6			; 0x1840 0x53e6 0x0000
	incdx.w	@r6			; 0x1840 0x53a6 0x0000
	incdx.a	@r6			; 0x1800 0x53e6 0x0000
	incdx	&12345h			; 0x1841 0x53a2 0x2345
	incdx.b	&12345h			; 0x1841 0x53e2 0x2345
	incdx.w	&12345h			; 0x1841 0x53a2 0x2345
	incdx.a	&12345h			; 0x1801 0x53e2 0x2345
	incdx	65432h			; 0x1845 0x53a0 0x095e
	incdx.b	65432h			; 0x1845 0x53e0 0x0958
	incdx.w	65432h			; 0x1845 0x53a0 0x0952
	incdx.a	65432h			; 0x1805 0x53e0 0x094c
	invx	r7			; 0x1840 0xe337
	invx.b	r7			; 0x1840 0xe377
	invx.w	r7			; 0x1840 0xe337
	invx.a	r7			; 0x1800 0xe377
	invx	200(r8)			; 0x1840 0xe3b8 0x00c8
	invx.b	200(r8)			; 0x1840 0xe3f8 0x00c8
	invx.w	200(r8)			; 0x1840 0xe3b8 0x00c8
	invx.a	200(r8)			; 0x1800 0xe3f8 0x00c8
	invx	@r6			; 0x1840 0xe3b6 0x0000
	invx.b	@r6			; 0x1840 0xe3f6 0x0000
	invx.w	@r6			; 0x1840 0xe3b6 0x0000
	invx.a	@r6			; 0x1800 0xe3f6 0x0000
	invx	&12345h			; 0x1841 0xe3b2 0x2345
	invx.b	&12345h			; 0x1841 0xe3f2 0x2345
	invx.w	&12345h			; 0x1841 0xe3b2 0x2345
	invx.a	&12345h			; 0x1801 0xe3f2 0x2345
	invx	65432h			; 0x1845 0xe3b0 0x08ee
	invx.b	65432h			; 0x1845 0xe3f0 0x08e8
	invx.w	65432h			; 0x1845 0xe3b0 0x08e2
	invx.a	65432h			; 0x1805 0xe3f0 0x08dc
	rlcx	r7			; 0x1840 0x6707
	rlcx.b	r7			; 0x1840 0x6747
	rlcx.w	r7			; 0x1840 0x6707
	rlcx.a	r7			; 0x1800 0x6747
	rlcx	200(r8)			; 0x1840 0x6898 0x00c8 0x00c8
	rlcx.b	200(r8)			; 0x1840 0x68d8 0x00c8 0x00c8
	rlcx.w	200(r8)			; 0x1840 0x6898 0x00c8 0x00c8
	rlcx.a	200(r8)			; 0x1800 0x68d8 0x00c8 0x00c8
	rlcx	@r6			; 0x1840 0x66a6 0x0000
	rlcx.b	@r6			; 0x1840 0x66e6 0x0000
	rlcx.w	@r6			; 0x1840 0x66a6 0x0000
	rlcx.a	@r6			; 0x1800 0x66e6 0x0000
	rlcx	@r6+			; 0x184f 0x66b6 0xfffe (tricky, equals ADDCX @R6+,-2(R6))
	rlcx.b	@r6+			; 0x184f 0x66f6 0xffff
	rlcx.w	@r6+			; 0x184f 0x66b6 0xfffe
	rlcx.a	@r6+			; 0x180f 0x66f6 0xfffc
	rlcx	&12345h			; 0x18c1 0x6292 0x2345 0x2345
	rlcx.b	&12345h			; 0x18c1 0x62d2 0x2345 0x2345
	rlcx.w	&12345h			; 0x18c1 0x6292 0x2345 0x2345
	rlcx.a	&12345h			; 0x1881 0x62d2 0x2345 0x2345
	rlcx	65432h			; 0x1ac5 0x6090 0x0856 0x0854
	rlcx.b	65432h			; 0x1ac5 0x60d0 0x084e 0x084c
	rlcx.w	65432h			; 0x1ac5 0x6090 0x0846 0x0844
	rlcx.a	65432h			; 0x1a85 0x60d0 0x083e 0x083c
	rlax	r7			; 0x1840 0x5707
	rlax.b	r7			; 0x1840 0x5747
	rlax.w	r7			; 0x1840 0x5707
	rlax.a	r7			; 0x1800 0x5747
	rlax	200(r8)			; 0x1840 0x5898 0x00c8 0x00c8
	rlax.b	200(r8)			; 0x1840 0x58d8 0x00c8 0x00c8
	rlax.w	200(r8)			; 0x1840 0x5898 0x00c8 0x00c8
	rlax.a	200(r8)			; 0x1800 0x58d8 0x00c8 0x00c8
	rlax	@r6			; 0x1840 0x56a6 0x0000
	rlax.b	@r6			; 0x1840 0x56e6 0x0000
	rlax.w	@r6			; 0x1840 0x56a6 0x0000
	rlax.a	@r6			; 0x1800 0x56e6 0x0000
	rlax	@r6+			; 0x184f 0x56b6 0xfffe (tricky, equals ADDX @R6+,-2(R6))
	rlax.b	@r6+			; 0x184f 0x56f6 0xffff
	rlax.w	@r6+			; 0x184f 0x56b6 0xfffe
	rlax.a	@r6+			; 0x180f 0x56f6 0xfffc
	rlax	&12345h			; 0x18c1 0x5292 0x2345 0x2345
	rlax.b	&12345h			; 0x18c1 0x52d2 0x2345 0x2345
	rlax.w	&12345h			; 0x18c1 0x5292 0x2345 0x2345
	rlax.a	&12345h			; 0x1881 0x52d2 0x2345 0x2345
	rlax	65432h			; 0x1ac5 0x5090 0x07b6 0x07b4
	rlax.b	65432h			; 0x1ac5 0x50d0 0x07ae 0x07ac
	rlax.w	65432h			; 0x1ac5 0x5090 0x07a6 0x07a4
	rlax.a	65432h			; 0x1a85 0x50d0 0x079e 0x079c
	sbcx	r7			; 0x1840 0x7307
	sbcx.b	r7			; 0x1840 0x7347
	sbcx.w	r7			; 0x1840 0x7307
	sbcx.a	r7			; 0x1800 0x7347
	sbcx	200(r8)			; 0x1840 0x7388 0x00c8
	sbcx.b	200(r8)			; 0x1840 0x73c8 0x00c8
	sbcx.w	200(r8)			; 0x1840 0x7388 0x00c8
	sbcx.a	200(r8)			; 0x1800 0x73c8 0x00c8
	sbcx	@r6			; 0x1840 0x7386 0x0000
	sbcx.b	@r6			; 0x1840 0x73c6 0x0000
	sbcx.w	@r6			; 0x1840 0x7386 0x0000
	sbcx.a	@r6			; 0x1800 0x73c6 0x0000
	sbcx	&12345h			; 0x1841 0x7382 0x2345
	sbcx.b	&12345h			; 0x1841 0x73c2 0x2345
	sbcx.w	&12345h			; 0x1841 0x7382 0x2345
	sbcx.a	&12345h			; 0x1801 0x73c2 0x2345
	sbcx	65432h			; 0x1845 0x7380 0x073e
	sbcx.b	65432h			; 0x1845 0x73c0 0x0738
	sbcx.w	65432h			; 0x1845 0x7380 0x0732
	sbcx.a	65432h			; 0x1805 0x73c0 0x072c
	tsta	r7			; 0x0097 0x0000
	tstx	r7			; 0x1840 0x9307
	tstx.b	r7			; 0x1840 0x9347
	tstx.w	r7			; 0x1840 0x9307
	tstx.a	r7			; 0x1800 0x9347
	tstx	200(r8)			; 0x1840 0x9388 0x00c8
	tstx.b	200(r8)			; 0x1840 0x93c8 0x00c8
	tstx.w	200(r8)			; 0x1840 0x9388 0x00c8
	tstx.a	200(r8)			; 0x1800 0x93c8 0x00c8
	tstx	@r6			; 0x1840 0x9386 0x0000
	tstx.b	@r6			; 0x1840 0x93c6 0x0000
	tstx.w	@r6			; 0x1840 0x9386 0x0000
	tstx.a	@r6			; 0x1800 0x93c6 0x0000
	tstx	&12345h			; 0x1841 0x9382 0x2345
	tstx.b	&12345h			; 0x1841 0x93c2 0x2345
	tstx.w	&12345h			; 0x1841 0x9382 0x2345
	tstx.a	&12345h			; 0x1801 0x93c2 0x2345
	tstx	65432h			; 0x1845 0x9380 0x06ca
	tstx.b	65432h			; 0x1845 0x93c0 0x06c4
	tstx.w	65432h			; 0x1845 0x9380 0x06be
	tstx.a	65432h			; 0x1805 0x93c0 0x06b8
	popx	r7			; 0x1840 0x4137
	popx.b	r7			; 0x1840 0x4177
	popx.w	r7			; 0x1840 0x4137
	popx.a	r7			; 0x1800 0x4177
	popx	200(r8)			; 0x1840 0x41b8 0x00c8
	popx.b	200(r8)			; 0x1840 0x41f8 0x00c8
	popx.w	200(r8)			; 0x1840 0x41b8 0x00c8
	popx.a	200(r8)			; 0x1800 0x41f8 0x00c8
	popx	@r6			; 0x1840 0x41b6 0x0000
	popx.b	@r6			; 0x1840 0x41f6 0x0000
	popx.w	@r6			; 0x1840 0x41b6 0x0000
	popx.a	@r6			; 0x1800 0x41f6 0x0000
	popx	&12345h			; 0x1841 0x41b2 0x2345
	popx.b	&12345h			; 0x1841 0x41f2 0x2345
	popx.w	&12345h			; 0x1841 0x41b2 0x2345
	popx.a	&12345h			; 0x1801 0x41f2 0x2345
	popx	65432h			; 0x1845 0x41b0 0x065a
	popx.b	65432h			; 0x1845 0x41f0 0x0654
	popx.w	65432h			; 0x1845 0x41b0 0x064e
	popx.a	65432h			; 0x1805 0x41f0 0x0648

	; 430X address instructions

	mova	@r5,r7			; 0x0507
	mova	@r6+,r7			; 0x0617
	mova	&12345h,r5		; 0x0125 0x2345
	mova	2345(r6),r5		; 0x0635 0x0929
	mova	r14,&12345h		; 0x0e61 0x2345
	mova	r14,2345(r6)		; 0x0e76 0x0929
	mova	r14,@r6                 ; 0x0e76 0x0000 ('@Rn' as dest treated like '0(Rn)')
	mova	#12345h,r5		; 0x0185 0x2345
	mova	r12,r7			; 0x0cc7

	cmpa	#12345h,r7		; 0x0197 0x2345
	cmpa	r12,r7			; 0x0cd7
	adda	#12345h,r7		; 0x01a7 0x2345
	adda	r12,r7			; 0x0ce7
	suba	#12345h,r7		; 0x01b7 0x2345
	suba	r12,r7			; 0x0cf7

	; repeated format 2 instructions

	rptc	#5 addx.w r4,r7
	rptc	r6 addx.w r4,r7
	rptz	#5 addx.w r4,r7
	rptz	r6 addx.w r4,r7

	; repeated format 1 instructions

	rptc	#5 rrcx r7
	rptc	r6 rrcx r7
	rptz	#5 rrcx r7
	rptz	r6 rrcx r7

	; repeated emulated instructions

	rptc	#5 rlcx r7
	rptc	r6 rlcx r7
	rptz	#5 rlcx r7
	rptz	r6 rlcx r7

	