;;;
;;; MN1613 Instructions
;;;

	;; Segment Base Register (BB)
	LR	R0,CSBR,(R1)	; 2040
	LR	R0,SSBR,(R1)	; 2050
	LR	R0,TSR0,(R1)	; 2060
	LR	R0,TSR1,(R1)	; 2070

	;; Indirect Register Mode (mm)
	LR	R1,SSBR,(R2)	; 2151
	LR	R1,SSBR,-(R2)	; 2191
	LR	R1,SSBR,(R2)+	; 21D1

	;; Indirect Register (ii)
	LR	SP,TSR0,(R1)+	; 25E0
	LR	SP,TSR0,(R2)+	; 25E1
	LR	SP,TSR0,(R3)+	; 25E2
	LR	SP,TSR0,(R4)+	; 25E3

	;; Segment Base Register (bbb)
	CPYB	R2,CSBR		; 0F82
	CPYB	R2,SSBR		; 0F92
	CPYB	R2,TSR0		; 0FA2
	CPYB	R2,TSR1		; 0FB2
	CPYB	R2,OSR0		; 0FC2
	CPYB	R2,OSR1		; 0FD2
	CPYB	R2,OSR2		; 0FE2
	CPYB	R2,OSR3		; 0FF2

	;; Special Register (ppp)
	CPYS	R3,SBRB		; 0F8B
	CPYS	R3,ICB		; 0F9B
	CPYS	R3,NPP		; 0FAB

	;; Hardware Control Register (hhh)
	CPYH	R4,TCR		; 3F84
	SETH	R0,TCR		; 3F00
	CPYH	R4,TIR		; 3F94
	SETH	R0,TIR		; 3F10
	CPYH	R4,TSR		; 3FA4
	SETH	R0,TSR		; 3F20
	CPYH	R4,SCR		; 3FB4
	SETH	R0,SCR		; 3F30
	CPYH	R4,SSR		; 3FC4
	SETH	R0,SSR		; 3F40
	CPYH	R4,SIR		; 3FD4
	SETH	R0,SOR		; 3F50
	CPYH	R4,IISR		; 3FE4
	SETH	R0,IISR		; 3F60

	;; Data Move
	LD	R0,CSBR,X'1234'	; 2708 1234
	LR	R1,(R3)+	; 21C2
	STD	R2,TSR1,X'8000'	; 277A 8000
	STR	R3,SSBR,-(R4)	; 2397
	MVWR	R0,(R1),LMZ	; 7FC8
	MVWI	R4,-1		; 7C0F FFFF
	MVBR	R0,(R1)		; 7F00
	BSWR	R0,(R2)		; 7709
	DSWR	R0,(R3),SKP	; 7712
	PSHM			; 170F
	POPM			; 1707

	;; Integer Arithmetic
	AWR	R0,(R4)		; 5F0B
	AWI	R1,4096,NE	; 595F 1000
	SWR	R0,(R1),PZ	; 5F30
	SWI	R2,-1024	; 5A07 FC00
	CWR	R0,(R2),M	; 5729
	CWI	R3,O'377'	; 530F 00FF
	CBR	R0,(R3),PZ	; 5732
	CBI	R4,255		; 5407 00FF
	NEG	STR,0,MZ	; 1F66
	AD	DR0,(R4),1,P	; 4F7F
	SD	DR0,(R1),C	; 470C
	M	DR0,(R2)	; 7F0D
	D	DR0,(R3),EZ	; 778E
	DAA	R0,(R4),C	; 5F0F
	DAS	R0,(R1),ENZ	; 5794
	LADR	R0,(R2)		; 6F01
	LADI	SP,4095		; 6D07 0FFF

	;; Floating Point
	FA	DR0,(R3),OZ	; 6FAE
	FS	DR0,(R4)	; 6F07
	FM	DR0,(R1)	; 670C
	FD	DR0,(R2),ONZ	; 67B5
	FIX	R0,DR0,LMZ	; 1FCF
	FLT	DR0,R0		; 1F07

	;; Logical
	ANDR	R0,(R3)		; 6F0A
	ANDI	R0,B'01010101'	; 680F 0055
	ORR	R0,(R4)		; 670B
	ORI	R1,X'CCCC'	; 610F CCCC
	EORR	R0,(R1),LP	; 67D0
LAB0:	EORI	R2,100		; 6207 0064

	;; Branch
	BD	LAB0		; 2607 xxxx
	BL	(JTAB1)		; 270F xxxx
	BR	(R2)		; 2705
	BALD	LAB1		; 2617 xxxx
	BALL	(JTAB0)		; 271F xxxx
	BALR	(R3)		; 2716
	RETL			; 3F07

	;; Bit / Shift
	TSET	R3,X'80F0',LPZ	; 17EB 80F0
	TRST	R4,X'0400'	; 1704 0400
	SRBT	R0,SP		; 3F75
	DEBP	STR,R0		; 3FF6

	;; Special
	BLK	(R2),(R1),R0	; 3F17
	RDR	R1,(R4)		; 2117
	WTR	R2,(R1)		; 2210
	LB	OSR0,LAB2	; 0F47 xxxx
	LS	SBRB,LAB2+1	; 0F0F xxxx
	STB	CSBR,LAB2+2	; 0F87 xxxx
	STS	NPP,LAB2+3	; 0FAF xxxx
	CPYB	R3,OSR1		; 0FD3
	CPYS	R4,ICB		; 0F9C
	CPYH	STR,TCR		; 3F86
	SETB	SP,OSR2		; 0F65
	SETS	R0,SBRB		; 0F08
LAB1:	SETH	R1,IISR		; 3F61

JTAB0:	DC	0
	DC	LAB0
JTAB1:	DC	15
	DC	LAB1
LAB2:	DS	4
